/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.internal.AbstractDiscriminatorMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class ExplicitColumnDiscriminatorMappingImpl
extends AbstractDiscriminatorMapping {
    private final String tableExpression;
    private final String columnName;
    private final String columnFormula;
    private final boolean isPhysical;

    public ExplicitColumnDiscriminatorMappingImpl(EntityPersister entityDescriptor, DiscriminatorType<?> discriminatorType, String tableExpression, String columnExpression, boolean isFormula, boolean isPhysical, MappingModelCreationProcess creationProcess) {
        super(discriminatorType.getJdbcMapping(), entityDescriptor, discriminatorType, creationProcess);
        this.tableExpression = tableExpression;
        this.isPhysical = isPhysical;
        if (isFormula) {
            this.columnName = null;
            this.columnFormula = columnExpression;
        } else {
            this.columnName = columnExpression;
            this.columnFormula = null;
        }
    }

    @Override
    public Expression resolveSqlExpression(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this.tableExpression);
        String selectionExpression = this.getSelectionExpression();
        return expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectionExpression), sqlAstProcessingState -> new ColumnReference(tableReference, selectionExpression, this.columnFormula != null, null, null, jdbcMappingToUse, this.getSessionFactory()));
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.columnName == null ? this.columnFormula : this.columnName;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public boolean isFormula() {
        return this.columnFormula != null;
    }

    @Override
    public boolean isPhysical() {
        return this.isPhysical;
    }
}

