/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.metamodel.mapping.MappingModelCreationLogger;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonTransientException;
import org.hibernate.metamodel.mapping.internal.InFlightEntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;

public class MappingModelCreationProcess {
    private final String EOL = System.lineSeparator();
    private final Map<String, EntityPersister> entityPersisterMap;
    private final SqmFunctionRegistry functionRegistry;
    private final RuntimeModelCreationContext creationContext;
    private String currentlyProcessingRole;
    private List<PostInitCallbackEntry> postInitCallbacks;

    public static void process(Map<String, EntityPersister> entityPersisterMap, SqmFunctionRegistry functionRegistry, RuntimeModelCreationContext creationContext) {
        MappingModelCreationProcess process = new MappingModelCreationProcess(entityPersisterMap, functionRegistry, creationContext);
        process.execute();
    }

    private MappingModelCreationProcess(Map<String, EntityPersister> entityPersisterMap, SqmFunctionRegistry functionRegistry, RuntimeModelCreationContext creationContext) {
        this.entityPersisterMap = entityPersisterMap;
        this.functionRegistry = functionRegistry;
        this.creationContext = creationContext;
    }

    public RuntimeModelCreationContext getCreationContext() {
        return this.creationContext;
    }

    public EntityPersister getEntityPersister(String name) {
        return this.entityPersisterMap.get(name);
    }

    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.functionRegistry;
    }

    private void execute() {
        for (EntityPersister entityPersister : this.entityPersisterMap.values()) {
            if (!(entityPersister instanceof InFlightEntityMappingType)) continue;
            ((InFlightEntityMappingType)((Object)entityPersister)).linkWithSuperType(this);
        }
        for (EntityPersister entityPersister : this.entityPersisterMap.values()) {
            this.currentlyProcessingRole = entityPersister.getEntityName();
            if (!(entityPersister instanceof InFlightEntityMappingType)) continue;
            ((InFlightEntityMappingType)((Object)entityPersister)).prepareMappingModel(this);
        }
        this.executePostInitCallbacks();
    }

    private void executePostInitCallbacks() {
        MappingModelCreationLogger.LOGGER.debugf("Starting post-init callbacks", new Object[0]);
        while (this.postInitCallbacks != null && !this.postInitCallbacks.isEmpty()) {
            ArrayList<PostInitCallbackEntry> copy = new ArrayList<PostInitCallbackEntry>(this.postInitCallbacks);
            boolean anyCompleted = false;
            for (int i = 0; i < copy.size(); ++i) {
                PostInitCallbackEntry callbackEntry2 = copy.get(i);
                try {
                    boolean completed = callbackEntry2.process();
                    if (!completed) continue;
                    anyCompleted = true;
                    this.postInitCallbacks.remove(callbackEntry2);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof NonTransientException) {
                        MappingModelCreationLogger.LOGGER.debugf("Mapping-model creation encountered non-transient error : %s", e);
                        throw e;
                    }
                    String format = "Mapping-model creation encountered (possibly) transient error : %s";
                    if (MappingModelCreationLogger.TRACE_ENABLED) {
                        MappingModelCreationLogger.LOGGER.tracef(e, "Mapping-model creation encountered (possibly) transient error : %s", e);
                        continue;
                    }
                    MappingModelCreationLogger.LOGGER.debugf("Mapping-model creation encountered (possibly) transient error : %s", e);
                }
            }
            if (anyCompleted) continue;
            StringBuilder buff = new StringBuilder("PostInitCallback queue could not be processed...");
            this.postInitCallbacks.forEach(callbackEntry -> buff.append(this.EOL).append("        - ").append(callbackEntry));
            buff.append(this.EOL);
            throw new IllegalStateException(buff.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ModelPart> T processSubPart(String localName, SubPartMappingProducer<T> subPartMappingProducer) {
        assert (this.currentlyProcessingRole != null);
        String initialRole = this.currentlyProcessingRole;
        this.currentlyProcessingRole = this.currentlyProcessingRole + "#" + localName;
        try {
            ModelPart modelPart = (ModelPart)subPartMappingProducer.produceSubMapping(this.currentlyProcessingRole, this);
            return (T)modelPart;
        }
        finally {
            this.currentlyProcessingRole = initialRole;
        }
    }

    public void registerInitializationCallback(String description, PostInitCallback callback) {
        if (this.postInitCallbacks == null) {
            this.postInitCallbacks = new ArrayList<PostInitCallbackEntry>();
        }
        this.postInitCallbacks.add(new PostInitCallbackEntry(description, callback));
    }

    public void registerForeignKeyPostInitCallbacks(String description, PostInitCallback callback) {
        this.registerInitializationCallback(description, callback);
    }

    private static class PostInitCallbackEntry {
        private final String description;
        private final PostInitCallback callback;

        public PostInitCallbackEntry(String description, PostInitCallback callback) {
            this.description = description;
            this.callback = callback;
        }

        private boolean process() {
            MappingModelCreationLogger.LOGGER.debugf("Starting PostInitCallbackEntry : %s", this.description);
            return this.callback.process();
        }

        public String toString() {
            return "PostInitCallbackEntry - " + this.description;
        }
    }

    @FunctionalInterface
    public static interface SubPartMappingProducer<T> {
        public T produceSubMapping(String var1, MappingModelCreationProcess var2);
    }

    @FunctionalInterface
    public static interface PostInitCallback {
        public boolean process();
    }
}

