/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortOrder;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class SelfRenderingOrderingExpression
extends SelfRenderingSqlFragmentExpression
implements OrderingExpression {
    public SelfRenderingOrderingExpression(String expression) {
        super(expression);
    }

    @Override
    public Expression resolve(QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        return this;
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, NullPrecedence nullPrecedence, SqlAstCreationState creationState) {
        Expression expression = this.resolve(ast, tableGroup, modelPartName, creationState);
        if (ast.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : ast.getSortSpecifications()) {
                if (sortSpecification.getSortExpression() != expression) continue;
                return;
            }
        }
        ast.addSortSpecification(new SortSpecification(expression, collation, sortOrder, nullPrecedence));
    }
}

