/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert;

import jakarta.persistence.AttributeConverter;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.convert.internal.JpaAttributeConverterImpl;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class Converters {
    public static <O, R> BasicValueConverter<O, R> jpaAttributeConverter(JavaType<R> relationalJtd, JavaType<O> domainJtd, Class<? extends AttributeConverter<O, R>> converterClass, SessionFactory factory) {
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)factory;
        ManagedBeanRegistry beanRegistry = sfi.getServiceRegistry().getService(ManagedBeanRegistry.class);
        ManagedBean<? extends AttributeConverter<O, R>> converterBean = beanRegistry.getBean(converterClass);
        TypeConfiguration typeConfiguration = sfi.getTypeConfiguration();
        JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeDescriptorRegistry();
        JavaType converterJtd = jtdRegistry.getDescriptor(converterClass);
        return new JpaAttributeConverterImpl<O, R>(converterBean, converterJtd, domainJtd, relationalJtd);
    }

    private Converters() {
    }
}

