/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.SubGraph;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.DynamicModelJtd;
import org.hibernate.type.spi.TypeConfiguration;

public class JpaMetamodelImpl
implements JpaMetamodel,
Serializable {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(JpaMetamodel.class);
    private static final ImportInfo<?> INVALID_IMPORT = new ImportInfo(null, null);
    private final TypeConfiguration typeConfiguration;
    private final JpaCompliance jpaCompliance;
    private final Map<String, EntityDomainType<?>> jpaEntityTypeMap = new TreeMap();
    private final Map<Class<?>, MappedSuperclassDomainType<?>> jpaMappedSuperclassTypeMap = new HashMap();
    private final Map<Class, EmbeddableDomainType<?>> jpaEmbeddableDescriptorMap = new HashMap();
    private final Map<String, Map<Class<?>, Enum<?>>> allowedEnumLiteralTexts = new HashMap();
    private final transient Map<String, RootGraphImplementor> entityGraphMap = new ConcurrentHashMap<String, RootGraphImplementor>();
    private final Map<Class, SqmPolymorphicRootDescriptor<?>> polymorphicEntityReferenceMap = new ConcurrentHashMap();
    private final Map<Class, String> entityProxyInterfaceMap = new HashMap<Class, String>();
    private final Map<String, ImportInfo<?>> nameToImportMap = new ConcurrentHashMap();

    public JpaMetamodelImpl(TypeConfiguration typeConfiguration, JpaCompliance jpaCompliance) {
        this.typeConfiguration = typeConfiguration;
        this.jpaCompliance = jpaCompliance;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public JpaCompliance getJpaCompliance() {
        return this.jpaCompliance;
    }

    @Override
    public <X> EntityDomainType<X> entity(String entityName) {
        return this.jpaEntityTypeMap.get(entityName);
    }

    @Override
    public <X> EntityDomainType<X> getHqlEntityReference(String entityName) {
        EntityDomainType<X> entityDescriptor;
        Class<Object> loadedClass = null;
        ImportInfo importInfo = this.resolveImport(entityName);
        if (importInfo != null) {
            loadedClass = importInfo.loadedClass;
            entityName = importInfo.importedName;
        }
        if ((entityDescriptor = this.entity(entityName)) != null) {
            return entityDescriptor;
        }
        if (loadedClass == null) {
            loadedClass = this.resolveRequestedClass(entityName);
            if (importInfo != null && loadedClass != null) {
                importInfo.loadedClass = loadedClass;
            }
        }
        if (loadedClass != null) {
            return this.resolveEntityReference(loadedClass);
        }
        return null;
    }

    @Override
    public <X> EntityDomainType<X> resolveHqlEntityReference(String entityName) {
        EntityDomainType<X> hqlEntityReference = this.getHqlEntityReference(entityName);
        if (hqlEntityReference == null) {
            throw new IllegalArgumentException("Could not resolve entity reference: " + entityName);
        }
        return hqlEntityReference;
    }

    @Override
    public void visitManagedTypes(Consumer<ManagedDomainType<?>> action) {
        this.visitEntityTypes(action);
        this.visitEmbeddables(action);
        this.jpaMappedSuperclassTypeMap.values().forEach(action);
    }

    @Override
    public <X> ManagedDomainType<X> findManagedType(Class<X> cls) {
        ManagedType type = this.jpaEntityTypeMap.get(cls.getName());
        if (type == null) {
            type = this.jpaMappedSuperclassTypeMap.get(cls);
        }
        if (type == null) {
            type = this.jpaEmbeddableDescriptorMap.get(cls);
        }
        if (type == null) {
            return null;
        }
        return (ManagedDomainType)type;
    }

    @Override
    public void visitEntityTypes(Consumer<EntityDomainType<?>> action) {
        this.jpaEntityTypeMap.values().forEach(action);
    }

    @Override
    public <X> EntityDomainType<X> findEntityType(Class<X> cls) {
        EntityType entityType = this.jpaEntityTypeMap.get(cls.getName());
        if (entityType == null) {
            return null;
        }
        return (EntityDomainType)entityType;
    }

    @Override
    public void visitRootEntityTypes(Consumer<EntityDomainType<?>> action) {
        this.jpaEntityTypeMap.values().forEach(entityDomainType -> {
            if (entityDomainType.getSuperType() == null) {
                action.accept((EntityDomainType<?>)entityDomainType);
            }
        });
    }

    @Override
    public void visitEmbeddables(Consumer<EmbeddableDomainType<?>> action) {
        this.jpaEmbeddableDescriptorMap.values().forEach(action);
    }

    @Override
    public <X> ManagedDomainType<X> managedType(Class<X> cls) {
        ManagedType type = this.jpaEntityTypeMap.get(cls.getName());
        if (type == null) {
            type = this.jpaMappedSuperclassTypeMap.get(cls);
        }
        if (type == null) {
            type = this.jpaEmbeddableDescriptorMap.get(cls);
        }
        if (type == null) {
            throw new IllegalArgumentException("Not a managed type: " + cls);
        }
        return (ManagedDomainType)type;
    }

    @Override
    public <X> EntityDomainType<X> entity(Class<X> cls) {
        EntityType entityType = this.jpaEntityTypeMap.get(cls.getName());
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls.getName());
        }
        return (EntityDomainType)entityType;
    }

    @Override
    public <X> EmbeddableDomainType<X> embeddable(Class<X> cls) {
        EmbeddableDomainType<?> embeddableType = this.jpaEmbeddableDescriptorMap.get(cls);
        if (embeddableType == null) {
            throw new IllegalArgumentException("Not an embeddable: " + cls);
        }
        return embeddableType;
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        int setSize = CollectionHelper.determineProperSizing(this.jpaEntityTypeMap.size() + this.jpaMappedSuperclassTypeMap.size() + this.jpaEmbeddableDescriptorMap.size());
        HashSet<ManagedType<?>> managedTypes = CollectionHelper.setOfSize(setSize);
        managedTypes.addAll(this.jpaEntityTypeMap.values());
        managedTypes.addAll(this.jpaMappedSuperclassTypeMap.values());
        managedTypes.addAll(this.jpaEmbeddableDescriptorMap.values());
        return managedTypes;
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        return new HashSet(this.jpaEntityTypeMap.values());
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        return new HashSet(this.jpaEmbeddableDescriptorMap.values());
    }

    @Override
    public Map<String, Map<Class<?>, Enum<?>>> getAllowedEnumLiteralTexts() {
        return this.allowedEnumLiteralTexts;
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, RootGraphImplementor<T> entityGraph) {
        EntityGraph old = this.entityGraphMap.put(graphName, entityGraph.makeImmutableCopy(graphName));
        if (old != null) {
            log.debugf("EntityGraph being replaced on EntityManagerFactory for name %s", graphName);
        }
    }

    @Override
    public <T> RootGraphImplementor<T> findEntityGraphByName(String name) {
        return this.entityGraphMap.get(name);
    }

    @Override
    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        EntityType entityType = this.entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Given class is not an entity : " + entityClass.getName());
        }
        ArrayList<RootGraphImplementor<T>> results = new ArrayList<RootGraphImplementor<T>>();
        for (EntityGraph entityGraph : this.entityGraphMap.values()) {
            RootGraphImplementor egi;
            if (!(entityGraph instanceof RootGraphImplementor) || !(egi = (RootGraphImplementor)entityGraph).appliesTo(entityType)) continue;
            results.add(egi);
        }
        return results;
    }

    @Override
    public String qualifyImportableName(String queryName) {
        ImportInfo importInfo = this.resolveImport(queryName);
        return importInfo == null ? null : importInfo.importedName;
    }

    private <T> ImportInfo<T> resolveImport(String name) {
        ImportInfo<?> importInfo = this.nameToImportMap.get(name);
        if (importInfo != null) {
            return importInfo == INVALID_IMPORT ? null : importInfo;
        }
        Class loadedClass = this.resolveRequestedClass(name);
        if (loadedClass == null) {
            if (this.nameToImportMap.size() < 1000) {
                this.nameToImportMap.put(name, INVALID_IMPORT);
            }
            return null;
        }
        ImportInfo info = new ImportInfo(name, loadedClass);
        this.nameToImportMap.put(name, info);
        return info;
    }

    private void applyNamedEntityGraphs(Collection<NamedEntityGraphDefinition> namedEntityGraphs) {
        for (NamedEntityGraphDefinition definition : namedEntityGraphs) {
            log.debugf("Applying named entity graph [name=%s, entity-name=%s, jpa-entity-name=%s]", definition.getRegisteredName(), definition.getEntityName(), definition.getJpaEntityName());
            EntityDomainType entityType = this.entity(definition.getEntityName());
            if (entityType == null) {
                throw new IllegalArgumentException("Attempted to register named entity graph [" + definition.getRegisteredName() + "] for unknown entity [" + definition.getEntityName() + "]");
            }
            RootGraphImpl entityGraph = new RootGraphImpl(definition.getRegisteredName(), entityType, (JpaMetamodel)this);
            NamedEntityGraph namedEntityGraph = definition.getAnnotation();
            if (namedEntityGraph.includeAllAttributes()) {
                for (Object attributeObject : entityType.getAttributes()) {
                    entityGraph.addAttributeNodes(new Attribute[]{(Attribute)attributeObject});
                }
            }
            if (namedEntityGraph.attributeNodes() != null) {
                this.applyNamedAttributeNodes(namedEntityGraph.attributeNodes(), namedEntityGraph, entityGraph);
            }
            this.entityGraphMap.put(definition.getRegisteredName(), entityGraph);
        }
    }

    private void applyNamedAttributeNodes(NamedAttributeNode[] namedAttributeNodes, NamedEntityGraph namedEntityGraph, GraphImplementor graphNode) {
        for (NamedAttributeNode namedAttributeNode : namedAttributeNodes) {
            SubGraph subgraph;
            String value = namedAttributeNode.value();
            AttributeNode attributeNode = graphNode.addAttributeNode(value);
            if (StringHelper.isNotEmpty(namedAttributeNode.subgraph())) {
                subgraph = attributeNode.makeSubGraph();
                this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.subgraph(), (SubGraphImplementor)subgraph);
            }
            if (!StringHelper.isNotEmpty(namedAttributeNode.keySubgraph())) continue;
            subgraph = attributeNode.makeKeySubGraph();
            this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.keySubgraph(), (SubGraphImplementor)subgraph);
        }
    }

    private void applyNamedSubgraphs(NamedEntityGraph namedEntityGraph, String subgraphName, SubGraphImplementor subgraph) {
        for (NamedSubgraph namedSubgraph : namedEntityGraph.subgraphs()) {
            if (!subgraphName.equals(namedSubgraph.name())) continue;
            this.applyNamedAttributeNodes(namedSubgraph.attributeNodes(), namedEntityGraph, subgraph);
        }
    }

    private <X> Class<X> resolveRequestedClass(String entityName) {
        try {
            return this.getServiceRegistry().getService(ClassLoaderService.class).classForName(entityName);
        }
        catch (ClassLoadingException e) {
            return null;
        }
    }

    public <T> EntityDomainType<T> resolveEntityReference(Class<T> javaType) {
        EntityDomainType<?> descriptor = this.jpaEntityTypeMap.get(javaType.getName());
        if (descriptor != null) {
            return descriptor;
        }
        String proxyEntityName = this.entityProxyInterfaceMap.get(javaType);
        if (proxyEntityName != null) {
            return this.jpaEntityTypeMap.get(proxyEntityName);
        }
        EntityDomainType polymorphicDomainType = this.polymorphicEntityReferenceMap.get(javaType);
        if (polymorphicDomainType != null) {
            return polymorphicDomainType;
        }
        HashSet matchingDescriptors = new HashSet();
        this.visitEntityTypes(entityDomainType -> {
            if (javaType.isAssignableFrom(entityDomainType.getJavaType())) {
                Queryable entityPersister;
                ManagedDomainType superType = entityDomainType.getSuperType();
                if (superType instanceof EntityDomainType && javaType.isAssignableFrom(superType.getJavaType()) && !(entityPersister = (Queryable)this.typeConfiguration.getSessionFactory().getMetamodel().getEntityDescriptor(((EntityDomainType)superType).getHibernateEntityName())).isExplicitPolymorphism()) {
                    return;
                }
                entityPersister = (Queryable)this.typeConfiguration.getSessionFactory().getMetamodel().getEntityDescriptor(entityDomainType.getHibernateEntityName());
                if (!entityPersister.isExplicitPolymorphism()) {
                    matchingDescriptors.add((EntityDomainType<?>)entityDomainType);
                }
            }
        });
        if (!matchingDescriptors.isEmpty()) {
            SqmPolymorphicRootDescriptor descriptor2 = new SqmPolymorphicRootDescriptor(this.typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(javaType), matchingDescriptors);
            this.polymorphicEntityReferenceMap.putIfAbsent(javaType, descriptor2);
            return descriptor2;
        }
        throw new IllegalArgumentException("Could not resolve entity reference : " + javaType.getName());
    }

    public void processJpa(MetadataImplementor bootMetamodel, MappingMetamodel mappingMetamodel, Map<Class, String> entityProxyInterfaceMap, JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting, Collection<NamedEntityGraphDefinition> namedEntityGraphDefinitions, RuntimeModelCreationContext runtimeModelCreationContext) {
        bootMetamodel.getImports().forEach((k, v) -> this.nameToImportMap.put((String)k, new ImportInfo((String)v, null)));
        this.entityProxyInterfaceMap.putAll(entityProxyInterfaceMap);
        MetadataContext context = new MetadataContext(this, mappingMetamodel, bootMetamodel, jpaStaticMetaModelPopulationSetting, runtimeModelCreationContext);
        for (PersistentClass persistentClass : bootMetamodel.getEntityBindings()) {
            this.locateOrBuildEntityType(persistentClass, context, this.typeConfiguration);
        }
        this.handleUnusedMappedSuperclasses(context, this.typeConfiguration);
        context.wrapUp();
        this.jpaEntityTypeMap.putAll(context.getEntityTypesByEntityName());
        this.jpaMappedSuperclassTypeMap.putAll(context.getMappedSuperclassTypeMap());
        for (EmbeddableDomainType embeddableDomainType : context.getEmbeddableTypeSet()) {
            this.jpaEmbeddableDescriptorMap.put(embeddableDomainType.getJavaType(), embeddableDomainType);
        }
        JpaMetamodelImpl.domainTypeStream(context).forEach(managedDomainType -> managedDomainType.visitAttributes(persistentAttribute -> {
            if (persistentAttribute.getJavaType() != null && persistentAttribute.getJavaType().isEnum()) {
                Enum[] enumConstants;
                Class enumClass = persistentAttribute.getJavaType();
                for (Enum enumConstant : enumConstants = (Enum[])enumClass.getEnumConstants()) {
                    String qualifiedEnumLiteral = enumConstant.getDeclaringClass().getSimpleName() + "." + enumConstant.name();
                    this.allowedEnumLiteralTexts.computeIfAbsent(enumConstant.name(), k -> new HashMap()).put(enumClass, enumConstant);
                    this.allowedEnumLiteralTexts.computeIfAbsent(qualifiedEnumLiteral, k -> new HashMap()).put(enumClass, enumConstant);
                }
            }
        }));
        this.applyNamedEntityGraphs(namedEntityGraphDefinitions);
    }

    private static Stream<ManagedDomainType<?>> domainTypeStream(MetadataContext context) {
        return Stream.concat(context.getEntityTypesByEntityName().values().stream(), Stream.concat(context.getMappedSuperclassTypeMap().values().stream(), context.getEmbeddableTypeSet().stream()));
    }

    private EntityDomainType<?> locateOrBuildEntityType(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        EntityDomainType<?> entityType = context.locateEntityType(persistentClass);
        if (entityType == null) {
            entityType = this.buildEntityType(persistentClass, context, typeConfiguration);
        }
        return entityType;
    }

    private EntityTypeImpl<?> buildEntityType(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        Class<?> javaType;
        MappedSuperclassDomainType<?> superType;
        context.pushEntityWorkedOn(persistentClass);
        MappedSuperclass superMappedSuperclass = persistentClass.getSuperMappedSuperclass();
        MappedSuperclassDomainType<?> mappedSuperclassDomainType = superType = superMappedSuperclass == null ? null : this.locateOrBuildMappedSuperclassType(superMappedSuperclass, context, typeConfiguration);
        if (superType == null) {
            PersistentClass superPersistentClass = persistentClass.getSuperclass();
            superType = superPersistentClass == null ? null : this.locateOrBuildEntityType(superPersistentClass, context, typeConfiguration);
        }
        JavaType<Map<?, ?>> javaTypeDescriptor = (javaType = persistentClass.getMappedClass()) == null || Map.class.isAssignableFrom(javaType) ? new DynamicModelJtd() : context.getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveEntityTypeDescriptor(javaType);
        EntityTypeImpl entityType = new EntityTypeImpl(javaTypeDescriptor, superType, persistentClass, (JpaMetamodel)this);
        context.registerEntityType(persistentClass, entityType);
        context.popEntityWorkedOn(persistentClass);
        return entityType;
    }

    private void handleUnusedMappedSuperclasses(MetadataContext context, TypeConfiguration typeConfiguration) {
        Set<MappedSuperclass> unusedMappedSuperclasses = context.getUnusedMappedSuperclasses();
        if (!unusedMappedSuperclasses.isEmpty()) {
            for (MappedSuperclass mappedSuperclass : unusedMappedSuperclasses) {
                log.unusedMappedSuperclass(mappedSuperclass.getMappedClass().getName());
                this.locateOrBuildMappedSuperclassType(mappedSuperclass, context, typeConfiguration);
            }
        }
    }

    private MappedSuperclassDomainType<?> locateOrBuildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<?> mappedSuperclassType = context.locateMappedSuperclassType(mappedSuperclass);
        if (mappedSuperclassType == null) {
            mappedSuperclassType = this.buildMappedSuperclassType(mappedSuperclass, context, typeConfiguration);
        }
        return mappedSuperclassType;
    }

    private MappedSuperclassTypeImpl<?> buildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<?> superType;
        MappedSuperclass superMappedSuperclass = mappedSuperclass.getSuperMappedSuperclass();
        MappedSuperclassDomainType<?> mappedSuperclassDomainType = superType = superMappedSuperclass == null ? null : this.locateOrBuildMappedSuperclassType(superMappedSuperclass, context, typeConfiguration);
        if (superType == null) {
            PersistentClass superPersistentClass = mappedSuperclass.getSuperPersistentClass();
            superType = superPersistentClass == null ? null : this.locateOrBuildEntityType(superPersistentClass, context, typeConfiguration);
        }
        JavaType javaTypeDescriptor = context.getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveManagedTypeDescriptor(mappedSuperclass.getMappedClass());
        MappedSuperclassTypeImpl mappedSuperclassType = new MappedSuperclassTypeImpl(javaTypeDescriptor, mappedSuperclass, superType, (JpaMetamodel)this);
        context.registerMappedSuperclassType(mappedSuperclass, mappedSuperclassType);
        return mappedSuperclassType;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.typeConfiguration.getSessionFactory());
    }

    private static class SerialForm
    implements Serializable {
        private final SessionFactoryImplementor sessionFactory;

        public SerialForm(SessionFactoryImplementor sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        private Object readResolve() {
            return this.sessionFactory.getJpaMetamodel();
        }
    }

    private static class ImportInfo<T> {
        final String importedName;
        Class<T> loadedClass;

        ImportInfo(String importedName, Class<T> loadedClass) {
            this.importedName = importedName;
            this.loadedClass = loadedClass;
        }
    }
}

