/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.sql.ast.Clause;

public class TupleMappingModelExpressable
implements MappingModelExpressable {
    private final MappingModelExpressable<Object>[] components;

    public TupleMappingModelExpressable(MappingModelExpressable<?>[] components) {
        this.components = components;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = 0;
        for (int i = 0; i < this.components.length; ++i) {
            span += this.components[i].forEachJdbcType(offset + span, action);
        }
        return span;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        Object[] disassembled = new Object[this.components.length];
        Object[] array = (Object[])value;
        for (int i = 0; i < this.components.length; ++i) {
            disassembled[i] = this.components[i].disassemble(array[i], session);
        }
        return disassembled;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        Object[] values = (Object[])value;
        int span = 0;
        for (int i = 0; i < this.components.length; ++i) {
            span += this.components[i].forEachDisassembledJdbcValue(values[i], clause, span + offset, valuesConsumer, session);
        }
        return span;
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        Object[] values = (Object[])value;
        int span = 0;
        for (int i = 0; i < this.components.length; ++i) {
            span += this.components[i].forEachDisassembledJdbcValue(this.components[i].disassemble(values[i], session), clause, span + offset, valuesConsumer, session);
        }
        return span;
    }
}

