/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.internal.FunctionReturnImpl;
import org.hibernate.procedure.internal.ProcedureParamBindings;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCall;

public class PostgresCallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final PostgresCallableStatementSupport INSTANCE = new PostgresCallableStatementSupport();

    @Override
    public JdbcCall interpretCall(String procedureName, FunctionReturnImpl functionReturn, ProcedureParameterMetadataImplementor parameterMetadata, ProcedureParamBindings paramBindings, SharedSessionContractImplementor session) {
        boolean firstParamIsRefCursor;
        boolean bl = firstParamIsRefCursor = parameterMetadata.getParameterCount() != 0 && PostgresCallableStatementSupport.isFirstParameterModeRefCursor(parameterMetadata);
        if (firstParamIsRefCursor && parameterMetadata.hasNamedParameters()) {
            throw new HibernateException("Cannot mix named parameters and REF_CURSOR parameter on PostgreSQL");
        }
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        StringBuilder buffer = firstParamIsRefCursor ? new StringBuilder(11 + procedureName.length() + registrations.size() * 2).append("{?=call ") : new StringBuilder(9 + procedureName.length() + registrations.size() * 2).append("{call ");
        buffer.append(procedureName).append("(");
        int startIndex = firstParamIsRefCursor ? 1 : 0;
        String sep = "";
        for (int i = startIndex; i < registrations.size(); ++i) {
            if (registrations.get(i).getMode() == ParameterMode.REF_CURSOR) {
                throw new HibernateException("PostgreSQL supports only one REF_CURSOR parameter, but multiple were registered");
            }
            buffer.append(sep).append("?");
            sep = ",";
        }
        buffer.append(")}");
        return new JdbcCallImpl.Builder(buffer.toString(), parameterMetadata.hasNamedParameters() ? ParameterStrategy.NAMED : ParameterStrategy.POSITIONAL).buildJdbcCall();
    }

    private static boolean isFirstParameterModeRefCursor(ProcedureParameterMetadataImplementor parameterMetadata) {
        return parameterMetadata.getRegistrationsAsList().get(0).getMode() == ParameterMode.REF_CURSOR;
    }
}

