/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.internal.FunctionReturnImpl;
import org.hibernate.procedure.internal.ProcedureParamBindings;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCall;

public class StandardCallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final StandardCallableStatementSupport NO_REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(false);
    public static final StandardCallableStatementSupport REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(true);
    private final boolean supportsRefCursors;

    public StandardCallableStatementSupport(boolean supportsRefCursors) {
        this.supportsRefCursors = supportsRefCursors;
    }

    @Override
    public JdbcCall interpretCall(String procedureName, FunctionReturnImpl functionReturn, ProcedureParameterMetadataImplementor parameterMetadata, ProcedureParamBindings paramBindings, SharedSessionContractImplementor session) {
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        StringBuilder buffer = new StringBuilder(9 + procedureName.length() + registrations.size() * 2).append("{call ").append(procedureName).append("(");
        String sep = "";
        for (int i = 0; i < registrations.size(); ++i) {
            if (registrations.get(i).getMode() == ParameterMode.REF_CURSOR) {
                this.verifyRefCursorSupport(session.getJdbcServices().getJdbcEnvironment().getDialect());
                buffer.append(sep).append("?");
                sep = ",";
                continue;
            }
            buffer.append(sep).append("?");
            sep = ",";
        }
        buffer.append(")}");
        return new JdbcCallImpl.Builder(buffer.toString(), parameterMetadata.hasNamedParameters() ? ParameterStrategy.NAMED : ParameterStrategy.POSITIONAL).buildJdbcCall();
    }

    private void verifyRefCursorSupport(Dialect dialect) {
        if (!this.supportsRefCursors) {
            throw new QueryException("Dialect [" + dialect.getClass().getName() + "] not known to support REF_CURSOR parameters");
        }
    }
}

