/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.function.Consumer;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.internal.EntityDomainResultBuilder;
import org.hibernate.procedure.internal.ScalarDomainResultBuilder;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.jboss.logging.Logger;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);

    private Util() {
    }

    public static void resolveResultSetMappings(String[] resultSetMappingNames, Class[] resultSetMappingClasses, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        if (!ArrayHelper.isEmpty(resultSetMappingNames)) {
            if (!ArrayHelper.isEmpty(resultSetMappingClasses)) {
                throw new IllegalArgumentException("Cannot specify both result-set mapping names and classes");
            }
            Util.resolveResultSetMappingNames(resultSetMappingNames, resultSetMapping, querySpaceConsumer, context);
        } else if (!ArrayHelper.isEmpty(resultSetMappingClasses)) {
            Util.resolveResultSetMappingClasses(resultSetMappingClasses, resultSetMapping, querySpaceConsumer, context);
        }
    }

    public static void resolveResultSetMappingNames(String[] resultSetMappingNames, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        NamedObjectRepository namedObjectRepository = context.getSessionFactory().getQueryEngine().getNamedObjectRepository();
        for (String resultSetMappingName : resultSetMappingNames) {
            NamedResultSetMappingMemento memento = namedObjectRepository.getResultSetMappingMemento(resultSetMappingName);
            memento.resolve(resultSetMapping, querySpaceConsumer, context);
        }
    }

    public static void resolveResultSetMappingClasses(Class[] resultSetMappingClasses, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        MappingMetamodel domainModel = context.getSessionFactory().getDomainModel();
        JavaTypeRegistry javaTypeRegistry = domainModel.getTypeConfiguration().getJavaTypeDescriptorRegistry();
        for (Class resultSetMappingClass : resultSetMappingClasses) {
            EntityPersister entityDescriptor = domainModel.findEntityDescriptor(resultSetMappingClass);
            if (entityDescriptor != null) {
                resultSetMapping.addResultBuilder(new EntityDomainResultBuilder(entityDescriptor));
                for (String querySpace : entityDescriptor.getSynchronizedQuerySpaces()) {
                    querySpaceConsumer.accept(querySpace);
                }
                continue;
            }
            JavaType basicType = javaTypeRegistry.getDescriptor(resultSetMappingClass);
            if (basicType == null) continue;
            resultSetMapping.addResultBuilder(new ScalarDomainResultBuilder(basicType));
        }
    }
}

