/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Locale;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.HqlInterpretationException;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.SqmJoinable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.jboss.logging.Logger;

public class QualifiedJoinPathConsumer
implements DotIdentifierConsumer {
    private static final Logger log = Logger.getLogger(QualifiedJoinPathConsumer.class);
    private final SqmCreationState creationState;
    private final SqmRoot<?> sqmRoot;
    private final SqmJoinType joinType;
    private final boolean fetch;
    private final String alias;
    private ConsumerDelegate delegate;
    private boolean treated;

    public QualifiedJoinPathConsumer(SqmRoot<?> sqmRoot, SqmJoinType joinType, boolean fetch, String alias, SqmCreationState creationState) {
        this.sqmRoot = sqmRoot;
        this.joinType = joinType;
        this.fetch = fetch;
        this.alias = alias;
        this.creationState = creationState;
    }

    public QualifiedJoinPathConsumer(SqmFrom<?, ?> sqmFrom, SqmJoinType joinType, boolean fetch, String alias, SqmCreationState creationState) {
        this.sqmRoot = null;
        this.joinType = joinType;
        this.fetch = fetch;
        this.alias = alias;
        this.creationState = creationState;
        this.delegate = new AttributeJoinDelegate(sqmFrom, joinType, fetch, alias, creationState);
    }

    public void setTreated(boolean treated) {
        this.treated = treated;
    }

    @Override
    public SemanticPathPart getConsumedPart() {
        return this.delegate.getConsumedPart();
    }

    @Override
    public void consumeIdentifier(String identifier, boolean isBase, boolean isTerminal) {
        if (isBase) {
            assert (this.delegate == null);
            this.delegate = this.resolveBase(identifier, !this.treated && isTerminal);
        } else {
            assert (this.delegate != null);
            this.delegate.consumeIdentifier(identifier, !this.treated && isTerminal);
        }
    }

    @Override
    public void consumeTreat(String entityName, boolean isTerminal) {
        assert (this.delegate != null);
        this.delegate.consumeTreat(entityName, isTerminal);
    }

    private ConsumerDelegate resolveBase(String identifier, boolean isTerminal) {
        SqmCreationProcessingState processingState = this.creationState.getCurrentProcessingState();
        SqmPathRegistry pathRegistry = processingState.getPathRegistry();
        Object pathRootByAlias = pathRegistry.findFromByAlias(identifier);
        if (pathRootByAlias != null) {
            if (isTerminal) {
                throw new SemanticException("Cannot join to root : " + identifier);
            }
            return new AttributeJoinDelegate((SqmFrom<?, ?>)pathRootByAlias, this.joinType, this.fetch, this.alias, this.creationState);
        }
        Object pathRootByExposedNavigable = pathRegistry.findFromExposing(identifier);
        if (pathRootByExposedNavigable != null) {
            return new AttributeJoinDelegate(this.createJoin((SqmFrom<?, Object>)pathRootByExposedNavigable, identifier, isTerminal), this.joinType, this.fetch, this.alias, this.creationState);
        }
        return new ExpectingEntityJoinDelegate(identifier, isTerminal, this.sqmRoot, this.joinType, this.alias, this.fetch, this.creationState);
    }

    private SqmFrom<?, ?> createJoin(SqmFrom<?, Object> lhs, String identifier, boolean isTerminal) {
        return QualifiedJoinPathConsumer.createJoin(lhs, identifier, this.joinType, this.alias, this.fetch, isTerminal, this.creationState);
    }

    private static SqmFrom<?, Object> createJoin(SqmFrom<?, Object> lhs, String name, SqmJoinType joinType, String alias, boolean fetch, boolean isTerminal, SqmCreationState creationState) {
        SqmPathSource<?> subPathSource = lhs.getReferencedPathSource().findSubPathSource(name);
        if (subPathSource == null) {
            throw new HqlInterpretationException(String.format(Locale.ROOT, "Could not locate specified joinable path : %s -> %s", lhs.getNavigablePath(), name));
        }
        if (!isTerminal) {
            for (SqmJoin<Object, ?> sqmJoin : lhs.getSqmJoins()) {
                if (sqmJoin.getAlias() != null || sqmJoin.getReferencedPathSource() != subPathSource) continue;
                return sqmJoin;
            }
        }
        SqmAttributeJoin join = ((SqmJoinable)((Object)subPathSource)).createSqmJoin(lhs, joinType, isTerminal ? alias : "{implicit}", fetch, creationState);
        lhs.addSqmJoin(join);
        creationState.getCurrentProcessingState().getPathRegistry().register(join);
        return join;
    }

    private static class ExpectingEntityJoinDelegate
    implements ConsumerDelegate {
        private final SqmCreationState creationState;
        private final SqmRoot<?> sqmRoot;
        private final SqmJoinType joinType;
        private final boolean fetch;
        private final String alias;
        private final StringBuilder path = new StringBuilder();
        private SqmEntityJoin<?> join;

        public ExpectingEntityJoinDelegate(String identifier, boolean isTerminal, SqmRoot<?> sqmRoot, SqmJoinType joinType, String alias, boolean fetch, SqmCreationState creationState) {
            this.creationState = creationState;
            this.sqmRoot = sqmRoot;
            this.joinType = joinType;
            this.fetch = fetch;
            this.alias = alias;
            this.consumeIdentifier(identifier, isTerminal);
        }

        @Override
        public void consumeIdentifier(String identifier, boolean isTerminal) {
            if (this.path.length() != 0) {
                this.path.append('.');
            }
            this.path.append(identifier);
            if (isTerminal) {
                String fullPath = this.path.toString();
                EntityDomainType joinedEntityType = this.creationState.getCreationContext().getJpaMetamodel().resolveHqlEntityReference(fullPath);
                if (joinedEntityType == null) {
                    throw new SemanticException("Could not resolve join path - " + fullPath);
                }
                assert (!(joinedEntityType instanceof SqmPolymorphicRootDescriptor));
                if (this.fetch) {
                    log.debugf("Ignoring fetch on entity join : %s(%s)", (Object)joinedEntityType.getHibernateEntityName(), (Object)this.alias);
                }
                this.join = new SqmEntityJoin(joinedEntityType, this.alias, this.joinType, this.sqmRoot);
                this.creationState.getCurrentProcessingState().getPathRegistry().register(this.join);
            }
        }

        @Override
        public void consumeTreat(String entityName, boolean isTerminal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SemanticPathPart getConsumedPart() {
            return this.join;
        }
    }

    private static class AttributeJoinDelegate
    implements ConsumerDelegate {
        private final SqmCreationState creationState;
        private final SqmJoinType joinType;
        private final boolean fetch;
        private final String alias;
        private SqmFrom<?, Object> currentPath;

        public AttributeJoinDelegate(SqmFrom<?, ?> base, SqmJoinType joinType, boolean fetch, String alias, SqmCreationState creationState) {
            this.joinType = joinType;
            this.fetch = fetch;
            this.alias = alias;
            this.creationState = creationState;
            this.currentPath = base;
        }

        @Override
        public void consumeIdentifier(String identifier, boolean isTerminal) {
            this.currentPath = QualifiedJoinPathConsumer.createJoin(this.currentPath, identifier, this.joinType, this.alias, this.fetch, isTerminal, this.creationState);
        }

        @Override
        public void consumeTreat(String entityName, boolean isTerminal) {
            EntityDomainType entityDomainType = this.creationState.getCreationContext().getJpaMetamodel().entity(entityName);
            this.currentPath = this.currentPath.treatAs(entityDomainType, isTerminal ? this.alias : null);
            this.creationState.getCurrentProcessingState().getPathRegistry().register(this.currentPath);
        }

        @Override
        public SemanticPathPart getConsumedPart() {
            return this.currentPath;
        }
    }

    private static interface ConsumerDelegate {
        public void consumeIdentifier(String var1, boolean var2);

        public void consumeTreat(String var1, boolean var2);

        public SemanticPathPart getConsumedPart();
    }
}

