/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.Join;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.grammars.hql.HqlParserBaseVisitor;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.internal.util.QuotingHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.PathException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SetOperator;
import org.hibernate.query.SortOrder;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.internal.QualifiedJoinPathConsumer;
import org.hibernate.query.hql.internal.QualifiedJoinPredicatePathConsumer;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.LiteralNumberFormatException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.internal.ParameterCollector;
import org.hibernate.query.sqm.internal.SqmCreationProcessingStateImpl;
import org.hibernate.query.sqm.internal.SqmDmlCreationProcessingState;
import org.hibernate.query.sqm.internal.SqmQuerySpecCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.spi.ParameterDeclarationContext;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmMaxElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMaxIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmMinElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMinIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCollate;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SemanticQueryBuilder<R>
extends HqlParserBaseVisitor<Object>
implements SqmCreationState {
    private static final Logger log = Logger.getLogger(SemanticQueryBuilder.class);
    private static final Set<String> JPA_STANDARD_FUNCTIONS;
    private final SqmCreationOptions creationOptions;
    private final SqmCreationContext creationContext;
    private final Stack<DotIdentifierConsumer> dotIdentifierConsumerStack;
    private final Stack<ParameterDeclarationContext> parameterDeclarationContextStack = new StandardStack<ParameterDeclarationContext>();
    private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>();
    private final BasicDomainType<Integer> integerDomainType;
    private final JavaType<List<?>> listJavaTypeDescriptor;
    private final JavaType<Map<?, ?>> mapJavaTypeDescriptor;
    private ParameterCollector parameterCollector;
    private ParameterStyle parameterStyle;
    private boolean isExtractingJdbcTemporalType;
    private static final Pattern FORMAT;

    public static <R> SqmStatement<R> buildSemanticModel(HqlParser.StatementContext hqlParseTree, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        return new SemanticQueryBuilder<R>(creationOptions, creationContext).visitStatement(hqlParseTree);
    }

    public SemanticQueryBuilder(SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        this.creationOptions = creationOptions;
        this.creationContext = creationContext;
        this.dotIdentifierConsumerStack = new StandardStack<BasicDotIdentifierConsumer>(new BasicDotIdentifierConsumer(this));
        this.parameterStyle = creationOptions.useStrictJpaCompliance() ? ParameterStyle.UNKNOWN : ParameterStyle.MIXED;
        this.integerDomainType = creationContext.getNodeBuilder().getTypeConfiguration().standardBasicTypeForJavaType(Integer.class);
        this.listJavaTypeDescriptor = creationContext.getNodeBuilder().getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor((Type)((Object)List.class));
        this.mapJavaTypeDescriptor = creationContext.getNodeBuilder().getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor((Type)((Object)Map.class));
    }

    @Override
    public SqmCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqmCreationOptions getCreationOptions() {
        return this.creationOptions;
    }

    @Override
    public Stack<SqmCreationProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    protected Stack<ParameterDeclarationContext> getParameterDeclarationContextStack() {
        return this.parameterDeclarationContextStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmStatement<R> visitStatement(HqlParser.StatementContext ctx) {
        this.parameterDeclarationContextStack.push(() -> false);
        try {
            ParseTree parseTree = ctx.getChild(0);
            if (parseTree instanceof HqlParser.SelectStatementContext) {
                Object selectStatement = this.visitSelectStatement((HqlParser.SelectStatementContext)parseTree);
                ((SqmQueryPart)((AbstractSqmSelectQuery)selectStatement).getQueryPart()).validateQueryStructureAndFetchOwners();
                Object object = selectStatement;
                return object;
            }
            if (parseTree instanceof HqlParser.InsertStatementContext) {
                Object object = this.visitInsertStatement((HqlParser.InsertStatementContext)parseTree);
                return object;
            }
            if (parseTree instanceof HqlParser.UpdateStatementContext) {
                Object object = this.visitUpdateStatement((HqlParser.UpdateStatementContext)parseTree);
                return object;
            }
            if (parseTree instanceof HqlParser.DeleteStatementContext) {
                Object object = this.visitDeleteStatement((HqlParser.DeleteStatementContext)parseTree);
                return object;
            }
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
        throw new ParsingException("Unexpected statement type [not INSERT, UPDATE, DELETE or SELECT] : " + ctx.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectStatement<R> visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        SqmSelectStatement selectStatement;
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        this.parameterCollector = selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
        try {
            queryExpressionContext.accept(this);
        }
        finally {
            this.processingStateStack.pop();
        }
        return selectStatement;
    }

    @Override
    public SqmRoot<R> visitDmlTarget(HqlParser.DmlTargetContext dmlTargetContext) {
        HqlParser.EntityNameContext entityNameContext = (HqlParser.EntityNameContext)dmlTargetContext.getChild(0);
        String identificationVariable = dmlTargetContext.getChildCount() == 1 ? null : this.applyJpaCompliance(this.visitIdentificationVariableDef((HqlParser.IdentificationVariableDefContext)dmlTargetContext.getChild(1)));
        return new SqmRoot(this.visitEntityName(entityNameContext), identificationVariable, false, this.creationContext.getNodeBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmInsertStatement<R> visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        SqmInsertValuesStatement insertStatement;
        int dmlTargetIndex = ctx.getChild(1) instanceof HqlParser.DmlTargetContext ? 1 : 2;
        HqlParser.DmlTargetContext dmlTargetContext = (HqlParser.DmlTargetContext)ctx.getChild(dmlTargetIndex);
        HqlParser.TargetFieldsSpecContext targetFieldsSpecContext = (HqlParser.TargetFieldsSpecContext)ctx.getChild(dmlTargetIndex + 1);
        Object root = this.visitDmlTarget(dmlTargetContext);
        if (((SqmRoot)root).getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Can't create an INSERT for a non entity name: " + ((SqmRoot)root).getReferencedPathSource().getHibernateEntityName());
        }
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        if (queryExpressionContext != null) {
            SqmInsertSelectStatement insertStatement2;
            this.parameterCollector = insertStatement2 = new SqmInsertSelectStatement(root, this.creationContext.getNodeBuilder());
            SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement2, this);
            this.processingStateStack.push(processingState);
            try {
                queryExpressionContext.accept(this);
                SqmCreationProcessingStateImpl stateFieldsProcessingState = new SqmCreationProcessingStateImpl(insertStatement2, this);
                stateFieldsProcessingState.getPathRegistry().register((SqmPath<?>)root);
                this.processingStateStack.push(stateFieldsProcessingState);
                try {
                    for (HqlParser.DotIdentifierSequenceContext stateFieldCtx : targetFieldsSpecContext.dotIdentifierSequence()) {
                        SqmPath stateField = (SqmPath)this.visitDotIdentifierSequence(stateFieldCtx);
                        insertStatement2.addInsertTargetStateField(stateField);
                    }
                }
                finally {
                    this.processingStateStack.pop();
                }
                SqmInsertSelectStatement sqmInsertSelectStatement = insertStatement2;
                return sqmInsertSelectStatement;
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        this.parameterCollector = insertStatement = new SqmInsertValuesStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register((SqmPath<?>)root);
        try {
            HqlParser.ValuesListContext valuesListContext = ctx.valuesList();
            for (int i = 1; i < valuesListContext.getChildCount(); i += 2) {
                ParseTree values = valuesListContext.getChild(i);
                SqmValues sqmValues = new SqmValues();
                for (int j = 1; j < values.getChildCount(); j += 2) {
                    sqmValues.getExpressions().add((SqmExpression)values.getChild(j).accept((ParseTreeVisitor)this));
                }
                insertStatement.getValuesList().add(sqmValues);
            }
            for (HqlParser.DotIdentifierSequenceContext stateFieldCtx : targetFieldsSpecContext.dotIdentifierSequence()) {
                SqmPath stateField = (SqmPath)this.visitDotIdentifierSequence(stateFieldCtx);
                insertStatement.addInsertTargetStateField(stateField);
            }
            SqmInsertValuesStatement sqmInsertValuesStatement = insertStatement;
            return sqmInsertValuesStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmUpdateStatement<R> visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        SqmUpdateStatement updateStatement;
        boolean versioned = !(ctx.getChild(1) instanceof HqlParser.DmlTargetContext);
        int dmlTargetIndex = versioned ? 2 : 1;
        HqlParser.DmlTargetContext dmlTargetContext = (HqlParser.DmlTargetContext)ctx.getChild(dmlTargetIndex);
        Object root = this.visitDmlTarget(dmlTargetContext);
        if (((SqmRoot)root).getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Can't create an UPDATE for a non entity name: " + ((SqmRoot)root).getReferencedPathSource().getHibernateEntityName());
        }
        this.parameterCollector = updateStatement = new SqmUpdateStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(updateStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register((SqmPath<?>)root);
        try {
            updateStatement.versioned(versioned);
            HqlParser.SetClauseContext setClauseCtx = (HqlParser.SetClauseContext)ctx.getChild(dmlTargetIndex + 1);
            for (ParseTree subCtx : setClauseCtx.children) {
                if (!(subCtx instanceof HqlParser.AssignmentContext)) continue;
                HqlParser.AssignmentContext assignmentContext = (HqlParser.AssignmentContext)subCtx;
                updateStatement.applyAssignment(this.consumeDomainPath((HqlParser.DotIdentifierSequenceContext)assignmentContext.getChild(0)), (SqmExpression)assignmentContext.getChild(2).accept((ParseTreeVisitor)this));
            }
            if (dmlTargetIndex + 2 <= ctx.getChildCount()) {
                updateStatement.applyPredicate(this.visitWhereClause((HqlParser.WhereClauseContext)ctx.getChild(dmlTargetIndex + 2)));
            }
            SqmUpdateStatement sqmUpdateStatement = updateStatement;
            return sqmUpdateStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmDeleteStatement<R> visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        SqmDeleteStatement deleteStatement;
        int dmlTargetIndex = ctx.getChild(1) instanceof HqlParser.DmlTargetContext ? 1 : 2;
        HqlParser.DmlTargetContext dmlTargetContext = (HqlParser.DmlTargetContext)ctx.getChild(dmlTargetIndex);
        Object root = this.visitDmlTarget(dmlTargetContext);
        this.parameterCollector = deleteStatement = new SqmDeleteStatement(root, SqmQuerySource.HQL, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState sqmDeleteCreationState = new SqmDmlCreationProcessingState(deleteStatement, this);
        sqmDeleteCreationState.getPathRegistry().register((SqmPath<?>)root);
        this.processingStateStack.push(sqmDeleteCreationState);
        try {
            if (dmlTargetIndex + 1 <= ctx.getChildCount()) {
                deleteStatement.applyPredicate(this.visitWhereClause((HqlParser.WhereClauseContext)ctx.getChild(dmlTargetIndex + 1)));
            }
            SqmDeleteStatement sqmDeleteStatement = deleteStatement;
            return sqmDeleteStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public SqmQueryPart<Object> visitSimpleQueryGroup(HqlParser.SimpleQueryGroupContext ctx) {
        return (SqmQueryPart)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmQueryPart<Object> visitQuerySpecExpression(HqlParser.QuerySpecExpressionContext ctx) {
        List children = ctx.children;
        Object queryPart = this.visitQuerySpec((HqlParser.QuerySpecContext)((Object)children.get(0)));
        if (children.size() > 1) {
            this.visitQueryOrder((SqmQueryPart<?>)queryPart, (HqlParser.QueryOrderContext)((Object)children.get(1)));
        }
        return queryPart;
    }

    @Override
    public SqmQueryPart<Object> visitNestedQueryExpression(HqlParser.NestedQueryExpressionContext ctx) {
        List children = ctx.children;
        SqmQueryPart queryPart = (SqmQueryPart)((ParseTree)children.get(1)).accept((ParseTreeVisitor)this);
        if (children.size() > 3) {
            this.visitQueryOrder(queryPart, (HqlParser.QueryOrderContext)((Object)children.get(3)));
        }
        return queryPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmQueryGroup<Object> visitSetQueryGroup(HqlParser.SetQueryGroupContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SET_OPERATIONS);
        }
        List children = ctx.children;
        SqmQueryPart firstQueryPart = (SqmQueryPart)((ParseTree)children.get(0)).accept((ParseTreeVisitor)this);
        SqmQueryGroup<Object> queryGroup = firstQueryPart instanceof SqmQueryGroup ? (SqmQueryGroup<Object>)firstQueryPart : new SqmQueryGroup<Object>(firstQueryPart);
        this.setCurrentQueryPart(queryGroup);
        int size = children.size();
        SqmCreationProcessingState firstProcessingState = this.processingStateStack.pop();
        for (int i = 1; i < size; i += 2) {
            List queryParts;
            SetOperator operator = this.visitSetOperator((HqlParser.SetOperatorContext)((Object)children.get(i)));
            HqlParser.SimpleQueryExpressionContext simpleQueryCtx = (HqlParser.SimpleQueryExpressionContext)((Object)children.get(i + 1));
            if (queryGroup.getSetOperator() == null || queryGroup.getSetOperator() == operator) {
                queryGroup.setSetOperator(operator);
                queryParts = queryGroup.queryParts();
            } else {
                queryParts = new ArrayList<SqmQueryPart<Object>>(size - (i >> 1));
                queryParts.add(queryGroup);
                queryGroup = new SqmQueryGroup(this.creationContext.getNodeBuilder(), operator, queryParts);
                this.setCurrentQueryPart(queryGroup);
            }
            try {
                this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), (SqmSelectQuery)firstProcessingState.getProcessingQuery(), this));
                List subChildren = simpleQueryCtx.children;
                if (subChildren.get(0) instanceof HqlParser.QuerySpecContext) {
                    SqmQuerySpec querySpec = new SqmQuerySpec(this.creationContext.getNodeBuilder());
                    queryParts.add(querySpec);
                    this.visitQuerySpecExpression((HqlParser.QuerySpecExpressionContext)simpleQueryCtx);
                    continue;
                }
                try {
                    SqmSelectStatement selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
                    this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
                    Object queryPart = this.visitNestedQueryExpression((HqlParser.NestedQueryExpressionContext)simpleQueryCtx);
                    queryParts.add(queryPart);
                    continue;
                }
                finally {
                    this.processingStateStack.pop();
                }
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        this.processingStateStack.push(firstProcessingState);
        return queryGroup;
    }

    @Override
    public SetOperator visitSetOperator(HqlParser.SetOperatorContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        boolean all = ctx.getChildCount() == 2;
        switch (token.getType()) {
            case 162: {
                return all ? SetOperator.UNION_ALL : SetOperator.UNION;
            }
            case 96: {
                return all ? SetOperator.INTERSECT_ALL : SetOperator.INTERSECT;
            }
            case 76: {
                return all ? SetOperator.EXCEPT_ALL : SetOperator.EXCEPT;
            }
        }
        throw new SemanticException("Illegal set operator token: " + token.getText());
    }

    protected void visitQueryOrder(SqmQueryPart<?> sqmQueryPart, HqlParser.QueryOrderContext ctx) {
        SqmOrderByClause orderByClause;
        if (ctx == null) {
            return;
        }
        HqlParser.OrderByClauseContext orderByClauseContext = (HqlParser.OrderByClauseContext)ctx.getChild(0);
        if (orderByClauseContext != null) {
            if (this.creationOptions.useStrictJpaCompliance() && this.processingStateStack.depth() > 1) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SUBQUERY_ORDER_BY);
            }
            orderByClause = this.visitOrderByClause(orderByClauseContext);
            sqmQueryPart.setOrderByClause(orderByClause);
        } else {
            orderByClause = null;
        }
        int currentIndex = 1;
        HqlParser.LimitClauseContext limitClauseContext = currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.LimitClauseContext ? (HqlParser.LimitClauseContext)ctx.getChild(currentIndex++) : null;
        HqlParser.OffsetClauseContext offsetClauseContext = currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.OffsetClauseContext ? (HqlParser.OffsetClauseContext)ctx.getChild(currentIndex++) : null;
        HqlParser.FetchClauseContext fetchClauseContext = currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.FetchClauseContext ? (HqlParser.FetchClauseContext)ctx.getChild(currentIndex++) : null;
        if (currentIndex != 1) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.LIMIT_OFFSET_CLAUSE);
            }
            if (this.processingStateStack.depth() > 1 && orderByClause == null) {
                throw new SemanticException("limit, offset and fetch clause require an order-by clause when used in sub-query");
            }
            sqmQueryPart.setOffsetExpression((SqmExpression<?>)this.visitOffsetClause(offsetClauseContext));
            if (limitClauseContext == null) {
                sqmQueryPart.setFetchExpression((SqmExpression<?>)this.visitFetchClause(fetchClauseContext), this.visitFetchClauseType(fetchClauseContext));
            } else if (fetchClauseContext == null) {
                sqmQueryPart.setFetchExpression((SqmExpression<?>)this.visitLimitClause(limitClauseContext));
            } else {
                throw new SemanticException("Can't use both, limit and fetch clause!");
            }
        }
    }

    @Override
    public SqmQuerySpec<Object> visitQuerySpec(HqlParser.QuerySpecContext ctx) {
        SqmSelectClause selectClause;
        SqmQuerySpec<Object> sqmQuerySpec = this.currentQuerySpec();
        int fromIndex = ctx.getChild(0) instanceof HqlParser.FromClauseContext ? 0 : 1;
        sqmQuerySpec.setFromClause(this.visitFromClause((HqlParser.FromClauseContext)ctx.getChild(fromIndex)));
        if (fromIndex == 1) {
            selectClause = this.visitSelectClause((HqlParser.SelectClauseContext)ctx.getChild(0));
        } else if (ctx.getChild(ctx.getChildCount() - 1) instanceof HqlParser.SelectClauseContext) {
            selectClause = this.visitSelectClause((HqlParser.SelectClauseContext)ctx.getChild(ctx.getChildCount() - 1));
        } else {
            if (this.creationOptions.useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered implicit select-clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_SELECT);
            }
            log.debugf("Encountered implicit select clause : %s", (Object)ctx.getText());
            selectClause = this.buildInferredSelectClause(sqmQuerySpec.getFromClause());
        }
        sqmQuerySpec.setSelectClause(selectClause);
        int currentIndex = fromIndex + 1;
        SqmWhereClause whereClause = new SqmWhereClause(this.creationContext.getNodeBuilder());
        if (currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.WhereClauseContext) {
            whereClause.setPredicate((SqmPredicate)ctx.getChild(currentIndex++).accept((ParseTreeVisitor)this));
        }
        sqmQuerySpec.setWhereClause(whereClause);
        if (currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.GroupByClauseContext) {
            sqmQuerySpec.setGroupByClauseExpressions((List<SqmExpression<?>>)this.visitGroupByClause((HqlParser.GroupByClauseContext)ctx.getChild(currentIndex++)));
        }
        if (currentIndex < ctx.getChildCount() && ctx.getChild(currentIndex) instanceof HqlParser.HavingClauseContext) {
            sqmQuerySpec.setHavingClausePredicate(this.visitHavingClause((HqlParser.HavingClauseContext)ctx.getChild(currentIndex)));
        }
        return sqmQuerySpec;
    }

    protected SqmSelectClause buildInferredSelectClause(SqmFromClause fromClause) {
        SqmSelectClause selectClause = new SqmSelectClause(false, fromClause.getNumberOfRoots(), this.creationContext.getNodeBuilder());
        fromClause.visitRoots(sqmRoot -> selectClause.addSelection(new SqmSelection(sqmRoot, sqmRoot.getAlias(), this.creationContext.getNodeBuilder())));
        return selectClause;
    }

    @Override
    public SqmSelectClause visitSelectClause(HqlParser.SelectClauseContext ctx) {
        int selectionListIndex = ctx.getChild(1) instanceof HqlParser.SelectionListContext ? 1 : 2;
        SqmSelectClause selectClause = new SqmSelectClause(selectionListIndex == 2, this.creationContext.getNodeBuilder());
        HqlParser.SelectionListContext selectionListContext = (HqlParser.SelectionListContext)ctx.getChild(selectionListIndex);
        for (ParseTree subCtx : selectionListContext.children) {
            if (!(subCtx instanceof HqlParser.SelectionContext)) continue;
            selectClause.addSelection((SqmSelection<?>)this.visitSelection((HqlParser.SelectionContext)subCtx));
        }
        return selectClause;
    }

    @Override
    public SqmSelection<?> visitSelection(HqlParser.SelectionContext ctx) {
        String resultIdentifier = ctx.getChildCount() == 1 ? null : this.applyJpaCompliance(this.visitIdentificationVariableDef((HqlParser.IdentificationVariableDefContext)ctx.getChild(1)));
        SqmSelectableNode<?> selectableNode = this.visitSelectableNode(ctx);
        SqmSelection selection = new SqmSelection(selectableNode, resultIdentifier, this.creationContext.getNodeBuilder());
        if (!(selectableNode instanceof SqmDynamicInstantiation)) {
            this.getCurrentProcessingState().getPathRegistry().register(selection);
        }
        return selection;
    }

    private SqmSelectableNode<?> visitSelectableNode(HqlParser.SelectionContext ctx) {
        ParseTree subCtx = ctx.getChild(0).getChild(0);
        if (subCtx instanceof HqlParser.ExpressionOrPredicateContext) {
            SqmPath sqmPath;
            SqmExpression sqmExpression = (SqmExpression)subCtx.accept((ParseTreeVisitor)this);
            if (sqmExpression instanceof SqmPath && (sqmPath = (SqmPath)sqmExpression).getReferencedPathSource() instanceof PluralPersistentAttribute) {
                if (this.creationOptions.useStrictJpaCompliance()) {
                    SqmTreeCreationLogger.LOGGER.debugf("Raw selection of plural attribute not supported by JPA: %s.  Use `value(%s)` or `key(%s)` to indicate what part of the collection to select", (Object)sqmPath.getAlias(), (Object)sqmPath.getAlias(), (Object)sqmPath.getAlias());
                }
                SemanticPathPart elementPath = sqmPath.resolvePathPart(CollectionPart.Nature.ELEMENT.getName(), true, this);
                this.processingStateStack.getCurrent().getPathRegistry().register((SqmPath<?>)elementPath);
                return elementPath;
            }
            return sqmExpression;
        }
        return (SqmSelectableNode)subCtx.accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmDynamicInstantiation<?> visitDynamicInstantiation(HqlParser.DynamicInstantiationContext ctx) {
        SqmDynamicInstantiation<Object> dynamicInstantiation;
        ParseTree instantiationTarget = ctx.dynamicInstantiationTarget().getChild(0);
        if (instantiationTarget instanceof HqlParser.DotIdentifierSequenceContext) {
            String className = instantiationTarget.getText();
            try {
                JavaType<?> jtd = this.resolveInstantiationTargetJtd(className);
                dynamicInstantiation = SqmDynamicInstantiation.forClassInstantiation(jtd, this.creationContext.getNodeBuilder());
            }
            catch (ClassLoadingException e) {
                throw new SemanticException("Unable to resolve class named for dynamic instantiation : " + className);
            }
        } else {
            TerminalNode terminalNode = (TerminalNode)instantiationTarget;
            switch (terminalNode.getSymbol().getType()) {
                case 112: {
                    dynamicInstantiation = SqmDynamicInstantiation.forMapInstantiation(this.mapJavaTypeDescriptor, this.creationContext.getNodeBuilder());
                    break;
                }
                case 107: {
                    dynamicInstantiation = SqmDynamicInstantiation.forListInstantiation(this.listJavaTypeDescriptor, this.creationContext.getNodeBuilder());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported instantiation target: " + terminalNode);
                }
            }
        }
        for (HqlParser.DynamicInstantiationArgContext arg : ctx.dynamicInstantiationArgs().dynamicInstantiationArg()) {
            dynamicInstantiation.addArgument((SqmDynamicInstantiationArgument<?>)this.visitDynamicInstantiationArg(arg));
        }
        return dynamicInstantiation;
    }

    private JavaType<?> resolveInstantiationTargetJtd(String className) {
        Class<?> targetJavaType = this.classForName(this.creationContext.getJpaMetamodel().qualifyImportableName(className));
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor(targetJavaType);
    }

    private Class<?> classForName(String className) {
        return this.creationContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(className);
    }

    @Override
    public SqmDynamicInstantiationArgument<?> visitDynamicInstantiationArg(HqlParser.DynamicInstantiationArgContext ctx) {
        String alias = ctx.getChildCount() > 1 ? this.visitIdentificationVariableDef((HqlParser.IdentificationVariableDefContext)ctx.getChild(ctx.getChildCount() - 1)) : null;
        SqmSelectableNode argExpression = (SqmSelectableNode)ctx.getChild(0).accept((ParseTreeVisitor)this);
        SqmDynamicInstantiationArgument argument = new SqmDynamicInstantiationArgument(argExpression, alias, this.creationContext.getNodeBuilder());
        if (!(argExpression instanceof SqmDynamicInstantiation)) {
            this.getCurrentProcessingState().getPathRegistry().register(argument);
        }
        return argument;
    }

    @Override
    public SqmPath<?> visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        String alias = ctx.getChild(2).getText();
        Object sqmFromByAlias = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias);
        if (sqmFromByAlias == null) {
            throw new SemanticException("Unable to resolve alias [" + alias + "] in selection [" + ctx.getText() + "]");
        }
        return sqmFromByAlias;
    }

    @Override
    public List<SqmExpression<?>> visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        int size = ctx.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        ArrayList expressions = new ArrayList(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.GroupByExpressionContext)) continue;
            expressions.add((SqmExpression)parseTree.accept((ParseTreeVisitor)this));
        }
        return expressions;
    }

    private SqmExpression<?> resolveOrderByOrGroupByExpression(ParseTree child, boolean definedCollate) {
        if (child instanceof TerminalNode) {
            if (definedCollate) {
                throw new ParsingException("COLLATE is not allowed for position based order-by or group-by items");
            }
            int position = Integer.parseInt(child.getText());
            SqmAliasedNode<?> nodeByPosition = this.getCurrentProcessingState().getPathRegistry().findAliasedNodeByPosition(position);
            if (nodeByPosition == null) {
                throw new ParsingException("Numeric literal `" + position + "` used in group-by does not match a registered select-item");
            }
            return new SqmAliasedNodeRef(position, this.integerDomainType, this.creationContext.getNodeBuilder());
        }
        if (child instanceof HqlParser.IdentifierContext) {
            String identifierText = this.visitIdentifier((HqlParser.IdentifierContext)child);
            Integer correspondingPosition = this.getCurrentProcessingState().getPathRegistry().findAliasedNodePosition(identifierText);
            if (correspondingPosition != null) {
                if (definedCollate) {
                    throw new ParsingException("COLLATE is not allowed for alias based order-by or group-by items");
                }
                return new SqmAliasedNodeRef(correspondingPosition, this.integerDomainType, this.creationContext.getNodeBuilder());
            }
            Object sqmFrom = this.getCurrentProcessingState().getPathRegistry().findFromByAlias(identifierText);
            if (sqmFrom != null) {
                if (definedCollate) {
                    throw new ParsingException("COLLATE is not allowed for alias based order-by or group-by items");
                }
                return sqmFrom;
            }
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(identifierText, true, true);
            return (SqmExpression)((Object)dotIdentifierConsumer.getConsumedPart());
        }
        return (SqmExpression)child.accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitGroupByExpression(HqlParser.GroupByExpressionContext ctx) {
        return this.resolveOrderByOrGroupByExpression(ctx.getChild(0), ctx.getChildCount() > 1);
    }

    @Override
    public SqmPredicate visitHavingClause(HqlParser.HavingClauseContext ctx) {
        return (SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        int size = ctx.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        SqmOrderByClause orderByClause = new SqmOrderByClause(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.SortSpecificationContext)) continue;
            orderByClause.addSortSpecification(this.visitSortSpecification((HqlParser.SortSpecificationContext)parseTree));
        }
        return orderByClause;
    }

    @Override
    public SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx) {
        NullPrecedence nullPrecedence;
        SortOrder sortOrder;
        Object sortExpression;
        block14: {
            block12: {
                block13: {
                    int nextIndex;
                    sortExpression = this.visitSortExpression((HqlParser.SortExpressionContext)ctx.getChild(0));
                    if (sortExpression == null) {
                        throw new ParsingException("Could not resolve sort-expression : " + ctx.getChild(0).getText());
                    }
                    if (sortExpression instanceof SqmLiteral || sortExpression instanceof SqmParameter) {
                        HqlLogging.QUERY_LOGGER.debugf("Questionable sorting by constant value : %s", sortExpression);
                    }
                    if ((nextIndex = 1) >= ctx.getChildCount()) break block12;
                    ParseTree parseTree = ctx.getChild(nextIndex);
                    if (parseTree instanceof HqlParser.OrderingSpecificationContext) {
                        switch (((TerminalNode)parseTree.getChild(0)).getSymbol().getType()) {
                            case 49: {
                                sortOrder = SortOrder.ASCENDING;
                                break;
                            }
                            case 67: {
                                sortOrder = SortOrder.DESCENDING;
                                break;
                            }
                            default: {
                                throw new SemanticException("Unrecognized sort ordering: " + parseTree.getText());
                            }
                        }
                        ++nextIndex;
                    } else {
                        sortOrder = null;
                    }
                    parseTree = ctx.getChild(nextIndex);
                    if (!(parseTree instanceof HqlParser.NullsPrecedenceContext)) break block13;
                    switch (((TerminalNode)parseTree.getChild(1)).getSymbol().getType()) {
                        case 81: {
                            nullPrecedence = NullPrecedence.FIRST;
                            break block14;
                        }
                        case 101: {
                            nullPrecedence = NullPrecedence.LAST;
                            break block14;
                        }
                        default: {
                            throw new SemanticException("Unrecognized null precedence: " + parseTree.getText());
                        }
                    }
                }
                nullPrecedence = null;
                break block14;
            }
            sortOrder = null;
            nullPrecedence = null;
        }
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public SqmExpression<?> visitSortExpression(HqlParser.SortExpressionContext ctx) {
        return this.resolveOrderByOrGroupByExpression(ctx.getChild(0), ctx.getChildCount() > 1);
    }

    private SqmQuerySpec<?> currentQuerySpec() {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            return ((SqmInsertSelectStatement)processingQuery).getSelectQueryPart().getLastQuerySpec();
        }
        return ((SqmQueryPart)((SqmSelectQuery)processingQuery).getQueryPart()).getLastQuerySpec();
    }

    private <X> void setCurrentQueryPart(SqmQueryPart<X> queryPart) {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            ((SqmInsertSelectStatement)processingQuery).setSelectQueryPart(queryPart);
        } else {
            ((AbstractSqmSelectQuery)processingQuery).setQueryPart(queryPart);
        }
    }

    private int getSelectionPosition(SqmSelection<?> selection) {
        return this.currentQuerySpec().getSelectClause().getSelections().indexOf(selection) + 1;
    }

    @Override
    public SqmExpression<?> visitLimitClause(HqlParser.LimitClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitFetchClause(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
    }

    private FetchClauseType visitFetchClauseType(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return FetchClauseType.ROWS_ONLY;
        }
        int thirdSymbolType = ((TerminalNode)ctx.getChild(3)).getSymbol().getType();
        int lastSymbolType = ((TerminalNode)ctx.getChild(ctx.getChildCount() - 1)).getSymbol().getType();
        if (lastSymbolType == 153) {
            return thirdSymbolType == 138 ? FetchClauseType.PERCENT_WITH_TIES : FetchClauseType.ROWS_WITH_TIES;
        }
        return thirdSymbolType == 138 ? FetchClauseType.PERCENT_ONLY : FetchClauseType.ROWS_ONLY;
    }

    @Override
    public Object visitSyntacticPathExpression(HqlParser.SyntacticPathExpressionContext ctx) {
        SemanticPathPart part = this.visitSyntacticDomainPath((HqlParser.SyntacticDomainPathContext)ctx.getChild(0));
        if (ctx.getChildCount() == 2) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(part, this){

                @Override
                protected void reset() {
                }
            });
            try {
                part = (SemanticPathPart)ctx.getChild(1).accept((ParseTreeVisitor)this);
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        if (part instanceof DomainPathPart) {
            return ((DomainPathPart)part).getSqmExpression();
        }
        return (SqmExpression)((Object)part);
    }

    @Override
    public Object visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx) {
        SemanticPathPart part = this.visitGeneralPathFragment((HqlParser.GeneralPathFragmentContext)ctx.getChild(0));
        if (part instanceof DomainPathPart) {
            return ((DomainPathPart)part).getSqmExpression();
        }
        return (SqmExpression)((Object)part);
    }

    @Override
    public SqmExpression<?> visitFunctionExpression(HqlParser.FunctionExpressionContext ctx) {
        return (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx) {
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof TerminalNode) {
            return this.integerLiteral(firstChild.getText());
        }
        return (SqmExpression)firstChild.accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return this.floatLiteral(ctx.FLOAT_LITERAL().getText());
        }
        if (ctx.DOUBLE_LITERAL() != null) {
            return this.doubleLiteral(ctx.DOUBLE_LITERAL().getText());
        }
        if (ctx.parameter() != null) {
            return (SqmExpression)ctx.parameter().accept(this);
        }
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof TerminalNode) {
            switch (((TerminalNode)firstChild).getSymbol().getType()) {
                case 3: {
                    return this.integerLiteral(firstChild.getText());
                }
                case 5: {
                    return this.floatLiteral(firstChild.getText());
                }
                case 6: {
                    return this.doubleLiteral(firstChild.getText());
                }
            }
            throw new UnsupportedOperationException("Unsupported literal: " + firstChild.getText());
        }
        return (SqmExpression)firstChild.accept((ParseTreeVisitor)this);
    }

    public String getEntityName(HqlParser.EntityNameContext parserEntityName) {
        StringBuilder sb = new StringBuilder();
        int end = parserEntityName.getChildCount();
        sb.append(this.visitIdentifier((HqlParser.IdentifierContext)parserEntityName.getChild(0)));
        for (int i = 2; i < end; i += 2) {
            sb.append('.');
            sb.append(this.visitIdentifier((HqlParser.IdentifierContext)parserEntityName.getChild(i)));
        }
        return sb.toString();
    }

    @Override
    public String visitIdentifier(HqlParser.IdentifierContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(0);
        if (node.getSymbol().getType() == 175) {
            return QuotingHelper.unquoteIdentifier(node.getText());
        }
        return node.getText();
    }

    @Override
    public EntityDomainType<?> visitEntityName(HqlParser.EntityNameContext parserEntityName) {
        String entityName = this.getEntityName(parserEntityName);
        EntityDomainType entityReference = this.getCreationContext().getJpaMetamodel().getHqlEntityReference(entityName);
        if (entityReference == null) {
            throw new UnknownEntityException("Could not resolve entity name [" + entityName + "] as DML target", entityName);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(entityName, entityReference);
        if (entityReference instanceof SqmPolymorphicRootDescriptor && this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered the use of a non entity name [" + entityName + "], but strict JPQL compliance was requested which doesn't allow this", StrictJpaComplianceViolation.Type.NON_ENTITY_NAME);
        }
        return entityReference;
    }

    @Override
    public SqmFromClause visitFromClause(HqlParser.FromClauseContext parserFromClause) {
        SqmFromClause fromClause;
        if (parserFromClause == null) {
            fromClause = new SqmFromClause();
        } else {
            int size = parserFromClause.getChildCount();
            int estimatedSize = size >> 1;
            fromClause = new SqmFromClause(estimatedSize);
            for (int i = 0; i < size; ++i) {
                ParseTree parseTree = parserFromClause.getChild(i);
                if (!(parseTree instanceof HqlParser.FromClauseSpaceContext)) continue;
                fromClause.addRoot((SqmRoot<?>)this.visitFromClauseSpace((HqlParser.FromClauseSpaceContext)parseTree));
            }
        }
        return fromClause;
    }

    @Override
    public SqmRoot<?> visitFromClauseSpace(HqlParser.FromClauseSpaceContext parserSpace) {
        Object sqmRoot = this.visitPathRoot((HqlParser.PathRootContext)parserSpace.getChild(0));
        int size = parserSpace.getChildCount();
        for (int i = 1; i < size; ++i) {
            ParseTree parseTree = parserSpace.getChild(i);
            if (parseTree instanceof HqlParser.CrossJoinContext) {
                this.consumeCrossJoin((HqlParser.CrossJoinContext)parseTree, (SqmRoot)sqmRoot);
                continue;
            }
            if (parseTree instanceof HqlParser.QualifiedJoinContext) {
                this.consumeQualifiedJoin((HqlParser.QualifiedJoinContext)parseTree, (SqmRoot)sqmRoot);
                continue;
            }
            if (!(parseTree instanceof HqlParser.JpaCollectionJoinContext)) continue;
            this.consumeJpaCollectionJoin((HqlParser.JpaCollectionJoinContext)parseTree, (SqmRoot<?>)sqmRoot);
        }
        return sqmRoot;
    }

    @Override
    public SqmRoot<?> visitPathRoot(HqlParser.PathRootContext ctx) {
        HqlParser.EntityNameContext entityNameContext = (HqlParser.EntityNameContext)ctx.getChild(0);
        List entityNameParseTreeChildren = entityNameContext.children;
        String name = this.getEntityName(entityNameContext);
        log.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().getHqlEntityReference(name);
        HqlParser.IdentificationVariableDefContext identificationVariableDefContext = ctx.getChildCount() > 1 ? (HqlParser.IdentificationVariableDefContext)ctx.getChild(1) : null;
        String alias = this.applyJpaCompliance(this.visitIdentificationVariableDef(identificationVariableDefContext));
        SqmCreationProcessingState processingState = this.processingStateStack.getCurrent();
        SqmPathRegistry pathRegistry = processingState.getPathRegistry();
        if (entityDescriptor == null) {
            int size = entityNameParseTreeChildren.size();
            if (this.processingStateStack.depth() > 1 && size > 2) {
                String parentAlias = ((ParseTree)entityNameParseTreeChildren.get(0)).getText();
                AbstractSqmFrom correlationBasis = (AbstractSqmFrom)processingState.getParentProcessingState().getPathRegistry().findFromByAlias(parentAlias);
                if (correlationBasis != null) {
                    SqmCorrelation correlation = correlationBasis.createCorrelation();
                    pathRegistry.register(correlation);
                    QualifiedJoinPathConsumer dotIdentifierConsumer = new QualifiedJoinPathConsumer(correlation, SqmJoinType.INNER, false, alias, (SqmCreationState)this);
                    int lastIdx = size - 1;
                    for (int i = 2; i != lastIdx; i += 2) {
                        dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(i)).getText(), false, false);
                    }
                    dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(lastIdx)).getText(), false, true);
                    return correlation.getCorrelatedRoot();
                }
                throw new IllegalArgumentException("Could not resolve entity reference or correlation path: " + name);
            }
            throw new IllegalArgumentException("Could not resolve entity reference: " + name);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(name, entityDescriptor);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered unmapped polymorphic reference [" + entityDescriptor.getHibernateEntityName() + "], but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.UNMAPPED_POLYMORPHISM);
            }
            if (this.processingStateStack.depth() > 1) {
                throw new SemanticException("Illegal implicit-polymorphic domain path in sub-query : " + entityDescriptor.getName());
            }
        }
        SqmRoot sqmRoot = new SqmRoot(entityDescriptor, alias, true, this.creationContext.getNodeBuilder());
        pathRegistry.register(sqmRoot);
        return sqmRoot;
    }

    @Override
    public String visitIdentificationVariableDef(HqlParser.IdentificationVariableDefContext ctx) {
        if (ctx == null) {
            return null;
        }
        ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 1);
        if (lastChild instanceof HqlParser.IdentifierContext) {
            Token identificationVariableToken;
            HqlParser.IdentifierContext identifierContext = (HqlParser.IdentifierContext)lastChild;
            if (this.getCreationOptions().useStrictJpaCompliance() && (identificationVariableToken = identifierContext.getStart()).getType() != 174) {
                throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariableToken.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
            }
            return this.visitIdentifier(identifierContext);
        }
        TerminalNode node = (TerminalNode)lastChild;
        if (node.getSymbol().getType() == 175) {
            return QuotingHelper.unquoteIdentifier(node.getText());
        }
        return node.getText();
    }

    private String applyJpaCompliance(String text) {
        if (text == null) {
            return null;
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            return text.toLowerCase(Locale.getDefault());
        }
        return text;
    }

    @Override
    public final SqmCrossJoin<?> visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        throw new UnsupportedOperationException("Unexpected call to #visitCrossJoin, see #consumeCrossJoin");
    }

    private <T> void consumeCrossJoin(HqlParser.CrossJoinContext parserJoin, SqmRoot<T> sqmRoot) {
        HqlParser.PathRootContext pathRootContext = (HqlParser.PathRootContext)parserJoin.getChild(2);
        HqlParser.EntityNameContext entityNameContext = (HqlParser.EntityNameContext)pathRootContext.getChild(0);
        String name = this.getEntityName(entityNameContext);
        SqmTreeCreationLogger.LOGGER.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().resolveHqlEntityReference(name);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Unmapped polymorphic reference cannot be used as a CROSS JOIN target");
        }
        HqlParser.IdentificationVariableDefContext identificationVariableDefContext = pathRootContext.getChildCount() > 1 ? (HqlParser.IdentificationVariableDefContext)pathRootContext.getChild(1) : null;
        SqmCrossJoin join = new SqmCrossJoin(entityDescriptor, this.visitIdentificationVariableDef(identificationVariableDefContext), sqmRoot);
        this.processingStateStack.getCurrent().getPathRegistry().register(join);
        sqmRoot.addSqmJoin((SqmJoin<T, ?>)join);
    }

    @Override
    public final SqmQualifiedJoin<?, ?> visitQualifiedJoin(HqlParser.QualifiedJoinContext parserJoin) {
        throw new UnsupportedOperationException("Unexpected call to #visitQualifiedJoin, see #consumeQualifiedJoin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <X> void consumeQualifiedJoin(HqlParser.QualifiedJoinContext parserJoin, SqmRoot<X> sqmRoot) {
        block16: {
            SqmJoinType joinType;
            int firstJoinTypeSymbolType = parserJoin.getChild(0) instanceof HqlParser.JoinTypeQualifierContext && parserJoin.getChild(0).getChildCount() != 0 ? ((TerminalNode)parserJoin.getChild(0).getChild(0)).getSymbol().getType() : 93;
            switch (firstJoinTypeSymbolType) {
                case 85: {
                    joinType = SqmJoinType.FULL;
                    break;
                }
                case 142: {
                    joinType = SqmJoinType.RIGHT;
                    break;
                }
                case 103: 
                case 135: {
                    joinType = SqmJoinType.LEFT;
                    break;
                }
                default: {
                    joinType = SqmJoinType.INNER;
                }
            }
            HqlParser.QualifiedJoinRhsContext qualifiedJoinRhsContext = parserJoin.qualifiedJoinRhs();
            HqlParser.IdentificationVariableDefContext identificationVariableDefContext = qualifiedJoinRhsContext.getChildCount() > 1 ? (HqlParser.IdentificationVariableDefContext)qualifiedJoinRhsContext.getChild(1) : null;
            String alias = this.visitIdentificationVariableDef(identificationVariableDefContext);
            boolean fetch = parserJoin.getChild(2) instanceof TerminalNode;
            if (fetch && this.processingStateStack.depth() > 1) {
                throw new SemanticException("fetch not allowed in subquery from-elements");
            }
            this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, joinType, fetch, alias, (SqmCreationState)this));
            try {
                SqmQualifiedJoin join = (SqmQualifiedJoin)qualifiedJoinRhsContext.getChild(0).accept((ParseTreeVisitor)this);
                HqlParser.QualifiedJoinPredicateContext qualifiedJoinPredicateContext = parserJoin.qualifiedJoinPredicate();
                if (join instanceof SqmEntityJoin) {
                    sqmRoot.addSqmJoin(join);
                } else {
                    SqmAttributeJoin attributeJoin = (SqmAttributeJoin)join;
                    if (this.getCreationOptions().useStrictJpaCompliance() && join.getExplicitAlias() != null && attributeJoin.isFetched()) {
                        throw new StrictJpaComplianceViolation("Encountered aliased fetch join, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.ALIASED_FETCH_JOIN);
                    }
                    if (qualifiedJoinPredicateContext != null && attributeJoin.isFetched()) {
                        throw new SemanticException("with-clause not allowed on fetched associations; use filters");
                    }
                }
                if (qualifiedJoinPredicateContext == null) break block16;
                this.dotIdentifierConsumerStack.push(new QualifiedJoinPredicatePathConsumer(join, (SqmCreationState)this));
                try {
                    join.setJoinPredicate((SqmPredicate)qualifiedJoinPredicateContext.getChild(1).accept((ParseTreeVisitor)this));
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
    }

    @Override
    public SqmJoin<?, ?> visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx, SqmRoot<?> sqmRoot) {
        HqlParser.IdentificationVariableDefContext identificationVariableDefContext = ctx.getChildCount() > 5 ? (HqlParser.IdentificationVariableDefContext)ctx.getChild(5) : null;
        String alias = this.visitIdentificationVariableDef(identificationVariableDefContext);
        this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, SqmJoinType.INNER, false, alias, (SqmCreationState)this));
        try {
            this.consumePluralAttributeReference((HqlParser.PathContext)ctx.getChild(3));
        }
        finally {
            this.dotIdentifierConsumerStack.pop();
        }
    }

    @Override
    public SqmPredicate visitWhereClause(HqlParser.WhereClauseContext ctx) {
        if (ctx == null || ctx.getChildCount() != 2) {
            return null;
        }
        return (SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmGroupedPredicate visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return new SqmGroupedPredicate((SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        return new SqmAndPredicate((SqmPredicate)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmPredicate)ctx.getChild(2).accept((ParseTreeVisitor)this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        return new SqmOrPredicate((SqmPredicate)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmPredicate)ctx.getChild(2).accept((ParseTreeVisitor)this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitNegatedPredicate(HqlParser.NegatedPredicateContext ctx) {
        SqmPredicate predicate = (SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this);
        if (predicate instanceof SqmNegatablePredicate) {
            ((SqmNegatablePredicate)predicate).negate();
            return predicate;
        }
        return new SqmNegatedPredicate(predicate, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmBetweenPredicate visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        boolean negated = ((TerminalNode)ctx.getChild(1)).getSymbol().getType() == 125;
        int startIndex = negated ? 3 : 2;
        return new SqmBetweenPredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex + 2).accept((ParseTreeVisitor)this), negated, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmNullnessPredicate visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 4;
        return new SqmNullnessPredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), negated, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmEmptinessPredicate visitIsEmptyPredicate(HqlParser.IsEmptyPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 4;
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)ctx.getChild(0).accept((ParseTreeVisitor)this), negated, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitComparisonOperator(HqlParser.ComparisonOperatorContext ctx) {
        TerminalNode firstToken = (TerminalNode)ctx.getChild(0);
        switch (firstToken.getSymbol().getType()) {
            case 15: {
                return ComparisonOperator.EQUAL;
            }
            case 16: {
                return ComparisonOperator.NOT_EQUAL;
            }
            case 19: {
                return ComparisonOperator.LESS_THAN;
            }
            case 20: {
                return ComparisonOperator.LESS_THAN_OR_EQUAL;
            }
            case 17: {
                return ComparisonOperator.GREATER_THAN;
            }
            case 18: {
                return ComparisonOperator.GREATER_THAN_OR_EQUAL;
            }
            case 98: {
                TerminalNode secondToken = (TerminalNode)ctx.getChild(1);
                return secondToken.getSymbol().getType() == 125 ? ComparisonOperator.NOT_DISTINCT_FROM : ComparisonOperator.DISTINCT_FROM;
            }
        }
        throw new QueryException("missing operator");
    }

    @Override
    public SqmPredicate visitComparisonPredicate(HqlParser.ComparisonPredicateContext ctx) {
        SqmExpression<?> left;
        SqmExpression<?> right;
        ComparisonOperator comparisonOperator = (ComparisonOperator)((Object)ctx.getChild(1).accept((ParseTreeVisitor)this));
        HqlParser.ExpressionContext leftExpressionContext = (HqlParser.ExpressionContext)ctx.getChild(0);
        HqlParser.ExpressionContext rightExpressionContext = (HqlParser.ExpressionContext)ctx.getChild(2);
        switch (comparisonOperator) {
            case EQUAL: 
            case NOT_EQUAL: 
            case DISTINCT_FROM: 
            case NOT_DISTINCT_FROM: {
                Map<Class<?>, Enum<?>> possibleEnumValues = this.getPossibleEnumValues(leftExpressionContext);
                if (possibleEnumValues != null) {
                    right = (SqmExpression)rightExpressionContext.accept(this);
                    left = this.resolveEnumShorthandLiteral(leftExpressionContext, possibleEnumValues, right.getJavaType());
                    break;
                }
                possibleEnumValues = this.getPossibleEnumValues(rightExpressionContext);
                if (possibleEnumValues != null) {
                    left = (SqmExpression)leftExpressionContext.accept(this);
                    right = this.resolveEnumShorthandLiteral(rightExpressionContext, possibleEnumValues, left.getJavaType());
                    break;
                }
                left = (SqmExpression)leftExpressionContext.accept(this);
                right = (SqmExpression)rightExpressionContext.accept(this);
                if (left instanceof SqmLiteralNull) {
                    return new SqmNullnessPredicate(right, comparisonOperator == ComparisonOperator.NOT_EQUAL || comparisonOperator == ComparisonOperator.DISTINCT_FROM, this.creationContext.getNodeBuilder());
                }
                if (!(right instanceof SqmLiteralNull)) break;
                return new SqmNullnessPredicate(left, comparisonOperator == ComparisonOperator.NOT_EQUAL || comparisonOperator == ComparisonOperator.DISTINCT_FROM, this.creationContext.getNodeBuilder());
            }
            default: {
                left = (SqmExpression<?>)leftExpressionContext.accept(this);
                right = (SqmExpression<?>)rightExpressionContext.accept(this);
            }
        }
        return new SqmComparisonPredicate(left, comparisonOperator, right, this.creationContext.getNodeBuilder());
    }

    private SqmExpression<?> resolveEnumShorthandLiteral(HqlParser.ExpressionContext expressionContext, Map<Class<?>, Enum<?>> possibleEnumValues, Class<?> enumType) {
        Enum<?> enumValue;
        if (possibleEnumValues != null && (enumValue = possibleEnumValues.get(enumType)) != null) {
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(enumValue.getClass().getCanonicalName(), true, false);
            dotIdentifierConsumer.consumeIdentifier(enumValue.name(), false, true);
            return (SqmExpression)((Object)this.dotIdentifierConsumerStack.getCurrent().getConsumedPart());
        }
        return (SqmExpression)expressionContext.accept(this);
    }

    private Map<Class<?>, Enum<?>> getPossibleEnumValues(HqlParser.ExpressionContext expressionContext) {
        if (expressionContext instanceof HqlParser.CollateExpressionContext && expressionContext.getChildCount() == 1) {
            ParseTree ctx = expressionContext.getChild(0);
            while (ctx instanceof HqlParser.PrimaryExpressionContext && ctx.getChildCount() == 1) {
                ctx = ctx.getChild(0);
            }
            if (ctx instanceof HqlParser.GeneralPathFragmentContext && ctx.getChildCount() == 1 && (ctx = ctx.getChild(0)) instanceof HqlParser.DotIdentifierSequenceContext) {
                return this.creationContext.getJpaMetamodel().getAllowedEnumLiteralTexts().get(ctx.getText());
            }
        }
        return null;
    }

    @Override
    public SqmPredicate visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        boolean caseSensitive;
        boolean negated = ((TerminalNode)ctx.getChild(1)).getSymbol().getType() == 125;
        int startIndex = negated ? 3 : 2;
        boolean bl = caseSensitive = ((TerminalNode)ctx.getChild(negated ? 2 : 1)).getSymbol().getType() == 104;
        if (ctx.getChildCount() == startIndex + 2) {
            return new SqmLikePredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex + 1).getChild(1).accept((ParseTreeVisitor)this), negated, caseSensitive, this.creationContext.getNodeBuilder());
        }
        return new SqmLikePredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(startIndex).accept((ParseTreeVisitor)this), negated, caseSensitive, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 5;
        SqmPath sqmPluralPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(ctx.getChildCount() - 1));
        if (sqmPluralPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return new SqmMemberOfPredicate((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), sqmPluralPath, negated, this.creationContext.getNodeBuilder());
        }
        throw new SemanticException("Path argument to MEMBER OF must be a plural attribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPredicate visitInPredicate(HqlParser.InPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 4;
        SqmExpression testExpression = (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
        HqlParser.InListContext inListContext = (HqlParser.InListContext)ctx.getChild(ctx.getChildCount() - 1);
        if (inListContext instanceof HqlParser.ExplicitTupleInListContext) {
            HqlParser.ExplicitTupleInListContext tupleExpressionListContext = (HqlParser.ExplicitTupleInListContext)inListContext;
            int size = tupleExpressionListContext.getChildCount();
            int estimatedSize = size >> 1;
            Class testExpressionJavaType = testExpression.getJavaType();
            boolean isEnum = testExpressionJavaType != null && testExpressionJavaType.isEnum();
            this.parameterDeclarationContextStack.push(() -> size == 3);
            try {
                ArrayList<SqmExpression> listExpressions = new ArrayList<SqmExpression>(estimatedSize);
                for (int i = 1; i < size; ++i) {
                    HqlParser.ExpressionContext expressionContext;
                    Map<Class<?>, Enum<?>> possibleEnumValues;
                    ParseTree parseTree = tupleExpressionListContext.getChild(i);
                    if (!(parseTree instanceof HqlParser.ExpressionOrPredicateContext)) continue;
                    ParseTree child = parseTree.getChild(0);
                    if (isEnum && child instanceof HqlParser.ExpressionContext && (possibleEnumValues = this.getPossibleEnumValues(expressionContext = (HqlParser.ExpressionContext)child)) != null) {
                        listExpressions.add(this.resolveEnumShorthandLiteral(expressionContext, possibleEnumValues, testExpressionJavaType));
                        continue;
                    }
                    listExpressions.add((SqmExpression)child.accept((ParseTreeVisitor)this));
                }
                SqmInListPredicate sqmInListPredicate = new SqmInListPredicate(testExpression, listExpressions, negated, this.creationContext.getNodeBuilder());
                return sqmInListPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.ParamInListContext) {
            HqlParser.ParamInListContext tupleExpressionListContext = (HqlParser.ParamInListContext)inListContext;
            this.parameterDeclarationContextStack.push(() -> true);
            try {
                SqmInListPredicate sqmInListPredicate = new SqmInListPredicate(testExpression, Collections.singletonList(tupleExpressionListContext.getChild(0).accept((ParseTreeVisitor)this)), negated, this.creationContext.getNodeBuilder());
                return sqmInListPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.SubQueryInListContext) {
            HqlParser.SubQueryInListContext subQueryOrParamInListContext = (HqlParser.SubQueryInListContext)inListContext;
            return new SqmInSubQueryPredicate(testExpression, this.visitSubQuery((HqlParser.SubQueryContext)subQueryOrParamInListContext.getChild(1)), negated, this.creationContext.getNodeBuilder());
        }
        if (inListContext instanceof HqlParser.PersistentCollectionReferenceInListContext) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
            }
            HqlParser.PersistentCollectionReferenceInListContext collectionReferenceInListContext = (HqlParser.PersistentCollectionReferenceInListContext)inListContext;
            return new SqmInSubQueryPredicate(testExpression, this.createCollectionReferenceSubQuery((HqlParser.DotIdentifierSequenceContext)collectionReferenceInListContext.getChild(2), (TerminalNode)collectionReferenceInListContext.getChild(0)), negated, this.creationContext.getNodeBuilder());
        }
        throw new ParsingException("Unexpected IN predicate type [" + ((Object)((Object)ctx)).getClass().getSimpleName() + "] : " + ctx.getText());
    }

    @Override
    public SqmPredicate visitExistsCollectionPartPredicate(HqlParser.ExistsCollectionPartPredicateContext ctx) {
        SqmSubQuery subQuery = this.createCollectionReferenceSubQuery((HqlParser.DotIdentifierSequenceContext)ctx.getChild(3), null);
        return new SqmExistsPredicate(subQuery, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitExistsPredicate(HqlParser.ExistsPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this);
        return new SqmExistsPredicate(expression, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitBooleanExpressionPredicate(HqlParser.BooleanExpressionPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        if (expression.getJavaType() != Boolean.class) {
            throw new SemanticException("Non-boolean expression used in predicate context: " + ctx.getText());
        }
        return new SqmBooleanExpressionPredicate(expression, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx) {
        ParseTree pathOrParameter = ctx.getChild(0).getChild(2);
        if (pathOrParameter instanceof HqlParser.ParameterContext) {
            return new SqmParameterizedEntityType((SqmParameter)pathOrParameter.accept((ParseTreeVisitor)this), this.creationContext.getNodeBuilder());
        }
        if (pathOrParameter instanceof HqlParser.PathContext) {
            return ((SqmPath)pathOrParameter.accept((ParseTreeVisitor)this)).type();
        }
        throw new ParsingException("Could not interpret grammar context as 'entity type' expression : " + ctx.getText());
    }

    @Override
    public SqmExpression<?> visitEntityIdExpression(HqlParser.EntityIdExpressionContext ctx) {
        return this.visitEntityIdReference((HqlParser.EntityIdReferenceContext)ctx.getChild(0));
    }

    @Override
    public SqmPath<?> visitEntityIdReference(HqlParser.EntityIdReferenceContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            SqmPathSource<?> identifierDescriptor = ((IdentifiableDomainType)sqmPathType).getIdentifierDescriptor();
            JpaPath idPath = sqmPath.get(identifierDescriptor.getPathName());
            if (ctx.getChildCount() != 5) {
                return idPath;
            }
            HqlParser.PathContinuationContext pathContinuationContext = (HqlParser.PathContinuationContext)ctx.getChild(4);
            throw new NotYetImplementedFor6Exception("Path continuation from `id()` reference not yet implemented");
        }
        throw new SemanticException("Path does not reference an identifiable-type : " + sqmPath.getNavigablePath().getFullPath());
    }

    @Override
    public SqmExpression<?> visitEntityVersionExpression(HqlParser.EntityVersionExpressionContext ctx) {
        return this.visitEntityVersionReference((HqlParser.EntityVersionReferenceContext)ctx.getChild(0));
    }

    @Override
    public SqmPath<?> visitEntityVersionReference(HqlParser.EntityVersionReferenceContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)sqmPathType;
            SingularPersistentAttribute versionAttribute = identifiableType.findVersionAttribute();
            if (versionAttribute == null) {
                throw new SemanticException("`" + sqmPath.getNavigablePath().getFullPath() + "` resolved to an identifiable-type (`" + identifiableType.getTypeName() + "`) which does not define a version");
            }
            return sqmPath.get(versionAttribute);
        }
        throw new SemanticException("Path does not reference an identifiable-type : " + sqmPath.getNavigablePath().getFullPath());
    }

    @Override
    public SqmPath<?> visitEntityNaturalIdExpression(HqlParser.EntityNaturalIdExpressionContext ctx) {
        return this.visitEntityNaturalIdReference((HqlParser.EntityNaturalIdReferenceContext)ctx.getChild(0));
    }

    @Override
    public SqmPath<?> visitEntityNaturalIdReference(HqlParser.EntityNaturalIdReferenceContext ctx) {
        throw new NotYetImplementedFor6Exception("Support for HQL natural-id references not yet implemented");
    }

    @Override
    public SqmMapEntryReference<?, ?> visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        return new SqmMapEntryReference(this.consumePluralAttributeReference((HqlParser.PathContext)ctx.getChild(2)), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitConcatenationExpression(HqlParser.ConcatenationExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new ParsingException("Expecting 2 operands to the concat operator");
        }
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this)), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitSignOperator(HqlParser.SignOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 29: {
                return UnaryArithmeticOperator.UNARY_PLUS;
            }
            case 30: {
                return UnaryArithmeticOperator.UNARY_MINUS;
            }
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitAdditiveOperator(HqlParser.AdditiveOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 29: {
                return BinaryArithmeticOperator.ADD;
            }
            case 30: {
                return BinaryArithmeticOperator.SUBTRACT;
            }
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitMultiplicativeOperator(HqlParser.MultiplicativeOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 31: {
                return BinaryArithmeticOperator.MULTIPLY;
            }
            case 32: {
                return BinaryArithmeticOperator.DIVIDE;
            }
            case 33: {
                return BinaryArithmeticOperator.MODULO;
            }
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new ParsingException("Expecting 2 operands to the additive operator");
        }
        return new SqmBinaryArithmetic((BinaryArithmeticOperator)((Object)ctx.getChild(1).accept((ParseTreeVisitor)this)), (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this), this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new ParsingException("Expecting 2 operands to the multiplicative operator");
        }
        SqmExpression left = (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
        SqmExpression right = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        BinaryArithmeticOperator operator = (BinaryArithmeticOperator)((Object)ctx.getChild(1).accept((ParseTreeVisitor)this));
        if (operator == BinaryArithmeticOperator.MODULO) {
            return this.getFunctionDescriptor("mod").generateSqmExpression(Arrays.asList(left, right), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
        }
        return new SqmBinaryArithmetic(operator, left, right, this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx) {
        return new SqmToDuration<Duration>((SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), this.toDurationUnit((SqmExtractUnit)ctx.getChild(1).accept((ParseTreeVisitor)this)), this.resolveExpressableTypeBasic(Duration.class), this.creationContext.getNodeBuilder());
    }

    private SqmDurationUnit<Long> toDurationUnit(SqmExtractUnit<?> extractUnit) {
        return new SqmDurationUnit<Long>(extractUnit.getUnit(), this.resolveExpressableTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx) {
        return new SqmByUnit(this.toDurationUnit((SqmExtractUnit)ctx.getChild(2).accept((ParseTreeVisitor)this)), (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this), this.resolveExpressableTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmUnaryOperation<?> visitUnaryExpression(HqlParser.UnaryExpressionContext ctx) {
        return new SqmUnaryOperation((UnaryArithmeticOperator)((Object)ctx.getChild(0).accept((ParseTreeVisitor)this)), (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this));
    }

    @Override
    public Object visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitCollateExpression(HqlParser.CollateExpressionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
        if (ctx.getChildCount() == 1) {
            return expression;
        }
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.COLLATIONS);
        }
        return new SqmCollate(expression, ctx.getChild(1).getChild(1).getText());
    }

    @Override
    public Object visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.TUPLES);
        }
        List<SqmExpression<?>> expressions = this.visitExpressions(ctx);
        return new SqmTuple(expressions, this.creationContext.getNodeBuilder());
    }

    private List<SqmExpression<?>> visitExpressions(ParserRuleContext parentContext) {
        int size = parentContext.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        ArrayList expressions = new ArrayList(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = parentContext.getChild(i);
            if (!(parseTree instanceof HqlParser.ExpressionOrPredicateContext)) continue;
            expressions.add((SqmExpression)parseTree.accept((ParseTreeVisitor)this));
        }
        return expressions;
    }

    @Override
    public Object visitCaseExpression(HqlParser.CaseExpressionContext ctx) {
        return ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmCaseSimple<?, ?> visitSimpleCaseList(HqlParser.SimpleCaseListContext ctx) {
        int size = ctx.getChildCount();
        SqmCaseSimple caseExpression = new SqmCaseSimple((SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this), null, size - 3, this.creationContext.getNodeBuilder());
        for (int i = 2; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.SimpleCaseWhenContext)) continue;
            caseExpression.when((SqmExpression)parseTree.getChild(1).accept((ParseTreeVisitor)this), (SqmExpression)parseTree.getChild(3).accept((ParseTreeVisitor)this));
        }
        ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 2);
        if (lastChild instanceof HqlParser.CaseOtherwiseContext) {
            caseExpression.otherwise((SqmExpression)lastChild.getChild(1).accept((ParseTreeVisitor)this));
        }
        return caseExpression;
    }

    @Override
    public SqmCaseSearched<?> visitSearchedCaseList(HqlParser.SearchedCaseListContext ctx) {
        int size = ctx.getChildCount();
        SqmCaseSearched caseExpression = new SqmCaseSearched(null, size - 2, this.creationContext.getNodeBuilder());
        for (int i = 1; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.SearchedCaseWhenContext)) continue;
            caseExpression.when((SqmPredicate)parseTree.getChild(1).accept((ParseTreeVisitor)this), (SqmExpression)parseTree.getChild(3).accept((ParseTreeVisitor)this));
        }
        ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 2);
        if (lastChild instanceof HqlParser.CaseOtherwiseContext) {
            caseExpression.otherwise((SqmExpression)lastChild.getChild(1).accept((ParseTreeVisitor)this));
        }
        return caseExpression;
    }

    @Override
    public SqmExpression<?> visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx) {
        return this.getFunctionDescriptor("current_date").generateSqmExpression(this.resolveExpressableTypeBasic(Date.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("current_time").generateSqmExpression(this.resolveExpressableTypeBasic(Time.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx) {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(this.resolveExpressableTypeBasic(Timestamp.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitInstantFunction(HqlParser.InstantFunctionContext ctx) {
        return this.getFunctionDescriptor("instant").generateSqmExpression(this.resolveExpressableTypeBasic(Instant.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLocalDateFunction(HqlParser.LocalDateFunctionContext ctx) {
        return this.getFunctionDescriptor("local_date").generateSqmExpression(this.resolveExpressableTypeBasic(LocalDate.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLocalTimeFunction(HqlParser.LocalTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_time").generateSqmExpression(this.resolveExpressableTypeBasic(LocalTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLocalDateTimeFunction(HqlParser.LocalDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_datetime").generateSqmExpression(this.resolveExpressableTypeBasic(LocalDateTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitOffsetDateTimeFunction(HqlParser.OffsetDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("offset_datetime").generateSqmExpression(this.resolveExpressableTypeBasic(OffsetDateTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitUnaryNumericLiteralExpression(HqlParser.UnaryNumericLiteralExpressionContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(1).getChild(0);
        Object text = ((TerminalNode)ctx.getChild(0).getChild(0)).getSymbol().getType() == 30 ? "-" + node.getText() : node.getText();
        switch (node.getSymbol().getType()) {
            case 3: {
                return this.integerOrLongLiteral((String)text);
            }
            case 4: {
                return this.longLiteral((String)text);
            }
            case 7: {
                return this.bigIntegerLiteral((String)text);
            }
            case 9: {
                return this.hexLiteral((String)text);
            }
            case 5: {
                return this.floatLiteral((String)text);
            }
            case 6: {
                return this.doubleLiteral((String)text);
            }
            case 8: {
                return this.bigDecimalLiteral((String)text);
            }
        }
        throw new ParsingException("Unexpected terminal node [" + (String)text + "]");
    }

    @Override
    public Object visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0);
        if (firstNode.getSymbol().getType() == 11) {
            return this.binaryLiteral(firstNode.getText());
        }
        StringBuilder text = new StringBuilder("x'");
        int size = ctx.getChildCount();
        for (int i = 0; i < size; ++i) {
            TerminalNode hex = (TerminalNode)ctx.getChild(i);
            if (hex.getSymbol().getType() != 9) continue;
            String hexText = hex.getText();
            if (hexText.length() != 4) {
                throw new LiteralNumberFormatException("not a byte: " + hexText);
            }
            text.append(hexText, 2, hexText.length());
        }
        return this.binaryLiteral(text.append("'").toString());
    }

    @Override
    public Object visitGeneralizedLiteral(HqlParser.GeneralizedLiteralContext ctx) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public SqmExpression<?> visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() == -1) {
            return null;
        }
        switch (node.getSymbol().getType()) {
            case 10: {
                return this.stringLiteral(node.getText());
            }
            case 3: {
                return this.integerOrLongLiteral(node.getText());
            }
            case 4: {
                return this.longLiteral(node.getText());
            }
            case 7: {
                return this.bigIntegerLiteral(node.getText());
            }
            case 9: {
                return this.hexLiteral(node.getText());
            }
            case 5: {
                return this.floatLiteral(node.getText());
            }
            case 6: {
                return this.doubleLiteral(node.getText());
            }
            case 8: {
                return this.bigDecimalLiteral(node.getText());
            }
            case 172: {
                return this.booleanLiteral(false);
            }
            case 171: {
                return this.booleanLiteral(true);
            }
            case 173: {
                return new SqmLiteralNull(this.creationContext.getQueryEngine().getCriteriaBuilder());
            }
            case 11: {
                return this.binaryLiteral(node.getText());
            }
        }
        throw new ParsingException("Unexpected terminal node [" + node.getText() + "]");
    }

    @Override
    public Object visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitDateLiteral(HqlParser.DateLiteralContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitTimeLiteral(HqlParser.TimeLiteralContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.DateTimeContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlTimestampLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.DateContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlDateLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.TimeContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlTimeLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitDateTime(HqlParser.DateTimeContext ctx) {
        ParseTree parseTree = ctx.getChild(2);
        if (parseTree instanceof HqlParser.ZoneIdContext || parseTree == null) {
            return this.dateTimeLiteralFrom((HqlParser.DateContext)ctx.getChild(0), (HqlParser.TimeContext)ctx.getChild(1), (HqlParser.ZoneIdContext)parseTree);
        }
        return this.offsetDatetimeLiteralFrom((HqlParser.DateContext)ctx.getChild(0), (HqlParser.TimeContext)ctx.getChild(1), (HqlParser.OffsetContext)parseTree);
    }

    private SqmLiteral<?> dateTimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.ZoneIdContext timezone) {
        if (timezone == null) {
            return new SqmLiteral<LocalDateTime>(LocalDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time)), this.resolveExpressableTypeBasic(LocalDateTime.class), this.creationContext.getNodeBuilder());
        }
        ZoneId zoneId = this.visitZoneId(timezone);
        return new SqmLiteral<ZonedDateTime>(ZonedDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), zoneId), this.resolveExpressableTypeBasic(ZonedDateTime.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public ZoneId visitZoneId(HqlParser.ZoneIdContext ctx) {
        TerminalNode firstChild = (TerminalNode)ctx.getChild(0);
        String timezoneText = firstChild.getSymbol().getType() == 10 ? QuotingHelper.unquoteStringLiteral(ctx.getText()) : ctx.getText();
        String timezoneFullName = ZoneId.SHORT_IDS.get(timezoneText);
        if (timezoneFullName == null) {
            return ZoneId.of(timezoneText);
        }
        return ZoneId.of(timezoneFullName);
    }

    private SqmLiteral<?> offsetDatetimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.OffsetContext offset) {
        return new SqmLiteral<OffsetDateTime>(OffsetDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), SemanticQueryBuilder.zoneOffset(offset)), this.resolveExpressableTypeBasic(OffsetDateTime.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitDate(HqlParser.DateContext ctx) {
        return new SqmLiteral<LocalDate>(SemanticQueryBuilder.localDate(ctx), this.resolveExpressableTypeBasic(LocalDate.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitTime(HqlParser.TimeContext ctx) {
        return new SqmLiteral<LocalTime>(SemanticQueryBuilder.localTime(ctx), this.resolveExpressableTypeBasic(LocalTime.class), this.creationContext.getNodeBuilder());
    }

    private static LocalTime localTime(HqlParser.TimeContext ctx) {
        int hour = Integer.parseInt(ctx.getChild(0).getText());
        int minute = Integer.parseInt(ctx.getChild(2).getText());
        if (ctx.getChildCount() == 5) {
            String secondText = ctx.getChild(4).getText();
            int index = secondText.indexOf(46);
            if (index < 0) {
                return LocalTime.of(hour, minute, Integer.parseInt(secondText));
            }
            return LocalTime.of(hour, minute, Integer.parseInt(secondText.substring(0, index)), Integer.parseInt(secondText.substring(index + 1)));
        }
        return LocalTime.of(hour, minute);
    }

    private static LocalDate localDate(HqlParser.DateContext ctx) {
        return LocalDate.of(Integer.parseInt(ctx.getChild(0).getText()), Integer.parseInt(ctx.getChild(2).getText()), Integer.parseInt(ctx.getChild(4).getText()));
    }

    private static ZoneOffset zoneOffset(HqlParser.OffsetContext offset) {
        int factor = ((TerminalNode)offset.getChild(0)).getSymbol().getType() == 29 ? 1 : -1;
        int hour = factor * Integer.parseInt(offset.getChild(1).getText());
        if (offset.getChildCount() == 2) {
            return ZoneOffset.ofHours(hour);
        }
        return ZoneOffset.ofHoursMinutes(hour, factor * Integer.parseInt(offset.getChild(3).getText()));
    }

    private SqmLiteral<?> sqlTimestampLiteralFrom(String literalText) {
        TemporalAccessor parsed = DateTimeUtils.DATE_TIME.parse(literalText.subSequence(1, literalText.length() - 1));
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.from(parsed);
            GregorianCalendar literal = GregorianCalendar.from(zonedDateTime);
            return new SqmLiteral<Calendar>(literal, this.resolveExpressableTypeBasic(Calendar.class), this.creationContext.getNodeBuilder());
        }
        catch (DateTimeException dte) {
            LocalDateTime localDateTime = LocalDateTime.from(parsed);
            Timestamp literal = Timestamp.valueOf(localDateTime);
            return new SqmLiteral<Timestamp>(literal, this.resolveExpressableTypeBasic(Timestamp.class), this.creationContext.getNodeBuilder());
        }
    }

    private SqmLiteral<Date> sqlDateLiteralFrom(String literalText) {
        LocalDate localDate = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(literalText.subSequence(1, literalText.length() - 1)));
        Date literal = Date.valueOf(localDate);
        return new SqmLiteral<Date>(literal, this.resolveExpressableTypeBasic(Date.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Time> sqlTimeLiteralFrom(String literalText) {
        LocalTime localTime = LocalTime.from(DateTimeFormatter.ISO_LOCAL_TIME.parse(literalText.subSequence(1, literalText.length() - 1)));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, this.resolveExpressableTypeBasic(Time.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Boolean> booleanLiteral(boolean value) {
        return new SqmLiteral<Boolean>(value, this.resolveExpressableTypeBasic(Boolean.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<String> stringLiteral(String text) {
        return new SqmLiteral<String>(QuotingHelper.unquoteStringLiteral(text), this.resolveExpressableTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<byte[]> binaryLiteral(String text) {
        return new SqmLiteral<byte[]>(PrimitiveByteArrayJavaTypeDescriptor.INSTANCE.fromString(CharSequenceHelper.subSequence(text, 2, text.length() - 1)), this.resolveExpressableTypeBasic(byte[].class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<? extends Number> integerOrLongLiteral(String text) {
        try {
            Integer value = Integer.valueOf(text);
            return new SqmLiteral<Integer>(value, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            try {
                Long value = Long.valueOf(text);
                return new SqmLiteral<Long>(value, this.resolveExpressableTypeBasic(Long.class), this.creationContext.getNodeBuilder());
            }
            catch (NumberFormatException e2) {
                e.addSuppressed(e2);
                throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Integer", e);
            }
        }
    }

    private SqmLiteral<Integer> integerLiteral(String text) {
        try {
            Integer value = Integer.valueOf(text);
            return new SqmLiteral<Integer>(value, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Integer", e);
        }
    }

    private SqmLiteral<Long> longLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("l") || text.endsWith("L")) {
                text = text.substring(0, text.length() - 1);
            }
            Long value = Long.valueOf(text);
            return new SqmLiteral<Long>(value, this.resolveExpressableTypeBasic(Long.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to Long", e);
        }
    }

    private SqmLiteral<? extends Number> hexLiteral(String text) {
        String originalText = text;
        text = text.substring(2);
        try {
            BasicType<Number> type;
            Number value;
            if (text.endsWith("l") || text.endsWith("L")) {
                text = text.substring(0, text.length() - 1);
                value = Long.parseUnsignedLong(text, 16);
                type = this.resolveExpressableTypeBasic(Long.class);
            } else {
                value = Integer.parseUnsignedInt(text, 16);
                type = this.resolveExpressableTypeBasic(Integer.class);
            }
            return new SqmLiteral<Integer>((Integer)value, (SqmExpressable<Integer>)type, this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "]", e);
        }
    }

    private SqmLiteral<BigInteger> bigIntegerLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bi") || text.endsWith("BI")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigInteger>(new BigInteger(text), this.resolveExpressableTypeBasic(BigInteger.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigInteger", e);
        }
    }

    private SqmLiteral<Float> floatLiteral(String text) {
        try {
            return new SqmLiteral<Float>(Float.valueOf(text), this.resolveExpressableTypeBasic(Float.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Float", e);
        }
    }

    private SqmLiteral<Double> doubleLiteral(String text) {
        try {
            return new SqmLiteral<Double>(Double.valueOf(text), this.resolveExpressableTypeBasic(Double.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Double", e);
        }
    }

    private SqmLiteral<BigDecimal> bigDecimalLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bd") || text.endsWith("BD")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigDecimal>(new BigDecimal(text), this.resolveExpressableTypeBasic(BigDecimal.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigDecimal", e);
        }
    }

    private <J> BasicType<J> resolveExpressableTypeBasic(Class<J> javaType) {
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
    }

    @Override
    public Object visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmNamedParameter<?> visitNamedParameter(HqlParser.NamedParameterContext ctx) {
        this.parameterStyle = this.parameterStyle.withNamed();
        SqmNamedParameter param = new SqmNamedParameter(ctx.getChild(1).getText(), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), this.creationContext.getNodeBuilder());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmPositionalParameter<?> visitPositionalParameter(HqlParser.PositionalParameterContext ctx) {
        if (ctx.getChildCount() == 1) {
            throw new SemanticException("Encountered positional parameter which did not declare position (? instead of, e.g., ?1)");
        }
        this.parameterStyle = this.parameterStyle.withPositional();
        SqmPositionalParameter param = new SqmPositionalParameter(Integer.parseInt(ctx.getChild(1).getText()), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), this.creationContext.getNodeBuilder());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmExpression<?> visitJpaNonStandardFunction(HqlParser.JpaNonStandardFunctionContext ctx) {
        String functionName = QuotingHelper.unquoteStringLiteral(ctx.getChild(2).getText()).toLowerCase();
        List functionArguments = ctx.getChildCount() > 4 ? (List)ctx.getChild(4).accept((ParseTreeVisitor)this) : Collections.emptyList();
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(this.resolveExpressableTypeBasic(Object.class)));
        }
        return functionTemplate.generateSqmExpression(functionArguments, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        String originalFunctionName = ctx.getChild(0).getText();
        String functionName = originalFunctionName.toLowerCase();
        if (this.creationOptions.useStrictJpaCompliance() && !JPA_STANDARD_FUNCTIONS.contains(functionName)) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [" + originalFunctionName + "], but strict JPA compliance was requested; use JPA's FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        ParseTree argumentChild = ctx.getChild(2);
        List<Object> functionArguments = argumentChild instanceof HqlParser.NonStandardFunctionArgumentsContext ? (List)argumentChild.accept((ParseTreeVisitor)this) : ("*".equals(argumentChild.getText()) ? Collections.singletonList(new SqmStar(this.getCreationContext().getNodeBuilder())) : Collections.emptyList());
        SqmPredicate filterExpression = this.getFilterExpression((ParseTree)ctx);
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(this.resolveExpressableTypeBasic(Object.class)), functionName, filterExpression != null ? FunctionKind.AGGREGATE : FunctionKind.NORMAL, null, SqlAstNodeRenderingMode.DEFAULT);
        }
        if (functionTemplate.getFunctionKind() == FunctionKind.AGGREGATE) {
            return functionTemplate.generateAggregateSqmExpression(functionArguments, filterExpression, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
        }
        if (filterExpression != null) {
            throw new ParsingException("Illegal use of a FILTER clause for non-aggregate function: " + originalFunctionName);
        }
        return functionTemplate.generateSqmExpression(functionArguments, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public List<SqmTypedNode<?>> visitNonStandardFunctionArguments(HqlParser.NonStandardFunctionArgumentsContext ctx) {
        int size = ctx.getChildCount();
        int lastIndex = size - 1;
        int estimateArgumentCount = size >> 1;
        ArrayList arguments = new ArrayList(estimateArgumentCount);
        int i = 0;
        boolean distinct = false;
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof HqlParser.DatetimeFieldContext) {
            arguments.add(this.toDurationUnit((SqmExtractUnit)firstChild.accept((ParseTreeVisitor)this)));
            i += 2;
        } else if (firstChild instanceof TerminalNode) {
            distinct = true;
            ++i;
        }
        while (i < size) {
            if (i == lastIndex) {
                arguments.add(this.visitFinalFunctionArgument(ctx.getChild(i)));
            } else {
                arguments.add((SqmTypedNode)ctx.getChild(i).accept((ParseTreeVisitor)this));
            }
            i += 2;
        }
        if (distinct) {
            NodeBuilder nodeBuilder = this.getCreationContext().getNodeBuilder();
            if (arguments.size() == 1) {
                arguments.set(0, new SqmDistinct((SqmExpression)arguments.get(0), nodeBuilder));
            } else {
                ArrayList newArguments = new ArrayList(1);
                newArguments.add(new SqmDistinct(new SqmTuple(arguments, nodeBuilder), nodeBuilder));
                return newArguments;
            }
        }
        return arguments;
    }

    private SqmExpression<?> visitFinalFunctionArgument(ParseTree expression) {
        this.parameterDeclarationContextStack.push(() -> !this.creationOptions.useStrictJpaCompliance());
        try {
            SqmExpression sqmExpression = (SqmExpression)expression.accept((ParseTreeVisitor)this);
            return sqmExpression;
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
    }

    private SqmFunctionDescriptor getFunctionDescriptor(String name) {
        return this.creationContext.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(name);
    }

    @Override
    public SqmExtractUnit<?> visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 65: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 121: {
                return new SqmExtractUnit<Integer>(TemporalUnit.MONTH, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 170: {
                return new SqmExtractUnit<Integer>(TemporalUnit.YEAR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 89: {
                return new SqmExtractUnit<Integer>(TemporalUnit.HOUR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 120: {
                return new SqmExtractUnit<Integer>(TemporalUnit.MINUTE, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 146: {
                return new SqmExtractUnit<Float>(TemporalUnit.SECOND, this.resolveExpressableTypeBasic(Float.class), nodeBuilder);
            }
            case 122: {
                return new SqmExtractUnit<Long>(TemporalUnit.NANOSECOND, this.resolveExpressableTypeBasic(Long.class), nodeBuilder);
            }
            case 166: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 141: {
                return new SqmExtractUnit<Integer>(TemporalUnit.QUARTER, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported datetime field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitDayField(HqlParser.DayFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(2)).getSymbol().getType()) {
            case 121: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_MONTH, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 166: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_WEEK, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 170: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_YEAR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported day field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitWeekField(HqlParser.WeekFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(2)).getSymbol().getType()) {
            case 121: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_MONTH, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 170: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_YEAR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported week field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitDateOrTimeField(HqlParser.DateOrTimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 63: {
                return this.isExtractingJdbcTemporalType ? new SqmExtractUnit<Date>(TemporalUnit.DATE, this.resolveExpressableTypeBasic(Date.class), nodeBuilder) : new SqmExtractUnit<LocalDate>(TemporalUnit.DATE, this.resolveExpressableTypeBasic(LocalDate.class), nodeBuilder);
            }
            case 154: {
                return this.isExtractingJdbcTemporalType ? new SqmExtractUnit<Time>(TemporalUnit.TIME, this.resolveExpressableTypeBasic(Time.class), nodeBuilder) : new SqmExtractUnit<LocalTime>(TemporalUnit.TIME, this.resolveExpressableTypeBasic(LocalTime.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported date or time field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitTimeZoneField(HqlParser.TimeZoneFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(ctx.getChildCount() - 1)).getSymbol().getType()) {
            case 156: {
                return new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_HOUR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case 157: {
                return new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_MINUTE, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
        }
        return new SqmExtractUnit<ZoneOffset>(TemporalUnit.OFFSET, this.resolveExpressableTypeBasic(ZoneOffset.class), nodeBuilder);
    }

    @Override
    public Object visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        SqmExpression expressionToExtract = (SqmExpression)ctx.getChild(ctx.getChildCount() - 2).accept((ParseTreeVisitor)this);
        this.isExtractingJdbcTemporalType = TypeConfiguration.isJdbcTemporalType(expressionToExtract.getNodeType());
        SqmExtractUnit extractFieldExpression = ctx.getChild(0) instanceof TerminalNode ? (SqmExtractUnit)ctx.getChild(2).accept((ParseTreeVisitor)this) : (SqmExtractUnit)ctx.getChild(0).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(extractFieldExpression, expressionToExtract), extractFieldExpression.getType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitFormat(HqlParser.FormatContext ctx) {
        String format = QuotingHelper.unquoteStringLiteral(ctx.getChild(0).getText());
        if (!FORMAT.matcher(format).matches()) {
            throw new SemanticException("illegal format pattern: '" + format + "'");
        }
        return new SqmFormat(format, (SqmExpressable<String>)this.resolveExpressableTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitFormatFunction(HqlParser.FormatFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmLiteral format = (SqmLiteral)ctx.getChild(4).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("format").generateSqmExpression(Arrays.asList(expressionToCast, format), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCastFunction(HqlParser.CastFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmCastTarget castTargetExpression = (SqmCastTarget)ctx.getChild(4).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("cast").generateSqmExpression(Arrays.asList(expressionToCast, castTargetExpression), castTargetExpression.getType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmCastTarget<?> visitCastTarget(HqlParser.CastTargetContext castTargetContext) {
        HqlParser.CastTargetTypeContext castTargetTypeContext = (HqlParser.CastTargetTypeContext)castTargetContext.getChild(0);
        String targetName = castTargetTypeContext.fullTargetName;
        Long length = null;
        Integer precision = null;
        Integer scale = null;
        switch (castTargetTypeContext.getChildCount()) {
            case 6: {
                scale = Integer.valueOf(castTargetTypeContext.getChild(4).getText());
            }
            case 4: {
                length = Long.valueOf(castTargetTypeContext.getChild(2).getText());
                precision = length.intValue();
            }
        }
        return new SqmCastTarget((AllowableFunctionReturnType)((Object)this.creationContext.getJpaMetamodel().getTypeConfiguration().resolveCastTargetType(targetName)), length, precision, scale, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitPositionFunction(HqlParser.PositionFunctionContext ctx) {
        SqmExpression pattern = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmExpression string = (SqmExpression)ctx.getChild(4).accept((ParseTreeVisitor)this);
        return this.getFunctionDescriptor("position").generateSqmExpression(Arrays.asList(pattern, string), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitOverlayFunction(HqlParser.OverlayFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmExpression replacement = (SqmExpression)ctx.getChild(4).accept((ParseTreeVisitor)this);
        SqmExpression start = (SqmExpression)ctx.getChild(6).accept((ParseTreeVisitor)this);
        SqmExpression length = ctx.getChildCount() == 10 ? (SqmExpression)ctx.getChild(8).accept((ParseTreeVisitor)this) : null;
        return this.getFunctionDescriptor("overlay").generateSqmExpression(length == null ? Arrays.asList(string, replacement, start) : Arrays.asList(string, replacement, start, length), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        SqmPredicate filterExpression = this.getFilterExpression((ParseTree)ctx);
        ParseTree argumentChild = ctx.getChild(2);
        if (argumentChild instanceof HqlParser.SubQueryContext) {
            SqmSubQuery subquery = (SqmSubQuery)argumentChild.accept((ParseTreeVisitor)this);
            return new SqmEvery(subquery, this.creationContext.getNodeBuilder());
        }
        if (argumentChild instanceof HqlParser.PredicateContext) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.FUNCTION_CALL);
            }
            SqmExpression argument = (SqmExpression)argumentChild.accept((ParseTreeVisitor)this);
            return this.getFunctionDescriptor("every").generateAggregateSqmExpression(Collections.singletonList(argument), filterExpression, this.resolveExpressableTypeBasic(Boolean.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmEvery(this.createCollectionReferenceSubQuery((HqlParser.DotIdentifierSequenceContext)ctx.getChild(3), (TerminalNode)ctx.getChild(1)), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        SqmPredicate filterExpression = this.getFilterExpression((ParseTree)ctx);
        ParseTree argumentChild = ctx.getChild(2);
        if (argumentChild instanceof HqlParser.SubQueryContext) {
            SqmSubQuery subquery = (SqmSubQuery)argumentChild.accept((ParseTreeVisitor)this);
            return new SqmAny(subquery, this.creationContext.getNodeBuilder());
        }
        if (argumentChild instanceof HqlParser.PredicateContext) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.FUNCTION_CALL);
            }
            SqmExpression argument = (SqmExpression)argumentChild.accept((ParseTreeVisitor)this);
            return this.getFunctionDescriptor("any").generateAggregateSqmExpression(Collections.singletonList(argument), filterExpression, this.resolveExpressableTypeBasic(Boolean.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmAny(this.createCollectionReferenceSubQuery((HqlParser.DotIdentifierSequenceContext)ctx.getChild(3), (TerminalNode)ctx.getChild(1)), this.creationContext.getNodeBuilder());
    }

    private <X> SqmSubQuery<X> createCollectionReferenceSubQuery(HqlParser.DotIdentifierSequenceContext pathCtx, TerminalNode collectionReferenceCtx) {
        SqmPath<?> pluralAttributePath = this.consumeDomainPath(pathCtx);
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new PathException("Illegal attempt to treat non-plural path as a plural path : " + pluralAttributePath.getNavigablePath());
        }
        PluralPersistentAttribute attribute = (PluralPersistentAttribute)referencedPathSource;
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder());
        SqmSelectClause selectClause = new SqmSelectClause(false, 1, this.creationContext.getNodeBuilder());
        SqmFromClause fromClause = new SqmFromClause(1);
        SqmCorrelation correlation = ((AbstractSqmFrom)pluralAttributePath.getLhs()).createCorrelation();
        Join collectionJoin = correlation.join(pluralAttributePath.getNavigablePath().getUnaliasedLocalName());
        fromClause.addRoot(correlation.getCorrelatedRoot());
        if (collectionReferenceCtx == null) {
            SqmLiteral<Integer> literal = new SqmLiteral<Integer>(1, this.creationContext.getNodeBuilder().getIntegerType(), this.creationContext.getNodeBuilder());
            subQuery.applyInferableType(literal.getNodeType());
            selectClause.setSelection(literal);
        } else {
            String partName;
            switch (collectionReferenceCtx.getSymbol().getType()) {
                case 69: {
                    partName = CollectionPart.Nature.ELEMENT.getName();
                    break;
                }
                case 92: {
                    partName = CollectionPart.Nature.INDEX.getName();
                    break;
                }
                default: {
                    throw new ParsingException("Unexpected collection reference : " + collectionReferenceCtx.getText());
                }
            }
            SemanticPathPart path = collectionJoin.resolvePathPart(partName, true, this);
            subQuery.applyInferableType(path.getNodeType());
            selectClause.setSelection((SqmSelectableNode<?>)((Object)path));
        }
        JpaQueryStructure querySpec = subQuery.getQuerySpec();
        ((SqmQuerySpec)querySpec).setFromClause(fromClause);
        ((SqmQuerySpec)querySpec).setSelectClause(selectClause);
        return subQuery;
    }

    private SqmPredicate getFilterExpression(ParseTree functionCtx) {
        ParseTree lastChild = functionCtx.getChild(functionCtx.getChildCount() - 1);
        if (lastChild instanceof HqlParser.FilterClauseContext) {
            return (SqmPredicate)lastChild.getChild(2).getChild(1).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    @Override
    public SqmExpression<?> visitCube(HqlParser.CubeContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.CUBE, this.visitExpressions(ctx), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitRollup(HqlParser.RollupContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.ROLLUP, this.visitExpressions(ctx), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmExpression start = (SqmExpression)ctx.getChild(4).accept((ParseTreeVisitor)this);
        SqmExpression length = ctx.getChildCount() == 8 ? (SqmExpression)ctx.getChild(6).accept((ParseTreeVisitor)this) : null;
        return this.getFunctionDescriptor("substring").generateSqmExpression(length == null ? Arrays.asList(source, start) : Arrays.asList(source, start, length), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitPadFunction(HqlParser.PadFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
        SqmExpression length = (SqmExpression)ctx.getChild(4).accept((ParseTreeVisitor)this);
        SqmTrimSpecification padSpec = this.visitPadSpecification((HqlParser.PadSpecificationContext)ctx.getChild(5));
        Object padChar = ctx.getChildCount() == 8 ? this.visitPadCharacter((HqlParser.PadCharacterContext)ctx.getChild(6)) : null;
        return this.getFunctionDescriptor("pad").generateSqmExpression(padChar != null ? Arrays.asList(source, length, padSpec, padChar) : Arrays.asList(source, length, padSpec), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmTrimSpecification visitPadSpecification(HqlParser.PadSpecificationContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 102: {
                return new SqmTrimSpecification(TrimSpec.LEADING, this.creationContext.getNodeBuilder());
            }
            case 158: {
                return new SqmTrimSpecification(TrimSpec.TRAILING, this.creationContext.getNodeBuilder());
            }
        }
        throw new ParsingException("Unsupported pad specification [" + ctx.getText() + "]");
    }

    @Override
    public SqmLiteral<Character> visitPadCharacter(HqlParser.PadCharacterContext ctx) {
        String padCharText = ctx.STRING_LITERAL().getText();
        if (padCharText.length() != 3) {
            throw new SemanticException("Pad character for pad() function must be single character, found: " + padCharText);
        }
        return new SqmLiteral<Character>(Character.valueOf(padCharText.charAt(1)), this.resolveExpressableTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        SqmTrimSpecification trimSpec;
        SqmExpression source = (SqmExpression)ctx.getChild(ctx.getChildCount() - 2).accept((ParseTreeVisitor)this);
        int index = 2;
        ParseTree parseTree = ctx.getChild(index);
        if (parseTree instanceof HqlParser.TrimSpecificationContext) {
            trimSpec = this.visitTrimSpecification((HqlParser.TrimSpecificationContext)parseTree);
            index = 3;
        } else {
            trimSpec = this.visitTrimSpecification(null);
        }
        parseTree = ctx.getChild(index);
        Object trimChar = parseTree instanceof HqlParser.TrimCharacterContext ? this.visitTrimCharacter((HqlParser.TrimCharacterContext)parseTree) : this.visitTrimCharacter(null);
        return this.getFunctionDescriptor("trim").generateSqmExpression(Arrays.asList(trimSpec, trimChar, source), null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmTrimSpecification visitTrimSpecification(HqlParser.TrimSpecificationContext ctx) {
        TrimSpec spec = TrimSpec.BOTH;
        if (ctx != null) {
            switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
                case 102: {
                    spec = TrimSpec.LEADING;
                    break;
                }
                case 158: {
                    spec = TrimSpec.TRAILING;
                }
            }
        }
        return new SqmTrimSpecification(spec, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmLiteral<Character> visitTrimCharacter(HqlParser.TrimCharacterContext ctx) {
        String trimCharText;
        String string = trimCharText = ctx != null ? QuotingHelper.unquoteStringLiteral(ctx.getText()) : " ";
        if (trimCharText.length() != 1) {
            throw new SemanticException("Trim character for trim() function must be single character, found: " + trimCharText);
        }
        return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressableTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmCollectionSize visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        return new SqmCollectionSize(this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2)), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPath<?> visitCollectionIndexFunction(HqlParser.CollectionIndexFunctionContext ctx) {
        String alias = ctx.getChild(2).getText();
        Object sqmFrom = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias);
        if (sqmFrom == null) {
            throw new ParsingException("Could not resolve identification variable [" + alias + "] to SqmFrom");
        }
        SqmPathSource pluralAttribute = sqmFrom.getReferencedPathSource();
        if (!(pluralAttribute instanceof PluralPersistentAttribute)) {
            throw new ParsingException("Could not resolve identification variable [" + alias + "] as plural-attribute");
        }
        return sqmFrom.resolvePathPart(CollectionPart.Nature.INDEX.getName(), true, this);
    }

    private boolean isIndexedPluralAttribute(SqmPath<?> path) {
        return path.getReferencedPathSource() instanceof PluralPersistentAttribute;
    }

    @Override
    public SqmMaxElementPath<?> visitMaxElementFunction(HqlParser.MaxElementFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmMaxElementPath(this.consumePluralAttributeReference((HqlParser.PathContext)ctx.getChild(2)));
    }

    @Override
    public SqmMinElementPath<?> visitMinElementFunction(HqlParser.MinElementFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmMinElementPath(this.consumePluralAttributeReference((HqlParser.PathContext)ctx.getChild(2)));
    }

    @Override
    public SqmMaxIndexPath<?> visitMaxIndexFunction(HqlParser.MaxIndexFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath<?> pluralPath = this.consumePluralAttributeReference((HqlParser.PathContext)ctx.getChild(2));
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("maxindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.getChild(2).getText() + "] resolved to " + pluralPath.getReferencedPathSource());
        }
        return new SqmMaxIndexPath(pluralPath);
    }

    @Override
    public SqmMinIndexPath<?> visitMinIndexFunction(HqlParser.MinIndexFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath<?> pluralPath = this.consumePluralAttributeReference((HqlParser.PathContext)ctx.getChild(2));
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("minindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.getChild(2).getText() + "] resolved to " + pluralPath.getReferencedPathSource());
        }
        return new SqmMinIndexPath(pluralPath);
    }

    @Override
    public SqmSubQuery<?> visitSubQueryExpression(HqlParser.SubQueryExpressionContext ctx) {
        return this.visitSubQuery((HqlParser.SubQueryContext)ctx.getChild(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSubQuery<?> visitSubQuery(HqlParser.SubQueryContext ctx) {
        HqlParser.QueryExpressionContext queryExpressionContext = (HqlParser.QueryExpressionContext)ctx.getChild(0);
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), subQuery, this));
        try {
            queryExpressionContext.accept(this);
            List<SqmSelection<?>> selections = ((SqmQuerySpec)subQuery.getQuerySpec()).getSelectClause().getSelections();
            if (selections.size() == 1) {
                subQuery.applyInferableType(selections.get(0).getNodeType());
            }
            SqmSubQuery sqmSubQuery = subQuery;
            return sqmSubQuery;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemanticPathPart visitPath(HqlParser.PathContext ctx) {
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof HqlParser.SyntacticDomainPathContext) {
            SemanticPathPart syntacticNavigablePathResult = this.visitSyntacticDomainPath((HqlParser.SyntacticDomainPathContext)firstChild);
            if (ctx.getChildCount() == 2) {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(syntacticNavigablePathResult, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    SemanticPathPart semanticPathPart = (SemanticPathPart)ctx.getChild(1).accept((ParseTreeVisitor)this);
                    return semanticPathPart;
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            return syntacticNavigablePathResult;
        }
        if (firstChild instanceof HqlParser.GeneralPathFragmentContext) {
            return (SemanticPathPart)firstChild.accept((ParseTreeVisitor)this);
        }
        throw new ParsingException("Unrecognized `path` rule branch");
    }

    @Override
    public SemanticPathPart visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        return this.visitIndexedPathAccessFragment((HqlParser.DotIdentifierSequenceContext)ctx.getChild(0), ctx.getChildCount() == 1 ? null : (HqlParser.IndexedPathAccessFragmentContext)ctx.getChild(1));
    }

    @Override
    public SemanticPathPart visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof HqlParser.TreatedNavigablePathContext) {
            return this.visitTreatedNavigablePath((HqlParser.TreatedNavigablePathContext)firstChild);
        }
        if (firstChild instanceof HqlParser.CollectionElementNavigablePathContext) {
            return this.visitCollectionElementNavigablePath((HqlParser.CollectionElementNavigablePathContext)firstChild);
        }
        if (firstChild instanceof HqlParser.CollectionIndexNavigablePathContext) {
            return this.visitCollectionIndexNavigablePath((HqlParser.CollectionIndexNavigablePathContext)firstChild);
        }
        if (firstChild instanceof HqlParser.MapKeyNavigablePathContext) {
            return this.visitMapKeyNavigablePath((HqlParser.MapKeyNavigablePathContext)firstChild);
        }
        if (firstChild instanceof HqlParser.DotIdentifierSequenceContext && ctx.getChildCount() == 2) {
            return this.visitIndexedPathAccessFragment((HqlParser.DotIdentifierSequenceContext)firstChild, (HqlParser.IndexedPathAccessFragmentContext)ctx.getChild(1));
        }
        throw new ParsingException("Unsure how to process `syntacticDomainPath` over : " + ctx.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemanticPathPart visitIndexedPathAccessFragment(HqlParser.DotIdentifierSequenceContext ctx, HqlParser.IndexedPathAccessFragmentContext idxCtx) {
        SemanticPathPart pathPart = this.visitDotIdentifierSequence(ctx);
        if (idxCtx == null) {
            return pathPart;
        }
        SqmExpression indexExpression = (SqmExpression)idxCtx.getChild(1).accept((ParseTreeVisitor)this);
        boolean hasIndexContinuation = idxCtx.getChildCount() == 5;
        SqmPath<?> indexedPath = pathPart.resolveIndexedAccess(indexExpression, !hasIndexContinuation, this);
        if (hasIndexContinuation) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(indexedPath, this){

                @Override
                protected void reset() {
                }
            });
            try {
                SemanticPathPart semanticPathPart = (SemanticPathPart)idxCtx.getChild(4).accept((ParseTreeVisitor)this);
                return semanticPathPart;
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        return indexedPath;
    }

    @Override
    public SemanticPathPart visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext idxCtx) {
        throw new UnsupportedOperationException("Should be handled by #visitIndexedPathAccessFragment");
    }

    @Override
    public SemanticPathPart visitDotIdentifierSequence(HqlParser.DotIdentifierSequenceContext ctx) {
        int numberOfContinuations = ctx.getChildCount() - 1;
        boolean hasContinuations = numberOfContinuations != 0;
        DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
        HqlParser.IdentifierContext identifierContext = (HqlParser.IdentifierContext)ctx.getChild(0);
        assert (identifierContext.getChildCount() == 1);
        dotIdentifierConsumer.consumeIdentifier(this.visitIdentifier(identifierContext), true, !hasContinuations);
        if (hasContinuations) {
            for (int i = 1; i < ctx.getChildCount(); ++i) {
                HqlParser.DotIdentifierSequenceContinuationContext continuation = (HqlParser.DotIdentifierSequenceContinuationContext)ctx.getChild(i);
                HqlParser.IdentifierContext identifier = (HqlParser.IdentifierContext)continuation.getChild(1);
                assert (identifier.getChildCount() == 1);
                dotIdentifierConsumer.consumeIdentifier(this.visitIdentifier(identifier), false, i >= numberOfContinuations);
            }
        }
        return dotIdentifierConsumer.getConsumedPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            ((QualifiedJoinPathConsumer)consumer).setTreated(true);
        }
        this.consumeManagedTypeReference((HqlParser.PathContext)ctx.getChild(2));
        String treatTargetName = ctx.getChild(4).getText();
        String treatTargetEntityName = this.getCreationContext().getJpaMetamodel().qualifyImportableName(treatTargetName);
        boolean hasContinuation = ctx.getChildCount() == 7;
        consumer.consumeTreat(treatTargetEntityName, !hasContinuation);
        SqmPath<?> result = (SqmPath<?>)consumer.getConsumedPart();
        if (hasContinuation) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                @Override
                protected void reset() {
                }
            });
            try {
                result = this.consumeDomainPath((HqlParser.DotIdentifierSequenceContext)ctx.getChild(6).getChild(1));
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        return result;
    }

    @Override
    public SqmPath<?> visitCollectionElementNavigablePath(HqlParser.CollectionElementNavigablePathContext ctx) {
        SqmPath pluralAttributePath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new PathException("Illegal attempt to treat non-plural path as a plural path : " + pluralAttributePath.getNavigablePath());
        }
        PluralPersistentAttribute attribute = (PluralPersistentAttribute)referencedPathSource;
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            if (attribute.getCollectionClassification() != CollectionClassification.MAP) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.VALUE_FUNCTION_ON_NON_MAP);
            }
            TerminalNode firstNode = (TerminalNode)ctx.getChild(0);
            if (firstNode.getSymbol().getType() == 69) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
            }
        }
        SqmPath<?> result = pluralAttributePath.resolvePathPart(CollectionPart.Nature.ELEMENT.getName(), true, this);
        if (ctx.getChildCount() == 5) {
            result = this.consumeDomainPath((HqlParser.DotIdentifierSequenceContext)ctx.getChild(4).getChild(1));
        }
        return result;
    }

    @Override
    public SqmPath<?> visitCollectionIndexNavigablePath(HqlParser.CollectionIndexNavigablePathContext ctx) {
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath pluralAttributePath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new PathException("Illegal attempt to treat non-plural path as a plural path : " + pluralAttributePath.getNavigablePath());
        }
        return pluralAttributePath.resolvePathPart(CollectionPart.Nature.INDEX.getName(), true, this);
    }

    @Override
    public SqmPath visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        SqmPath<?> result;
        SqmPath sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        if (sqmPath instanceof SqmMapJoin) {
            SqmMapJoin sqmMapJoin = (SqmMapJoin)sqmPath;
            result = sqmMapJoin.key();
        } else {
            assert (sqmPath instanceof SqmPluralValuedSimplePath);
            SqmPluralValuedSimplePath mapPath = (SqmPluralValuedSimplePath)sqmPath;
            result = mapPath.resolvePathPart(CollectionPart.Nature.INDEX.getName(), true, this);
        }
        if (ctx.getChildCount() == 5) {
            result = this.consumeDomainPath((HqlParser.DotIdentifierSequenceContext)ctx.getChild(4).getChild(1));
        }
        return result;
    }

    private <X> SqmPath<X> consumeDomainPath(HqlParser.PathContext parserPath) {
        SemanticPathPart consumedPart = (SemanticPathPart)parserPath.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath<?> consumeDomainPath(HqlParser.DotIdentifierSequenceContext sequence) {
        SemanticPathPart consumedPart = (SemanticPathPart)sequence.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath<?> consumeManagedTypeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        SqmPathSource<?> pathSource = sqmPath.getReferencedPathSource();
        if (pathSource.getSqmPathType() instanceof ManagedDomainType) {
            return sqmPath;
        }
        throw new SemanticException("Expecting ManagedType valued path [" + sqmPath.getNavigablePath() + "], but found : " + pathSource.getSqmPathType());
    }

    private SqmPath<?> consumePluralAttributeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        if (sqmPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return sqmPath;
        }
        throw new SemanticException("Expecting plural attribute valued path [" + sqmPath.getNavigablePath() + "], but found : " + sqmPath.getReferencedPathSource().getSqmPathType());
    }

    private void checkFQNEntityNameJpaComplianceViolationIfNeeded(String name, EntityDomainType<?> entityDescriptor) {
        if (this.getCreationOptions().useStrictJpaCompliance() && !name.equals(entityDescriptor.getName())) {
            throw new StrictJpaComplianceViolation("Encountered FQN entity name [" + name + "], but strict JPQL compliance was requested ( [" + entityDescriptor.getName() + "] should be used instead )", StrictJpaComplianceViolation.Type.FQN_ENTITY_NAME);
        }
    }

    static {
        HashSet<String> jpaStandardFunctions = new HashSet<String>();
        jpaStandardFunctions.add("avg");
        jpaStandardFunctions.add("max");
        jpaStandardFunctions.add("min");
        jpaStandardFunctions.add("sum");
        jpaStandardFunctions.add("count");
        jpaStandardFunctions.add("length");
        jpaStandardFunctions.add("locate");
        jpaStandardFunctions.add("abs");
        jpaStandardFunctions.add("sqrt");
        jpaStandardFunctions.add("mod");
        jpaStandardFunctions.add("size");
        jpaStandardFunctions.add("index");
        jpaStandardFunctions.add("current_date");
        jpaStandardFunctions.add("current_time");
        jpaStandardFunctions.add("current_timestamp");
        jpaStandardFunctions.add("concat");
        jpaStandardFunctions.add("substring");
        jpaStandardFunctions.add("trim");
        jpaStandardFunctions.add("lower");
        jpaStandardFunctions.add("upper");
        jpaStandardFunctions.add("coalesce");
        jpaStandardFunctions.add("nullif");
        JPA_STANDARD_FUNCTIONS = jpaStandardFunctions;
        FORMAT = Pattern.compile("('[^']+'|[:;/,.!@#$^&?~`|()\\[\\]{}<>\\-+*=]|\\s|G{1,2}|[yY]{1,4}|M{1,4}|w{1,2}|W|E{3,4}|e{1,2}|d{1,2}|D{1,3}|a{1,2}|[Hhms]{1,2}|S{1,6}|[zZx]{1,3})*");
    }

    private static enum ParameterStyle {
        UNKNOWN{

            @Override
            ParameterStyle withNamed() {
                return NAMED;
            }

            @Override
            ParameterStyle withPositional() {
                return POSITIONAL;
            }
        }
        ,
        NAMED{

            @Override
            ParameterStyle withNamed() {
                return NAMED;
            }

            @Override
            ParameterStyle withPositional() {
                throw new StrictJpaComplianceViolation("Cannot mix positional and named parameters", StrictJpaComplianceViolation.Type.MIXED_POSITIONAL_NAMED_PARAMETERS);
            }
        }
        ,
        POSITIONAL{

            @Override
            ParameterStyle withNamed() {
                throw new StrictJpaComplianceViolation("Cannot mix positional and named parameters", StrictJpaComplianceViolation.Type.MIXED_POSITIONAL_NAMED_PARAMETERS);
            }

            @Override
            ParameterStyle withPositional() {
                return POSITIONAL;
            }
        }
        ,
        MIXED{

            @Override
            ParameterStyle withNamed() {
                return MIXED;
            }

            @Override
            ParameterStyle withPositional() {
                return MIXED;
            }
        };


        abstract ParameterStyle withNamed();

        abstract ParameterStyle withPositional();
    }
}

