/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.TemporalType;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class BindingTypeHelper {
    public static final BindingTypeHelper INSTANCE = new BindingTypeHelper();

    private BindingTypeHelper() {
    }

    public <T> AllowableParameterType<T> resolveTemporalPrecision(TemporalType precision, AllowableParameterType<T> declaredParameterType, TypeConfiguration typeConfiguration) {
        if (precision != null) {
            if (!(declaredParameterType.getExpressableJavaTypeDescriptor() instanceof TemporalJavaTypeDescriptor)) {
                throw new UnsupportedOperationException("Cannot treat non-temporal parameter type with temporal precision");
            }
            TemporalJavaTypeDescriptor temporalJtd = (TemporalJavaTypeDescriptor)declaredParameterType.getExpressableJavaTypeDescriptor();
            if (temporalJtd.getPrecision() != precision) {
                return typeConfiguration.getBasicTypeRegistry().resolve(temporalJtd.resolveTypeForPrecision(precision, typeConfiguration), TemporalJavaTypeDescriptor.resolveJdbcTypeCode(precision));
            }
        }
        return declaredParameterType;
    }

    public JdbcMapping resolveBindType(Object value, JdbcMapping baseType, TypeConfiguration typeConfiguration) {
        if (value == null || !(baseType.getJavaTypeDescriptor() instanceof TemporalJavaTypeDescriptor)) {
            return baseType;
        }
        Class<?> javaType = value.getClass();
        TemporalType temporalType = ((TemporalJavaTypeDescriptor)baseType.getJavaTypeDescriptor()).getPrecision();
        switch (temporalType) {
            case TIMESTAMP: {
                return (JdbcMapping)((Object)this.resolveTimestampTemporalTypeVariant(javaType, (AllowableParameterType)((Object)baseType), typeConfiguration));
            }
            case DATE: {
                return (JdbcMapping)((Object)this.resolveDateTemporalTypeVariant(javaType, (AllowableParameterType)((Object)baseType), typeConfiguration));
            }
            case TIME: {
                return (JdbcMapping)((Object)this.resolveTimeTemporalTypeVariant(javaType, (AllowableParameterType)((Object)baseType), typeConfiguration));
            }
        }
        throw new IllegalArgumentException("Unexpected TemporalType [" + temporalType + "]; expecting TIMESTAMP, DATE or TIME");
    }

    public AllowableParameterType resolveTimestampTemporalTypeVariant(Class javaType, AllowableParameterType baseType, TypeConfiguration typeConfiguration) {
        if (baseType.getExpressableJavaTypeDescriptor().getJavaTypeClass().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.TIMESTAMP);
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INSTANT);
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.ZONED_DATE_TIME);
        }
        if (OffsetTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIMESTAMP");
    }

    public AllowableParameterType<?> resolveDateTemporalTypeVariant(Class<?> javaType, AllowableParameterType<?> baseType, TypeConfiguration typeConfiguration) {
        if (baseType.getExpressableJavaTypeDescriptor().getJavaTypeClass().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR_DATE);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.DATE);
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INSTANT);
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.ZONED_DATE_TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#DATE");
    }

    public AllowableParameterType resolveTimeTemporalTypeVariant(Class javaType, AllowableParameterType baseType, TypeConfiguration typeConfiguration) {
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR_TIME);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIME");
    }
}

