/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.hibernate.Incubating;
import org.hibernate.QueryException;
import org.hibernate.QueryParameterException;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.QueryParameterBindingImpl;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypedExpressable;
import org.hibernate.type.spi.TypeConfiguration;

@Incubating
public class QueryParameterBindingsImpl
implements QueryParameterBindings {
    private final SessionFactoryImplementor sessionFactory;
    private final ParameterMetadataImplementor parameterMetadata;
    private final boolean queryParametersValidationEnabled;
    private Map<QueryParameter<?>, QueryParameterBinding<?>> parameterBindingMap;

    public static QueryParameterBindingsImpl from(ParameterMetadataImplementor parameterMetadata, SessionFactoryImplementor sessionFactory) {
        return QueryParameterBindingsImpl.from(parameterMetadata, sessionFactory, sessionFactory.getSessionFactoryOptions().isQueryParametersValidationEnabled());
    }

    public static QueryParameterBindingsImpl from(ParameterMetadataImplementor parameterMetadata, SessionFactoryImplementor sessionFactory, boolean queryParametersValidationEnabled) {
        if (parameterMetadata == null) {
            throw new QueryParameterException("Query parameter metadata cannot be null");
        }
        return new QueryParameterBindingsImpl(sessionFactory, parameterMetadata, queryParametersValidationEnabled);
    }

    private QueryParameterBindingsImpl(SessionFactoryImplementor sessionFactory, ParameterMetadataImplementor parameterMetadata, boolean queryParametersValidationEnabled) {
        this.sessionFactory = sessionFactory;
        this.parameterMetadata = parameterMetadata;
        this.queryParametersValidationEnabled = queryParametersValidationEnabled;
        this.parameterBindingMap = new ConcurrentHashMap(parameterMetadata.getParameterCount());
    }

    protected <T> QueryParameterBinding<T> makeBinding(QueryParameterImplementor<T> queryParameter) {
        if (this.parameterBindingMap == null) {
            this.parameterBindingMap = new IdentityHashMap();
        } else assert (!this.parameterBindingMap.containsKey(queryParameter));
        if (!this.parameterMetadata.containsReference(queryParameter)) {
            throw new IllegalArgumentException("Cannot create binding for parameter reference [" + queryParameter + "] - reference is not a parameter of this query");
        }
        QueryParameterBindingImpl<T> binding = new QueryParameterBindingImpl<T>(queryParameter, this.sessionFactory, this.parameterMetadata.getInferredParameterType(queryParameter), this.queryParametersValidationEnabled);
        this.parameterBindingMap.put(queryParameter, binding);
        return binding;
    }

    @Override
    public boolean isBound(QueryParameterImplementor<?> parameter) {
        return this.getBinding(parameter).isBound();
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(QueryParameterImplementor<P> parameter) {
        if (this.parameterBindingMap == null) {
            return this.makeBinding(parameter);
        }
        QueryParameterBinding<Object> binding = this.parameterBindingMap.get(parameter);
        if (binding == null) {
            binding = this.makeBinding(parameter);
        }
        return binding;
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(int position) {
        return this.getBinding((QueryParameterImplementor<P>)this.parameterMetadata.getQueryParameter(position));
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(String name) {
        return this.getBinding((QueryParameterImplementor<P>)this.parameterMetadata.getQueryParameter(name));
    }

    @Override
    public void validate() {
        this.parameterMetadata.visitRegistrations(queryParameter -> {
            if (!this.parameterBindingMap.containsKey(queryParameter)) {
                if (queryParameter.getName() != null) {
                    throw new QueryException("Named parameter not bound : " + queryParameter.getName());
                }
                throw new QueryException("Ordinal parameter not bound : " + queryParameter.getPosition());
            }
        });
    }

    @Override
    public boolean hasAnyMultiValuedBindings() {
        for (QueryParameterBinding<?> binding : this.parameterBindingMap.values()) {
            if (!binding.isMultiValued()) continue;
            return true;
        }
        return false;
    }

    public void visitBindings(BiConsumer action) {
        this.parameterMetadata.visitRegistrations(queryParameterImplementor -> action.accept(queryParameterImplementor, this.parameterBindingMap.get(queryParameterImplementor)));
    }

    @Override
    public QueryKey.ParameterBindingsMemento generateQueryKeyMemento(SharedSessionContractImplementor persistenceContext) {
        int size = this.parameterBindingMap.size();
        ArrayList<Object> allBindValues = new ArrayList<Object>(size);
        int hashCode = 0;
        for (QueryParameterBinding<?> binding : this.parameterBindingMap.values()) {
            MappingModelExpressable<?> mappingType = this.determineMappingType(binding, persistenceContext);
            assert (mappingType instanceof JavaTypedExpressable);
            JavaType<?> javaType = ((JavaTypedExpressable)((Object)mappingType)).getExpressableJavaTypeDescriptor();
            if (binding.isMultiValued()) {
                for (Object bindValue : binding.getBindValues()) {
                    assert (bindValue != null);
                    Object disassembled = mappingType.disassemble(bindValue, persistenceContext);
                    allBindValues.add(disassembled);
                    int valueHashCode = bindValue != null ? javaType.extractHashCode(bindValue) : 0;
                    hashCode = 31 * hashCode + valueHashCode;
                }
                continue;
            }
            Object bindValue = binding.getBindValue();
            Object disassembled = mappingType.disassemble(bindValue, persistenceContext);
            allBindValues.add(disassembled);
            int valueHashCode = bindValue != null ? javaType.extractHashCode(bindValue) : 0;
            hashCode = 31 * hashCode + valueHashCode;
        }
        return new ParameterBindingsMementoImpl(allBindValues.toArray(new Object[0]), hashCode);
    }

    private MappingModelExpressable<?> determineMappingType(QueryParameterBinding<?> binding, SharedSessionContractImplementor session) {
        JavaTypedExpressable javaTypedExpressable;
        JavaType jtd;
        if (binding.getBindType() != null && binding.getBindType() instanceof MappingModelExpressable) {
            return (MappingModelExpressable)((Object)binding.getBindType());
        }
        if (binding.getType() != null) {
            return binding.getType();
        }
        TypeConfiguration typeConfiguration = session.getFactory().getTypeConfiguration();
        if (binding.getBindType() instanceof JavaTypedExpressable && (jtd = (javaTypedExpressable = (JavaTypedExpressable)((Object)binding.getBindType())).getExpressableJavaTypeDescriptor()).getJavaTypeClass() != null) {
            return typeConfiguration.getBasicTypeForJavaType(jtd.getJavaTypeClass());
        }
        if (binding.isMultiValued()) {
            Iterator<?> iterator = binding.getBindValues().iterator();
            Object firstNonNullBindValue = null;
            if (iterator.hasNext() && firstNonNullBindValue == null) {
                firstNonNullBindValue = iterator.next();
            }
            if (firstNonNullBindValue != null) {
                return typeConfiguration.getBasicTypeForJavaType(firstNonNullBindValue.getClass());
            }
        } else if (binding.getBindValue() != null) {
            return typeConfiguration.getBasicTypeForJavaType(binding.getBindValue().getClass());
        }
        return typeConfiguration.getBasicTypeForJavaType(binding.getBindType().getJavaType());
    }

    private static class ParameterBindingsMementoImpl
    implements QueryKey.ParameterBindingsMemento {
        private final Object[] values;
        private final int hashCode;

        private ParameterBindingsMementoImpl(Object[] values, int hashCode) {
            this.values = values;
            this.hashCode = hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterBindingsMementoImpl queryKey = (ParameterBindingsMementoImpl)o;
            if (this.hashCode != queryKey.hashCode) {
                return false;
            }
            return Arrays.equals(this.values, queryKey.values);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

