/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import jakarta.persistence.AttributeConverter;
import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.model.convert.internal.JpaAttributeConverterImpl;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValued;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class CompleteResultBuilderBasicValuedConverted<O, R>
implements CompleteResultBuilderBasicValued {
    private final String explicitColumnName;
    private final ManagedBean<? extends AttributeConverter<O, R>> converterBean;
    private final JavaType<? extends AttributeConverter<O, R>> converterJtd;
    private final BasicJavaType<O> domainJavaType;
    private final BasicValuedMapping underlyingMapping;

    public CompleteResultBuilderBasicValuedConverted(String explicitColumnName, ManagedBean<? extends AttributeConverter<O, R>> converterBean, JavaType<? extends AttributeConverter<O, R>> converterJtd, BasicJavaType<O> domainJavaType, BasicValuedMapping underlyingMapping) {
        this.explicitColumnName = explicitColumnName;
        this.converterBean = converterBean;
        this.converterJtd = converterJtd;
        this.domainJavaType = domainJavaType;
        this.underlyingMapping = underlyingMapping;
    }

    @Override
    public Class<?> getJavaType() {
        return this.domainJavaType.getJavaTypeClass();
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        SessionFactoryImplementor sessionFactory = creationStateImpl.getSessionFactory();
        String columnName = this.explicitColumnName != null ? this.explicitColumnName : jdbcResultsMetadata.resolveColumnName(resultPosition + 1);
        SqlSelection sqlSelection = creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(columnName, processingState -> {
            int jdbcPosition = this.explicitColumnName != null ? jdbcResultsMetadata.resolveColumnPosition(this.explicitColumnName) : resultPosition + 1;
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new SqlSelectionImpl(valuesArrayPosition, this.underlyingMapping);
        }), this.domainJavaType, sessionFactory.getTypeConfiguration());
        JpaAttributeConverterImpl valueConverter = new JpaAttributeConverterImpl(this.converterBean, this.converterJtd, this.domainJavaType, this.underlyingMapping.getJdbcMapping().getJavaTypeDescriptor());
        return new BasicResult<O>(sqlSelection.getValuesArrayPosition(), columnName, this.domainJavaType, valueConverter);
    }
}

