/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderStandard;

public abstract class AbstractFetchBuilderContainer<T extends AbstractFetchBuilderContainer<T>>
implements DynamicFetchBuilderContainer {
    private Map<String, DynamicFetchBuilder> fetchBuilderMap;

    protected abstract String getPropertyBase();

    @Override
    public DynamicFetchBuilder findFetchBuilder(String fetchableName) {
        return this.fetchBuilderMap == null ? null : this.fetchBuilderMap.get(fetchableName);
    }

    public T addProperty(String propertyName, String columnAlias) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(propertyName);
        fetchBuilder.addColumnAlias(columnAlias);
        return (T)this;
    }

    public T addProperty(String propertyName, String ... columnAliases) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(propertyName);
        ArrayHelper.forEach(columnAliases, fetchBuilder::addColumnAlias);
        return (T)this;
    }

    @Override
    public DynamicFetchBuilder addProperty(String propertyName) {
        if (this.fetchBuilderMap == null) {
            this.fetchBuilderMap = new HashMap<String, DynamicFetchBuilder>();
        } else {
            FetchBuilder existing = this.fetchBuilderMap.get(propertyName);
            if (existing != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Fetch was already defined for %s.%s : %s", this.getPropertyBase(), propertyName, existing));
            }
        }
        DynamicFetchBuilderStandard fetchBuilder = new DynamicFetchBuilderStandard(this, propertyName);
        this.fetchBuilderMap.put(propertyName, fetchBuilder);
        return fetchBuilder;
    }

    public void addFetchBuilder(String propertyName, DynamicFetchBuilder fetchBuilder) {
        if (this.fetchBuilderMap == null) {
            this.fetchBuilderMap = new HashMap<String, DynamicFetchBuilder>();
        }
        this.fetchBuilderMap.put(propertyName, fetchBuilder);
    }
}

