/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.results.dynamic.AbstractFetchBuilderContainer;
import org.hibernate.query.results.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderEntity;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicResultBuilderEntityStandard
extends AbstractFetchBuilderContainer<DynamicResultBuilderEntityStandard>
implements DynamicResultBuilderEntity,
NativeQuery.RootReturn {
    private static final String ELEMENT_PREFIX = CollectionPart.Nature.ELEMENT.getName() + ".";
    private final NavigablePath navigablePath;
    private final EntityMappingType entityMapping;
    private final String tableAlias;
    private LockMode lockMode;
    private List<String> idColumnNames;
    private String discriminatorColumnName;

    public DynamicResultBuilderEntityStandard(EntityMappingType entityMapping, String tableAlias) {
        this(entityMapping, tableAlias, new NavigablePath(entityMapping.getEntityName()));
    }

    public DynamicResultBuilderEntityStandard(EntityMappingType entityMapping, String tableAlias, NavigablePath navigablePath) {
        this.navigablePath = navigablePath;
        this.entityMapping = entityMapping;
        this.tableAlias = tableAlias;
    }

    @Override
    public Class<?> getJavaType() {
        return this.entityMapping.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public EntityMappingType getEntityMapping() {
        return this.entityMapping;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NativeQuery.RootReturn addIdColumnAliases(String ... aliases) {
        if (this.idColumnNames == null) {
            this.idColumnNames = new ArrayList<String>(aliases.length);
        }
        Collections.addAll(this.idColumnNames, aliases);
        return this;
    }

    @Override
    public String getDiscriminatorAlias() {
        return this.discriminatorColumnName;
    }

    @Override
    protected String getPropertyBase() {
        return this.entityMapping.getEntityName();
    }

    @Override
    public EntityResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        return this.buildResultOrFetch(tableGroup -> (EntityResult)this.entityMapping.createDomainResult(this.navigablePath, (TableGroup)tableGroup, this.tableAlias, domainResultCreationState), jdbcResultsMetadata, domainResultCreationState);
    }

    public Fetch buildFetch(FetchParent parent, Fetchable fetchable, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        return this.buildResultOrFetch(tableGroup -> parent.generateFetchableFetch(fetchable, this.navigablePath, FetchTiming.IMMEDIATE, true, null, domainResultCreationState), jdbcResultsMetadata, domainResultCreationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T buildResultOrFetch(Function<TableGroup, T> resultOrFetchBuilder, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DynamicFetchBuilder idFetchBuilder;
        DomainResultCreationStateImpl creationState = ResultsHelper.impl(domainResultCreationState);
        FromClauseAccess fromClauseAccess = domainResultCreationState.getSqlAstCreationState().getFromClauseAccess();
        TableGroup tableGroup = fromClauseAccess.resolveTableGroup(this.navigablePath, np -> {
            TableReference tableReference = this.entityMapping.createPrimaryTableReference(new SqlAliasBaseConstant(this.tableAlias), creationState.getSqlExpressionResolver(), creationState.getCreationContext());
            if (this.lockMode != null) {
                domainResultCreationState.getSqlAstCreationState().registerLockMode(this.tableAlias, this.lockMode);
            }
            return new TableGroupImpl(this.navigablePath, this.tableAlias, tableReference, this.entityMapping);
        });
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        List<String> idColumnAliases = this.idColumnNames != null ? this.idColumnNames : ((idFetchBuilder = this.findIdFetchBuilder()) != null ? idFetchBuilder.getColumnAliases() : null);
        if (idColumnAliases != null) {
            EntityIdentifierMapping identifierMapping = this.entityMapping.getIdentifierMapping();
            identifierMapping.forEachSelectable((selectionIndex, selectableMapping) -> this.resolveSqlSelection((String)idColumnAliases.get(selectionIndex), SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), selectableMapping.getJdbcMapping(), jdbcResultsMetadata, domainResultCreationState));
        }
        if (this.discriminatorColumnName != null) {
            this.resolveSqlSelection(this.discriminatorColumnName, SqlExpressionResolver.createColumnReferenceKey(tableReference, this.entityMapping.getDiscriminatorMapping().getSelectionExpression()), this.entityMapping.getDiscriminatorMapping().getJdbcMapping(), jdbcResultsMetadata, domainResultCreationState);
        }
        try {
            NavigablePath currentRelativePath = creationState.getCurrentRelativePath();
            Object prefix = currentRelativePath == null ? "" : currentRelativePath.getFullPath() + ".";
            creationState.pushExplicitFetchMementoResolver(arg_0 -> this.lambda$buildResultOrFetch$4((String)prefix, arg_0));
            T t = resultOrFetchBuilder.apply(tableGroup);
            return t;
        }
        finally {
            creationState.popExplicitFetchMementoResolver();
        }
    }

    private DynamicFetchBuilder findIdFetchBuilder() {
        EntityIdentifierMapping identifierMapping = this.entityMapping.getIdentifierMapping();
        if (identifierMapping instanceof SingleAttributeIdentifierMapping) {
            return this.findFetchBuilder(((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName());
        }
        return this.findFetchBuilder(identifierMapping.getPartName());
    }

    private void resolveSqlSelection(String columnAlias, String columnKey, JdbcMapping jdbcMapping, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(columnKey, state -> {
            int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(columnAlias);
            int valuesArrayPosition = jdbcPosition - 1;
            return new SqlSelectionImpl(valuesArrayPosition, jdbcMapping);
        }), jdbcMapping.getMappedJavaTypeDescriptor(), domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public DynamicResultBuilderEntityStandard setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    @Override
    public DynamicResultBuilderEntityStandard setDiscriminatorAlias(String columnName) {
        this.discriminatorColumnName = columnName;
        return this;
    }

    private /* synthetic */ FetchBuilder lambda$buildResultOrFetch$4(String prefix, String relativePath) {
        if (relativePath.startsWith(prefix)) {
            int startIndex = relativePath.regionMatches(prefix.length(), ELEMENT_PREFIX, 0, ELEMENT_PREFIX.length()) ? prefix.length() + ELEMENT_PREFIX.length() : prefix.length();
            return this.findFetchBuilder(relativePath.substring(startIndex));
        }
        return null;
    }
}

