/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.query.Limit;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryOptionsAdapter;

public interface QueryOptions {
    public static final QueryOptions NONE = new QueryOptionsAdapter(){};

    public Integer getTimeout();

    public FlushMode getFlushMode();

    public Boolean isReadOnly();

    public AppliedGraph getAppliedGraph();

    public TupleTransformer getTupleTransformer();

    public ResultListTransformer getResultListTransformer();

    public Boolean isResultCachingEnabled();

    public CacheRetrieveMode getCacheRetrieveMode();

    public CacheStoreMode getCacheStoreMode();

    default public CacheMode getCacheMode() {
        return CacheMode.fromJpaModes(this.getCacheRetrieveMode(), this.getCacheStoreMode());
    }

    public String getResultCacheRegionName();

    public LockOptions getLockOptions();

    public String getComment();

    public List<String> getDatabaseHints();

    public Integer getFetchSize();

    public Limit getLimit();

    default public Integer getFirstRow() {
        return this.getLimit().getFirstRow();
    }

    default public Integer getMaxRows() {
        return this.getLimit().getMaxRows();
    }

    default public Limit getEffectiveLimit() {
        Limit explicit = this.getLimit();
        return explicit != null ? explicit : Limit.NONE;
    }

    default public boolean hasLimit() {
        Limit limit = this.getLimit();
        if (limit != null) {
            if (limit.getFirstRow() != null) {
                return true;
            }
            if (limit.getMaxRows() != null) {
                return true;
            }
        }
        return false;
    }
}

