/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingSqmAggregateFunction;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractSqmSelfRenderingFunctionDescriptor
extends AbstractSqmFunctionDescriptor
implements FunctionRenderingSupport {
    private final FunctionKind functionKind;

    public AbstractSqmSelfRenderingFunctionDescriptor(String name, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        super(name, argumentsValidator, returnTypeResolver);
        this.functionKind = FunctionKind.NORMAL;
    }

    public AbstractSqmSelfRenderingFunctionDescriptor(String name, FunctionKind functionKind, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        super(name, argumentsValidator, returnTypeResolver);
        this.functionKind = functionKind;
    }

    @Override
    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        if (this.functionKind == FunctionKind.AGGREGATE) {
            return this.generateAggregateSqmExpression(arguments, null, impliedResultType, queryEngine, typeConfiguration);
        }
        return new SelfRenderingSqmFunction<T>(this, this::render, arguments, impliedResultType, this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    @Override
    public <T> SelfRenderingSqmAggregateFunction<T> generateSqmAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        if (this.functionKind != FunctionKind.AGGREGATE) {
            throw new UnsupportedOperationException("The function " + this.getName() + " is not an aggregate function!");
        }
        return new SelfRenderingSqmAggregateFunction<T>(this, this, arguments, filter, impliedResultType, this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    @Override
    public abstract void render(SqlAppender var1, List<SqlAstNode> var2, SqlAstTranslator<?> var3);

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> sqlAstArguments, Predicate filter, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, walker);
    }
}

