/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SimpleInsertQueryPlan
implements NonSelectQueryPlan {
    private final SqmInsertStatement sqmInsert;
    private final DomainParameterXref domainParameterXref;
    private Map<SqmParameter, MappingModelExpressable> paramTypeResolutions;
    private JdbcInsert jdbcInsert;
    private FromClauseAccess tableGroupAccess;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter, List<List<JdbcParameter>>>> jdbcParamsXref;

    public SimpleInsertQueryPlan(SqmInsertStatement sqmInsert, DomainParameterXref domainParameterXref) {
        this.sqmInsert = sqmInsert;
        this.domainParameterXref = domainParameterXref;
    }

    private SqlAstTranslator<JdbcInsert> createInsertTranslator(DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        QueryEngine queryEngine = factory.getQueryEngine();
        SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmTranslator<InsertStatement> translator = translatorFactory.createInsertTranslator(this.sqmInsert, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), factory);
        SqmTranslation<InsertStatement> sqmInterpretation = translator.translate();
        this.tableGroupAccess = sqmInterpretation.getFromClauseAccess();
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        this.paramTypeResolutions = sqmInterpretation.getSqmParameterMappingModelTypeResolutions();
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildInsertTranslator(factory, sqmInterpretation.getSqlAst());
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext executionContext) {
        BulkOperationCleanupAction.schedule(executionContext.getSession(), this.sqmInsert);
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<JdbcInsert> insertTranslator = null;
        if (this.jdbcInsert == null) {
            insertTranslator = this.createInsertTranslator(executionContext);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getDomainModel(), this.tableGroupAccess::findTableGroup, this.paramTypeResolutions::get, session);
        if (this.jdbcInsert != null && !this.jdbcInsert.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
            insertTranslator = this.createInsertTranslator(executionContext);
        }
        if (insertTranslator != null) {
            this.jdbcInsert = insertTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        } else {
            this.jdbcInsert.bindFilterJdbcParameters(jdbcParameterBindings);
        }
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcInsert, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext));
    }
}

