/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.UpdateHandler;
import org.hibernate.query.sqm.mutation.internal.cte.AbstractCteMutationHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;

public class CteUpdateHandler
extends AbstractCteMutationHandler
implements UpdateHandler {
    public CteUpdateHandler(SqmCteTable cteTable, SqmUpdateStatement sqmStatement, DomainParameterXref domainParameterXref, CteMutationStrategy strategy, SessionFactoryImplementor sessionFactory) {
        super(cteTable, sqmStatement, domainParameterXref, strategy, sessionFactory);
    }

    @Override
    protected void addDmlCtes(CteContainer statement, CteStatement idSelectCte, MultiTableSqmMutationConverter sqmConverter, Map<SqmParameter, List<JdbcParameter>> parameterResolutions, SessionFactoryImplementor factory) {
        TableGroup updatingTableGroup = sqmConverter.getMutatingTableGroup();
        SqmUpdateStatement updateStatement = (SqmUpdateStatement)this.getSqmDeleteOrUpdateStatement();
        EntityMappingType entityDescriptor = this.getEntityDescriptor();
        EntityPersister entityPersister = entityDescriptor.getEntityPersister();
        String rootEntityName = entityPersister.getRootEntityName();
        EntityPersister rootEntityDescriptor = factory.getDomainModel().getEntityDescriptor(rootEntityName);
        String hierarchyRootTableName = ((Joinable)((Object)rootEntityDescriptor)).getTableName();
        TableReference hierarchyRootTableReference = updatingTableGroup.resolveTableReference(updatingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        SqmSetClause setClause = updateStatement.getSetClause();
        ArrayList assignments = new ArrayList(setClause.getAssignments().size());
        LinkedHashMap paramTypeResolutions = new LinkedHashMap();
        sqmConverter.visitSetClause(setClause, assignments::add, (sqmParam, mappingType, jdbcParameters) -> {
            parameterResolutions.put(sqmParam, jdbcParameters);
            paramTypeResolutions.put(sqmParam, mappingType);
        });
        sqmConverter.addVersionedAssignment(assignments::add, updateStatement);
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(updatingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < updatingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(updatingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        HashMap assignmentsByTable = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        for (int i = 0; i < assignments.size(); ++i) {
            Assignment assignment = (Assignment)assignments.get(i);
            List<ColumnReference> assignmentColumnRefs = assignment.getAssignable().getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, tableReferenceByAlias);
                if (assignmentTableReference != null && !assignmentTableReference.equals(tableReference)) {
                    throw new IllegalStateException("Assignment referred to columns from multiple tables");
                }
                assignmentTableReference = tableReference;
            }
            assert (assignmentTableReference != null);
            ArrayList<Assignment> assignmentsForTable = (ArrayList<Assignment>)assignmentsByTable.get(assignmentTableReference);
            if (assignmentsForTable == null) {
                assignmentsForTable = new ArrayList<Assignment>();
                assignmentsByTable.put(assignmentTableReference, assignmentsForTable);
            }
            assignmentsForTable.add(assignment);
        }
        this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableColumnsVisitationSupplier) -> {
            CteTable dmlResultCte = new CteTable(this.getCteTableName(tableExpression), idSelectCte.getCteTable().getCteColumns(), factory);
            TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression, true, true);
            List assignmentList = (List)assignmentsByTable.get(updatingTableReference);
            if (assignmentList == null) {
                return;
            }
            NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
            ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
            ((Consumer)tableColumnsVisitationSupplier.get()).accept((index, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, selectable, factory)));
            UpdateStatement dmlStatement = new UpdateStatement(dmlTableReference, assignmentList, this.createIdSubQueryPredicate(columnReferences, idSelectCte, factory), columnReferences);
            statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
        });
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    private TableReference resolveTableReference(ColumnReference columnReference, Map<String, TableReference> tableReferenceByAlias) {
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + columnReference);
    }
}

