/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SortOrder;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedInsertHandler;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.JdbcUpdate;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;

public class InsertExecutionDelegate
implements TableBasedInsertHandler.ExecutionDelegate {
    private final SqmInsertStatement<?> sqmInsert;
    private final MultiTableSqmMutationConverter sqmConverter;
    private final TemporaryTable entityTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final TableGroup updatingTableGroup;
    private final InsertStatement insertStatement;
    private final EntityMappingType entityDescriptor;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final Map<TableReference, List<Assignment>> assignmentsByTable;
    private final Map<SqmParameter, MappingModelExpressable> paramTypeResolutions;
    private final SessionFactoryImplementor sessionFactory;

    public InsertExecutionDelegate(SqmInsertStatement<?> sqmInsert, MultiTableSqmMutationConverter sqmConverter, TemporaryTable entityTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainParameterXref domainParameterXref, TableGroup insertingTableGroup, Map<String, TableReference> tableReferenceByAlias, List<Assignment> assignments, InsertStatement insertStatement, Map<SqmParameter, List<List<JdbcParameter>>> parameterResolutions, Map<SqmParameter, MappingModelExpressable> paramTypeResolutions, DomainQueryExecutionContext executionContext) {
        this.sqmInsert = sqmInsert;
        this.sqmConverter = sqmConverter;
        this.entityTable = entityTable;
        this.afterUseAction = afterUseAction;
        this.sessionUidAccess = sessionUidAccess;
        this.domainParameterXref = domainParameterXref;
        this.updatingTableGroup = insertingTableGroup;
        this.paramTypeResolutions = paramTypeResolutions;
        this.insertStatement = insertStatement;
        this.sessionFactory = executionContext.getSession().getFactory();
        ModelPartContainer updatingModelPart = insertingTableGroup.getModelPart();
        assert (updatingModelPart instanceof EntityMappingType);
        this.entityDescriptor = (EntityMappingType)updatingModelPart;
        this.assignmentsByTable = CollectionHelper.mapOfSize(insertingTableGroup.getTableReferenceJoins().size() + 1);
        this.jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, SqmUtil.generateJdbcParamsXref(domainParameterXref, () -> parameterResolutions), this.sessionFactory.getDomainModel(), navigablePath -> insertingTableGroup, paramTypeResolutions::get, executionContext.getSession());
        for (int i = 0; i < assignments.size(); ++i) {
            Assignment assignment = assignments.get(i);
            Assignable assignable = assignment.getAssignable();
            List<ColumnReference> assignmentColumnRefs = assignable.getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, insertingTableGroup, tableReferenceByAlias);
                if (assignmentTableReference != null && assignmentTableReference != tableReference) {
                    throw new SemanticException("Assignment referred to columns from multiple tables: " + i);
                }
                assignmentTableReference = tableReference;
            }
            this.assignmentsByTable.computeIfAbsent(assignmentTableReference, k -> new ArrayList()).add(assignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(ExecutionContext executionContext) {
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.entityTable, executionContext);
        try {
            int rows = ExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(this.insertStatement, this.jdbcParameterBindings, executionContext);
            if (rows != 0) {
                AbstractEntityPersister persister = (AbstractEntityPersister)this.entityDescriptor.getEntityPersister();
                int tableSpan = persister.getTableSpan();
                this.insertRootTable(persister.getTableName(0), rows, persister.getKeyColumns(0), executionContext);
                for (int i = 1; i < tableSpan; ++i) {
                    this.insertTable(persister.getTableName(i), persister.getKeyColumns(i), persister.isNullableTable(i), executionContext);
                }
            }
            int n = rows;
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.entityTable, this.sessionUidAccess, this.afterUseAction, executionContext);
        }
    }

    private TableReference resolveTableReference(ColumnReference columnReference, TableGroup updatingTableGroup, Map<String, TableReference> tableReferenceByAlias) {
        if (columnReference.getQualifier() == null) {
            return null;
        }
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + columnReference);
    }

    private NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional(), this.sessionFactory);
        }
        return (NamedTableReference)tableReference;
    }

    private void insertRootTable(String tableExpression, int rows, String[] keyColumns, final ExecutionContext executionContext) {
        LinkedHashMap entityTableToRootIdentity;
        TableReference updatingTableReference = this.updatingTableGroup.getTableReference(this.updatingTableGroup.getNavigablePath(), tableExpression, true, true);
        IdentifierGenerator identifierGenerator = this.entityDescriptor.getEntityPersister().getIdentifierGenerator();
        List<Assignment> assignments = this.assignmentsByTable.get(updatingTableReference);
        if ((assignments == null || assignments.isEmpty()) && !(identifierGenerator instanceof PostInsertIdentifierGenerator)) {
            throw new IllegalStateException("There must be at least a single root table assignment");
        }
        NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        QuerySpec querySpec = new QuerySpec(true);
        NamedTableReference temporaryTableReference = new NamedTableReference(this.insertStatement.getTargetTable().getTableExpression(), updatingTableReference.getIdentificationVariable(), false, this.sessionFactory);
        TableGroupImpl temporaryTableGroup = new TableGroupImpl(this.updatingTableGroup.getNavigablePath(), null, temporaryTableReference, this.entityDescriptor);
        querySpec.getFromClause().addRoot(temporaryTableGroup);
        InsertStatement insertStatement = new InsertStatement(dmlTableReference);
        insertStatement.setSourceSelectStatement(querySpec);
        for (Assignment assignment : assignments) {
            insertStatement.addTargetColumnReferences(assignment.getAssignable().getColumnReferences());
            for (ColumnReference columnReference : assignment.getAssignable().getColumnReferences()) {
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference(updatingTableReference.getIdentificationVariable(), columnReference.getColumnExpression(), false, null, null, columnReference.getJdbcMapping(), this.sessionFactory)));
            }
        }
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        if (identifierGenerator instanceof PostInsertIdentifierGenerator) {
            BasicEntityIdentifierMapping identifierMapping = (BasicEntityIdentifierMapping)this.entityDescriptor.getIdentifierMapping();
            QuerySpec idSelectQuerySpec = new QuerySpec(true);
            idSelectQuerySpec.getFromClause().addRoot(temporaryTableGroup);
            ColumnReference columnReference = new ColumnReference((String)null, "HTE_IDENTITY", false, null, null, identifierMapping.getJdbcMapping(), this.sessionFactory);
            idSelectQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, columnReference));
            idSelectQuerySpec.addSortSpecification(new SortSpecification(columnReference, null, SortOrder.ASCENDING));
            SelectStatement selectStatement = new SelectStatement(idSelectQuerySpec, Collections.singletonList(new BasicFetch(0, null, null, identifierMapping, null, FetchTiming.IMMEDIATE, null)));
            JdbcSelect jdbcSelect = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.sessionFactory, selectStatement).translate(null, executionContext.getQueryOptions());
            List list = jdbcServices.getJdbcSelectExecutor().list(jdbcSelect, JdbcParameterBindings.NO_BINDINGS, executionContext, null, ListResultsConsumer.UniqueSemantic.NONE);
            entityTableToRootIdentity = new LinkedHashMap(list.size());
            for (Object o : list) {
                entityTableToRootIdentity.put(o, null);
            }
            querySpec.applyPredicate(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, new JdbcParameterImpl(identifierMapping.getJdbcMapping())));
        } else {
            Optimizer optimizer;
            entityTableToRootIdentity = null;
            if (identifierGenerator instanceof OptimizableGenerator && (optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1) {
                BasicEntityIdentifierMapping identifierMapping = (BasicEntityIdentifierMapping)this.entityDescriptor.getIdentifierMapping();
                JdbcParameterImpl rowNumber = new JdbcParameterImpl(identifierMapping.getJdbcMapping());
                JdbcParameterImpl rootIdentity = new JdbcParameterImpl(identifierMapping.getJdbcMapping());
                ArrayList<Assignment> temporaryTableAssignments = new ArrayList<Assignment>(1);
                ColumnReference idColumnReference = new ColumnReference((String)null, (SelectableMapping)identifierMapping, this.sessionFactory);
                temporaryTableAssignments.add(new Assignment(idColumnReference, rootIdentity));
                TemporaryTableColumn rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - 1);
                UpdateStatement updateStatement = new UpdateStatement(temporaryTableReference, temporaryTableAssignments, new ComparisonPredicate(new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, null, rowNumberColumn.getJdbcMapping(), this.sessionFactory), ComparisonOperator.EQUAL, rowNumber));
                JdbcUpdate jdbcUpdate = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildUpdateTranslator(this.sessionFactory, updateStatement).translate(null, executionContext.getQueryOptions());
                JdbcParameterBindingsImpl updateBindings = new JdbcParameterBindingsImpl(2);
                for (int i = 0; i < rows; ++i) {
                    updateBindings.addBinding(rowNumber, new JdbcParameterBindingImpl(rowNumberColumn.getJdbcMapping(), i + 1));
                    updateBindings.addBinding(rootIdentity, new JdbcParameterBindingImpl(identifierMapping.getJdbcMapping(), identifierGenerator.generate(executionContext.getSession(), null)));
                    jdbcServices.getJdbcMutationExecutor().execute(jdbcUpdate, updateBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
                }
                if (insertStatement.getTargetColumnReferences().stream().noneMatch(c -> keyColumns[0].equals(c.getColumnExpression()))) {
                    insertStatement.addTargetColumnReferences(new ColumnReference((String)null, keyColumns[0], false, null, null, identifierMapping.getJdbcMapping(), this.sessionFactory));
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference(updatingTableReference.getIdentificationVariable(), idColumnReference.getColumnExpression(), false, null, null, idColumnReference.getJdbcMapping(), this.sessionFactory)));
                }
            }
        }
        JdbcInsert jdbcInsert = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildInsertTranslator(this.sessionFactory, insertStatement).translate(null, executionContext.getQueryOptions());
        if (identifierGenerator instanceof PostInsertIdentifierGenerator) {
            PostInsertIdentifierGenerator generator = (PostInsertIdentifierGenerator)identifierGenerator;
            boolean generatedKeysEnabled = this.sessionFactory.getSessionFactoryOptions().isGetGeneratedKeysEnabled();
            InsertGeneratedIdentifierDelegate identifierDelegate = generator.getInsertGeneratedIdentifierDelegate((PostInsertIdentityPersister)this.entityDescriptor.getEntityPersister(), jdbcServices.getDialect(), generatedKeysEnabled);
            String finalSql = identifierDelegate.prepareIdentifierGeneratingInsert(jdbcInsert.getSql());
            BasicEntityIdentifierMapping identifierMapping = (BasicEntityIdentifierMapping)this.entityDescriptor.getIdentifierMapping();
            final ValueBinder jdbcValueBinder = identifierMapping.getJdbcMapping().getJdbcValueBinder();
            for (final Map.Entry entry : entityTableToRootIdentity.entrySet()) {
                Object rootIdentity = identifierDelegate.performInsert(finalSql, executionContext.getSession(), new Binder(){

                    @Override
                    public void bindValues(PreparedStatement ps) throws SQLException {
                        jdbcValueBinder.bind(ps, entry.getKey(), 1, (WrapperOptions)executionContext.getSession());
                    }

                    @Override
                    public Object getEntity() {
                        return null;
                    }
                });
                entry.setValue(rootIdentity);
            }
            JdbcParameterImpl entityIdentity = new JdbcParameterImpl(identifierMapping.getJdbcMapping());
            JdbcParameterImpl jdbcParameterImpl = new JdbcParameterImpl(identifierMapping.getJdbcMapping());
            ArrayList<Assignment> temporaryTableAssignments = new ArrayList<Assignment>(1);
            temporaryTableAssignments.add(new Assignment(new ColumnReference((String)null, (SelectableMapping)identifierMapping, this.sessionFactory), jdbcParameterImpl));
            UpdateStatement updateStatement = new UpdateStatement(temporaryTableReference, temporaryTableAssignments, new ComparisonPredicate(new ColumnReference((String)null, "HTE_IDENTITY", false, null, null, identifierMapping.getJdbcMapping(), this.sessionFactory), ComparisonOperator.EQUAL, entityIdentity));
            JdbcUpdate jdbcUpdate = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildUpdateTranslator(this.sessionFactory, updateStatement).translate(null, executionContext.getQueryOptions());
            JdbcParameterBindingsImpl updateBindings = new JdbcParameterBindingsImpl(2);
            for (Map.Entry entry : entityTableToRootIdentity.entrySet()) {
                updateBindings.addBinding(entityIdentity, new JdbcParameterBindingImpl(identifierMapping.getJdbcMapping(), entry.getKey()));
                updateBindings.addBinding(jdbcParameterImpl, new JdbcParameterBindingImpl(identifierMapping.getJdbcMapping(), entry.getValue()));
                jdbcServices.getJdbcMutationExecutor().execute(jdbcUpdate, updateBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
            }
        } else {
            jdbcServices.getJdbcMutationExecutor().execute(jdbcInsert, JdbcParameterBindings.NO_BINDINGS, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        }
    }

    private void insertTable(String tableExpression, String[] keyColumns, boolean nullableTable, ExecutionContext executionContext) {
        Optimizer optimizer;
        TableReference updatingTableReference = this.updatingTableGroup.getTableReference(this.updatingTableGroup.getNavigablePath(), tableExpression, true, true);
        List<Assignment> assignments = this.assignmentsByTable.get(updatingTableReference);
        if (nullableTable && (assignments == null || assignments.isEmpty())) {
            return;
        }
        NamedTableReference dmlTargetTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        QuerySpec querySpec = new QuerySpec(true);
        TableGroupImpl temporaryTableGroup = new TableGroupImpl(this.updatingTableGroup.getNavigablePath(), null, new NamedTableReference(this.insertStatement.getTargetTable().getTableExpression(), updatingTableReference.getIdentificationVariable(), false, this.sessionFactory), this.entityDescriptor);
        querySpec.getFromClause().addRoot(temporaryTableGroup);
        InsertStatement insertStatement = new InsertStatement(dmlTargetTableReference);
        insertStatement.setSourceSelectStatement(querySpec);
        if (assignments != null && !assignments.isEmpty()) {
            for (Assignment assignment : assignments) {
                insertStatement.addTargetColumnReferences(assignment.getAssignable().getColumnReferences());
                for (ColumnReference columnReference : assignment.getAssignable().getColumnReferences()) {
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference(updatingTableReference.getIdentificationVariable(), columnReference.getColumnExpression(), false, null, null, columnReference.getJdbcMapping(), this.sessionFactory)));
                }
            }
        }
        String targetKeyColumnName = keyColumns[0];
        AbstractEntityPersister entityPersister = (AbstractEntityPersister)this.entityDescriptor.getEntityPersister();
        IdentifierGenerator identifierGenerator = entityPersister.getIdentifierGenerator();
        boolean needsKeyInsert = identifierGenerator instanceof PostInsertIdentifierGenerator ? true : (identifierGenerator instanceof OptimizableGenerator ? (optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1 : false);
        if (needsKeyInsert && insertStatement.getTargetColumnReferences().stream().noneMatch(c -> targetKeyColumnName.equals(c.getColumnExpression()))) {
            BasicEntityIdentifierMapping identifierMapping = (BasicEntityIdentifierMapping)this.entityDescriptor.getIdentifierMapping();
            insertStatement.addTargetColumnReferences(new ColumnReference(dmlTargetTableReference.getIdentificationVariable(), targetKeyColumnName, false, null, null, identifierMapping.getJdbcMapping(), this.sessionFactory));
            querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference(updatingTableReference.getIdentificationVariable(), (SelectableMapping)identifierMapping, this.sessionFactory)));
        }
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        JdbcInsert jdbcInsert = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildInsertTranslator(this.sessionFactory, insertStatement).translate(null, executionContext.getQueryOptions());
        jdbcServices.getJdbcMutationExecutor().execute(jdbcInsert, JdbcParameterBindings.NO_BINDINGS, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

