/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.RestrictedDeleteExecutionDelegate;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.jboss.logging.Logger;

public class TableBasedDeleteHandler
extends AbstractMutationHandler
implements DeleteHandler {
    private static final Logger log = Logger.getLogger(TableBasedDeleteHandler.class);
    private final TemporaryTable idTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;

    public TableBasedDeleteHandler(SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, TemporaryTable idTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        super(sqmDeleteStatement, sessionFactory);
        this.idTable = idTable;
        this.domainParameterXref = domainParameterXref;
        this.afterUseAction = afterUseAction;
        this.sessionUidAccess = sessionUidAccess;
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table delete execution - %s", (Object)this.getSqmDeleteOrUpdateStatement().getRoot().getModel().getName());
        }
        return this.resolveDelegate(executionContext).execute(executionContext);
    }

    private ExecutionDelegate resolveDelegate(DomainQueryExecutionContext executionContext) {
        return new RestrictedDeleteExecutionDelegate(this.getEntityDescriptor(), this.idTable, this.afterUseAction, this.getSqmDeleteOrUpdateStatement(), this.domainParameterXref, this.sessionUidAccess, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), this.getSessionFactory());
    }

    public SqmDeleteStatement getSqmDeleteOrUpdateStatement() {
        return (SqmDeleteStatement)super.getSqmDeleteOrUpdateStatement();
    }

    public static interface ExecutionDelegate {
        public int execute(DomainQueryExecutionContext var1);
    }
}

