/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.hibernate.QueryException;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class StandardFunctionReturnTypeResolvers {
    private StandardFunctionReturnTypeResolvers() {
    }

    public static FunctionReturnTypeResolver invariant(final BasicType<?> invariantType) {
        if (invariantType == null) {
            throw new IllegalArgumentException("Passed `invariantType` for function return cannot be null");
        }
        return new FunctionReturnTypeResolver(){

            @Override
            public AllowableFunctionReturnType<?> resolveFunctionReturnType(AllowableFunctionReturnType<?> impliedType, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                return StandardFunctionReturnTypeResolvers.isAssignableTo(invariantType, impliedType) ? impliedType : invariantType;
            }

            @Override
            public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(invariantType, impliedTypeAccess.get());
            }

            @Override
            public String getReturnType() {
                return invariantType.getJavaType().getSimpleName();
            }
        };
    }

    public static FunctionReturnTypeResolver useArgType(final int argPosition) {
        return new FunctionReturnTypeResolver(){

            @Override
            public AllowableFunctionReturnType<?> resolveFunctionReturnType(AllowableFunctionReturnType<?> impliedType, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                AllowableFunctionReturnType<?> argType = StandardFunctionReturnTypeResolvers.extractArgumentType(arguments, argPosition);
                return StandardFunctionReturnTypeResolvers.isAssignableTo(argType, impliedType) ? impliedType : argType;
            }

            @Override
            public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                BasicValuedMapping specifiedArgType = StandardFunctionReturnTypeResolvers.extractArgumentValuedMapping(arguments, argPosition);
                return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(specifiedArgType, impliedTypeAccess.get());
            }
        };
    }

    public static FunctionReturnTypeResolver useFirstNonNull() {
        return new FunctionReturnTypeResolver(){

            @Override
            public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                for (SqlAstNode sqlAstNode : arguments) {
                    JdbcMappingContainer nodeType;
                    if (!(sqlAstNode instanceof Expression) || !((nodeType = ((Expression)sqlAstNode).getExpressionType()) instanceof BasicValuedMapping)) continue;
                    BasicValuedMapping argType = (BasicValuedMapping)nodeType;
                    return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(argType, impliedTypeAccess.get());
                }
                return impliedTypeAccess.get();
            }

            @Override
            public AllowableFunctionReturnType<?> resolveFunctionReturnType(AllowableFunctionReturnType<?> impliedType, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                for (SqmTypedNode<?> arg : arguments) {
                    if (arg == null || !(arg.getNodeType() instanceof AllowableFunctionReturnType)) continue;
                    AllowableFunctionReturnType argType = (AllowableFunctionReturnType)arg.getNodeType();
                    return StandardFunctionReturnTypeResolvers.isAssignableTo(argType, impliedType) ? impliedType : argType;
                }
                return impliedType;
            }
        };
    }

    private static boolean isAssignableTo(AllowableFunctionReturnType<?> defined, AllowableFunctionReturnType<?> implied) {
        int definedTypeCode;
        if (implied == null) {
            return false;
        }
        if (defined == null) {
            return true;
        }
        if (!(implied instanceof BasicType) || !(defined instanceof BasicType)) {
            return false;
        }
        int impliedTypeCode = ((BasicType)implied).getJdbcMapping().getJdbcTypeDescriptor().getJdbcTypeCode();
        return impliedTypeCode == (definedTypeCode = ((BasicType)defined).getJdbcMapping().getJdbcTypeDescriptor().getJdbcTypeCode()) || StandardFunctionReturnTypeResolvers.isNumeric(impliedTypeCode) && StandardFunctionReturnTypeResolvers.isNumeric(definedTypeCode);
    }

    private static BasicValuedMapping useImpliedTypeIfPossible(BasicValuedMapping defined, BasicValuedMapping implied) {
        if (defined == null) {
            return implied;
        }
        if (implied == null) {
            return defined;
        }
        return StandardFunctionReturnTypeResolvers.areCompatible(defined, implied) ? implied : defined;
    }

    private static boolean areCompatible(BasicValuedMapping defined, BasicValuedMapping implied) {
        int definedTypeCode;
        if (defined == null || implied == null) {
            return true;
        }
        if (defined.getJdbcMapping() == null) {
            return true;
        }
        if (implied.getJdbcMapping() == null) {
            return true;
        }
        int impliedTypeCode = implied.getJdbcMapping().getJdbcTypeDescriptor().getJdbcTypeCode();
        return impliedTypeCode == (definedTypeCode = defined.getJdbcMapping().getJdbcTypeDescriptor().getJdbcTypeCode()) || StandardFunctionReturnTypeResolvers.isNumeric(impliedTypeCode) && StandardFunctionReturnTypeResolvers.isNumeric(definedTypeCode);
    }

    private static boolean isNumeric(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static AllowableFunctionReturnType<?> extractArgumentType(List<? extends SqmTypedNode<?>> arguments, int position) {
        SqmTypedNode<?> specifiedArgument = arguments.get(position - 1);
        SqmExpressable<?> specifiedArgType = specifiedArgument.getNodeType();
        if (!(specifiedArgType instanceof AllowableFunctionReturnType)) {
            throw new QueryException(String.format(Locale.ROOT, "Function argument [%s] of type [%s] at specified position [%d] in call arguments was not typed as an allowable function return type", specifiedArgument, specifiedArgType, position));
        }
        return (AllowableFunctionReturnType)specifiedArgType;
    }

    public static JdbcMapping extractArgumentJdbcMapping(TypeConfiguration typeConfiguration, List<? extends SqmTypedNode<?>> arguments, int position) {
        SqmTypedNode<?> specifiedArgument = arguments.get(position - 1);
        SqmExpressable<?> specifiedArgType = specifiedArgument.getNodeType();
        if (specifiedArgType instanceof BasicType) {
            return ((BasicType)specifiedArgType).getJdbcMapping();
        }
        BasicType<?> basicType = typeConfiguration.getBasicTypeForJavaType(specifiedArgType.getExpressableJavaTypeDescriptor().getJavaTypeClass());
        if (basicType == null) {
            throw new QueryException(String.format(Locale.ROOT, "Function argument [%s] of type [%s] at specified position [%d] in call arguments was not typed as basic type", specifiedArgument, specifiedArgType, position));
        }
        return basicType.getJdbcMapping();
    }

    public static BasicValuedMapping extractArgumentValuedMapping(List<? extends SqlAstNode> arguments, int position) {
        JdbcMappingContainer specifiedArgType;
        SqlAstNode specifiedArgument = arguments.get(position - 1);
        JdbcMappingContainer jdbcMappingContainer = specifiedArgType = specifiedArgument instanceof Expression ? ((Expression)specifiedArgument).getExpressionType() : null;
        if (specifiedArgType instanceof BasicValuedMapping) {
            return (BasicValuedMapping)specifiedArgType;
        }
        throw new QueryException(String.format(Locale.ROOT, "Function argument [%s] at specified position [%d] in call arguments was not typed as an allowable function return type", specifiedArgument, position));
    }
}

