/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.dialect.function.TimestampdiffFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.CompositeNestedGeneratedValueGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.Restrictable;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.metamodel.mapping.ValueMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.DiscriminatorSqmPath;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.CastType;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.DynamicInstantiationNature;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SortOrder;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.StandardSqmTranslation;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.BasicValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DiscriminatedAssociationPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.EmbeddableValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.EntityValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.NonAggregatedCompositeValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.PluralValuedSimplePathInterpretation;
import org.hibernate.query.sqm.sql.internal.SelfInterpretingSqmPath;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqmMapEntryResult;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.TypeHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.cte.SqmSearchClauseSpecification;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.NonAggregatedCompositeSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRootJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMaxElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMaxIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmMinElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMinIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedRoot;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCollate;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmModifiedSubQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmJpaCompoundSelection;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.SearchClauseSpecification;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Collate;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.ModifiedSubQueryExpression;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.CorrelatedPluralTableGroup;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.QueryPartTableGroup;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.internal.VersionTypeSeedParameterSpecification;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParameters;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiation;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.StandardEntityGraphTraversalStateImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserVersionType;
import org.jboss.logging.Logger;

public abstract class BaseSqmToSqlAstConverter<T extends Statement>
extends BaseSemanticQueryWalker
implements SqmTranslator<T>,
DomainResultCreationState,
JdbcTypeDescriptorIndicators {
    private static final Logger log = Logger.getLogger(BaseSqmToSqlAstConverter.class);
    private final SqlAstCreationContext creationContext;
    private final boolean jpaQueryComplianceEnabled;
    private final SqmStatement<?> statement;
    private final QueryOptions queryOptions;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindings domainParameterBindings;
    private final Map<SqmParameter, MappingModelExpressable> sqmParameterMappingModelTypes = new LinkedHashMap<SqmParameter, MappingModelExpressable>();
    private final Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> jpaCriteriaParamResolutions;
    private final List<DomainResult<?>> domainResults;
    private final EntityGraphTraversalState entityGraphTraversalState;
    private int fetchDepth;
    private String currentBagRole;
    private boolean resolvingCircularFetch;
    private ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide;
    private SqmQueryPart<?> currentSqmQueryPart;
    private final Map<String, PredicateCollector> collectionFilterPredicates = new HashMap<String, PredicateCollector>();
    private List<Map.Entry<OrderByFragment, TableGroup>> orderByFragments;
    private final SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
    private final Stack<SqlAstProcessingState> processingStateStack = new StandardStack<SqlAstProcessingState>();
    private final Stack<FromClauseIndex> fromClauseIndexStack = new StandardStack<FromClauseIndex>();
    private SqlAstProcessingState lastPoppedProcessingState;
    private FromClauseIndex lastPoppedFromClauseIndex;
    private SqmJoin<?, ?> currentlyProcessingJoin;
    private final Stack<Clause> currentClauseStack = new StandardStack<Clause>();
    private SqmByUnit appliedByUnit;
    private Expression adjustedTimestamp;
    private SqmExpressable<?> adjustedTimestampType;
    private Expression adjustmentScale;
    private boolean negativeAdjustment;
    private boolean trackSelectionsForGroup;
    protected Predicate additionalRestrictions;
    private final Map<TableGroup, Set<String>> tableGroupTreatUsages = new IdentityHashMap<TableGroup, Set<String>>();
    private final Map<SqmParameter, List<List<JdbcParameter>>> jdbcParamsBySqmParam = new IdentityHashMap<SqmParameter, List<List<JdbcParameter>>>();
    private final JdbcParameters jdbcParameters = new JdbcParametersImpl();
    protected final Stack<Supplier<MappingModelExpressable>> inferrableTypeAccessStack = new StandardStack<Supplier<MappingModelExpressable>>(() -> null);

    public BaseSqmToSqlAstConverter(SqlAstCreationContext creationContext, SqmStatement<?> statement, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings) {
        super(creationContext.getServiceRegistry());
        this.creationContext = creationContext;
        this.jpaQueryComplianceEnabled = creationContext.getSessionFactory().getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled();
        this.statement = statement;
        if (statement instanceof SqmSelectStatement) {
            this.domainResults = new ArrayList(((SqmQueryPart)((SqmSelectStatement)statement).getQueryPart()).getFirstQuerySpec().getSelectClause().getSelections().size());
            AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
            this.entityGraphTraversalState = appliedGraph != null && appliedGraph.getSemantic() != null && appliedGraph.getGraph() != null ? new StandardEntityGraphTraversalStateImpl(appliedGraph.getSemantic(), appliedGraph.getGraph()) : null;
        } else {
            this.domainResults = null;
            this.entityGraphTraversalState = null;
        }
        this.queryOptions = queryOptions;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.domainParameterXref = domainParameterXref;
        this.domainParameterBindings = domainParameterBindings;
        this.jpaCriteriaParamResolutions = domainParameterXref.getParameterResolutions().getJpaCriteriaParamResolutions();
    }

    public Map<SqmParameter, MappingModelExpressable> getSqmParameterMappingModelExpressableResolutions() {
        return this.sqmParameterMappingModelTypes;
    }

    protected Stack<SqlAstProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    protected void pushProcessingState(SqlAstProcessingState processingState) {
        this.pushProcessingState(processingState, new FromClauseIndex(this.getFromClauseIndex()));
    }

    protected void pushProcessingState(SqlAstProcessingState processingState, FromClauseIndex fromClauseIndex) {
        this.fromClauseIndexStack.push(fromClauseIndex);
        this.processingStateStack.push(processingState);
    }

    protected void popProcessingStateStack() {
        this.lastPoppedFromClauseIndex = this.fromClauseIndexStack.pop();
        this.lastPoppedProcessingState = this.processingStateStack.pop();
    }

    private QuerySpec currentQuerySpec() {
        return this.currentQueryPart().getLastQuerySpec();
    }

    private QueryPart currentQueryPart() {
        SqlAstQueryPartProcessingState processingState = (SqlAstQueryPartProcessingState)this.getProcessingStateStack().getCurrent();
        return processingState.getInflightQueryPart();
    }

    protected SqmAliasedNodeCollector currentSqlSelectionCollector() {
        return (SqmAliasedNodeCollector)((Object)this.getCurrentProcessingState().getSqlExpressionResolver());
    }

    protected SqmStatement<?> getStatement() {
        return this.statement;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.creationContext.getSessionFactory().getTypeConfiguration();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.creationContext.getSessionFactory().getSessionFactoryOptions().getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public TableGroup findTableGroupOnLeaf(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroupOnLeaf(navigablePath);
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroup(navigablePath);
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroup(navigablePath).getModelPart();
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this.processingStateStack.getCurrent();
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.getCurrentProcessingState().getSqlExpressionResolver();
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public void registerLockMode(String identificationVariable, LockMode explicitLockMode) {
        throw new UnsupportedOperationException("Registering lock modes should only be done for result set mappings!");
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    public FromClauseIndex getFromClauseIndex() {
        return (FromClauseIndex)this.getFromClauseAccess();
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        if (fromClauseIndex == null) {
            return this.lastPoppedFromClauseIndex;
        }
        return fromClauseIndex;
    }

    @Override
    public Stack<Clause> getCurrentClauseStack() {
        return this.currentClauseStack;
    }

    @Override
    public SqmTranslation<T> translate() {
        SqmStatement<?> sqmStatement = this.getStatement();
        Statement statement = (Statement)sqmStatement.accept(this);
        this.pruneTableGroupJoins();
        return new StandardSqmTranslation<Statement>(statement, this.getJdbcParamsBySqmParam(), this.sqmParameterMappingModelTypes, this.lastPoppedProcessingState.getSqlExpressionResolver(), this.getFromClauseAccess());
    }

    @Override
    public Statement visitStatement(SqmStatement<?> sqmStatement) {
        return (Statement)sqmStatement.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStatement visitUpdateStatement(SqmUpdateStatement sqmStatement) {
        Object cteStatements = this.visitCteContainer(sqmStatement);
        JpaRoot sqmTarget = sqmStatement.getTarget();
        String entityName = ((SqmRoot)sqmTarget).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmTarget)).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, sqmStatement.getRoot().getAlias(), () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM UPDATE");
            }
            if (((AbstractSqmFrom)((Object)sqmTarget)).hasJoins()) {
                throw new HibernateException("SQM UPDATE does not support explicit joins");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            Object assignments = this.visitSetClause(sqmStatement.getSetClause());
            this.addVersionedAssignment(((List)assignments)::add, sqmStatement);
            FilterHelper.applyBaseRestrictions(filterPredicate -> {
                this.additionalRestrictions = filterPredicate;
            }, entityDescriptor, rootTableGroup, AbstractSqlAstTranslator.rendersTableReferenceAlias(Clause.UPDATE), this.getLoadQueryInfluencers(), this);
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = sqmStatement.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.getCurrentClauseStack().push(Clause.WHERE);
                try {
                    suppliedPredicate = (Predicate)whereClause.getPredicate().accept(this);
                }
                finally {
                    this.getCurrentClauseStack().pop();
                }
            }
            UpdateStatement updateStatement = new UpdateStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, (NamedTableReference)rootTableGroup.getPrimaryTableReference(), (List<Assignment>)assignments, SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions), Collections.emptyList());
            return updateStatement;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    private static void verifyManipulationImplicitJoin(TableGroup tableGroup) {
        if (!(tableGroup instanceof LazyTableGroup && ((LazyTableGroup)tableGroup).getUnderlyingTableGroup() == null || tableGroup instanceof VirtualTableGroup)) {
            throw new QueryException("Manipulation query may only contain embeddable joins");
        }
    }

    public void addVersionedAssignment(Consumer<Assignment> assignmentConsumer, SqmUpdateStatement<?> sqmStatement) {
        if (!sqmStatement.isVersioned()) {
            return;
        }
        EntityPersister persister = this.creationContext.getDomainModel().findEntityDescriptor(((SqmRoot)sqmStatement.getTarget()).getEntityName());
        if (!persister.isVersioned()) {
            throw new SemanticException("increment option specified for update of non-versioned entity");
        }
        BasicType<?> versionType = persister.getVersionType();
        if (versionType instanceof UserVersionType) {
            throw new SemanticException("user-defined version types not supported for increment option");
        }
        EntityVersionMapping versionMapping = persister.getVersionMapping();
        List<ColumnReference> targetColumnReferences = BasicValuedPathInterpretation.from((SqmBasicValuedSimplePath)sqmStatement.getRoot().get(versionMapping.getPartName()), this, this, this.jpaQueryComplianceEnabled).getColumnReferences();
        assert (targetColumnReferences.size() == 1);
        ColumnReference versionColumn = targetColumnReferences.get(0);
        Expression value = versionMapping.getJdbcMapping().getJdbcTypeDescriptor().isTemporal() ? new VersionTypeSeedParameterSpecification(versionType, persister.getVersionJavaTypeDescriptor()) : new BinaryArithmeticExpression(versionColumn, BinaryArithmeticOperator.ADD, new QueryLiteral<Integer>(1, versionType), versionType);
        assignmentConsumer.accept(new Assignment(versionColumn, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Assignment> visitSetClause(SqmSetClause setClause) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>(setClause.getAssignments().size());
        for (SqmAssignment sqmAssignment : setClause.getAssignments()) {
            SqmPathInterpretation assignedPathInterpretation;
            final ArrayList targetColumnReferences = new ArrayList();
            this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent){

                @Override
                public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                    Expression expression = this.getParentState().getSqlExpressionResolver().resolveSqlExpression(key, creator);
                    assert (expression instanceof ColumnReference);
                    targetColumnReferences.add((ColumnReference)expression);
                    return expression;
                }
            }, this.getFromClauseIndex());
            try {
                assignedPathInterpretation = (SqmPathInterpretation)sqmAssignment.getTargetPath().accept(this);
            }
            finally {
                this.popProcessingStateStack();
            }
            this.inferrableTypeAccessStack.push(assignedPathInterpretation::getExpressionType);
            final ArrayList valueColumnReferences = new ArrayList();
            this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent){

                @Override
                public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                    Expression expression = this.getParentState().getSqlExpressionResolver().resolveSqlExpression(key, creator);
                    assert (expression instanceof ColumnReference);
                    valueColumnReferences.add((ColumnReference)expression);
                    return expression;
                }
            }, this.getFromClauseIndex());
            try {
                int assignedPathJdbcCount;
                SqmExpression assignmentValue = sqmAssignment.getValue();
                SqmParameter<?> assignmentValueParameter = this.getSqmParameter(assignmentValue);
                if (assignmentValueParameter != null) {
                    this.consumeSqmParameter(assignmentValueParameter, (index, jdbcParameter) -> assignments.add(new Assignment((Assignable)targetColumnReferences.get((int)index), (Expression)jdbcParameter)));
                    continue;
                }
                Expression valueExpression = (Expression)assignmentValue.accept(this);
                int valueExprJdbcCount = this.getKeyExpressable(valueExpression.getExpressionType()).getJdbcTypeCount();
                if (valueExprJdbcCount != (assignedPathJdbcCount = this.getKeyExpressable(assignedPathInterpretation.getExpressionType()).getJdbcTypeCount())) {
                    SqlTreeCreationLogger.LOGGER.debugf("JDBC type count does not match in UPDATE assignment between the assigned-path and the assigned-value; this will likely lead to problems executing the query", new Object[0]);
                }
                assert (assignedPathJdbcCount == valueExprJdbcCount);
                for (ColumnReference columnReference : targetColumnReferences) {
                    assignments.add(new Assignment(columnReference, valueExpression));
                }
            }
            finally {
                this.popProcessingStateStack();
                this.inferrableTypeAccessStack.pop();
            }
        }
        return assignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStatement visitDeleteStatement(SqmDeleteStatement<?> statement) {
        Object cteStatements = this.visitCteContainer(statement);
        String entityName = ((SqmRoot)statement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, statement.getRoot().getAlias(), () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.getCreationContext());
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM DELETE");
            }
            FilterHelper.applyBaseRestrictions(filterPredicate -> {
                this.additionalRestrictions = filterPredicate;
            }, entityDescriptor, rootTableGroup, AbstractSqlAstTranslator.rendersTableReferenceAlias(Clause.DELETE), this.getLoadQueryInfluencers(), this);
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = statement.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.getCurrentClauseStack().push(Clause.WHERE);
                try {
                    suppliedPredicate = (Predicate)whereClause.getPredicate().accept(this);
                }
                finally {
                    this.getCurrentClauseStack().pop();
                }
            }
            DeleteStatement deleteStatement = new DeleteStatement(statement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, (NamedTableReference)rootTableGroup.getPrimaryTableReference(), SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions), Collections.emptyList());
            return deleteStatement;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertSelectStatement(SqmInsertSelectStatement<?> sqmStatement) {
        AdditionalInsertValues additionalInsertValues;
        InsertStatement insertStatement;
        Object cteStatements = this.visitCteContainer(sqmStatement);
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        SqmQueryPart<?> selectQueryPart = sqmStatement.getSelectQueryPart();
        this.pushProcessingState(new SqlAstProcessingStateImpl(null, this, r -> new SqmAliasedNodePositionTracker((SqlExpressionResolver)r, (List<? extends SqmAliasedNode<?>>)selectQueryPart.getFirstQuerySpec().getSelectClause().getSelections()), this.getCurrentClauseStack()::getCurrent));
        this.currentClauseStack.push(Clause.INSERT);
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.getCreationContext());
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            insertStatement = new InsertStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, (NamedTableReference)rootTableGroup.getPrimaryTableReference(), Collections.emptyList());
            additionalInsertValues = this.visitInsertionTargetPaths((assigable, references) -> insertStatement.addTargetColumnReferences((List<ColumnReference>)references), sqmStatement, entityDescriptor, rootTableGroup);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new SemanticException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
        }
        finally {
            this.popProcessingStateStack();
            this.currentClauseStack.pop();
        }
        insertStatement.setSourceSelectStatement((QueryPart)this.visitQueryPart((SqmQueryPart)selectQueryPart));
        insertStatement.getSourceSelectStatement().visitQuerySpecs(querySpec -> {
            boolean appliedRowNumber = additionalInsertValues.applySelections((QuerySpec)querySpec, this.creationContext.getSessionFactory());
            assert (!appliedRowNumber);
        });
        return insertStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertValuesStatement(SqmInsertValuesStatement<?> sqmStatement) {
        Object cteStatements = this.visitCteContainer(sqmStatement);
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            InsertStatement insertStatement = new InsertStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, (NamedTableReference)rootTableGroup.getPrimaryTableReference(), Collections.emptyList());
            AdditionalInsertValues additionalInsertValues = this.visitInsertionTargetPaths((assigable, references) -> insertStatement.addTargetColumnReferences((List<ColumnReference>)references), sqmStatement, entityDescriptor, rootTableGroup);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new SemanticException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            List<SqmValues> valuesList = sqmStatement.getValuesList();
            for (SqmValues sqmValues : valuesList) {
                Values values = this.visitValues(sqmValues);
                additionalInsertValues.applyValues(values);
                insertStatement.getValuesList().add(values);
            }
            InsertStatement insertStatement2 = insertStatement;
            return insertStatement2;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    public AdditionalInsertValues visitInsertionTargetPaths(BiConsumer<Assignable, List<ColumnReference>> targetColumnReferenceConsumer, SqmInsertStatement<?> sqmStatement, EntityPersister entityDescriptor, TableGroup rootTableGroup) {
        List<SqmPath<?>> targetPaths = sqmStatement.getInsertionTargetPaths();
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        IdentifierGenerator identifierGenerator = entityDescriptor.getIdentifierGenerator();
        VersionTypeSeedParameterSpecification versionExpression = null;
        QueryLiteral<Object> discriminatorExpression = null;
        BasicEntityIdentifierMapping identifierMapping = null;
        if (entityDescriptor.isVersioned()) {
            String identifierPropertyName = entityDescriptor.getIdentifierPropertyName();
            String versionAttributeName = entityDescriptor.getVersionMapping().getVersionAttribute().getAttributeName();
            boolean needsVersionInsert = true;
            for (int i = 0; i < targetPaths.size(); ++i) {
                SqmPath<?> path = targetPaths.get(i);
                if (identifierPropertyName.equals(path.getNavigablePath().getLocalName())) {
                    identifierGenerator = null;
                } else if (versionAttributeName.equals(path.getNavigablePath().getLocalName())) {
                    needsVersionInsert = false;
                }
                Assignable assignable = (Assignable)path.accept(this);
                targetColumnReferenceConsumer.accept(assignable, assignable.getColumnReferences());
            }
            if (needsVersionInsert) {
                BasicValuedPathInterpretation versionPath = BasicValuedPathInterpretation.from((SqmBasicValuedSimplePath)((AbstractSqmPath)((Object)sqmStatement.getTarget())).get(versionAttributeName), this, this, this.jpaQueryComplianceEnabled);
                List<ColumnReference> targetColumnReferences = versionPath.getColumnReferences();
                assert (targetColumnReferences.size() == 1);
                targetColumnReferenceConsumer.accept(versionPath, targetColumnReferences);
                versionExpression = new VersionTypeSeedParameterSpecification(entityDescriptor.getVersionMapping().getJdbcMapping(), entityDescriptor.getVersionJavaTypeDescriptor());
            }
        } else if (identifierGenerator != null && !(identifierGenerator instanceof PostInsertIdentifierGenerator) && !(identifierGenerator instanceof CompositeNestedGeneratedValueGenerator)) {
            String identifierPropertyName = entityDescriptor.getIdentifierPropertyName();
            for (int i = 0; i < targetPaths.size(); ++i) {
                SqmPath<?> path = targetPaths.get(i);
                if (identifierPropertyName.equals(path.getNavigablePath().getLocalName())) {
                    identifierGenerator = null;
                }
                Assignable assignable = (Assignable)path.accept(this);
                targetColumnReferenceConsumer.accept(assignable, assignable.getColumnReferences());
            }
        } else {
            for (int i = 0; i < targetPaths.size(); ++i) {
                Assignable assignable = (Assignable)targetPaths.get(i).accept(this);
                targetColumnReferenceConsumer.accept(assignable, assignable.getColumnReferences());
            }
        }
        if (discriminatorMapping != null && discriminatorMapping.isPhysical()) {
            BasicValuedPathInterpretation discriminatorPath = new BasicValuedPathInterpretation(new ColumnReference(rootTableGroup.resolveTableReference(discriminatorMapping.getContainingTableExpression()), (SelectableMapping)discriminatorMapping, this.getCreationContext().getSessionFactory()), rootTableGroup.getNavigablePath().append(discriminatorMapping.getPartName()), discriminatorMapping, rootTableGroup);
            targetColumnReferenceConsumer.accept(discriminatorPath, discriminatorPath.getColumnReferences());
            discriminatorExpression = new QueryLiteral<Object>(entityDescriptor.getDiscriminatorValue(), discriminatorMapping);
        }
        if (identifierGenerator instanceof PostInsertIdentifierGenerator || identifierGenerator instanceof CompositeNestedGeneratedValueGenerator) {
            identifierGenerator = null;
        } else if (identifierGenerator != null) {
            identifierMapping = (BasicEntityIdentifierMapping)entityDescriptor.getIdentifierMapping();
            BasicValuedPathInterpretation identifierPath = new BasicValuedPathInterpretation(new ColumnReference(rootTableGroup.resolveTableReference(identifierMapping.getContainingTableExpression()), (SelectableMapping)identifierMapping, this.getCreationContext().getSessionFactory()), rootTableGroup.getNavigablePath().append(identifierMapping.getPartName()), identifierMapping, rootTableGroup);
            targetColumnReferenceConsumer.accept(identifierPath, identifierPath.getColumnReferences());
        }
        return new AdditionalInsertValues(versionExpression, discriminatorExpression, identifierGenerator, identifierMapping);
    }

    @Override
    public Values visitValues(SqmValues sqmValues) {
        Values values = new Values();
        for (SqmExpression<?> expression : sqmValues.getExpressions()) {
            values.getExpressions().add((Expression)expression.accept(this));
        }
        return values;
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement<?> statement) {
        Object cteStatements = this.visitCteContainer(statement);
        Object queryPart = this.visitQueryPart((SqmQueryPart)statement.getQueryPart());
        List<DomainResult<?>> domainResults = ((QueryPart)queryPart).isRoot() ? this.domainResults : Collections.emptyList();
        return new SelectStatement(statement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, (QueryPart)queryPart, domainResults);
    }

    @Override
    public DynamicInstantiation<?> visitDynamicInstantiation(SqmDynamicInstantiation<?> sqmDynamicInstantiation) {
        SqmDynamicInstantiationTarget<?> instantiationTarget = sqmDynamicInstantiation.getInstantiationTarget();
        DynamicInstantiationNature instantiationNature = instantiationTarget.getNature();
        JavaType targetTypeDescriptor = this.interpretInstantiationTarget(instantiationTarget);
        DynamicInstantiation dynamicInstantiation = new DynamicInstantiation(instantiationNature, targetTypeDescriptor);
        for (SqmDynamicInstantiationArgument<?> sqmArgument : sqmDynamicInstantiation.getArguments()) {
            SqmSelectableNode<?> selectableNode = sqmArgument.getSelectableNode();
            if (selectableNode instanceof SqmPath) {
                this.prepareForSelection((SqmPath)selectableNode);
            }
            DomainResultProducer argumentResultProducer = (DomainResultProducer)selectableNode.accept(this);
            dynamicInstantiation.addArgument(sqmArgument.getAlias(), argumentResultProducer, this);
        }
        dynamicInstantiation.complete();
        return dynamicInstantiation;
    }

    private <X> JavaType<X> interpretInstantiationTarget(SqmDynamicInstantiationTarget<?> instantiationTarget) {
        Class targetJavaType = instantiationTarget.getNature() == DynamicInstantiationNature.LIST ? List.class : (instantiationTarget.getNature() == DynamicInstantiationNature.MAP ? Map.class : instantiationTarget.getJavaType());
        return this.getCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(targetJavaType);
    }

    @Override
    public CteStatement visitCteStatement(SqmCteStatement<?> sqmCteStatement) {
        CteTable cteTable = BaseSqmToSqlAstConverter.createCteTable(sqmCteStatement.getCteTable(), this.getCreationContext().getSessionFactory());
        return new CteStatement(cteTable, (Statement)this.visitStatement((SqmStatement)sqmCteStatement.getCteDefinition()), sqmCteStatement.getMaterialization(), sqmCteStatement.getSearchClauseKind(), this.visitSearchBySpecifications(cteTable, sqmCteStatement.getSearchBySpecifications()), this.visitCycleColumns(cteTable, sqmCteStatement.getCycleColumns()), this.findCteColumn(cteTable, sqmCteStatement.getCycleMarkColumn()), sqmCteStatement.getCycleValue(), sqmCteStatement.getNoCycleValue());
    }

    protected List<SearchClauseSpecification> visitSearchBySpecifications(CteTable cteTable, List<SqmSearchClauseSpecification> searchBySpecifications) {
        if (searchBySpecifications == null || searchBySpecifications.isEmpty()) {
            return null;
        }
        int size = searchBySpecifications.size();
        ArrayList<SearchClauseSpecification> searchClauseSpecifications = new ArrayList<SearchClauseSpecification>(size);
        for (int i = 0; i < size; ++i) {
            SqmSearchClauseSpecification specification = searchBySpecifications.get(i);
            this.forEachCteColumn(cteTable, specification.getCteColumn(), cteColumn -> searchClauseSpecifications.add(new SearchClauseSpecification((CteColumn)cteColumn, specification.getSortOrder(), specification.getNullPrecedence())));
        }
        return searchClauseSpecifications;
    }

    protected CteColumn findCteColumn(CteTable cteTable, SqmCteTableColumn cteColumn) {
        if (cteColumn == null) {
            return null;
        }
        List<CteColumn> cteColumns = cteTable.getCteColumns();
        int size = cteColumns.size();
        for (int i = 0; i < size; ++i) {
            CteColumn column = cteColumns.get(i);
            if (!cteColumn.getColumnName().equals(column.getColumnExpression())) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Couldn't find cte column %s in cte %s!", cteColumn.getColumnName(), cteTable.getTableExpression()));
    }

    protected void forEachCteColumn(CteTable cteTable, SqmCteTableColumn cteColumn, Consumer<CteColumn> consumer) {
        List<CteColumn> cteColumns = cteTable.getCteColumns();
        int size = cteColumns.size();
        for (int i = 0; i < size; ++i) {
            CteColumn column = cteColumns.get(i);
            if (!cteColumn.getColumnName().equals(column.getColumnExpression())) continue;
            consumer.accept(column);
        }
    }

    protected List<CteColumn> visitCycleColumns(CteTable cteTable, List<SqmCteTableColumn> cycleColumns) {
        if (cycleColumns == null || cycleColumns.isEmpty()) {
            return null;
        }
        int size = cycleColumns.size();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(size);
        for (int i = 0; i < size; ++i) {
            this.forEachCteColumn(cteTable, cycleColumns.get(i), columns::add);
        }
        return columns;
    }

    public static CteTable createCteTable(SqmCteTable sqmCteTable, SessionFactoryImplementor factory) {
        return BaseSqmToSqlAstConverter.createCteTable(sqmCteTable, sqmCteTable.getColumns(), factory);
    }

    public static CteTable createCteTable(SqmCteTable sqmCteTable, List<SqmCteTableColumn> sqmCteColumns, SessionFactoryImplementor factory) {
        ArrayList<CteColumn> sqlCteColumns = new ArrayList<CteColumn>(sqmCteColumns.size());
        for (int i = 0; i < sqmCteColumns.size(); ++i) {
            SqmCteTableColumn sqmCteTableColumn = sqmCteColumns.get(i);
            ValueMapping valueMapping = sqmCteTableColumn.getType();
            if (valueMapping instanceof Association) {
                valueMapping = ((Association)((Object)valueMapping)).getForeignKeyDescriptor();
            }
            if (valueMapping instanceof EmbeddableValuedModelPart) {
                valueMapping.forEachJdbcType((index, jdbcMapping) -> sqlCteColumns.add(new CteColumn(sqmCteTableColumn.getColumnName() + "_" + index, (JdbcMapping)jdbcMapping)));
                continue;
            }
            sqlCteColumns.add(new CteColumn(sqmCteTableColumn.getColumnName(), ((BasicValuedMapping)valueMapping).getJdbcMapping()));
        }
        return new CteTable(sqmCteTable.getCteName(), sqlCteColumns, factory);
    }

    @Override
    public Map<String, CteStatement> visitCteContainer(SqmCteContainer consumer) {
        Collection<SqmCteStatement<?>> sqmCteStatements = consumer.getCteStatements();
        LinkedHashMap<String, CteStatement> cteStatements = new LinkedHashMap<String, CteStatement>(sqmCteStatements.size());
        for (SqmCteStatement<?> sqmCteStatement : sqmCteStatements) {
            Object cteStatement = this.visitCteStatement((SqmCteStatement)sqmCteStatement);
            cteStatements.put(((CteStatement)cteStatement).getCteTable().getTableExpression(), (CteStatement)cteStatement);
        }
        return cteStatements;
    }

    @Override
    public QueryPart visitQueryPart(SqmQueryPart<?> queryPart) {
        return (QueryPart)super.visitQueryPart(queryPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryGroup visitQueryGroup(SqmQueryGroup<?> queryGroup) {
        List<SqmQueryPart<?>> queryParts = queryGroup.getQueryParts();
        int size = queryParts.size();
        ArrayList<QueryPart> newQueryParts = new ArrayList<QueryPart>(size);
        QueryGroup group = new QueryGroup(this.getProcessingStateStack().isEmpty(), queryGroup.getSetOperator(), newQueryParts);
        if (queryGroup.getOrderByClause() != null && queryGroup.getOrderByClause().hasPositionalSortItem()) {
            this.trackSelectionsForGroup = true;
        }
        SqlAstQueryPartProcessingStateImpl processingState = new SqlAstQueryPartProcessingStateImpl(group, this.getCurrentProcessingState(), this, DelegatingSqmAliasedNodeCollector::new, this.currentClauseStack::getCurrent);
        DelegatingSqmAliasedNodeCollector collector = (DelegatingSqmAliasedNodeCollector)processingState.getSqlExpressionResolver();
        SqmQueryPart<?> sqmQueryPart = this.currentSqmQueryPart;
        this.currentSqmQueryPart = queryGroup;
        this.pushProcessingState(processingState);
        try {
            newQueryParts.add((QueryPart)this.visitQueryPart((SqmQueryPart)queryParts.get(0)));
            collector.setSqmAliasedNodeCollector((SqmAliasedNodeCollector)((Object)this.lastPoppedProcessingState.getSqlExpressionResolver()));
            this.visitOrderByOffsetAndFetch(queryGroup, group);
            this.trackSelectionsForGroup = false;
            for (int i = 1; i < size; ++i) {
                newQueryParts.add((QueryPart)this.visitQueryPart((SqmQueryPart)queryParts.get(i)));
            }
            QueryGroup queryGroup2 = group;
            return queryGroup2;
        }
        finally {
            this.popProcessingStateStack();
            this.currentSqmQueryPart = sqmQueryPart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuerySpec visitQuerySpec(SqmQuerySpec<?> sqmQuerySpec) {
        boolean trackAliasedNodePositions;
        boolean topLevel = this.getProcessingStateStack().isEmpty();
        QuerySpec sqlQuerySpec = new QuerySpec(topLevel, sqmQuerySpec.getFromClause().getNumberOfRoots());
        SqmSelectClause selectClause = sqmQuerySpec.getSelectClause();
        Predicate originalAdditionalRestrictions = this.additionalRestrictions;
        this.additionalRestrictions = null;
        if (this.trackSelectionsForGroup) {
            trackAliasedNodePositions = true;
        } else if (sqmQuerySpec.getOrderByClause() != null && sqmQuerySpec.getOrderByClause().hasPositionalSortItem()) {
            trackAliasedNodePositions = true;
        } else if (sqmQuerySpec.hasPositionalGroupItem()) {
            trackAliasedNodePositions = true;
        } else {
            boolean bl = trackAliasedNodePositions = this.statement.getQuerySource() == SqmQuerySource.CRITERIA && (sqmQuerySpec.getOrderByClause() != null || !sqmQuerySpec.getGroupByClauseExpressions().isEmpty());
        }
        SqlAstQueryPartProcessingStateImpl processingState = trackAliasedNodePositions ? new SqlAstQueryPartProcessingStateImpl(sqlQuerySpec, this.getCurrentProcessingState(), this, r -> new SqmAliasedNodePositionTracker((SqlExpressionResolver)r, (List<? extends SqmAliasedNode<?>>)selectClause.getSelections()), this.currentClauseStack::getCurrent) : new SqlAstQueryPartProcessingStateImpl(sqlQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent);
        SqmQueryPart<?> sqmQueryPart = this.currentSqmQueryPart;
        this.currentSqmQueryPart = sqmQuerySpec;
        this.pushProcessingState(processingState);
        try {
            this.visitFromClause(sqmQuerySpec.getFromClause());
            this.visitSelectClause(selectClause);
            SqmWhereClause whereClause = sqmQuerySpec.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.currentClauseStack.push(Clause.WHERE);
                try {
                    sqlQuerySpec.applyPredicate((Predicate)whereClause.getPredicate().accept(this));
                }
                finally {
                    this.currentClauseStack.pop();
                }
            }
            sqlQuerySpec.setGroupByClauseExpressions((List<Expression>)this.visitGroupByClause((List)sqmQuerySpec.getGroupByClauseExpressions()));
            if (sqmQuerySpec.getHavingClausePredicate() != null) {
                sqlQuerySpec.setHavingClauseRestrictions(this.visitHavingClause(sqmQuerySpec.getHavingClausePredicate()));
            }
            this.visitOrderByOffsetAndFetch(sqmQuerySpec, sqlQuerySpec);
            if (topLevel && this.statement instanceof SqmSelectStatement) {
                if (this.orderByFragments != null) {
                    this.orderByFragments.forEach(entry -> ((OrderByFragment)entry.getKey()).apply(sqlQuerySpec, (TableGroup)entry.getValue(), this));
                    this.orderByFragments = null;
                }
                this.applyCollectionFilterPredicates(sqlQuerySpec);
            }
            QuerySpec querySpec = sqlQuerySpec;
            return querySpec;
        }
        finally {
            if (this.additionalRestrictions != null) {
                sqlQuerySpec.applyPredicate(this.additionalRestrictions);
            }
            this.additionalRestrictions = originalAdditionalRestrictions;
            this.popProcessingStateStack();
            this.currentSqmQueryPart = sqmQueryPart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitOrderByOffsetAndFetch(SqmQueryPart<?> sqmQueryPart, QueryPart sqlQueryPart) {
        if (sqmQueryPart.getOrderByClause() != null) {
            this.currentClauseStack.push(Clause.ORDER);
            try {
                for (SqmSortSpecification sortSpecification : sqmQueryPart.getOrderByClause().getSortSpecifications()) {
                    SortSpecification specification = this.visitSortSpecification(sortSpecification);
                    if (specification == null) continue;
                    sqlQueryPart.addSortSpecification(specification);
                }
            }
            finally {
                this.currentClauseStack.pop();
            }
        }
        sqlQueryPart.setOffsetClauseExpression((Expression)this.visitOffsetExpression((SqmExpression)sqmQueryPart.getOffsetExpression()));
        sqlQueryPart.setFetchClauseExpression((Expression)this.visitFetchExpression((SqmExpression)sqmQueryPart.getFetchExpression()), sqmQueryPart.getFetchClauseType());
    }

    private TableGroup findTableGroupByPath(NavigablePath navigablePath) {
        return this.getFromClauseAccess().getTableGroup(navigablePath);
    }

    protected void applyCollectionFilterPredicates(QuerySpec sqlQuerySpec) {
        List<TableGroup> roots = sqlQuerySpec.getFromClause().getRoots();
        if (roots != null && roots.size() == 1) {
            TableGroup root = roots.get(0);
            if (CollectionHelper.isNotEmpty(this.collectionFilterPredicates)) {
                root.getTableGroupJoins().forEach(tableGroupJoin -> this.collectionFilterPredicates.forEach((alias, predicates) -> {
                    if (tableGroupJoin.getJoinedGroup().getGroupAlias().equals(alias)) {
                        tableGroupJoin.applyPredicate(predicates.getPredicate());
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectClause visitSelectClause(SqmSelectClause selectClause) {
        this.currentClauseStack.push(Clause.SELECT);
        try {
            SelectClause sqlSelectClause = this.currentQuerySpec().getSelectClause();
            if (selectClause == null) {
                SqmFrom<?, ?> implicitSelection = this.determineImplicitSelection((SqmQuerySpec)this.currentSqmQueryPart);
                this.visitSelection(new SqmSelection(implicitSelection, implicitSelection.nodeBuilder()));
            } else {
                super.visitSelectClause(selectClause);
                sqlSelectClause.makeDistinct(selectClause.isDistinct());
            }
            SelectClause selectClause2 = sqlSelectClause;
            return selectClause2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    protected SqmFrom<?, ?> determineImplicitSelection(SqmQuerySpec<?> querySpec) {
        return querySpec.getFromClause().getRoots().get(0);
    }

    @Override
    public Void visitSelection(SqmSelection<?> sqmSelection) {
        boolean collectDomainResults;
        boolean needsDomainResults;
        List<Object> resultProducers;
        SqmSelectableNode<?> selectionNode = sqmSelection.getSelectableNode();
        if (selectionNode instanceof SqmJpaCompoundSelection) {
            SqmJpaCompoundSelection selectableNode = (SqmJpaCompoundSelection)selectionNode;
            resultProducers = new ArrayList(selectableNode.getSelectionItems().size());
            for (SqmSelectableNode<?> selectionItem : selectableNode.getSelectionItems()) {
                if (selectionItem instanceof SqmPath) {
                    this.prepareForSelection((SqmPath)selectionItem);
                }
                resultProducers.add(new AbstractMap.SimpleEntry<String, DomainResultProducer>(selectionItem.getAlias(), (DomainResultProducer)selectionItem.accept(this)));
            }
        } else {
            if (selectionNode instanceof SqmPath) {
                this.prepareForSelection((SqmPath)selectionNode);
            }
            resultProducers = Collections.singletonList(new AbstractMap.SimpleEntry<String, DomainResultProducer>(sqmSelection.getAlias(), (DomainResultProducer)selectionNode.accept(this)));
        }
        Stack<SqlAstProcessingState> processingStateStack = this.getProcessingStateStack();
        boolean bl = needsDomainResults = this.domainResults != null && this.currentClauseContributesToTopLevelSelectClause();
        if (processingStateStack.depth() == 1) {
            collectDomainResults = needsDomainResults;
        } else {
            SqlAstProcessingState current = processingStateStack.getCurrent();
            boolean bl2 = collectDomainResults = needsDomainResults && processingStateStack.findCurrentFirst(processingState -> {
                if (!(processingState instanceof SqlAstQueryPartProcessingState)) {
                    return Boolean.FALSE;
                }
                if (processingState == current) {
                    return null;
                }
                QueryPart part = ((SqlAstQueryPartProcessingState)processingState).getInflightQueryPart();
                if (part instanceof QueryGroup && ((QueryGroup)part).getQueryParts().isEmpty()) {
                    return null;
                }
                return Boolean.FALSE;
            }) == null;
        }
        if (collectDomainResults) {
            resultProducers.forEach(entry -> {
                if (!(entry.getValue() instanceof DynamicInstantiation)) {
                    this.currentSqlSelectionCollector().next();
                }
                this.domainResults.add(((DomainResultProducer)entry.getValue()).createDomainResult((String)entry.getKey(), this));
            });
        } else if (needsDomainResults) {
            resultProducers.forEach(entry -> {
                if (!(entry.getValue() instanceof DynamicInstantiation)) {
                    this.currentSqlSelectionCollector().next();
                }
                ((DomainResultProducer)entry.getValue()).createDomainResult((String)entry.getKey(), this);
            });
        } else {
            resultProducers.forEach(entry -> {
                if (!(entry.getValue() instanceof DynamicInstantiation)) {
                    this.currentSqlSelectionCollector().next();
                }
                ((DomainResultProducer)entry.getValue()).applySqlSelections(this);
            });
        }
        return null;
    }

    private boolean currentClauseContributesToTopLevelSelectClause() {
        return this.currentClauseStack.findCurrentFirst(clause -> clause == Clause.SELECT ? null : clause) == null;
    }

    protected Expression resolveGroupOrOrderByExpression(SqmExpression<?> groupByClauseExpression) {
        int sqmPosition;
        if (groupByClauseExpression instanceof SqmAliasedNodeRef) {
            int aliasedNodeOrdinal = ((SqmAliasedNodeRef)groupByClauseExpression).getPosition();
            sqmPosition = aliasedNodeOrdinal - 1;
        } else if (this.statement.getQuerySource() == SqmQuerySource.CRITERIA) {
            SqmQuerySpec<?> querySpec = this.currentSqmQueryPart.getFirstQuerySpec();
            sqmPosition = this.indexOfExpression(querySpec.getSelectClause().getSelections(), groupByClauseExpression);
        } else {
            sqmPosition = -1;
        }
        if (sqmPosition != -1) {
            List<SqlSelection> selections = this.currentSqlSelectionCollector().getSelections(sqmPosition);
            assert (selections != null) : String.format(Locale.ROOT, "No SqlSelections for SQM position `%s`", sqmPosition);
            ArrayList<SqlSelectionExpression> expressions = new ArrayList<SqlSelectionExpression>(selections.size());
            block0: for (int i = 0; i < selections.size(); ++i) {
                SqlSelection selection = selections.get(i);
                for (int j = 0; j < i; ++j) {
                    if (selections.get(j) == selection) continue block0;
                }
                if (this.currentSqmQueryPart instanceof SqmQueryGroup) {
                    expressions.add(new SqlSelectionExpression(new SqlSelectionImpl(selection.getJdbcResultSetIndex(), selection.getValuesArrayPosition(), new QueryLiteral<Integer>(selection.getValuesArrayPosition(), this.basicType(Integer.class)))));
                    continue;
                }
                expressions.add(new SqlSelectionExpression(selection));
            }
            if (expressions.size() == 1) {
                return (Expression)expressions.get(0);
            }
            return new SqlTuple(expressions, null);
        }
        return (Expression)groupByClauseExpression.accept(this);
    }

    private int indexOfExpression(List<? extends SqmAliasedNode<?>> selections, SqmExpression<?> node) {
        int result = this.indexOfExpression(0, selections, node);
        if (result < 1) {
            return -result;
        }
        return -1;
    }

    private int indexOfExpression(int offset, List<? extends SqmAliasedNode<?>> selections, SqmExpression<?> node) {
        for (int i = 0; i < selections.size(); ++i) {
            SqmSelectableNode<?> selectableNode = selections.get(i).getSelectableNode();
            if (selectableNode instanceof SqmDynamicInstantiation) {
                int subResult = this.indexOfExpression(offset + i, ((SqmDynamicInstantiation)selectableNode).getArguments(), node);
                if (subResult < 0) {
                    return subResult;
                }
                offset = subResult - i;
                continue;
            }
            if (selectableNode instanceof SqmJpaCompoundSelection) {
                List<SqmSelectableNode<?>> selectionItems = ((SqmJpaCompoundSelection)selectableNode).getSelectionItems();
                for (int j = 0; j < selectionItems.size(); ++j) {
                    if (selectionItems.get(j) != node) continue;
                    return -(offset + i + j);
                }
                offset += selectionItems.size();
                continue;
            }
            if (selectableNode != node) continue;
            return -(offset + i);
        }
        return offset + selections.size();
    }

    private boolean selectClauseContains(SqmFrom<?, ?> from) {
        List<SqmSelection> selections;
        SqmQuerySpec sqmQuerySpec = (SqmQuerySpec)this.currentSqmQueryPart;
        List<SqmSelection> list = selections = sqmQuerySpec.getSelectClause() == null ? Collections.emptyList() : sqmQuerySpec.getSelectClause().getSelections();
        if (selections.isEmpty() && from instanceof SqmRoot) {
            return true;
        }
        for (SqmSelection selection : selections) {
            if (selection.getSelectableNode() != from) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Expression> visitGroupByClause(List<SqmExpression<?>> groupByClauseExpressions) {
        if (!groupByClauseExpressions.isEmpty()) {
            this.currentClauseStack.push(Clause.GROUP);
            try {
                ArrayList<Expression> expressions = new ArrayList<Expression>(groupByClauseExpressions.size());
                for (SqmExpression<?> groupByClauseExpression : groupByClauseExpressions) {
                    expressions.add(this.resolveGroupOrOrderByExpression(groupByClauseExpression));
                }
                ArrayList<Expression> arrayList = expressions;
                return arrayList;
            }
            finally {
                this.currentClauseStack.pop();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Predicate visitHavingClause(SqmPredicate sqmPredicate) {
        if (sqmPredicate == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.HAVING);
        try {
            Predicate predicate = (Predicate)sqmPredicate.accept(this);
            return predicate;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitOrderByClause(SqmOrderByClause orderByClause) {
        super.visitOrderByClause(orderByClause);
        return null;
    }

    @Override
    public SortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
        Expression expression = this.resolveGroupOrOrderByExpression(sortSpecification.getSortExpression());
        if (expression == null) {
            return null;
        }
        return new SortSpecification(expression, null, sortSpecification.getSortOrder(), sortSpecification.getNullPrecedence());
    }

    public QuerySpec visitOffsetAndFetchExpressions(QuerySpec sqlQuerySpec, SqmQuerySpec<?> sqmQuerySpec) {
        Object offsetExpression = this.visitOffsetExpression((SqmExpression)sqmQuerySpec.getOffsetExpression());
        Object fetchExpression = this.visitFetchExpression((SqmExpression)sqmQuerySpec.getFetchExpression());
        sqlQuerySpec.setOffsetClauseExpression((Expression)offsetExpression);
        sqlQuerySpec.setFetchClauseExpression((Expression)fetchExpression, sqmQuerySpec.getFetchClauseType());
        return sqlQuerySpec;
    }

    @Override
    public Expression visitOffsetExpression(SqmExpression<?> expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.OFFSET);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Expression visitFetchExpression(SqmExpression<?> expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.FETCH);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitFromClause(SqmFromClause sqmFromClause) {
        this.currentClauseStack.push(Clause.FROM);
        try {
            sqmFromClause.visitRoots(this::consumeFromClauseRoot);
        }
        finally {
            this.currentClauseStack.pop();
        }
        return null;
    }

    protected void consumeFromClauseRoot(SqmRoot<?> sqmRoot) {
        TableGroup tableGroup;
        log.tracef("Resolving SqmRoot [%s] to TableGroup", sqmRoot);
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        if (fromClauseIndex.isResolved(sqmRoot)) {
            log.tracef("Already resolved SqmRoot [%s] to TableGroup", sqmRoot);
        }
        QuerySpec currentQuerySpec = this.currentQuerySpec();
        if (sqmRoot.isCorrelated()) {
            SessionFactoryImplementor sessionFactory = this.creationContext.getSessionFactory();
            EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getReferencedPathSource());
            if (sqmRoot.containsOnlyInnerJoins()) {
                CorrelatedTableGroup tableGroup2;
                SqmFrom from;
                if (sqmRoot instanceof SqmCorrelatedRootJoin) {
                    assert (sqmRoot.getSqmJoins().size() == 1);
                    assert (sqmRoot.getSqmJoins().get(0).isCorrelated());
                    from = sqmRoot.getSqmJoins().get(0);
                } else {
                    from = sqmRoot;
                }
                TableGroup parentTableGroup = fromClauseIndex.findTableGroup(from.getCorrelationParent().getNavigablePath());
                SqlAliasBase sqlAliasBase = this.sqlAliasBaseManager.createSqlAliasBase(parentTableGroup.getGroupAlias());
                if (parentTableGroup instanceof PluralTableGroup) {
                    TableGroup indexTableGroup;
                    PluralTableGroup pluralTableGroup = (PluralTableGroup)parentTableGroup;
                    CorrelatedPluralTableGroup correlatedPluralTableGroup = new CorrelatedPluralTableGroup(parentTableGroup, sqlAliasBase, currentQuerySpec, predicate -> {
                        this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                    }, sessionFactory);
                    TableGroup elementTableGroup = pluralTableGroup.getElementTableGroup();
                    if (elementTableGroup != null) {
                        CorrelatedTableGroup correlatedElementTableGroup = new CorrelatedTableGroup(elementTableGroup, sqlAliasBase, currentQuerySpec, predicate -> {
                            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                        }, sessionFactory);
                        TableGroupJoin tableGroupJoin = new TableGroupJoin(elementTableGroup.getNavigablePath(), SqlAstJoinType.INNER, correlatedElementTableGroup);
                        correlatedPluralTableGroup.registerElementTableGroup(tableGroupJoin);
                    }
                    if ((indexTableGroup = pluralTableGroup.getIndexTableGroup()) != null) {
                        CorrelatedTableGroup correlatedIndexTableGroup = new CorrelatedTableGroup(indexTableGroup, sqlAliasBase, currentQuerySpec, predicate -> {
                            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                        }, sessionFactory);
                        TableGroupJoin tableGroupJoin = new TableGroupJoin(indexTableGroup.getNavigablePath(), SqlAstJoinType.INNER, correlatedIndexTableGroup);
                        correlatedPluralTableGroup.registerIndexTableGroup(tableGroupJoin);
                    }
                    tableGroup2 = correlatedPluralTableGroup;
                } else {
                    tableGroup2 = new CorrelatedTableGroup(parentTableGroup, sqlAliasBase, currentQuerySpec, predicate -> {
                        this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                    }, sessionFactory);
                }
                fromClauseIndex.register(from, tableGroup2);
                this.registerPluralTableGroupParts(tableGroup2);
                log.tracef("Resolved SqmRoot [%s] to correlated TableGroup [%s]", sqmRoot, (Object)tableGroup2);
                this.consumeExplicitJoins(from, tableGroup2);
                return;
            }
            TableGroup parentTableGroup = fromClauseIndex.findTableGroup(sqmRoot.getCorrelationParent().getNavigablePath());
            tableGroup = entityDescriptor.createRootTableGroup(true, sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), () -> predicate -> {}, this, this.creationContext);
            EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
            NavigablePath navigablePath = sqmRoot.getNavigablePath().append(identifierMapping.getNavigableRole().getNavigableName());
            int jdbcTypeCount = identifierMapping.getJdbcTypeCount();
            if (jdbcTypeCount == 1) {
                identifierMapping.forEachSelectable((index, selectable) -> {
                    this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, new ComparisonPredicate(new ColumnReference(parentTableGroup.resolveTableReference(navigablePath, selectable.getContainingTableExpression()), selectable, sessionFactory), ComparisonOperator.EQUAL, new ColumnReference(tableGroup.resolveTableReference(navigablePath, selectable.getContainingTableExpression()), selectable, sessionFactory)));
                });
            } else {
                ArrayList lhs = new ArrayList(jdbcTypeCount);
                ArrayList rhs = new ArrayList(jdbcTypeCount);
                identifierMapping.forEachSelectable((index, selectable) -> {
                    lhs.add(new ColumnReference(parentTableGroup.resolveTableReference(navigablePath, selectable.getContainingTableExpression()), selectable, sessionFactory));
                    rhs.add(new ColumnReference(tableGroup.resolveTableReference(navigablePath, selectable.getContainingTableExpression()), selectable, sessionFactory));
                });
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, new ComparisonPredicate(new SqlTuple(lhs, identifierMapping), ComparisonOperator.EQUAL, new SqlTuple(rhs, identifierMapping)));
            }
        } else {
            EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getReferencedPathSource());
            tableGroup = entityDescriptor.createRootTableGroup(true, sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.creationContext);
            entityDescriptor.applyBaseRestrictions(currentQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
        }
        log.tracef("Resolved SqmRoot [%s] to new TableGroup [%s]", sqmRoot, (Object)tableGroup);
        fromClauseIndex.register(sqmRoot, tableGroup);
        currentQuerySpec.getFromClause().addRoot(tableGroup);
        if (sqmRoot.getOrderedJoins() == null) {
            this.consumeExplicitJoins(sqmRoot, tableGroup);
        } else {
            if (log.isTraceEnabled()) {
                log.tracef("Visiting explicit joins for `%s`", (Object)sqmRoot.getNavigablePath());
            }
            TableGroup lastTableGroup = tableGroup;
            for (SqmJoin<?, ?> join : sqmRoot.getOrderedJoins()) {
                TableGroup ownerTableGroup = join.getLhs() == null ? tableGroup : (join.getLhs() instanceof SqmCorrelation ? fromClauseIndex.findTableGroup(((SqmCorrelation)join.getLhs()).getCorrelatedRoot().getNavigablePath()) : fromClauseIndex.findTableGroup(join.getLhs().getNavigablePath()));
                assert (ownerTableGroup != null);
                lastTableGroup = this.consumeExplicitJoin(join, lastTableGroup, ownerTableGroup, false);
            }
        }
    }

    private EntityPersister resolveEntityPersister(EntityDomainType<?> entityDomainType) {
        return this.creationContext.getDomainModel().getEntityDescriptor(entityDomainType.getHibernateEntityName());
    }

    protected void registerUsage(SqmFrom<?, ?> sqmFrom, TableGroup tableGroup) {
        EntityDomainType treatedType;
        if (sqmFrom instanceof SqmTreatedPath) {
            treatedType = ((SqmTreatedPath)((Object)sqmFrom)).getTreatTarget();
        } else if (sqmFrom.getReferencedPathSource().getSqmPathType() instanceof EntityDomainType) {
            treatedType = (EntityDomainType)sqmFrom.getReferencedPathSource().getSqmPathType();
        } else {
            return;
        }
        Set treatedEntityNames = this.tableGroupTreatUsages.computeIfAbsent(tableGroup, tg -> new HashSet(1));
        treatedEntityNames.add(treatedType.getHibernateEntityName());
    }

    protected void registerTypeUsage(DiscriminatorSqmPath path) {
        TableGroup tableGroup = this.getFromClauseAccess().getTableGroup(path.getNavigablePath().getParent());
        EntityMappingType mappingType = (EntityMappingType)tableGroup.getModelPart().getPartMappingType();
        AbstractEntityPersister persister = (AbstractEntityPersister)mappingType.getEntityPersister();
        int subclassTableSpan = persister.getSubclassTableSpan();
        for (int i = 0; i < subclassTableSpan; ++i) {
            tableGroup.resolveTableReference(persister.getSubclassTableName(i));
        }
    }

    protected void pruneTableGroupJoins() {
        for (Map.Entry<TableGroup, Set<String>> entry : this.tableGroupTreatUsages.entrySet()) {
            TableGroup tableGroup = entry.getKey();
            Set<String> treatedEntityNames = entry.getValue();
            ModelPartContainer modelPart = tableGroup.getModelPart();
            EntityPersister tableGroupPersister = modelPart instanceof PluralAttributeMapping ? (EntityPersister)((PluralAttributeMapping)modelPart).getElementDescriptor().getPartMappingType() : (EntityPersister)modelPart.getPartMappingType();
            tableGroupPersister.pruneForSubclasses(tableGroup, treatedEntityNames);
        }
    }

    protected void consumeExplicitJoins(SqmFrom<?, ?> sqmFrom, TableGroup lhsTableGroup) {
        if (log.isTraceEnabled()) {
            log.tracef("Visiting explicit joins for `%s`", (Object)sqmFrom.getNavigablePath());
        }
        sqmFrom.visitSqmJoins(sqmJoin -> {
            TableGroup actualTableGroup = this.findActualTableGroup(lhsTableGroup, (SqmPath<?>)sqmJoin);
            this.registerUsage((SqmFrom)sqmJoin.getLhs(), actualTableGroup);
            this.consumeExplicitJoin((SqmJoin<?, ?>)sqmJoin, actualTableGroup, actualTableGroup, true);
        });
        for (SqmFrom<?, ?> sqmTreat : sqmFrom.getSqmTreats()) {
            TableGroup actualTableGroup = this.findActualTableGroup(lhsTableGroup, sqmTreat);
            this.registerUsage(sqmTreat, actualTableGroup);
            this.consumeExplicitJoins(sqmTreat, actualTableGroup);
        }
    }

    protected TableGroup consumeExplicitJoin(SqmJoin<?, ?> sqmJoin, TableGroup lhsTableGroup, TableGroup ownerTableGroup, boolean transitive) {
        if (sqmJoin instanceof SqmAttributeJoin) {
            return this.consumeAttributeJoin((SqmAttributeJoin)sqmJoin, lhsTableGroup, ownerTableGroup, transitive);
        }
        if (sqmJoin instanceof SqmCrossJoin) {
            return this.consumeCrossJoin((SqmCrossJoin)sqmJoin, lhsTableGroup, transitive);
        }
        if (sqmJoin instanceof SqmEntityJoin) {
            return this.consumeEntityJoin((SqmEntityJoin)sqmJoin, lhsTableGroup, transitive);
        }
        throw new InterpretationException("Could not resolve SqmJoin [" + sqmJoin.getNavigablePath() + "] to TableGroupJoin");
    }

    private TableGroup findActualTableGroup(TableGroup lhsTableGroup, SqmPath<?> path) {
        SqmPathSource<?> intermediatePathSource;
        JpaPath lhs = path instanceof SqmTreatedPath ? ((SqmTreatedPath)path).getWrappedPath().getLhs() : path.getLhs();
        SqmPathSource<?> sqmPathSource = intermediatePathSource = lhs == null ? null : lhs.getReferencedPathSource().getIntermediatePathSource(path.getReferencedPathSource());
        if (intermediatePathSource == null) {
            return lhsTableGroup;
        }
        assert (intermediatePathSource.getPathName().equals(CollectionPart.Nature.ELEMENT.getName()));
        PluralTableGroup pluralTableGroup = (PluralTableGroup)lhsTableGroup;
        return pluralTableGroup.getElementTableGroup();
    }

    private TableGroup consumeAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin, TableGroup lhsTableGroup, TableGroup ownerTableGroup, boolean transitive) {
        TableGroup joinedTableGroup;
        TableGroupJoin joinedTableGroupJoin;
        SqmPathSource<?> pathSource = sqmJoin.getReferencedPathSource();
        SqmJoinType sqmJoinType = sqmJoin.getSqmJoinType();
        NavigablePath sqmJoinNavigablePath = sqmJoin.getNavigablePath();
        ModelPart modelPart = ownerTableGroup.getModelPart().findSubPart(pathSource.getPathName(), SqmMappingModelHelper.resolveExplicitTreatTarget(sqmJoin, this));
        if (pathSource instanceof PluralPersistentAttribute) {
            assert (modelPart instanceof PluralAttributeMapping);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPart;
            joinedTableGroupJoin = pluralAttributeMapping.createTableGroupJoin(sqmJoinNavigablePath, ownerTableGroup, sqmJoin.getExplicitAlias(), sqmJoinType.getCorrespondingSqlJoinType(), sqmJoin.isFetched(), sqmJoin.getJoinPredicate() != null, this);
            joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
            pluralAttributeMapping.applyBaseRestrictions(predicate -> {
                PredicateCollector existing = this.collectionFilterPredicates.get(joinedTableGroup.getGroupAlias());
                if (existing == null) {
                    PredicateCollector collector = new PredicateCollector((Predicate)predicate);
                    this.collectionFilterPredicates.put(joinedTableGroup.getGroupAlias(), collector);
                } else {
                    PredicateCollector collector = existing;
                    collector.applyPredicate((Predicate)predicate);
                }
            }, joinedTableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
        } else {
            assert (modelPart instanceof TableGroupJoinProducer);
            joinedTableGroupJoin = ((TableGroupJoinProducer)modelPart).createTableGroupJoin(sqmJoinNavigablePath, ownerTableGroup, sqmJoin.getExplicitAlias(), sqmJoinType.getCorrespondingSqlJoinType(), sqmJoin.isFetched(), sqmJoin.getJoinPredicate() != null, this);
            joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
            if (sqmJoin.getJoinPredicate() != null || sqmJoinType != SqmJoinType.INNER && sqmJoinType != SqmJoinType.LEFT) {
                joinedTableGroup.getPrimaryTableReference();
            }
        }
        lhsTableGroup.addTableGroupJoin(joinedTableGroupJoin);
        this.getFromClauseIndex().register(sqmJoin, joinedTableGroup);
        this.registerPluralTableGroupParts(joinedTableGroup);
        if (joinedTableGroup instanceof PluralTableGroup) {
            PluralTableGroup pluralTableGroup = (PluralTableGroup)joinedTableGroup;
            for (SqmFrom<?, ?> sqmTreat : sqmJoin.getSqmTreats()) {
                if (pluralTableGroup.getElementTableGroup() != null) {
                    this.getFromClauseAccess().registerTableGroup(sqmTreat.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()), pluralTableGroup.getElementTableGroup());
                }
                if (pluralTableGroup.getIndexTableGroup() == null) continue;
                this.getFromClauseAccess().registerTableGroup(sqmTreat.getNavigablePath().append(CollectionPart.Nature.INDEX.getName()), pluralTableGroup.getIndexTableGroup());
            }
        } else {
            for (SqmFrom sqmFrom : sqmJoin.getSqmTreats()) {
                this.getFromClauseAccess().registerTableGroup(sqmFrom.getNavigablePath(), joinedTableGroup);
            }
        }
        if (sqmJoin.getJoinPredicate() != null) {
            if (sqmJoin.isFetched()) {
                QueryLogging.QUERY_MESSAGE_LOGGER.debugf("Join fetch [" + sqmJoinNavigablePath + "] is restricted", new Object[0]);
            }
            SqmJoin<?, ?> oldJoin = this.currentlyProcessingJoin;
            this.currentlyProcessingJoin = sqmJoin;
            joinedTableGroupJoin.applyPredicate((Predicate)sqmJoin.getJoinPredicate().accept(this));
            this.currentlyProcessingJoin = oldJoin;
        }
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, joinedTableGroup);
        }
        return joinedTableGroup;
    }

    private TableGroup consumeCrossJoin(SqmCrossJoin<?> sqmJoin, TableGroup lhsTableGroup, boolean transitive) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(true, sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this, this.getCreationContext());
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), SqlAstJoinType.CROSS, tableGroup);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        this.getFromClauseIndex().register(sqmJoin, tableGroup);
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        }
        return tableGroup;
    }

    private TableGroup consumeEntityJoin(SqmEntityJoin<?> sqmJoin, TableGroup lhsTableGroup, boolean transitive) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        SqlAstJoinType correspondingSqlJoinType = sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType();
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(correspondingSqlJoinType == SqlAstJoinType.INNER || correspondingSqlJoinType == SqlAstJoinType.CROSS, sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this, this.getCreationContext());
        this.getFromClauseIndex().register(sqmJoin, tableGroup);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), correspondingSqlJoinType, tableGroup, null);
        if (sqmJoin.getJoinPredicate() != null) {
            SqmJoin<?, ?> oldJoin = this.currentlyProcessingJoin;
            this.currentlyProcessingJoin = sqmJoin;
            tableGroupJoin.applyPredicate((Predicate)sqmJoin.getJoinPredicate().accept(this));
            this.currentlyProcessingJoin = oldJoin;
        }
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        }
        return tableGroup;
    }

    private <X> X prepareReusablePath(SqmPath<?> sqmPath, Supplier<X> supplier) {
        Consumer<TableGroup> implicitJoinChecker = this.getCurrentProcessingState() instanceof SqlAstQueryPartProcessingState ? tg -> {} : BaseSqmToSqlAstConverter::verifyManipulationImplicitJoin;
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        this.prepareReusablePath(fromClauseIndex, sqmPath, false, implicitJoinChecker);
        return supplier.get();
    }

    private TableGroup prepareReusablePath(FromClauseIndex fromClauseIndex, JpaPath<?> sqmPath, boolean useInnerJoin, Consumer<TableGroup> implicitJoinChecker) {
        SqmPath parentPath = sqmPath instanceof SqmTreatedPath ? ((SqmTreatedPath)sqmPath).getWrappedPath() : sqmPath.getParentPath();
        TableGroup tableGroup = fromClauseIndex.findTableGroup(parentPath.getNavigablePath());
        if (tableGroup == null) {
            TableGroup parentTableGroup = this.prepareReusablePath(fromClauseIndex, parentPath, useInnerJoin, implicitJoinChecker);
            if (parentPath instanceof SqmTreatedPath) {
                fromClauseIndex.register(parentPath, parentTableGroup);
                return parentTableGroup;
            }
            TableGroup newTableGroup = this.createTableGroup(parentTableGroup, parentPath, useInnerJoin);
            if (newTableGroup != null) {
                implicitJoinChecker.accept(newTableGroup);
                if (sqmPath instanceof SqmFrom) {
                    this.registerUsage((SqmFrom)sqmPath, newTableGroup);
                }
            }
            return newTableGroup;
        }
        if (sqmPath instanceof SqmTreatedPath) {
            fromClauseIndex.register((SqmPath)sqmPath, tableGroup);
            if (sqmPath instanceof SqmFrom) {
                this.registerUsage((SqmFrom)sqmPath, tableGroup);
            }
        } else if (parentPath instanceof SqmFrom) {
            this.registerUsage((SqmFrom)parentPath, tableGroup);
        }
        return tableGroup;
    }

    private void prepareForSelection(SqmPath<?> joinedPath) {
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        TableGroup tableGroup = fromClauseIndex.findTableGroup(joinedPath.getNavigablePath());
        if (tableGroup == null) {
            this.prepareReusablePath(joinedPath, () -> null);
            NavigablePath navigablePath = CollectionPart.Nature.fromNameExact(joinedPath.getNavigablePath().getUnaliasedLocalName()) != null ? joinedPath.getLhs().getLhs().getNavigablePath() : (joinedPath instanceof SqmTreatedRoot ? ((SqmTreatedRoot)joinedPath).getWrappedPath().getNavigablePath() : joinedPath.getLhs().getNavigablePath());
            boolean useInnerJoin = true;
            TableGroup createdTableGroup = this.createTableGroup(fromClauseIndex.getTableGroup(navigablePath), joinedPath, true);
            if (createdTableGroup != null && joinedPath instanceof SqmTreatedPath) {
                fromClauseIndex.register(joinedPath, createdTableGroup);
            }
        } else if (joinedPath instanceof SqmFrom) {
            this.registerUsage((SqmFrom)joinedPath, tableGroup);
        }
    }

    private TableGroup createTableGroup(TableGroup parentTableGroup, SqmPath<?> joinedPath, boolean useInnerJoin) {
        TableGroup tableGroup;
        TableGroup actualParentTableGroup = this.findActualTableGroup(parentTableGroup, joinedPath);
        JpaPath lhsPath = joinedPath.getLhs();
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        ModelPart subPart = actualParentTableGroup.getModelPart().findSubPart(joinedPath.getReferencedPathSource().getPathName(), lhsPath instanceof SqmTreatedPath ? this.resolveEntityPersister(((SqmTreatedPath)lhsPath).getTreatTarget()) : null);
        if (subPart instanceof TableGroupJoinProducer) {
            TableGroupJoinProducer joinProducer = (TableGroupJoinProducer)subPart;
            SqlAstJoinType defaultSqlAstJoinType = useInnerJoin || joinProducer instanceof PluralAttributeMapping ? SqlAstJoinType.INNER : joinProducer.getDefaultSqlAstJoinType(actualParentTableGroup);
            if (fromClauseIndex.findTableGroupOnLeaf(actualParentTableGroup.getNavigablePath()) == null) {
                QuerySpec querySpec = this.currentQuerySpec();
                tableGroup = joinProducer.createRootTableGroupJoin(joinedPath.getNavigablePath(), actualParentTableGroup, null, defaultSqlAstJoinType, false, querySpec::applyPredicate, this);
                tableGroup.getPrimaryTableReference();
                querySpec.getFromClause().addRoot(tableGroup);
            } else {
                boolean nested;
                TableGroupJoin tableGroupJoin = joinProducer.createTableGroupJoin(joinedPath.getNavigablePath(), actualParentTableGroup, null, defaultSqlAstJoinType, false, false, this);
                boolean bl = nested = this.currentClauseStack.getCurrent() == Clause.FROM && this.currentlyProcessingJoin instanceof SqmAttributeJoin;
                if (nested) {
                    actualParentTableGroup.addNestedTableGroupJoin(tableGroupJoin);
                } else {
                    actualParentTableGroup.addTableGroupJoin(tableGroupJoin);
                }
                tableGroup = tableGroupJoin.getJoinedGroup();
            }
            fromClauseIndex.register(joinedPath, tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
        } else {
            tableGroup = null;
        }
        return tableGroup;
    }

    private void registerPluralTableGroupParts(TableGroup tableGroup) {
        if (tableGroup instanceof PluralTableGroup) {
            PluralTableGroup pluralTableGroup = (PluralTableGroup)tableGroup;
            if (pluralTableGroup.getElementTableGroup() != null) {
                this.getFromClauseAccess().registerTableGroup(pluralTableGroup.getElementTableGroup().getNavigablePath(), pluralTableGroup.getElementTableGroup());
            }
            if (pluralTableGroup.getIndexTableGroup() != null) {
                this.getFromClauseAccess().registerTableGroup(pluralTableGroup.getIndexTableGroup().getNavigablePath(), pluralTableGroup.getIndexTableGroup());
            }
        }
    }

    @Override
    public Expression visitRootPath(SqmRoot<?> sqmRoot) {
        TableGroup resolved = this.getFromClauseAccess().findTableGroup(sqmRoot.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmRoot [%s] resolved to existing TableGroup [%s]", sqmRoot, (Object)resolved);
            return this.visitTableGroup(resolved, sqmRoot);
        }
        throw new InterpretationException("SqmRoot not yet resolved to TableGroup");
    }

    @Override
    public Expression visitQualifiedAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmAttributeJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmAttributeJoin not yet resolved to TableGroup");
    }

    @Override
    public Expression visitCrossJoin(SqmCrossJoin<?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmCrossJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmCrossJoin not yet resolved to TableGroup");
    }

    @Override
    public Expression visitQualifiedEntityJoin(SqmEntityJoin sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmEntityJoin [%s] resolved to existing TableGroup [%s]", (Object)sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmEntityJoin not yet resolved to TableGroup");
    }

    private Expression visitTableGroup(TableGroup tableGroup, SqmFrom<?, ?> path) {
        AbstractSqmPathInterpretation result;
        ModelPart resultPart;
        ModelPart keyPart;
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)modelPart;
            keyPart = toOneAttributeMapping.findSubPart(toOneAttributeMapping.getTargetKeyPropertyName());
            resultPart = modelPart;
        } else if (modelPart instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPart;
            CollectionPart elementDescriptor = pluralAttributeMapping.getElementDescriptor();
            keyPart = elementDescriptor instanceof EntityCollectionPart ? ((EntityCollectionPart)elementDescriptor).getKeyTargetMatchPart() : elementDescriptor;
            resultPart = elementDescriptor;
        } else if (modelPart instanceof EntityCollectionPart) {
            keyPart = ((EntityCollectionPart)modelPart).getKeyTargetMatchPart();
            resultPart = modelPart;
        } else if (modelPart instanceof EntityMappingType) {
            keyPart = ((EntityMappingType)modelPart).getIdentifierMapping();
            resultPart = modelPart;
        } else {
            keyPart = modelPart;
            resultPart = modelPart;
        }
        NavigablePath navigablePath = resultPart == modelPart ? tableGroup.getNavigablePath() : tableGroup.getNavigablePath().append(resultPart.getPartName());
        if (resultPart instanceof EntityValuedModelPart) {
            EntityValuedModelPart mapping = (EntityValuedModelPart)resultPart;
            boolean expandToAllColumns = this.currentClauseStack.getCurrent() == Clause.GROUP ? tableGroup.isFetched() || this.selectClauseContains(path) : false;
            TableGroup parentGroupToUse = this.findTableGroup(navigablePath.getParent());
            result = EntityValuedPathInterpretation.from(navigablePath, parentGroupToUse == null ? tableGroup : parentGroupToUse, mapping, expandToAllColumns, this);
        } else if (resultPart instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart mapping = (EmbeddableValuedModelPart)keyPart;
            result = new EmbeddableValuedPathInterpretation(mapping.toSqlExpression(tableGroup, this.currentClauseStack.getCurrent(), this, this.getSqlAstCreationState()), navigablePath, (EmbeddableValuedModelPart)resultPart, tableGroup);
        } else {
            ColumnReference columnReference;
            assert (resultPart instanceof BasicValuedModelPart);
            BasicValuedModelPart mapping = (BasicValuedModelPart)keyPart;
            TableReference tableReference = tableGroup.resolveTableReference(navigablePath.append(keyPart.getPartName()), mapping.getContainingTableExpression());
            Expression expression = this.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, mapping.getSelectionExpression()), sacs -> new ColumnReference(tableReference.getIdentificationVariable(), (SelectableMapping)mapping, this.getCreationContext().getSessionFactory()));
            if (expression instanceof ColumnReference) {
                columnReference = (ColumnReference)expression;
            } else if (expression instanceof SqlSelectionExpression) {
                Expression selectedExpression = ((SqlSelectionExpression)expression).getSelection().getExpression();
                assert (selectedExpression instanceof ColumnReference);
                columnReference = (ColumnReference)selectedExpression;
            } else {
                throw new UnsupportedOperationException("Unsupported basic-valued path expression : " + expression);
            }
            result = new BasicValuedPathInterpretation(columnReference, navigablePath, (BasicValuedModelPart)resultPart, tableGroup);
        }
        return this.withTreatRestriction(result, path);
    }

    @Override
    public Expression visitBasicValuedPath(SqmBasicValuedSimplePath<?> sqmPath) {
        BasicValuedPathInterpretation path;
        Expression result = path = this.prepareReusablePath(sqmPath, () -> BasicValuedPathInterpretation.from(sqmPath, this, this, this.jpaQueryComplianceEnabled));
        if (TypeConfiguration.isDuration(sqmPath.getNodeType())) {
            Expression scaledExpression = this.applyScale(this.toSqlExpression(path));
            if (this.adjustedTimestamp != null) {
                if (this.appliedByUnit != null) {
                    throw new IllegalStateException();
                }
                result = this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, new DurationUnit(TemporalUnit.SECOND, this.basicType(Long.class)), scaledExpression, this.adjustedTimestamp);
            } else if (this.appliedByUnit != null) {
                JdbcMappingContainer durationType = scaledExpression.getExpressionType();
                Duration duration = durationType.getJdbcMappings().get(0).getJdbcTypeDescriptor().isInterval() ? new Duration(this.extractEpoch(scaledExpression), TemporalUnit.SECOND, (BasicValuedMapping)durationType) : new Duration(scaledExpression, TemporalUnit.SECOND, (BasicValuedMapping)durationType);
                TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
                BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
                result = new Conversion(duration, appliedUnit, scalarType);
            } else {
                result = scaledExpression;
            }
        }
        return this.withTreatRestriction(result, sqmPath);
    }

    private Expression extractEpoch(Expression intervalExpression) {
        BasicType<Integer> intType = this.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
        return new SelfRenderingFunctionSqlAstExpression("extract", (sqlAppender, sqlAstArguments, walker) -> new PatternRenderer(this.creationContext.getSessionFactory().getJdbcServices().getDialect().extractPattern(TemporalUnit.EPOCH)).render(sqlAppender, sqlAstArguments, walker), Arrays.asList(new ExtractUnit(TemporalUnit.EPOCH, intType), intervalExpression), intType, intType);
    }

    @Override
    public Expression visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> EmbeddableValuedPathInterpretation.from(sqmPath, this, this, this.jpaQueryComplianceEnabled)), sqmPath);
    }

    @Override
    public Expression visitAnyValuedValuedPath(SqmAnyValuedSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> DiscriminatedAssociationPathInterpretation.from(sqmPath, this)), sqmPath);
    }

    @Override
    public Expression visitNonAggregatedCompositeValuedPath(NonAggregatedCompositeSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> NonAggregatedCompositeValuedPathInterpretation.from(sqmPath, this, this)), sqmPath);
    }

    @Override
    public Expression visitEntityValuedPath(SqmEntityValuedSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> EntityValuedPathInterpretation.from(sqmPath, this)), sqmPath);
    }

    @Override
    public Expression visitPluralValuedPath(SqmPluralValuedSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> PluralValuedSimplePathInterpretation.from(sqmPath, this)), sqmPath);
    }

    @Override
    public Object visitSelfInterpretingSqmPath(SelfInterpretingSqmPath<?> sqmPath) {
        return this.prepareReusablePath(sqmPath, () -> {
            if (sqmPath instanceof DiscriminatorSqmPath) {
                this.registerTypeUsage((DiscriminatorSqmPath)sqmPath);
            }
            return sqmPath.interpret(this, this, this.jpaQueryComplianceEnabled);
        });
    }

    @Override
    public Expression visitMaxElementPath(SqmMaxElementPath<?> path) {
        return this.createMinOrMaxIndexOrElement(path, false, true);
    }

    @Override
    public Expression visitMinElementPath(SqmMinElementPath<?> path) {
        return this.createMinOrMaxIndexOrElement(path, false, false);
    }

    @Override
    public Expression visitMaxIndexPath(SqmMaxIndexPath<?> path) {
        return this.createMinOrMaxIndexOrElement(path, true, true);
    }

    @Override
    public Expression visitMinIndexPath(SqmMinIndexPath<?> path) {
        return this.createMinOrMaxIndexOrElement(path, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression visitPluralAttributeSizeFunction(SqmCollectionSize function) {
        SqmPath<?> pluralPath = function.getPluralPath();
        this.prepareReusablePath(pluralPath, () -> null);
        TableGroup parentTableGroup = this.getFromClauseAccess().getTableGroup(pluralPath.getNavigablePath().getParent());
        assert (parentTableGroup != null);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)parentTableGroup.getModelPart().findSubPart(pluralPath.getNavigablePath().getUnaliasedLocalName(), null);
        assert (pluralAttributeMapping != null);
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent));
        try {
            TableGroup tableGroup = pluralAttributeMapping.createRootTableGroup(true, pluralPath.getNavigablePath(), null, () -> subQuerySpec::applyPredicate, this, this.creationContext);
            pluralAttributeMapping.applyBaseRestrictions(subQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
            this.getFromClauseAccess().registerTableGroup(pluralPath.getNavigablePath(), tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            AbstractSqmSelfRenderingFunctionDescriptor functionDescriptor = (AbstractSqmSelfRenderingFunctionDescriptor)this.creationContext.getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("count");
            BasicType<Integer> integerType = this.creationContext.getDomainModel().getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
            SelfRenderingAggregateFunctionSqlAstExpression expression = new SelfRenderingAggregateFunctionSqlAstExpression(functionDescriptor.getName(), functionDescriptor::render, Collections.singletonList(new QueryLiteral<Integer>(1, integerType)), null, integerType, integerType);
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, expression));
            subQuerySpec.applyPredicate(pluralAttributeMapping.getKeyDescriptor().generateJoinPredicate(parentTableGroup, tableGroup, SqlAstJoinType.INNER, this.getSqlExpressionResolver(), this.creationContext));
        }
        finally {
            this.popProcessingStateStack();
        }
        return subQuerySpec;
    }

    @Override
    public Object visitIndexedPluralAccessPath(SqmIndexedCollectionAccessPath<?> path) {
        return path.getLhs().accept(this);
    }

    @Override
    public Object visitMapEntryFunction(SqmMapEntryReference<?, ?> entryRef) {
        SqmPath<?> mapPath = entryRef.getMapPath();
        this.prepareReusablePath(mapPath, () -> null);
        NavigablePath mapNavigablePath = mapPath.getNavigablePath();
        TableGroup tableGroup = this.getFromClauseAccess().resolveTableGroup(mapNavigablePath, navigablePath -> {
            TableGroup parentTableGroup = this.getFromClauseAccess().getTableGroup(mapNavigablePath.getParent());
            PluralAttributeMapping mapAttribute = (PluralAttributeMapping)parentTableGroup.getModelPart().findSubPart(mapNavigablePath.getLocalName(), null);
            TableGroupJoin tableGroupJoin = mapAttribute.createTableGroupJoin(mapNavigablePath, parentTableGroup, null, SqlAstJoinType.INNER, false, false, this.sqlAliasBaseManager, this.getSqlExpressionResolver(), this, this.creationContext);
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        PluralAttributeMapping mapDescriptor = (PluralAttributeMapping)tableGroup.getModelPart();
        CollectionPart indexDescriptor = mapDescriptor.getIndexDescriptor();
        NavigablePath indexNavigablePath = mapNavigablePath.append(indexDescriptor.getPartName());
        final DomainResult indexResult = indexDescriptor.createDomainResult(indexNavigablePath, tableGroup, null, this);
        CollectionPart valueDescriptor = mapDescriptor.getElementDescriptor();
        NavigablePath valueNavigablePath = mapNavigablePath.append(valueDescriptor.getPartName());
        final DomainResult valueResult = valueDescriptor.createDomainResult(valueNavigablePath, tableGroup, null, this);
        return new DomainResultProducer<Map.Entry<Object, Object>>(){

            @Override
            public DomainResult<Map.Entry<Object, Object>> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
                JavaType mapEntryDescriptor = BaseSqmToSqlAstConverter.this.getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor((Type)((Object)Map.Entry.class));
                return new SqmMapEntryResult(indexResult, valueResult, resultVariable, mapEntryDescriptor);
            }
        };
    }

    protected Expression createMinOrMaxIndexOrElement(AbstractSqmSpecificPluralPartPath<?> pluralPartPath, boolean index, boolean max) {
        if (this.creationContext.getSessionFactory().getJdbcServices().getDialect().supportsLateral()) {
            return this.createLateralJoinExpression(pluralPartPath, index, max);
        }
        return this.createCorrelatedAggregateSubQuery(pluralPartPath, index, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression createCorrelatedAggregateSubQuery(AbstractSqmSpecificPluralPartPath<?> pluralPartPath, boolean index, boolean max) {
        this.prepareReusablePath((SqmPath<?>)pluralPartPath.getLhs(), (Supplier)() -> null);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.determineValueMapping(pluralPartPath.getPluralDomainPath());
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent));
        try {
            TableGroup tableGroup = pluralAttributeMapping.createRootTableGroup(true, pluralPartPath.getNavigablePath(), null, () -> subQuerySpec::applyPredicate, this, this.creationContext);
            pluralAttributeMapping.applyBaseRestrictions(subQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
            this.getFromClauseAccess().registerTableGroup(pluralPartPath.getNavigablePath(), tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            AbstractSqmSelfRenderingFunctionDescriptor functionDescriptor = (AbstractSqmSelfRenderingFunctionDescriptor)this.creationContext.getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(max ? "max" : "min");
            CollectionPart collectionPart = index ? pluralAttributeMapping.getIndexDescriptor() : pluralAttributeMapping.getElementDescriptor();
            ModelPart modelPart = collectionPart instanceof EntityAssociationMapping ? ((EntityAssociationMapping)((Object)collectionPart)).getKeyTargetMatchPart() : collectionPart;
            ArrayList<SqlAstNode> arguments = new ArrayList<SqlAstNode>(1);
            NavigablePath navigablePath = pluralPartPath.getNavigablePath();
            int jdbcTypeCount = modelPart.getJdbcTypeCount();
            ArrayList<SqlAstNode> tupleElements = jdbcTypeCount == 1 ? arguments : new ArrayList(jdbcTypeCount);
            modelPart.forEachSelectable((selectionIndex, selectionMapping) -> tupleElements.add(new ColumnReference(tableGroup.resolveTableReference(navigablePath, selectionMapping.getContainingTableExpression()), selectionMapping, this.creationContext.getSessionFactory())));
            if (jdbcTypeCount != 1) {
                arguments.add(new SqlTuple(tupleElements, modelPart));
            }
            SelfRenderingAggregateFunctionSqlAstExpression expression = new SelfRenderingAggregateFunctionSqlAstExpression(functionDescriptor.getName(), functionDescriptor::render, arguments, null, (AllowableFunctionReturnType)((Object)modelPart.getJdbcMappings().get(0)), modelPart);
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, expression));
            subQuerySpec.applyPredicate(pluralAttributeMapping.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(pluralPartPath.getPluralDomainPath().getNavigablePath().getParent()), tableGroup, SqlAstJoinType.INNER, this.getSqlExpressionResolver(), this.creationContext));
        }
        finally {
            this.popProcessingStateStack();
        }
        return subQuerySpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression createLateralJoinExpression(AbstractSqmSpecificPluralPartPath<?> pluralPartPath, boolean index, boolean max) {
        this.prepareReusablePath((SqmPath<?>)pluralPartPath.getLhs(), (Supplier)() -> null);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.determineValueMapping(pluralPartPath.getPluralDomainPath());
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        TableGroup parentTableGroup = parentFromClauseAccess.findTableGroup(pluralPartPath.getNavigablePath().getParent());
        CollectionPart collectionPart = index ? pluralAttributeMapping.getIndexDescriptor() : pluralAttributeMapping.getElementDescriptor();
        ModelPart modelPart = collectionPart instanceof EntityAssociationMapping ? ((EntityAssociationMapping)((Object)collectionPart)).getKeyTargetMatchPart() : collectionPart;
        int jdbcTypeCount = modelPart.getJdbcTypeCount();
        String pathName = (max ? "max" : "min") + (index ? "_index" : "_element");
        String identifierVariable = parentTableGroup.getPrimaryTableReference().getIdentificationVariable() + "_" + pathName;
        NavigablePath queryPath = new NavigablePath(parentTableGroup.getNavigablePath(), pathName, identifierVariable);
        TableGroup lateralTableGroup = parentFromClauseAccess.findTableGroup(queryPath);
        if (lateralTableGroup == null) {
            QuerySpec subQuerySpec = new QuerySpec(false);
            this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent));
            try {
                Expression expression;
                TableGroup tableGroup = pluralAttributeMapping.createRootTableGroup(true, pluralPartPath.getNavigablePath(), null, () -> subQuerySpec::applyPredicate, this, this.creationContext);
                pluralAttributeMapping.applyBaseRestrictions(subQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
                this.getFromClauseAccess().registerTableGroup(pluralPartPath.getNavigablePath(), tableGroup);
                this.registerPluralTableGroupParts(tableGroup);
                subQuerySpec.getFromClause().addRoot(tableGroup);
                ArrayList<String> columnNames = new ArrayList<String>(jdbcTypeCount);
                ArrayList resultColumnReferences = new ArrayList(jdbcTypeCount);
                NavigablePath navigablePath = pluralPartPath.getNavigablePath();
                modelPart.forEachSelectable((selectionIndex, selectionMapping) -> {
                    ColumnReference columnReference = new ColumnReference(tableGroup.resolveTableReference(navigablePath, selectionMapping.getContainingTableExpression()), selectionMapping, this.creationContext.getSessionFactory());
                    Object columnName = selectionMapping.isFormula() ? "col" + columnNames.size() : selectionMapping.getSelectionExpression();
                    columnNames.add((String)columnName);
                    subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(selectionIndex - 1, selectionIndex, columnReference));
                    subQuerySpec.addSortSpecification(new SortSpecification(columnReference, null, max ? SortOrder.DESCENDING : SortOrder.ASCENDING));
                    resultColumnReferences.add(new ColumnReference(identifierVariable, (String)columnName, false, null, null, selectionMapping.getJdbcMapping(), this.creationContext.getSessionFactory()));
                });
                subQuerySpec.setFetchClauseExpression(new QueryLiteral<Integer>(1, this.basicType(Integer.class)), FetchClauseType.ROWS_ONLY);
                subQuerySpec.applyPredicate(pluralAttributeMapping.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(pluralPartPath.getPluralDomainPath().getNavigablePath().getParent()), tableGroup, SqlAstJoinType.INNER, this.getSqlExpressionResolver(), this.creationContext));
                lateralTableGroup = new QueryPartTableGroup(queryPath, null, subQuerySpec, identifierVariable, columnNames, true, false, this.creationContext.getSessionFactory());
                if (this.currentlyProcessingJoin == null) {
                    parentTableGroup.addTableGroupJoin(new TableGroupJoin(lateralTableGroup.getNavigablePath(), SqlAstJoinType.LEFT, lateralTableGroup));
                } else {
                    TableGroup targetTableGroup = this.currentlyProcessingJoin.getLhs() == null ? parentFromClauseAccess.getTableGroup(this.currentlyProcessingJoin.findRoot().getNavigablePath()) : parentFromClauseAccess.getTableGroup(this.currentlyProcessingJoin.getLhs().getNavigablePath());
                    targetTableGroup.prependTableGroupJoin(this.currentlyProcessingJoin.getNavigablePath(), new TableGroupJoin(lateralTableGroup.getNavigablePath(), SqlAstJoinType.LEFT, lateralTableGroup));
                }
                parentFromClauseAccess.registerTableGroup(lateralTableGroup.getNavigablePath(), lateralTableGroup);
                if (jdbcTypeCount == 1) {
                    expression = (Expression)resultColumnReferences.get(0);
                    return expression;
                }
                expression = new SqlTuple(resultColumnReferences, modelPart);
                return expression;
            }
            finally {
                this.popProcessingStateStack();
            }
        }
        QueryPartTableReference tableReference = (QueryPartTableReference)lateralTableGroup.getPrimaryTableReference();
        if (jdbcTypeCount == 1) {
            return new ColumnReference(identifierVariable, tableReference.getColumnNames().get(0), false, null, null, modelPart.getJdbcMappings().get(0), this.creationContext.getSessionFactory());
        }
        ArrayList resultColumnReferences = new ArrayList(jdbcTypeCount);
        modelPart.forEachSelectable((selectionIndex, selectionMapping) -> resultColumnReferences.add(new ColumnReference(identifierVariable, tableReference.getColumnNames().get(selectionIndex), false, null, null, selectionMapping.getJdbcMapping(), this.creationContext.getSessionFactory())));
        return new SqlTuple(resultColumnReferences, modelPart);
    }

    private Expression withTreatRestriction(Expression expression, SqmPath<?> path) {
        JpaPath lhs = path.getLhs();
        if (lhs instanceof SqmTreatedPath) {
            Class originalJavaType;
            SqmTreatedPath treatedPath = (SqmTreatedPath)lhs;
            Class treatTargetJavaType = treatedPath.getTreatTarget().getJavaType();
            if (treatTargetJavaType.isAssignableFrom(originalJavaType = treatedPath.getWrappedPath().getJavaType())) {
                return expression;
            }
            return this.createCaseExpression(treatedPath.getWrappedPath(), treatedPath.getTreatTarget(), expression);
        }
        return expression;
    }

    private Expression createCaseExpression(SqmPath<?> lhs, EntityDomainType<?> treatTarget, Expression expression) {
        BasicValuedMapping mappingModelExpressable = (BasicValuedMapping)expression.getExpressionType();
        ArrayList<CaseSearchedExpression.WhenFragment> whenFragments = new ArrayList<CaseSearchedExpression.WhenFragment>(1);
        whenFragments.add(new CaseSearchedExpression.WhenFragment(this.createTreatTypeRestriction(lhs, treatTarget), expression));
        return new CaseSearchedExpression(mappingModelExpressable, whenFragments, new QueryLiteral<Object>(null, mappingModelExpressable));
    }

    private Predicate createTreatTypeRestriction(SqmPath<?> lhs, EntityDomainType<?> treatTarget) {
        MappingMetamodel domainModel = this.getCreationContext().getDomainModel();
        EntityPersister entityDescriptor = domainModel.findEntityDescriptor(treatTarget.getHibernateEntityName());
        Set<String> subclassEntityNames = entityDescriptor.getEntityMetamodel().getSubclassEntityNames();
        Expression typeExpression = (Expression)lhs.type().accept(this);
        if (subclassEntityNames.size() == 1) {
            return new ComparisonPredicate(typeExpression, ComparisonOperator.EQUAL, new EntityTypeLiteral(entityDescriptor));
        }
        ArrayList<Expression> typeLiterals = new ArrayList<Expression>(subclassEntityNames.size());
        for (String subclassEntityName : subclassEntityNames) {
            typeLiterals.add(new EntityTypeLiteral(domainModel.findEntityDescriptor(subclassEntityName)));
        }
        return new InListPredicate(typeExpression, typeLiterals);
    }

    @Override
    public Expression visitLiteral(SqmLiteral<?> literal) {
        MappingModelExpressable<?> elementExpressable;
        MappingModelExpressable localExpressable;
        MappingModelExpressable expressable;
        Supplier<MappingModelExpressable> inferableTypeAccess = this.inferrableTypeAccessStack.getCurrent();
        if (literal instanceof SqmLiteralNull) {
            MappingModelExpressable<?> mappingModelExpressable = inferableTypeAccess.get();
            if (mappingModelExpressable == null) {
                mappingModelExpressable = this.determineCurrentExpressable(literal);
            }
            if (mappingModelExpressable instanceof BasicValuedMapping) {
                return new QueryLiteral<Object>(null, (BasicValuedMapping)mappingModelExpressable);
            }
            MappingModelExpressable<?> keyExpressable = this.getKeyExpressable(mappingModelExpressable);
            if (keyExpressable == null) {
                return new QueryLiteral<Object>(null, this.basicType(Object.class));
            }
            ArrayList expressions = new ArrayList(keyExpressable.getJdbcTypeCount());
            keyExpressable.forEachJdbcType((index, jdbcMapping) -> expressions.add(new QueryLiteral<Object>(null, (BasicValuedMapping)((Object)jdbcMapping))));
            return new SqlTuple(expressions, mappingModelExpressable);
        }
        MappingModelExpressable inferableExpressable = inferableTypeAccess.get();
        if (inferableExpressable instanceof ConvertibleModelPart) {
            ConvertibleModelPart convertibleModelPart = (ConvertibleModelPart)inferableExpressable;
            BasicValueConverter valueConverter = convertibleModelPart.getValueConverter();
            if (valueConverter != null) {
                Object sqlLiteralValue;
                Object literalValue = literal.getLiteralValue();
                if (valueConverter.getDomainJavaDescriptor().getJavaTypeClass().isInstance(literalValue)) {
                    sqlLiteralValue = valueConverter.toRelationalValue(literalValue);
                } else {
                    if (!valueConverter.getRelationalJavaDescriptor().getJavaTypeClass().isInstance(literalValue)) {
                        throw new SqlTreeCreationException(String.format(Locale.ROOT, "QueryLiteral type [`%s`] did not match domain Java-type [`%s`] nor JDBC Java-type [`%s`]", literalValue.getClass(), valueConverter.getDomainJavaDescriptor().getJavaTypeClass().getName(), valueConverter.getRelationalJavaDescriptor().getJavaTypeClass().getName()));
                    }
                    sqlLiteralValue = literalValue;
                }
                return new QueryLiteral(sqlLiteralValue, convertibleModelPart);
            }
        } else if (inferableExpressable instanceof EntityDiscriminatorMapping) {
            EntityPersister mappingDescriptor;
            EntityDiscriminatorMapping discriminatorMapping = (EntityDiscriminatorMapping)inferableExpressable;
            Object literalValue = literal.getLiteralValue();
            if (literalValue instanceof Class) {
                mappingDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor((Class)literalValue);
            } else {
                JavaType javaTypeDescriptor = discriminatorMapping.getJdbcMapping().getJavaTypeDescriptor();
                Object discriminatorValue = javaTypeDescriptor.getJavaTypeClass().isInstance(literalValue) ? literalValue : (literalValue instanceof CharSequence ? javaTypeDescriptor.fromString((CharSequence)literalValue) : (this.creationContext.getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled() ? literalValue : javaTypeDescriptor.coerce(literalValue, null)));
                String entityName = discriminatorMapping.getConcreteEntityNameForDiscriminatorValue(discriminatorValue);
                mappingDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
            }
            return new EntityTypeLiteral(mappingDescriptor);
        }
        if ((expressable = (localExpressable = SqmMappingModelHelper.resolveMappingModelExpressable(literal, this.getCreationContext().getDomainModel(), this.getFromClauseAccess()::findTableGroup)) == null ? this.getElementExpressable(inferableExpressable) : ((elementExpressable = this.getElementExpressable(localExpressable)) instanceof BasicType ? InferredBasicValueResolver.resolveSqlTypeIndicators(this, (BasicType)elementExpressable, literal.getJavaTypeDescriptor()) : elementExpressable)) instanceof BasicValuedMapping) {
            return new QueryLiteral(literal.getLiteralValue(), (BasicValuedMapping)expressable);
        }
        if (expressable instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)expressable;
            ArrayList list = new ArrayList(embeddableValuedModelPart.getJdbcTypeCount());
            embeddableValuedModelPart.forEachJdbcValue(literal.getLiteralValue(), null, (selectionIndex, value, jdbcMapping) -> list.add(new QueryLiteral<Object>(value, (BasicValuedMapping)((Object)jdbcMapping))), null);
            return new SqlTuple(list, expressable);
        }
        if (expressable instanceof EntityValuedModelPart) {
            ModelPart associationKeyPart;
            Object associationKey;
            EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)expressable;
            if (entityValuedModelPart instanceof Association) {
                Association association = (Association)((Object)entityValuedModelPart);
                ForeignKeyDescriptor foreignKeyDescriptor = association.getForeignKeyDescriptor();
                associationKey = foreignKeyDescriptor.getAssociationKeyFromSide(literal.getLiteralValue(), association.getSideNature(), null);
                associationKeyPart = foreignKeyDescriptor.getPart(association.getSideNature());
            } else {
                EntityIdentifierMapping identifierMapping = entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
                associationKeyPart = identifierMapping;
                associationKey = identifierMapping.getIdentifier(literal.getLiteralValue(), null);
            }
            if (associationKeyPart instanceof BasicValuedMapping) {
                return new QueryLiteral<Object>(associationKey, (BasicValuedMapping)((Object)associationKeyPart));
            }
            ArrayList list = new ArrayList(associationKeyPart.getJdbcTypeCount());
            associationKeyPart.forEachJdbcValue(associationKey, null, (selectionIndex, value, jdbcMapping) -> list.add(new QueryLiteral<Object>(value, (BasicValuedMapping)((Object)jdbcMapping))), null);
            return new SqlTuple(list, associationKeyPart);
        }
        throw new NotYetImplementedFor6Exception(expressable == null ? literal.getLiteralValue().getClass() : expressable.getClass());
    }

    private MappingModelExpressable<?> getKeyExpressable(JdbcMappingContainer mappingModelExpressable) {
        if (mappingModelExpressable instanceof EntityAssociationMapping) {
            return ((EntityAssociationMapping)mappingModelExpressable).getKeyTargetMatchPart();
        }
        return (MappingModelExpressable)mappingModelExpressable;
    }

    private MappingModelExpressable<?> getElementExpressable(MappingModelExpressable<?> mappingModelExpressable) {
        if (mappingModelExpressable instanceof PluralAttributeMapping) {
            return ((PluralAttributeMapping)mappingModelExpressable).getElementDescriptor();
        }
        return mappingModelExpressable;
    }

    @Override
    public Map<SqmParameter, List<List<JdbcParameter>>> getJdbcParamsBySqmParam() {
        return this.jdbcParamsBySqmParam;
    }

    @Override
    public Expression visitNamedParameterExpression(SqmNamedParameter<?> expression) {
        return this.consumeSqmParameter(expression);
    }

    protected Expression consumeSqmParameter(SqmParameter sqmParameter, BiConsumer<Integer, JdbcParameter> jdbcParameterConsumer) {
        MappingModelExpressable<?> valueMapping = this.determineValueMapping(sqmParameter);
        ArrayList<JdbcParameter> jdbcParametersForSqm = new ArrayList<JdbcParameter>();
        this.resolveSqmParameter(sqmParameter, valueMapping, (index, jdbcParameter) -> {
            jdbcParameterConsumer.accept((Integer)index, (JdbcParameter)jdbcParameter);
            jdbcParametersForSqm.add((JdbcParameter)jdbcParameter);
        });
        this.jdbcParameters.addParameters(jdbcParametersForSqm);
        this.jdbcParamsBySqmParam.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParametersForSqm);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        if (binding.setType(valueMapping)) {
            this.replaceJdbcParametersType(sqmParameter, this.domainParameterXref.getSqmParameters(queryParameter), valueMapping);
        }
        return new SqmParameterInterpretation(sqmParameter, queryParameter, jdbcParametersForSqm, valueMapping, qp -> binding);
    }

    private void replaceJdbcParametersType(SqmParameter sourceSqmParameter, List<SqmParameter> sqmParameters, MappingModelExpressable<?> valueMapping) {
        JdbcMapping jdbcMapping = valueMapping.getJdbcMappings().get(0);
        for (SqmParameter sqmParameter : sqmParameters) {
            if (sqmParameter == sourceSqmParameter) continue;
            this.sqmParameterMappingModelTypes.put(sqmParameter, valueMapping);
            List<List<JdbcParameter>> jdbcParamsForSqmParameter = this.jdbcParamsBySqmParam.get(sqmParameter);
            if (jdbcParamsForSqmParameter == null) continue;
            for (List<JdbcParameter> parameters : jdbcParamsForSqmParameter) {
                assert (parameters.size() == 1);
                JdbcParameter jdbcParameter = parameters.get(0);
                if (((SqlExpressable)((Object)jdbcParameter)).getJdbcMapping() == valueMapping) continue;
                JdbcParameterImpl newJdbcParameter = new JdbcParameterImpl(jdbcMapping);
                parameters.set(0, newJdbcParameter);
                this.jdbcParameters.getJdbcParameters().remove(jdbcParameter);
                this.jdbcParameters.getJdbcParameters().add(newJdbcParameter);
            }
        }
    }

    protected Expression consumeSqmParameter(SqmParameter sqmParameter) {
        if (sqmParameter.allowMultiValuedBinding()) {
            QueryParameterImplementor<?> domainParam = this.domainParameterXref.getQueryParameter(sqmParameter);
            QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(domainParam);
            if (!domainParamBinding.isMultiValued()) {
                return this.consumeSingleSqmParameter(sqmParameter);
            }
            Collection<?> bindValues = domainParamBinding.getBindValues();
            ArrayList<Expression> expressions = new ArrayList<Expression>(bindValues.size());
            boolean first = true;
            for (Object bindValue : bindValues) {
                SqmParameter sqmParamToConsume;
                if (first) {
                    sqmParamToConsume = sqmParameter;
                    first = false;
                } else {
                    sqmParamToConsume = sqmParameter.copy();
                    this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
                }
                expressions.add(this.consumeSingleSqmParameter(sqmParamToConsume));
            }
            return new SqlTuple(expressions, null);
        }
        return this.consumeSingleSqmParameter(sqmParameter);
    }

    protected Expression consumeSingleSqmParameter(SqmParameter sqmParameter) {
        MappingModelExpressable<?> valueMapping = this.determineValueMapping(sqmParameter);
        ArrayList<JdbcParameter> jdbcParametersForSqm = new ArrayList<JdbcParameter>();
        this.resolveSqmParameter(sqmParameter, valueMapping, jdbcParametersForSqm::add);
        this.jdbcParameters.addParameters(jdbcParametersForSqm);
        this.jdbcParamsBySqmParam.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParametersForSqm);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        if (binding.setType(valueMapping)) {
            this.replaceJdbcParametersType(sqmParameter, this.domainParameterXref.getSqmParameters(queryParameter), valueMapping);
        }
        return new SqmParameterInterpretation(sqmParameter, queryParameter, jdbcParametersForSqm, valueMapping, qp -> binding);
    }

    protected MappingModelExpressable<?> lenientlyResolveMappingExpressable(SqmExpressable<?> nodeType) {
        return this.resolveMappingExpressable(nodeType);
    }

    protected MappingModelExpressable<?> resolveMappingExpressable(SqmExpressable<?> nodeType) {
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        MappingModelExpressable valueMapping = this.getCreationContext().getDomainModel().resolveMappingExpressable(nodeType, this::findTableGroupByPath);
        if (valueMapping == null && (currentExpressableSupplier = this.inferrableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier.get();
        }
        if (valueMapping == null) {
            throw new ConversionException("Could not determine ValueMapping for SqmExpressable: " + nodeType);
        }
        return valueMapping;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MappingModelExpressable<?> determineValueMapping(SqmExpression<?> sqmExpression) {
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        SqmSelection<?> subQuerySelection;
        SqmExpressable selectionNodeType;
        SqmSubQuery subQuery;
        SqmSelectClause selectClause;
        Supplier<MappingModelExpressable> currentExpressableSupplier2;
        if (sqmExpression instanceof SqmParameter) {
            return this.determineValueMapping((SqmParameter)sqmExpression);
        }
        MappingMetamodel domainModel = this.getCreationContext().getDomainModel();
        if (sqmExpression instanceof SqmPath) {
            log.debugf("Determining mapping-model type for SqmPath : %s ", sqmExpression);
            return SqmMappingModelHelper.resolveMappingModelExpressable(sqmExpression, domainModel, this.getFromClauseAccess()::findTableGroup);
        }
        if (sqmExpression instanceof SqmEnumLiteral && (currentExpressableSupplier2 = this.inferrableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier2.get();
        }
        if (sqmExpression instanceof SqmSubQuery && (selectClause = ((SqmQuerySpec)(subQuery = (SqmSubQuery)sqmExpression).getQuerySpec()).getSelectClause()).getSelections().size() == 1 && (selectionNodeType = (subQuerySelection = selectClause.getSelections().get(0)).getNodeType()) != null) {
            void var7_10;
            block16: {
                if (selectionNodeType instanceof PluralPersistentAttribute) {
                    SqmPathSource sqmPathSource = ((PluralPersistentAttribute)selectionNodeType).getElementPathSource();
                } else {
                    if (selectionNodeType instanceof SqmPathSource) {
                        SqmPathSource pathSource = (SqmPathSource)selectionNodeType;
                        CollectionPart.Nature partNature = CollectionPart.Nature.fromName(pathSource.getPathName());
                        if (partNature == null) {
                            SqmExpressable sqmExpressable = selectionNodeType;
                            break block16;
                        } else {
                            SqmPath sqmPath = (SqmPath)subQuerySelection.getSelectableNode();
                            NavigablePath navigablePath = sqmPath.getNavigablePath().getParent();
                            if (navigablePath.getParent() != null) {
                                TableGroup parentTableGroup = this.findTableGroup(navigablePath.getParent());
                                PluralAttributeMapping pluralPart = (PluralAttributeMapping)parentTableGroup.getModelPart().findSubPart(navigablePath.getUnaliasedLocalName(), null);
                                return pluralPart.findSubPart(pathSource.getPathName(), null);
                            }
                            return this.findTableGroup(navigablePath).getModelPart();
                        }
                    }
                    SqmExpressable sqmExpressable = selectionNodeType;
                }
            }
            MappingModelExpressable expressable = domainModel.resolveMappingExpressable((SqmExpressable<?>)var7_10, this::findTableGroupByPath);
            if (expressable != null) {
                return expressable;
            }
            try {
                return this.inferrableTypeAccessStack.getCurrent().get();
            }
            catch (Exception ignore) {
                return null;
            }
        }
        log.debugf("Determining mapping-model type for generalized SqmExpression : %s", sqmExpression);
        SqmExpressable<?> nodeType = sqmExpression.getNodeType();
        if (nodeType == null) {
            return null;
        }
        MappingModelExpressable valueMapping = domainModel.resolveMappingExpressable(nodeType, this::findTableGroupByPath);
        if (valueMapping == null && (currentExpressableSupplier = this.inferrableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier.get();
        }
        if (valueMapping == null) {
            throw new ConversionException("Could not determine ValueMapping for SqmExpression: " + sqmExpression);
        }
        return valueMapping;
    }

    protected MappingModelExpressable<?> getInferredValueMapping() {
        MappingModelExpressable inferredMapping;
        Supplier<MappingModelExpressable> currentExpressableSupplier = this.inferrableTypeAccessStack.getCurrent();
        if (currentExpressableSupplier != null && (inferredMapping = currentExpressableSupplier.get()) != null) {
            if (inferredMapping instanceof PluralAttributeMapping) {
                return ((PluralAttributeMapping)inferredMapping).getElementDescriptor();
            }
            if (!(inferredMapping instanceof JavaObjectType)) {
                return inferredMapping;
            }
        }
        return null;
    }

    protected MappingModelExpressable<?> determineValueMapping(SqmParameter<?> sqmParameter) {
        MappingModelExpressable<?> inferredValueMapping;
        log.debugf("Determining mapping-model type for SqmParameter : %s", sqmParameter);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        if (sqmParameter.getAnticipatedType() == null && (inferredValueMapping = this.getInferredValueMapping()) != null) {
            return inferredValueMapping;
        }
        AllowableParameterType<Object> parameterSqmType = binding.getBindType();
        if (parameterSqmType == null && (parameterSqmType = queryParameter.getHibernateType()) == null) {
            parameterSqmType = sqmParameter.getAnticipatedType();
        }
        if (parameterSqmType == null) {
            return this.basicType(Object.class);
        }
        if (parameterSqmType instanceof MappingModelExpressable && parameterSqmType.getJavaType() == Object.class) {
            return (MappingModelExpressable)((Object)parameterSqmType);
        }
        if (parameterSqmType instanceof SqmPath) {
            SqmPath sqmPath = (SqmPath)((Object)parameterSqmType);
            NavigablePath navigablePath = sqmPath.getNavigablePath();
            if (navigablePath.getParent() != null) {
                TableGroup tableGroup = this.getFromClauseAccess().getTableGroup(navigablePath.getParent());
                return tableGroup.getModelPart().findSubPart(navigablePath.getLocalName(), null);
            }
            return this.getFromClauseAccess().getTableGroup(navigablePath).getModelPart();
        }
        if (parameterSqmType instanceof BasicValuedMapping) {
            return (BasicValuedMapping)((Object)parameterSqmType);
        }
        if (parameterSqmType instanceof CompositeSqmPathSource) {
            MappingModelExpressable<?> inferredValueMapping2 = this.getInferredValueMapping();
            if (inferredValueMapping2 != null) {
                return inferredValueMapping2;
            }
            throw new NotYetImplementedFor6Exception("Support for embedded-valued parameters not yet implemented");
        }
        if (parameterSqmType instanceof SqmPathSource || parameterSqmType instanceof BasicDomainType) {
            MappingModelExpressable<?> inferredValueMapping3 = this.getInferredValueMapping();
            if (inferredValueMapping3 != null) {
                return inferredValueMapping3;
            }
            return this.getTypeConfiguration().getBasicTypeForJavaType(parameterSqmType.getExpressableJavaTypeDescriptor().getJavaTypeClass());
        }
        throw new ConversionException("Could not determine ValueMapping for SqmParameter: " + sqmParameter);
    }

    private void resolveSqmParameter(SqmParameter expression, MappingModelExpressable valueMapping, BiConsumer<Integer, JdbcParameter> jdbcParameterConsumer) {
        this.sqmParameterMappingModelTypes.put(expression, valueMapping);
        MappingModelExpressable bindable = valueMapping instanceof EntityAssociationMapping ? ((EntityAssociationMapping)valueMapping).getKeyTargetMatchPart() : (valueMapping instanceof EntityMappingType ? ((EntityMappingType)valueMapping).getIdentifierMapping() : valueMapping);
        bindable.forEachJdbcType((index, jdbcMapping) -> jdbcParameterConsumer.accept(index, new JdbcParameterImpl((JdbcMapping)jdbcMapping)));
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter<?> expression) {
        return this.consumeSqmParameter(expression);
    }

    @Override
    public Object visitJpaCriteriaParameter(JpaCriteriaParameter<?> expression) {
        return this.consumeSqmParameter(this.getSqmParameter(expression));
    }

    private SqmParameter<?> getSqmParameter(SqmExpression<?> parameter) {
        if (parameter instanceof JpaCriteriaParameter) {
            return this.getSqmParameter((JpaCriteriaParameter)parameter);
        }
        if (parameter instanceof SqmParameter) {
            return (SqmParameter)parameter;
        }
        return null;
    }

    private SqmParameter<?> getSqmParameter(JpaCriteriaParameter<?> expression) {
        if (this.jpaCriteriaParamResolutions == null) {
            throw new IllegalStateException("No JpaCriteriaParameter resolutions registered");
        }
        SqmJpaCriteriaParameterWrapper<?> supplier = this.jpaCriteriaParamResolutions.get(expression);
        if (supplier == null) {
            throw new IllegalStateException("Criteria parameter [" + expression + "] not known to be a parameter of the processing tree");
        }
        return supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitTuple(SqmTuple<?> sqmTuple) {
        SqmExpressable expressable;
        int i;
        List<SqmExpression<?>> groupedExpressions = sqmTuple.getGroupedExpressions();
        int size = groupedExpressions.size();
        ArrayList<Expression> expressions = new ArrayList<Expression>(size);
        MappingModelExpressable mappingModelExpressable = this.inferrableTypeAccessStack.getCurrent().get();
        EmbeddableMappingType embeddableMappingType = mappingModelExpressable instanceof ValueMapping ? (EmbeddableMappingType)((ValueMapping)mappingModelExpressable).getMappedType() : null;
        if (embeddableMappingType == null) {
            try {
                this.inferrableTypeAccessStack.push(() -> null);
                for (i = 0; i < size; ++i) {
                    expressions.add((Expression)groupedExpressions.get(i).accept(this));
                }
            }
            finally {
                this.inferrableTypeAccessStack.pop();
            }
        } else {
            for (i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = embeddableMappingType.getAttributeMappings().get(i);
                this.inferrableTypeAccessStack.push(() -> attributeMapping);
                try {
                    expressions.add((Expression)groupedExpressions.get(i).accept(this));
                    continue;
                }
                finally {
                    this.inferrableTypeAccessStack.pop();
                }
            }
        }
        MappingModelExpressable valueMapping = mappingModelExpressable != null ? mappingModelExpressable : ((expressable = sqmTuple.getExpressable()) instanceof MappingModelExpressable ? (MappingModelExpressable)((Object)expressable) : null);
        return new SqlTuple(expressions, valueMapping);
    }

    @Override
    public Object visitCollate(SqmCollate<?> sqmCollate) {
        return new Collate((Expression)sqmCollate.getExpression().accept(this), sqmCollate.getCollation());
    }

    @Override
    public Expression visitFunction(SqmFunction<?> sqmFunction) {
        this.inferrableTypeAccessStack.push(() -> null);
        try {
            Expression expression = sqmFunction.convertToSqlAst(this);
            return expression;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    @Override
    public Star visitStar(SqmStar sqmStar) {
        return new Star();
    }

    @Override
    public Object visitDistinct(SqmDistinct<?> sqmDistinct) {
        return new Distinct((Expression)sqmDistinct.getExpression().accept(this));
    }

    @Override
    public Object visitTrimSpecification(SqmTrimSpecification specification) {
        return new TrimSpecification(specification.getSpecification());
    }

    @Override
    public Object visitCastTarget(SqmCastTarget<?> target) {
        BasicType<?> targetType = (BasicType<?>)target.getType();
        if (targetType instanceof BasicType) {
            targetType = InferredBasicValueResolver.resolveSqlTypeIndicators(this, targetType, target.getNodeJavaTypeDescriptor());
        }
        return new CastTarget(targetType.getJdbcMapping(), target.getLength(), target.getPrecision(), target.getScale());
    }

    @Override
    public Object visitExtractUnit(SqmExtractUnit<?> unit) {
        return new ExtractUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
    }

    @Override
    public Object visitDurationUnit(SqmDurationUnit<?> unit) {
        return new DurationUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
    }

    @Override
    public Object visitFormat(SqmFormat sqmFormat) {
        return new Format((String)sqmFormat.getLiteralValue(), (BasicValuedMapping)((Object)sqmFormat.getNodeType()));
    }

    @Override
    public Object visitUnaryOperationExpression(SqmUnaryOperation<?> expression) {
        return new UnaryOperation(this.interpret(expression.getOperation()), this.toSqlExpression(expression.getOperand().accept(this)), (BasicValuedMapping)this.determineValueMapping(expression.getOperand()));
    }

    private UnaryArithmeticOperator interpret(UnaryArithmeticOperator operator) {
        return operator;
    }

    @Override
    public Object visitBinaryArithmeticExpression(SqmBinaryArithmetic<?> expression) {
        boolean temporalTypeSomewhereToLeft;
        SqmExpression<?> leftOperand = expression.getLeftHandOperand();
        SqmExpression<?> rightOperand = expression.getRightHandOperand();
        boolean durationToRight = TypeConfiguration.isDuration(rightOperand.getNodeType());
        TypeConfiguration typeConfiguration = this.getCreationContext().getDomainModel().getTypeConfiguration();
        TemporalType temporalTypeToLeft = typeConfiguration.getSqlTemporalType(leftOperand.getNodeType());
        TemporalType temporalTypeToRight = typeConfiguration.getSqlTemporalType(rightOperand.getNodeType());
        boolean bl = temporalTypeSomewhereToLeft = this.adjustedTimestamp != null || temporalTypeToLeft != null;
        if (temporalTypeToLeft != null && durationToRight && (this.adjustmentScale != null || this.negativeAdjustment)) {
            throw new SemanticException("scalar multiplication of temporal value");
        }
        if (durationToRight && temporalTypeSomewhereToLeft) {
            return this.transformDurationArithmetic(expression);
        }
        if (temporalTypeToLeft != null && temporalTypeToRight != null) {
            return this.transformDatetimeArithmetic(expression);
        }
        if (durationToRight && this.appliedByUnit != null) {
            return new BinaryArithmeticExpression(this.toSqlExpression(leftOperand.accept(this)), expression.getOperator(), this.toSqlExpression(rightOperand.accept(this)), (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType()));
        }
        return new BinaryArithmeticExpression(this.toSqlExpression(leftOperand.accept(this)), expression.getOperator(), this.toSqlExpression(rightOperand.accept(this)), this.getExpressionType(expression));
    }

    private BasicValuedMapping getExpressionType(SqmBinaryArithmetic<?> expression) {
        SqmExpressable sqmExpressable = QueryHelper.highestPrecedenceType(expression.getLeftHandOperand().getNodeType(), expression.getRightHandOperand().getNodeType());
        if (sqmExpressable instanceof BasicValuedMapping) {
            return (BasicValuedMapping)((Object)sqmExpressable);
        }
        if (sqmExpressable != null) {
            return this.getTypeConfiguration().getBasicTypeForJavaType(sqmExpressable.getExpressableJavaTypeDescriptor().getJavaTypeClass());
        }
        return JavaObjectType.INSTANCE;
    }

    private Expression toSqlExpression(Object value) {
        return (Expression)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object transformDurationArithmetic(SqmBinaryArithmetic<?> expression) {
        operator = expression.getOperator();
        switch (4.$SwitchMap$org$hibernate$query$BinaryArithmeticOperator[operator.ordinal()]) {
            case 1: 
            case 2: {
                timestamp = this.adjustedTimestamp;
                timestampType = this.adjustedTimestampType;
                this.adjustedTimestamp = this.toSqlExpression(expression.getLeftHandOperand().accept(this));
                type = this.adjustedTimestamp.getExpressionType();
                this.adjustedTimestampType = type instanceof SqmExpressable != false ? (SqmExpressable<Object>)type : (type instanceof AttributeMapping != false ? (SqmExpressable<Object>)((AttributeMapping)type).getMappedType() : expression.getLeftHandOperand().getNodeType());
                if (operator == BinaryArithmeticOperator.SUBTRACT) {
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                try {
                    var6_6 = expression.getRightHandOperand().accept(this);
                    if (operator != BinaryArithmeticOperator.SUBTRACT) ** GOTO lbl21
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                catch (Throwable var7_8) {
                    if (operator == BinaryArithmeticOperator.SUBTRACT) {
                        this.negativeAdjustment = this.negativeAdjustment == false;
                    }
                    this.adjustedTimestamp = timestamp;
                    this.adjustedTimestampType = timestampType;
                    throw var7_8;
                }
lbl21:
                // 2 sources

                this.adjustedTimestamp = timestamp;
                this.adjustedTimestampType = timestampType;
                return var6_6;
            }
            case 3: {
                duration = this.toSqlExpression(expression.getLeftHandOperand().accept(this));
                scale = this.adjustmentScale;
                negate = this.negativeAdjustment;
                this.adjustmentScale = this.applyScale(duration);
                this.negativeAdjustment = false;
                try {
                    var9_11 = expression.getRightHandOperand().accept(this);
                    return var9_11;
                }
                finally {
                    this.adjustmentScale = scale;
                    this.negativeAdjustment = negate;
                }
            }
        }
        throw new SemanticException("illegal operator for a duration " + operator);
    }

    private Object transformDatetimeArithmetic(SqmBinaryArithmetic expression) {
        TemporalUnit baseUnit;
        BinaryArithmeticOperator operator = expression.getOperator();
        if (operator != BinaryArithmeticOperator.SUBTRACT) {
            throw new SemanticException("illegal operator for temporal type: " + operator);
        }
        Expression left = this.cleanly(() -> this.toSqlExpression(expression.getLeftHandOperand().accept(this)));
        Expression right = this.cleanly(() -> this.toSqlExpression(expression.getRightHandOperand().accept(this)));
        TypeConfiguration typeConfiguration = this.getCreationContext().getDomainModel().getTypeConfiguration();
        TemporalType leftTimestamp = typeConfiguration.getSqlTemporalType(expression.getLeftHandOperand().getNodeType());
        TemporalType rightTimestamp = typeConfiguration.getSqlTemporalType(expression.getRightHandOperand().getNodeType());
        TemporalUnit temporalUnit = baseUnit = rightTimestamp == TemporalType.TIMESTAMP || leftTimestamp == TemporalType.TIMESTAMP ? TemporalUnit.NATIVE : TemporalUnit.DAY;
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            DurationUnit unit = new DurationUnit(baseUnit, this.basicType(Integer.class));
            Expression magnitude = this.applyScale(this.timestampdiff().expression(null, unit, right, left));
            return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, unit, magnitude, this.adjustedTimestamp);
        }
        if (this.appliedByUnit != null) {
            DurationUnit unit = (DurationUnit)this.appliedByUnit.getUnit().accept((SemanticQueryWalker<?>)this);
            return this.applyScale(this.timestampdiff().expression(null, unit, right, left));
        }
        DurationUnit unit = new DurationUnit(baseUnit, this.basicType(Integer.class));
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)expression.getNodeType());
        Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
        return new Duration(scaledMagnitude, baseUnit, durationType);
    }

    private <J> BasicType<J> basicType(Class<J> javaType) {
        return this.creationContext.getDomainModel().getTypeConfiguration().getBasicTypeForJavaType(javaType);
    }

    private TimestampaddFunction timestampadd() {
        return (TimestampaddFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampadd");
    }

    private TimestampdiffFunction timestampdiff() {
        return (TimestampdiffFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampdiff");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T cleanly(Supplier<T> supplier) {
        SqmByUnit byUnit = this.appliedByUnit;
        Expression timestamp = this.adjustedTimestamp;
        SqmExpressable<?> timestampType = this.adjustedTimestampType;
        Expression scale = this.adjustmentScale;
        boolean negate = this.negativeAdjustment;
        this.adjustmentScale = null;
        this.negativeAdjustment = false;
        this.appliedByUnit = null;
        this.adjustedTimestamp = null;
        this.adjustedTimestampType = null;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.appliedByUnit = byUnit;
            this.adjustedTimestamp = timestamp;
            this.adjustedTimestampType = timestampType;
            this.adjustmentScale = scale;
            this.negativeAdjustment = negate;
        }
    }

    Expression applyScale(Expression magnitude) {
        boolean negate = this.negativeAdjustment;
        if (magnitude instanceof UnaryOperation) {
            UnaryOperation unary = (UnaryOperation)magnitude;
            if (unary.getOperator() == UnaryArithmeticOperator.UNARY_MINUS) {
                negate = !negate;
            }
            magnitude = unary.getOperand();
        }
        if (this.adjustmentScale != null && !BaseSqmToSqlAstConverter.isOne(this.adjustmentScale)) {
            if (BaseSqmToSqlAstConverter.isOne(magnitude)) {
                magnitude = this.adjustmentScale;
            } else {
                BasicValuedMapping magnitudeType = (BasicValuedMapping)magnitude.getExpressionType();
                BasicValuedMapping expressionType = magnitudeType.getJdbcMapping().getJdbcTypeDescriptor().isInterval() ? magnitudeType : this.widestNumeric((BasicValuedMapping)this.adjustmentScale.getExpressionType(), magnitudeType);
                magnitude = new BinaryArithmeticExpression(this.adjustmentScale, BinaryArithmeticOperator.MULTIPLY, magnitude, expressionType);
            }
        }
        if (negate) {
            magnitude = new UnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, magnitude, (BasicValuedMapping)magnitude.getExpressionType());
        }
        return magnitude;
    }

    static boolean isOne(Expression scale) {
        return scale instanceof QueryLiteral && ((Number)((QueryLiteral)scale).getLiteralValue()).longValue() == 1L;
    }

    @Override
    public Object visitToDuration(SqmToDuration<?> toDuration) {
        Expression magnitude = this.toSqlExpression(toDuration.getMagnitude().accept(this));
        DurationUnit unit = (DurationUnit)toDuration.getUnit().accept((SemanticQueryWalker<?>)this);
        Expression scaledMagnitude = this.applyScale(magnitude);
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)toDuration.getNodeType());
        Duration duration = scaledMagnitude.getExpressionType().getJdbcMappings().get(0).getJdbcTypeDescriptor().isInterval() ? new Duration(this.extractEpoch(scaledMagnitude), TemporalUnit.SECOND, durationType) : new Duration(scaledMagnitude, unit.getUnit(), durationType);
        if (this.appliedByUnit != null) {
            TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
            BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
            return new Conversion(duration, appliedUnit, scalarType);
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitByUnit(SqmByUnit byUnit) {
        SqmByUnit outer = this.appliedByUnit;
        this.appliedByUnit = byUnit;
        try {
            Object object = byUnit.getDuration().accept(this);
            return object;
        }
        finally {
            this.appliedByUnit = outer;
        }
    }

    private BasicValuedMapping widestNumeric(BasicValuedMapping lhs, BasicValuedMapping rhs) {
        CastType lhsCastType = lhs.getJdbcMapping().getJdbcTypeDescriptor().getCastType();
        CastType rhsCastType = rhs.getJdbcMapping().getJdbcTypeDescriptor().getCastType();
        if (lhsCastType == CastType.FIXED) {
            return lhs;
        }
        if (rhsCastType == CastType.FIXED) {
            return rhs;
        }
        if (lhsCastType == CastType.DOUBLE) {
            return lhs;
        }
        if (rhsCastType == CastType.DOUBLE) {
            return rhs;
        }
        if (lhsCastType == CastType.FLOAT) {
            return lhs;
        }
        if (rhsCastType == CastType.FLOAT) {
            return rhs;
        }
        return lhs;
    }

    @Override
    public Object visitModifiedSubQueryExpression(SqmModifiedSubQueryExpression<?> expr) {
        return new ModifiedSubQueryExpression((QueryPart)this.visitSubQueryExpression((SqmSubQuery)expr.getSubQuery()), this.convert(expr.getModifier()));
    }

    private ModifiedSubQueryExpression.Modifier convert(SqmModifiedSubQueryExpression.Modifier modifier) {
        if (modifier == SqmModifiedSubQueryExpression.Modifier.ALL) {
            return ModifiedSubQueryExpression.Modifier.ALL;
        }
        if (modifier == SqmModifiedSubQueryExpression.Modifier.ANY) {
            return ModifiedSubQueryExpression.Modifier.ANY;
        }
        if (modifier == SqmModifiedSubQueryExpression.Modifier.SOME) {
            return ModifiedSubQueryExpression.Modifier.SOME;
        }
        throw new IllegalStateException("Unrecognized SqmModifiedSubQueryExpression.Modifier : " + modifier);
    }

    @Override
    public QueryPart visitSubQueryExpression(SqmSubQuery<?> sqmSubQuery) {
        SqmJoin<?, ?> oldJoin = this.currentlyProcessingJoin;
        this.currentlyProcessingJoin = null;
        Object queryPart = this.visitQueryPart((SqmQueryPart)sqmSubQuery.getQueryPart());
        this.currentlyProcessingJoin = oldJoin;
        return queryPart;
    }

    @Override
    public CaseSimpleExpression visitSimpleCaseExpression(SqmCaseSimple<?, ?> expression) {
        ArrayList<CaseSimpleExpression.WhenFragment> whenFragments = new ArrayList<CaseSimpleExpression.WhenFragment>(expression.getWhenFragments().size());
        Supplier<MappingModelExpressable> inferenceSupplier = this.inferrableTypeAccessStack.getCurrent();
        this.inferrableTypeAccessStack.push(() -> {
            for (SqmCaseSimple.WhenFragment whenFragment : expression.getWhenFragments()) {
                MappingModelExpressable resolved = this.determineCurrentExpressable(whenFragment.getCheckValue());
                if (resolved == null) continue;
                return resolved;
            }
            return null;
        });
        Expression fixture = (Expression)expression.getFixture().accept(this);
        MappingModelExpressable fixtureType = (MappingModelExpressable)fixture.getExpressionType();
        this.inferrableTypeAccessStack.pop();
        MappingModelExpressable resolved = this.determineCurrentExpressable(expression);
        Expression otherwise = null;
        for (SqmCaseSimple.WhenFragment<?, ?> whenFragment : expression.getWhenFragments()) {
            this.inferrableTypeAccessStack.push(() -> fixtureType);
            Expression checkValue = (Expression)whenFragment.getCheckValue().accept(this);
            this.inferrableTypeAccessStack.pop();
            MappingModelExpressable alreadyKnown = resolved;
            this.inferrableTypeAccessStack.push(() -> alreadyKnown == null && inferenceSupplier != null ? (MappingModelExpressable)inferenceSupplier.get() : alreadyKnown);
            Expression resultExpression = (Expression)whenFragment.getResult().accept(this);
            this.inferrableTypeAccessStack.pop();
            resolved = (MappingModelExpressable)TypeHelper.highestPrecedence(resolved, resultExpression.getExpressionType());
            whenFragments.add(new CaseSimpleExpression.WhenFragment(checkValue, resultExpression));
        }
        if (expression.getOtherwise() != null) {
            MappingModelExpressable alreadyKnown = resolved;
            this.inferrableTypeAccessStack.push(() -> alreadyKnown == null && inferenceSupplier != null ? (MappingModelExpressable)inferenceSupplier.get() : alreadyKnown);
            otherwise = (Expression)expression.getOtherwise().accept(this);
            this.inferrableTypeAccessStack.pop();
            resolved = (MappingModelExpressable)TypeHelper.highestPrecedence(resolved, otherwise.getExpressionType());
        }
        return new CaseSimpleExpression(resolved, fixture, whenFragments, otherwise);
    }

    @Override
    public CaseSearchedExpression visitSearchedCaseExpression(SqmCaseSearched<?> expression) {
        ArrayList<CaseSearchedExpression.WhenFragment> whenFragments = new ArrayList<CaseSearchedExpression.WhenFragment>(expression.getWhenFragments().size());
        Supplier<MappingModelExpressable> inferenceSupplier = this.inferrableTypeAccessStack.getCurrent();
        MappingModelExpressable resolved = this.determineCurrentExpressable(expression);
        Expression otherwise = null;
        for (SqmCaseSearched.WhenFragment<?> whenFragment : expression.getWhenFragments()) {
            this.inferrableTypeAccessStack.push(() -> null);
            Predicate whenPredicate = (Predicate)whenFragment.getPredicate().accept(this);
            this.inferrableTypeAccessStack.pop();
            MappingModelExpressable alreadyKnown = resolved;
            this.inferrableTypeAccessStack.push(() -> alreadyKnown == null && inferenceSupplier != null ? (MappingModelExpressable)inferenceSupplier.get() : alreadyKnown);
            Expression resultExpression = (Expression)whenFragment.getResult().accept(this);
            this.inferrableTypeAccessStack.pop();
            resolved = (MappingModelExpressable)TypeHelper.highestPrecedence(resolved, resultExpression.getExpressionType());
            whenFragments.add(new CaseSearchedExpression.WhenFragment(whenPredicate, resultExpression));
        }
        if (expression.getOtherwise() != null) {
            MappingModelExpressable alreadyKnown = resolved;
            this.inferrableTypeAccessStack.push(() -> alreadyKnown == null && inferenceSupplier != null ? (MappingModelExpressable)inferenceSupplier.get() : alreadyKnown);
            otherwise = (Expression)expression.getOtherwise().accept(this);
            this.inferrableTypeAccessStack.pop();
            resolved = (MappingModelExpressable)TypeHelper.highestPrecedence(resolved, otherwise.getExpressionType());
        }
        return new CaseSearchedExpression(resolved, whenFragments, otherwise);
    }

    private MappingModelExpressable<?> determineCurrentExpressable(SqmTypedNode<?> expression) {
        return this.creationContext.getDomainModel().resolveMappingExpressable(expression.getNodeType(), this.getFromClauseIndex()::findTableGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> X visitWithInferredType(SqmExpression<?> expression, SqmExpression<?> inferred) {
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(inferred));
        try {
            Object object = expression.accept(this);
            return (X)object;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> X visitWithLenientInferredType(SqmExpression<?> expression, SqmExpression<?> inferred) {
        this.inferrableTypeAccessStack.push(() -> {
            MappingModelExpressable definedType = this.creationContext.getDomainModel().resolveMappingExpressable(expression.getNodeType(), this.getFromClauseIndex()::findTableGroup);
            if (definedType != null) {
                return definedType;
            }
            definedType = this.creationContext.getDomainModel().lenientlyResolveMappingExpressable(inferred.getNodeType(), this.getFromClauseIndex()::findTableGroup);
            if (definedType != null) {
                return definedType;
            }
            return null;
        });
        try {
            Object object = expression.accept(this);
            return (X)object;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    @Override
    public Object visitAny(SqmAny<?> sqmAny) {
        return new Any((QueryPart)this.visitSubQueryExpression((SqmSubQuery)sqmAny.getSubquery()), null);
    }

    @Override
    public Object visitEvery(SqmEvery<?> sqmEvery) {
        return new Every((QueryPart)this.visitSubQueryExpression((SqmSubQuery)sqmEvery.getSubquery()), null);
    }

    @Override
    public Object visitSummarization(SqmSummarization<?> sqmSummarization) {
        List<SqmExpression<?>> groupingExpressions = sqmSummarization.getGroupings();
        int size = groupingExpressions.size();
        ArrayList<Expression> expressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            expressions.add((Expression)groupingExpressions.get(i).accept(this));
        }
        return new Summarization(this.getSummarizationKind(sqmSummarization.getKind()), expressions);
    }

    private Summarization.Kind getSummarizationKind(SqmSummarization.Kind kind) {
        switch (kind) {
            case CUBE: {
                return Summarization.Kind.CUBE;
            }
            case ROLLUP: {
                return Summarization.Kind.ROLLUP;
            }
        }
        throw new UnsupportedOperationException("Unsupported summarization: " + kind);
    }

    @Override
    public Expression visitEntityTypeLiteralExpression(SqmLiteralEntityType<?> sqmExpression) {
        SqmExpressable nodeType = sqmExpression.getNodeType();
        EntityPersister mappingDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(nodeType.getHibernateEntityName());
        return new EntityTypeLiteral(mappingDescriptor);
    }

    @Override
    public Expression visitParameterizedEntityTypeExpression(SqmParameterizedEntityType<?> sqmExpression) {
        assert (this.inferrableTypeAccessStack.getCurrent().get() instanceof EntityDiscriminatorMapping);
        return (Expression)sqmExpression.getDiscriminatorSource().accept(this);
    }

    @Override
    public Object visitEnumLiteral(SqmEnumLiteral<?> sqmEnumLiteral) {
        BasicValuedMapping inferrableType = (BasicValuedMapping)this.inferrableTypeAccessStack.getCurrent().get();
        if (inferrableType instanceof ConvertibleModelPart) {
            ConvertibleModelPart inferredPart = (ConvertibleModelPart)inferrableType;
            BasicValueConverter valueConverter = inferredPart.getValueConverter();
            Object jdbcValue = valueConverter.toRelationalValue(sqmEnumLiteral.getEnumValue());
            return new QueryLiteral(jdbcValue, inferredPart);
        }
        return new QueryLiteral(sqmEnumLiteral.getEnumValue(), (BasicValuedMapping)this.determineValueMapping(sqmEnumLiteral));
    }

    @Override
    public Object visitFieldLiteral(SqmFieldLiteral<?> sqmFieldLiteral) {
        return new QueryLiteral(sqmFieldLiteral.getValue(), (BasicValuedMapping)this.determineValueMapping(sqmFieldLiteral));
    }

    @Override
    public GroupedPredicate visitGroupedPredicate(SqmGroupedPredicate predicate) {
        return new GroupedPredicate((Predicate)predicate.getSubPredicate().accept(this));
    }

    @Override
    public Junction visitAndPredicate(SqmAndPredicate predicate) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION, this.getBooleanType());
        conjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        conjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return conjunction;
    }

    @Override
    public Junction visitOrPredicate(SqmOrPredicate predicate) {
        Junction disjunction = new Junction(Junction.Nature.DISJUNCTION, this.getBooleanType());
        disjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        disjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return disjunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
        Expression lhs;
        SqmPath<?> pluralPath = predicate.getPluralPath();
        this.prepareReusablePath(pluralPath, () -> null);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.determineValueMapping(pluralPath);
        if (pluralAttributeMapping.getElementDescriptor() instanceof EntityCollectionPart) {
            this.inferrableTypeAccessStack.push(() -> ((EntityCollectionPart)pluralAttributeMapping.getElementDescriptor()).getKeyTargetMatchPart());
        } else if (pluralAttributeMapping.getElementDescriptor() instanceof EmbeddedCollectionPart) {
            this.inferrableTypeAccessStack.push(() -> pluralAttributeMapping.getElementDescriptor());
        } else {
            this.inferrableTypeAccessStack.push(() -> pluralAttributeMapping);
        }
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent));
        try {
            TableGroup tableGroup = pluralAttributeMapping.createRootTableGroup(true, pluralPath.getNavigablePath(), null, () -> subQuerySpec::applyPredicate, this, this.creationContext);
            pluralAttributeMapping.applyBaseRestrictions(subQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
            this.getFromClauseAccess().registerTableGroup(pluralPath.getNavigablePath(), tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            CollectionPart elementDescriptor = pluralAttributeMapping.getElementDescriptor();
            if (elementDescriptor instanceof EntityCollectionPart) {
                ((EntityCollectionPart)elementDescriptor).getKeyTargetMatchPart().createDomainResult(pluralPath.getNavigablePath(), tableGroup, null, this);
            } else {
                elementDescriptor.createDomainResult(pluralPath.getNavigablePath(), tableGroup, null, this);
            }
            subQuerySpec.applyPredicate(pluralAttributeMapping.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(pluralPath.getNavigablePath().getParent()), tableGroup, SqlAstJoinType.INNER, this.getSqlExpressionResolver(), this.creationContext));
        }
        finally {
            this.popProcessingStateStack();
        }
        return new InSubQueryPredicate(lhs, subQuerySpec, predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public NegatedPredicate visitNegatedPredicate(SqmNegatedPredicate predicate) {
        return new NegatedPredicate((Predicate)predicate.getWrappedPredicate().accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
        Expression rhs;
        Expression lhs;
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getRightHandExpression()));
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getLeftHandExpression()));
        try {
            rhs = (Expression)predicate.getRightHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        ComparisonOperator sqmOperator = predicate.getSqmOperator();
        if (predicate.isNegated()) {
            sqmOperator = sqmOperator.negated();
        }
        return new ComparisonPredicate(lhs, sqmOperator, rhs, this.getBooleanType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
        this.prepareReusablePath(predicate.getPluralPath(), () -> null);
        QuerySpec subQuerySpec = new QuerySpec(false, 1);
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        SqlAstProcessingStateImpl subQueryState = new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent);
        this.pushProcessingState(subQueryState);
        try {
            SqmPluralValuedSimplePath<?> sqmPluralPath = predicate.getPluralPath();
            NavigablePath pluralPathNavPath = sqmPluralPath.getNavigablePath();
            NavigablePath parentNavPath = pluralPathNavPath.getParent();
            assert (parentNavPath != null);
            TableGroup parentTableGroup = parentFromClauseAccess.getTableGroup(parentNavPath);
            SqlAliasBase sqlAliasBase = this.sqlAliasBaseManager.createSqlAliasBase(parentTableGroup.getGroupAlias());
            CorrelatedTableGroup tableGroup = new CorrelatedTableGroup(parentTableGroup, sqlAliasBase, subQuerySpec, subQuerySpec::applyPredicate, this.creationContext.getSessionFactory());
            subQueryState.getSqlAstCreationState().getFromClauseAccess().registerTableGroup(parentNavPath, tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.visitPluralValuedPath((SqmPluralValuedSimplePath)sqmPluralPath).getExpressionType();
            tableGroup.addTableGroupJoin(pluralAttributeMapping.createTableGroupJoin(pluralPathNavPath, tableGroup, sqmPluralPath.getExplicitAlias(), SqlAstJoinType.INNER, false, false, this.sqlAliasBaseManager, subQueryState, this, this.creationContext));
            ForeignKeyDescriptor collectionKeyDescriptor = pluralAttributeMapping.getKeyDescriptor();
            int jdbcTypeCount = collectionKeyDescriptor.getJdbcTypeCount();
            assert (jdbcTypeCount > 0);
            JdbcLiteral<Integer> jdbcLiteral = new JdbcLiteral<Integer>(1, this.basicType(Integer.class));
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, jdbcLiteral));
            ExistsPredicate existsPredicate = new ExistsPredicate(subQuerySpec, !predicate.isNegated(), this.getBooleanType());
            return existsPredicate;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BetweenPredicate visitBetweenPredicate(SqmBetweenPredicate predicate) {
        Expression upperBound;
        Expression lowerBound;
        Expression expression;
        this.inferrableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getLowerBound()), () -> this.determineValueMapping(predicate.getUpperBound())));
        try {
            expression = (Expression)predicate.getExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getExpression()), () -> this.determineValueMapping(predicate.getUpperBound())));
        try {
            lowerBound = (Expression)predicate.getLowerBound().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getExpression()), () -> this.determineValueMapping(predicate.getLowerBound())));
        try {
            upperBound = (Expression)predicate.getUpperBound().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return new BetweenPredicate(expression, lowerBound, upperBound, predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public LikePredicate visitLikePredicate(SqmLikePredicate predicate) {
        Expression escapeExpression = predicate.getEscapeCharacter() == null ? null : (Expression)predicate.getEscapeCharacter().accept(this);
        return new LikePredicate((Expression)predicate.getMatchExpression().accept(this), (Expression)predicate.getPattern().accept(this), escapeExpression, predicate.isNegated(), predicate.isCaseSensitive(), this.getBooleanType());
    }

    @Override
    public NullnessPredicate visitIsNullPredicate(SqmNullnessPredicate predicate) {
        return new NullnessPredicate((Expression)predicate.getExpression().accept(this), predicate.isNegated(), this.getBooleanType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate visitInListPredicate(SqmInListPredicate<?> predicate) {
        Predicate specialCase;
        SqmParameter sqmParameter;
        SqmExpression<?> sqmExpression;
        if (predicate.getListExpressions().size() == 1 && (sqmExpression = predicate.getListExpressions().get(0)) instanceof SqmParameter && (sqmParameter = (SqmParameter)sqmExpression).allowMultiValuedBinding() && (specialCase = this.processInListWithSingleParameter(predicate, sqmParameter)) != null) {
            return specialCase;
        }
        InListPredicate inPredicate = new InListPredicate((Expression)predicate.getTestExpression().accept(this), predicate.isNegated(), this.getBooleanType());
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getTestExpression()));
        try {
            for (SqmExpression<?> expression : predicate.getListExpressions()) {
                inPredicate.addExpression((Expression)expression.accept(this));
            }
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return inPredicate;
    }

    private Predicate processInListWithSingleParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter<?> sqmParameter) {
        assert (sqmParameter.allowMultiValuedBinding());
        if (sqmParameter instanceof JpaCriteriaParameter) {
            return this.processInSingleCriteriaParameter(sqmPredicate, (JpaCriteriaParameter)sqmParameter);
        }
        return this.processInSingleHqlParameter(sqmPredicate, sqmParameter);
    }

    private Predicate processInSingleHqlParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter<?> sqmParameter) {
        QueryParameterImplementor<?> domainParam = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(domainParam);
        if (!domainParamBinding.isMultiValued()) {
            return null;
        }
        return this.processInSingleParameter(sqmPredicate, sqmParameter, domainParam, domainParamBinding);
    }

    private Predicate processInSingleCriteriaParameter(SqmInListPredicate<?> sqmPredicate, JpaCriteriaParameter<?> jpaCriteriaParameter) {
        assert (jpaCriteriaParameter.allowsMultiValuedBinding());
        QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(jpaCriteriaParameter);
        if (!domainParamBinding.isMultiValued()) {
            return null;
        }
        SqmJpaCriteriaParameterWrapper<?> sqmWrapper = this.jpaCriteriaParamResolutions.get(jpaCriteriaParameter);
        return this.processInSingleParameter(sqmPredicate, sqmWrapper, jpaCriteriaParameter, domainParamBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Predicate processInSingleParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter<?> sqmParameter, QueryParameterImplementor<?> domainParam, QueryParameterBinding<?> domainParamBinding) {
        Iterator<?> iterator = domainParamBinding.getBindValues().iterator();
        InListPredicate inListPredicate = new InListPredicate((Expression)sqmPredicate.getTestExpression().accept(this), sqmPredicate.isNegated(), this.getBooleanType());
        if (!iterator.hasNext()) {
            return inListPredicate;
        }
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(sqmPredicate.getTestExpression()));
        try {
            inListPredicate.addExpression(this.consumeSingleSqmParameter(sqmParameter));
            iterator.next();
            while (iterator.hasNext()) {
                iterator.next();
                SqmParameter sqmParamToConsume = sqmParameter.copy();
                this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
                inListPredicate.addExpression(this.consumeSingleSqmParameter(sqmParamToConsume));
            }
            InListPredicate inListPredicate2 = inListPredicate;
            return inListPredicate2;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    @Override
    public InSubQueryPredicate visitInSubQueryPredicate(SqmInSubQueryPredicate predicate) {
        return new InSubQueryPredicate((Expression)this.visitWithInferredType(predicate.getTestExpression(), predicate.getSubQueryExpression()), (QueryPart)this.visitWithInferredType(predicate.getSubQueryExpression(), predicate.getTestExpression()), predicate.isNegated(), this.getBooleanType());
    }

    private JdbcMappingContainer getBooleanType() {
        return this.getTypeConfiguration().getBasicTypeForJavaType(Boolean.class);
    }

    @Override
    public Object visitBooleanExpressionPredicate(SqmBooleanExpressionPredicate predicate) {
        Expression booleanExpression = (Expression)predicate.getBooleanExpression().accept(this);
        if (booleanExpression instanceof SelfRenderingExpression) {
            SelfRenderingPredicate sqlPredicate = new SelfRenderingPredicate((SelfRenderingExpression)booleanExpression);
            if (predicate.isNegated()) {
                return new NegatedPredicate(sqlPredicate);
            }
            return sqlPredicate;
        }
        return new BooleanExpressionPredicate(booleanExpression, predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public Object visitExistsPredicate(SqmExistsPredicate predicate) {
        return new ExistsPredicate((QueryPart)predicate.getExpression().accept(this), predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public Object visitFullyQualifiedClass(Class<?> namedClass) {
        throw new NotYetImplementedFor6Exception();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFetch(List<Fetch> fetches, FetchParent fetchParent, Fetchable fetchable, Boolean isKeyFetchable) {
        String alias;
        NavigablePath fetchablePath;
        NavigablePath resolvedNavigablePath = fetchParent.resolveNavigablePath(fetchable);
        FetchTiming fetchTiming = fetchable.getMappedFetchOptions().getTiming();
        boolean joined = false;
        EntityGraphTraversalState.TraversalResult traversalResult = null;
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        SqmAttributeJoin fetchedJoin = fromClauseIndex.findFetchedJoinByPath(resolvedNavigablePath);
        boolean explicitFetch = false;
        if (fetchedJoin != null) {
            fetchablePath = fetchedJoin.getNavigablePath();
            assert (fromClauseIndex.getTableGroup(fetchedJoin.getNavigablePath()) != null);
            if (fetchedJoin.isFetched()) {
                fetchTiming = FetchTiming.IMMEDIATE;
            }
            joined = true;
            alias = fetchedJoin.getExplicitAlias();
            explicitFetch = true;
        } else {
            Integer maxDepth;
            TableGroup existingJoinedGroup;
            fetchablePath = resolvedNavigablePath;
            alias = null;
            if (!(fetchable instanceof CollectionPart)) {
                if (this.entityGraphTraversalState != null) {
                    traversalResult = this.entityGraphTraversalState.traverse(fetchParent, fetchable, isKeyFetchable);
                    fetchTiming = traversalResult.getFetchTiming();
                    joined = traversalResult.isJoined();
                    explicitFetch = true;
                } else if (this.getLoadQueryInfluencers().hasEnabledFetchProfiles() && (fetchTiming != FetchTiming.IMMEDIATE || fetchable.incrementFetchDepth())) {
                    String fetchableRole = fetchable.getNavigableRole().getFullPath();
                    for (String enabledFetchProfileName : this.getLoadQueryInfluencers().getEnabledFetchProfileNames()) {
                        CollectionClassification collectionClassification;
                        FetchProfile enabledFetchProfile = this.getCreationContext().getSessionFactory().getFetchProfile(enabledFetchProfileName);
                        org.hibernate.engine.profile.Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                        if (profileFetch == null) continue;
                        fetchTiming = FetchTiming.IMMEDIATE;
                        joined = joined || profileFetch.getStyle() == Fetch.Style.JOIN;
                        explicitFetch = true;
                        if (this.currentBagRole == null || !(fetchable instanceof PluralAttributeMapping) || (collectionClassification = ((PluralAttributeMapping)fetchable).getMappedType().getCollectionSemantics().getCollectionClassification()) != CollectionClassification.BAG) continue;
                        joined = false;
                    }
                }
            }
            if ((existingJoinedGroup = fromClauseIndex.findTableGroup(fetchablePath)) != null) {
                // empty if block
            }
            if ((maxDepth = this.getCreationContext().getMaximumFetchDepth()) != null && this.fetchDepth >= maxDepth) {
                joined = false;
            }
            if (joined && fetchable instanceof TableGroupJoinProducer) {
                TableGroupJoinProducer tableGroupJoinProducer = (TableGroupJoinProducer)((Object)fetchable);
                fromClauseIndex.resolveTableGroup(fetchablePath, np -> {
                    TableGroup lhs = fromClauseIndex.getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)fetchable)).createTableGroupJoin(fetchablePath, lhs, alias, tableGroupJoinProducer.getDefaultSqlAstJoinType(lhs), true, false, this);
                    lhs.addTableGroupJoin(tableGroupJoin);
                    return tableGroupJoin.getJoinedGroup();
                });
            }
        }
        boolean incrementFetchDepth = fetchable.incrementFetchDepth();
        try {
            Fetch biDirectionalFetch;
            if (incrementFetchDepth) {
                ++this.fetchDepth;
            }
            if (!explicitFetch && !this.isResolvingCircularFetch() && (biDirectionalFetch = fetchable.resolveCircularFetch(fetchablePath, fetchParent, fetchTiming, this)) != null) {
                fetches.add(biDirectionalFetch);
                return;
            }
            Fetch fetch = this.buildFetch(fetchablePath, fetchParent, fetchable, fetchTiming, joined, alias);
            if (fetch != null) {
                PluralAttributeMapping pluralAttributeMapping;
                CollectionClassification collectionClassification;
                if (fetch.getTiming() == FetchTiming.IMMEDIATE && fetchable instanceof PluralAttributeMapping && (collectionClassification = (pluralAttributeMapping = (PluralAttributeMapping)fetchable).getMappedType().getCollectionSemantics().getCollectionClassification()) == CollectionClassification.BAG) {
                    if (this.currentBagRole != null) {
                        throw new MultipleBagFetchException(Arrays.asList(this.currentBagRole, fetchable.getNavigableRole().getNavigableName()));
                    }
                    this.currentBagRole = fetchable.getNavigableRole().getNavigableName();
                }
                fetches.add(fetch);
            }
        }
        finally {
            if (incrementFetchDepth) {
                --this.fetchDepth;
            }
            if (this.entityGraphTraversalState != null && traversalResult != null) {
                this.entityGraphTraversalState.backtrack(traversalResult.getPreviousContext());
            }
        }
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        ArrayList<Fetch> fetches = CollectionHelper.arrayList(fetchParent.getReferencedMappingType().getNumberOfFetchables());
        fetchParent.getReferencedMappingContainer().visitKeyFetchables(fetchable -> this.addFetch((List<Fetch>)fetches, fetchParent, (Fetchable)fetchable, true), null);
        fetchParent.getReferencedMappingContainer().visitFetchables(fetchable -> this.addFetch((List<Fetch>)fetches, fetchParent, (Fetchable)fetchable, false), null);
        return fetches;
    }

    private Fetch buildFetch(NavigablePath fetchablePath, FetchParent fetchParent, Fetchable fetchable, FetchTiming fetchTiming, boolean joined, String alias) {
        try {
            Fetch fetch = fetchParent.generateFetchableFetch(fetchable, fetchablePath, fetchTiming, joined, alias, this);
            if (fetchable instanceof PluralAttributeMapping && fetch.getTiming() == FetchTiming.IMMEDIATE && joined) {
                TableGroup tableGroup = this.getFromClauseIndex().getTableGroup(fetchablePath);
                PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                Joinable joinable = pluralAttributeMapping.getCollectionDescriptor().getCollectionType().getAssociatedJoinable(this.getCreationContext().getSessionFactory());
                if (joinable instanceof Restrictable) {
                    joinable.applyBaseRestrictions(predicate -> this.addCollectionFilterPredicate(tableGroup.getGroupAlias(), (Predicate)predicate), tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
                }
                pluralAttributeMapping.applyBaseManyToManyRestrictions(predicate -> {
                    TableGroup parentTableGroup = this.getFromClauseIndex().getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin pluralTableGroupJoin = null;
                    for (TableGroupJoin nestedTableGroupJoin : parentTableGroup.getTableGroupJoins()) {
                        if (nestedTableGroupJoin.getNavigablePath() != fetchablePath) continue;
                        pluralTableGroupJoin = nestedTableGroupJoin;
                        break;
                    }
                    assert (pluralTableGroupJoin != null);
                    pluralTableGroupJoin.applyPredicate((Predicate)predicate);
                }, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
                if (this.currentQuerySpec().isRoot()) {
                    assert (tableGroup.getModelPart() == pluralAttributeMapping);
                    this.applyOrdering(tableGroup, pluralAttributeMapping);
                }
            }
            return fetch;
        }
        catch (RuntimeException e) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not generate fetch : %s -> %s", fetchParent.getNavigablePath(), fetchable.getFetchableName()), e);
        }
    }

    private void addCollectionFilterPredicate(String groupAlias, Predicate predicate) {
        PredicateCollector existing = this.collectionFilterPredicates.get(groupAlias);
        if (existing != null) {
            existing.applyPredicate(predicate);
        } else {
            this.collectionFilterPredicates.put(groupAlias, new PredicateCollector(predicate));
        }
    }

    private void applyOrdering(TableGroup tableGroup, PluralAttributeMapping pluralAttributeMapping) {
        if (pluralAttributeMapping.getOrderByFragment() != null) {
            this.applyOrdering(tableGroup, pluralAttributeMapping.getOrderByFragment());
        }
        if (pluralAttributeMapping.getManyToManyOrderByFragment() != null) {
            this.applyOrdering(tableGroup, pluralAttributeMapping.getManyToManyOrderByFragment());
        }
    }

    private void applyOrdering(TableGroup tableGroup, OrderByFragment orderByFragment) {
        if (this.orderByFragments == null) {
            this.orderByFragments = new ArrayList<Map.Entry<OrderByFragment, TableGroup>>();
        }
        this.orderByFragments.add(new AbstractMap.SimpleEntry<OrderByFragment, TableGroup>(orderByFragment, tableGroup));
    }

    @Override
    public boolean isResolvingCircularFetch() {
        return this.resolvingCircularFetch;
    }

    @Override
    public void setResolvingCircularFetch(boolean resolvingCircularFetch) {
        this.resolvingCircularFetch = resolvingCircularFetch;
    }

    @Override
    public ForeignKeyDescriptor.Nature getCurrentlyResolvingForeignKeyPart() {
        return this.currentlyResolvingForeignKeySide;
    }

    @Override
    public void setCurrentlyResolvingForeignKeyPart(ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide) {
        this.currentlyResolvingForeignKeySide = currentlyResolvingForeignKeySide;
    }

    @Override
    public List<Expression> expandSelfRenderingFunctionMultiValueParameter(SqmParameter sqmParameter) {
        assert (sqmParameter.allowMultiValuedBinding());
        QueryParameterImplementor<?> domainParam = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(domainParam);
        Collection<?> bindValues = domainParamBinding.getBindValues();
        int bindValuesSize = bindValues.size();
        ArrayList<Expression> result = new ArrayList<Expression>(bindValuesSize);
        boolean first = true;
        for (int i = 0; i < bindValuesSize; ++i) {
            SqmParameter sqmParamToConsume;
            if (first) {
                sqmParamToConsume = sqmParameter;
                first = false;
            } else {
                sqmParamToConsume = sqmParameter.copy();
                this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
            }
            Expression expression = this.consumeSingleSqmParameter(sqmParamToConsume);
            result.add(expression);
        }
        return result;
    }

    protected static class SqmAliasedNodePositionTracker
    implements SqlExpressionResolver,
    SqmAliasedNodeCollector {
        private final SqlExpressionResolver delegate;
        private final List<SqlSelection>[] sqlSelectionsForSqmSelection;
        private int index = -1;

        public SqmAliasedNodePositionTracker(SqlExpressionResolver delegate, List<? extends SqmAliasedNode<?>> selections) {
            this.delegate = delegate;
            this.sqlSelectionsForSqmSelection = new List[SqmAliasedNodePositionTracker.countIndividualSelections(selections)];
        }

        private static int countIndividualSelections(List<? extends SqmAliasedNode<?>> selections) {
            int offset = 0;
            for (int i = 0; i < selections.size(); ++i) {
                SqmSelectableNode<?> selectableNode = selections.get(i).getSelectableNode();
                if (selectableNode instanceof SqmDynamicInstantiation) {
                    offset = SqmAliasedNodePositionTracker.countIndividualSelections(((SqmDynamicInstantiation)selectableNode).getArguments()) - 1;
                    continue;
                }
                if (!(selectableNode instanceof SqmJpaCompoundSelection)) continue;
                offset += ((SqmJpaCompoundSelection)selectableNode).getSelectionItems().size() - 1;
            }
            return offset + selections.size();
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public List<SqlSelection> getSelections(int position) {
            return this.sqlSelectionsForSqmSelection[position];
        }

        @Override
        public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
            return this.delegate.resolveSqlExpression(key, creator);
        }

        @Override
        public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            SqlSelection selection = this.delegate.resolveSqlSelection(expression, javaTypeDescriptor, typeConfiguration);
            List<SqlSelection> sqlSelectionList = this.sqlSelectionsForSqmSelection[this.index];
            if (sqlSelectionList == null) {
                this.sqlSelectionsForSqmSelection[this.index] = sqlSelectionList = new ArrayList<SqlSelection>();
            }
            sqlSelectionList.add(selection);
            return selection;
        }
    }

    protected static class DelegatingSqmAliasedNodeCollector
    implements SqlExpressionResolver,
    SqmAliasedNodeCollector {
        private final SqlExpressionResolver delegate;
        private SqmAliasedNodeCollector sqmAliasedNodeCollector;

        public DelegatingSqmAliasedNodeCollector(SqlExpressionResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        public void next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SqlSelection> getSelections(int position) {
            return this.sqmAliasedNodeCollector.getSelections(position);
        }

        @Override
        public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
            return this.delegate.resolveSqlExpression(key, creator);
        }

        @Override
        public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return this.delegate.resolveSqlSelection(expression, javaTypeDescriptor, typeConfiguration);
        }

        public SqmAliasedNodeCollector getSqmAliasedNodeCollector() {
            return this.sqmAliasedNodeCollector;
        }

        public void setSqmAliasedNodeCollector(SqmAliasedNodeCollector sqmAliasedNodeCollector) {
            this.sqmAliasedNodeCollector = sqmAliasedNodeCollector;
        }
    }

    @Internal
    public static interface SqmAliasedNodeCollector {
        public void next();

        public List<SqlSelection> getSelections(int var1);
    }

    private static class IdGeneratorParameter
    extends JdbcParameterImpl {
        private final IdentifierGenerator generator;

        public IdGeneratorParameter(BasicEntityIdentifierMapping identifierMapping, IdentifierGenerator generator) {
            super(identifierMapping.getJdbcMapping());
            this.generator = generator;
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
            this.getJdbcMapping().getJdbcValueBinder().bind(statement, this.generator.generate(executionContext.getSession(), null), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    public static class AdditionalInsertValues {
        private final Expression versionExpression;
        private final Expression discriminatorExpression;
        private final IdentifierGenerator identifierGenerator;
        private final BasicEntityIdentifierMapping identifierMapping;
        private Expression identifierGeneratorParameter;
        private SqlSelection versionSelection;
        private SqlSelection discriminatorSelection;
        private SqlSelection identifierSelection;

        public AdditionalInsertValues(Expression versionExpression, Expression discriminatorExpression, IdentifierGenerator identifierGenerator, BasicEntityIdentifierMapping identifierMapping) {
            this.versionExpression = versionExpression;
            this.discriminatorExpression = discriminatorExpression;
            this.identifierGenerator = identifierGenerator;
            this.identifierMapping = identifierMapping;
        }

        public void applyValues(Values values) {
            List<Expression> expressions = values.getExpressions();
            if (this.versionExpression != null) {
                expressions.add(this.versionExpression);
            }
            if (this.discriminatorExpression != null) {
                expressions.add(this.discriminatorExpression);
            }
            if (this.identifierGenerator != null) {
                if (this.identifierGeneratorParameter == null) {
                    this.identifierGeneratorParameter = new IdGeneratorParameter(this.identifierMapping, this.identifierGenerator);
                }
                expressions.add(this.identifierGeneratorParameter);
            }
        }

        public boolean applySelections(QuerySpec querySpec, SessionFactoryImplementor sessionFactory) {
            SelectClause selectClause = querySpec.getSelectClause();
            if (this.versionExpression != null) {
                if (this.versionSelection == null) {
                    this.versionSelection = new SqlSelectionImpl(1, 0, this.versionExpression);
                }
                selectClause.addSqlSelection(this.versionSelection);
            }
            if (this.discriminatorExpression != null) {
                if (this.discriminatorSelection == null) {
                    this.discriminatorSelection = new SqlSelectionImpl(1, 0, this.discriminatorExpression);
                }
                selectClause.addSqlSelection(this.discriminatorSelection);
            }
            if (this.identifierGenerator != null) {
                if (this.identifierSelection == null) {
                    Optimizer optimizer;
                    if (!(this.identifierGenerator instanceof BulkInsertionCapableIdentifierGenerator) || !((BulkInsertionCapableIdentifierGenerator)this.identifierGenerator).supportsBulkInsertionIdentifierGeneration()) {
                        throw new SemanticException("SQM INSERT-SELECT without bulk insertion capable identifier generator: " + this.identifierGenerator);
                    }
                    if (this.identifierGenerator instanceof OptimizableGenerator && (optimizer = ((OptimizableGenerator)this.identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1) {
                        BasicType<Integer> rowNumberType = sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
                        this.identifierSelection = new SqlSelectionImpl(1, 0, new Over(new SelfRenderingFunctionSqlAstExpression("row_number", (appender, args, walker) -> appender.appendSql("row_number()"), Collections.emptyList(), rowNumberType, rowNumberType), Collections.emptyList(), Collections.emptyList()));
                        selectClause.addSqlSelection(this.identifierSelection);
                        return true;
                    }
                    String fragment = ((BulkInsertionCapableIdentifierGenerator)this.identifierGenerator).determineBulkInsertionIdentifierGenerationSelectFragment(sessionFactory.getSqlStringGenerationContext());
                    this.identifierSelection = new SqlSelectionImpl(1, 0, new SelfRenderingSqlFragmentExpression(fragment));
                }
                selectClause.addSqlSelection(this.identifierSelection);
            }
            return this.requiresRowNumberIntermediate();
        }

        public boolean requiresRowNumberIntermediate() {
            return this.identifierSelection != null && !(this.identifierSelection.getExpression() instanceof SelfRenderingSqlFragmentExpression);
        }
    }
}

