/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class EntityValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements SqlTupleContainer,
Assignable {
    private final Expression sqlExpression;

    public static <T> EntityValuedPathInterpretation<T> from(SqmEntityValuedSimplePath<T> sqmPath, SqmToSqlAstConverter sqlAstCreationState) {
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        EntityValuedModelPart mapping = (EntityValuedModelPart)sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath()).getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, mapping, false, sqlAstCreationState);
    }

    public static <T> EntityValuedPathInterpretation<T> from(NavigablePath navigablePath, TableGroup tableGroup, EntityValuedModelPart mapping, boolean expandToAllColumns, SqmToSqlAstConverter sqlAstCreationState) {
        Expression sqlExpression;
        SqlExpressionResolver sqlExprResolver = sqlAstCreationState.getSqlExpressionResolver();
        SessionFactoryImplementor sessionFactory = sqlAstCreationState.getCreationContext().getSessionFactory();
        if (expandToAllColumns) {
            EntityMappingType entityMappingType = mapping.getEntityMappingType();
            EntityIdentifierMapping identifierMapping = entityMappingType.getIdentifierMapping();
            EntityDiscriminatorMapping discriminatorMapping = entityMappingType.getDiscriminatorMapping();
            ArrayList expressions = new ArrayList(entityMappingType.getJdbcTypeCount() + identifierMapping.getJdbcTypeCount() + (discriminatorMapping == null ? 0 : 1));
            TableGroup parentTableGroup = tableGroup;
            SelectableConsumer selectableConsumer = (selectionIndex, selectableMapping) -> {
                TableReference tableReference = parentTableGroup.resolveTableReference(navigablePath, selectableMapping.getContainingTableExpression(), false);
                expressions.add(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, sessionFactory)));
            };
            identifierMapping.forEachSelectable(selectableConsumer);
            if (discriminatorMapping != null) {
                discriminatorMapping.forEachSelectable(selectableConsumer);
            }
            entityMappingType.forEachSelectable(selectableConsumer);
            sqlExpression = new SqlTuple(expressions, entityMappingType);
        } else if (mapping instanceof EntityAssociationMapping) {
            EntityAssociationMapping associationMapping = (EntityAssociationMapping)((Object)mapping);
            ModelPart keyTargetMatchPart = associationMapping.getKeyTargetMatchPart();
            ModelPart lhsPart = keyTargetMatchPart instanceof ToOneAttributeMapping ? ((ToOneAttributeMapping)keyTargetMatchPart).getKeyTargetMatchPart() : keyTargetMatchPart;
            if (lhsPart instanceof BasicValuedModelPart) {
                BasicValuedModelPart basicValuedModelPart = (BasicValuedModelPart)lhsPart;
                TableReference tableReference = tableGroup.resolveTableReference(navigablePath, basicValuedModelPart.getContainingTableExpression());
                sqlExpression = sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, basicValuedModelPart.getSelectionExpression()), processingState -> new ColumnReference(tableReference, (SelectableMapping)basicValuedModelPart, sessionFactory));
            } else {
                ArrayList expressions = new ArrayList(lhsPart.getJdbcTypeCount());
                lhsPart.forEachSelectable((selectionIndex, selectableMapping) -> {
                    TableReference tableReference = tableGroup.resolveTableReference(navigablePath, selectableMapping.getContainingTableExpression());
                    expressions.add(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, sessionFactory)));
                });
                sqlExpression = new SqlTuple(expressions, lhsPart);
            }
        } else {
            assert (mapping instanceof EntityMappingType);
            TableGroup parentTableGroup = tableGroup;
            EntityMappingType entityMappingType = (EntityMappingType)mapping;
            EntityIdentifierMapping identifierMapping = entityMappingType.getIdentifierMapping();
            if (identifierMapping instanceof BasicEntityIdentifierMapping) {
                BasicEntityIdentifierMapping simpleIdMapping = (BasicEntityIdentifierMapping)identifierMapping;
                TableReference tableReference = parentTableGroup.resolveTableReference(navigablePath, simpleIdMapping.getContainingTableExpression());
                assert (tableReference != null) : "Could not resolve table-group : " + simpleIdMapping.getContainingTableExpression();
                sqlExpression = sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, simpleIdMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, (SelectableMapping)simpleIdMapping, sessionFactory));
            } else {
                ArrayList expressions = new ArrayList();
                identifierMapping.forEachSelectable((selectionIndex, selectableMapping) -> {
                    TableReference tableReference = parentTableGroup.resolveTableReference(navigablePath, selectableMapping.getContainingTableExpression());
                    expressions.add(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, sessionFactory)));
                });
                sqlExpression = new SqlTuple(expressions, identifierMapping);
            }
        }
        return new EntityValuedPathInterpretation<T>(sqlExpression, navigablePath, tableGroup, mapping);
    }

    public EntityValuedPathInterpretation(Expression sqlExpression, NavigablePath navigablePath, TableGroup tableGroup, EntityValuedModelPart mapping) {
        super(navigablePath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
    }

    @Override
    public Expression getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        if (this.sqlExpression instanceof SqlTuple) {
            return ((SqlTuple)this.sqlExpression).getExpressions();
        }
        return Collections.singletonList((ColumnReference)this.sqlExpression);
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        if (this.sqlExpression instanceof SqlTuple) {
            for (Expression expression : ((SqlTuple)this.sqlExpression).getExpressions()) {
                columnReferenceConsumer.accept((ColumnReference)expression);
            }
        } else {
            columnReferenceConsumer.accept((ColumnReference)this.sqlExpression);
        }
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlExpression instanceof SqlTuple ? (SqlTuple)this.sqlExpression : null;
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this.sqlExpression, this.getExpressionType().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public EntityValuedModelPart getExpressionType() {
        return (EntityValuedModelPart)super.getExpressionType();
    }
}

