/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstQueryPartProcessingStateImpl
extends SqlAstProcessingStateImpl
implements SqlAstQueryPartProcessingState {
    private final QueryPart queryPart;
    private Map<Expression, SqlSelection> sqlSelectionMap;

    public SqlAstQueryPartProcessingStateImpl(QueryPart queryPart, SqlAstProcessingState parent, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess) {
        super(parent, creationState, currentClauseAccess);
        this.queryPart = queryPart;
    }

    public SqlAstQueryPartProcessingStateImpl(QueryPart queryPart, SqlAstProcessingState parent, SqlAstCreationState creationState, Function<SqlExpressionResolver, SqlExpressionResolver> expressionResolverDecorator, Supplier<Clause> currentClauseAccess) {
        super(parent, creationState, expressionResolverDecorator, currentClauseAccess);
        this.queryPart = queryPart;
    }

    @Override
    public QueryPart getInflightQueryPart() {
        return this.queryPart;
    }

    @Override
    protected Map<Expression, SqlSelection> sqlSelectionMap() {
        return this.sqlSelectionMap;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        SqlSelection existing;
        if (this.sqlSelectionMap == null) {
            this.sqlSelectionMap = new HashMap<Expression, SqlSelection>();
            existing = null;
        } else {
            existing = this.sqlSelectionMap.get(expression);
        }
        if (existing != null) {
            return existing;
        }
        int valuesArrayPosition = this.sqlSelectionMap.size();
        SqlSelection sqlSelection = expression.createSqlSelection(valuesArrayPosition + 1, valuesArrayPosition, javaTypeDescriptor, typeConfiguration);
        this.sqlSelectionMap.put(expression, sqlSelection);
        ((QuerySpec)this.queryPart).getSelectClause().addSqlSelection(sqlSelection);
        return sqlSelection;
    }
}

