/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.cte;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValueMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;

public class SqmCteTable
implements Serializable {
    private final String cteName;
    private final List<SqmCteTableColumn> columns;

    private SqmCteTable(String cteName, Function<SqmCteTable, List<SqmCteTableColumn>> columnInitializer) {
        this.cteName = cteName;
        this.columns = columnInitializer.apply(this);
    }

    public SqmCteTable(String cteName, List<SqmCteTableColumn> columns) {
        this.cteName = cteName;
        this.columns = columns;
    }

    public static SqmCteTable createIdTable(String cteName, EntityMappingType entityDescriptor) {
        return new SqmCteTable(cteName, sqmCteTable -> {
            int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
            ArrayList<SqmCteTableColumn> columns = new ArrayList<SqmCteTableColumn>(numberOfColumns);
            EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
            String idName = identifierMapping instanceof SingleAttributeIdentifierMapping ? ((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName() : "id";
            columns.add(new SqmCteTableColumn((SqmCteTable)sqmCteTable, idName, identifierMapping));
            return columns;
        });
    }

    public static SqmCteTable createEntityTable(String cteName, EntityMappingType entityDescriptor) {
        return new SqmCteTable(cteName, sqmCteTable -> {
            int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
            ArrayList<SqmCteTableColumn> columns = new ArrayList<SqmCteTableColumn>(numberOfColumns);
            EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
            String idName = identifierMapping instanceof SingleAttributeIdentifierMapping ? ((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName() : "id";
            columns.add(new SqmCteTableColumn((SqmCteTable)sqmCteTable, idName, identifierMapping));
            EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
            if (discriminatorMapping != null && discriminatorMapping.isPhysical() && !discriminatorMapping.isFormula()) {
                columns.add(new SqmCteTableColumn((SqmCteTable)sqmCteTable, "class", discriminatorMapping));
            }
            entityDescriptor.visitSubTypeAttributeMappings(attribute -> {
                if (!(attribute instanceof PluralAttributeMapping)) {
                    columns.add(new SqmCteTableColumn((SqmCteTable)sqmCteTable, attribute.getAttributeName(), (ValueMapping)attribute));
                }
            });
            columns.add(new SqmCteTableColumn((SqmCteTable)sqmCteTable, "rn_", entityDescriptor.getEntityPersister().getFactory().getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
            return columns;
        });
    }

    public String getCteName() {
        return this.cteName;
    }

    public List<SqmCteTableColumn> getColumns() {
        return this.columns;
    }

    public void visitColumns(Consumer<SqmCteTableColumn> columnConsumer) {
        for (int i = 0; i < this.columns.size(); ++i) {
            columnConsumer.accept(this.columns.get(i));
        }
    }
}

