/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.PathException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmBasicValuedSimplePath<T>
extends AbstractSqmSimplePath<T>
implements AllowableParameterType<T> {
    public SqmBasicValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        this(navigablePath, referencedPathSource, lhs, null, nodeBuilder);
    }

    public SqmBasicValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, explicitAlias, nodeBuilder);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new SemanticException("Basic-valued path [" + this.getNavigablePath() + "] cannot be de-referenced : " + name);
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        return super.getReferencedPathSource();
    }

    @Override
    public SqmPathSource<T> getNodeType() {
        return this.getReferencedPathSource();
    }

    @Override
    public BasicJavaType<T> getJavaTypeDescriptor() {
        return (BasicJavaType)super.getJavaTypeDescriptor();
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        throw new UnsupportedOperationException("Basic-value cannot be treated (downcast)");
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        throw new UnsupportedOperationException("Basic-value cannot be treated (downcast)");
    }

    @Override
    public JavaType<T> getExpressableJavaTypeDescriptor() {
        return this.getJavaTypeDescriptor();
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    @Override
    public Class<T> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitBasicValuedPath(this);
    }
}

