/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.type.descriptor.java.JdbcDateJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimeJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaTypeDescriptor;

public class LiteralHelper {
    public static SqmLiteral<Timestamp> timestampLiteralFrom(String literalText, SqmCreationState creationState) {
        Timestamp literal = Timestamp.valueOf(LocalDateTime.from(JdbcTimestampJavaTypeDescriptor.LITERAL_FORMATTER.parse(literalText)));
        return new SqmLiteral<Timestamp>(literal, creationState.getCreationContext().getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(Timestamp.class), creationState.getCreationContext().getQueryEngine().getCriteriaBuilder());
    }

    public static SqmLiteral<Integer> integerLiteral(String literalText, SqmCreationState creationState) {
        return LiteralHelper.integerLiteral(literalText, creationState.getCreationContext().getQueryEngine());
    }

    public static SqmLiteral<Integer> integerLiteral(String literalText, QueryEngine queryEngine) {
        return LiteralHelper.integerLiteral(Integer.parseInt(literalText), queryEngine);
    }

    public static SqmLiteral<Integer> integerLiteral(int value, QueryEngine queryEngine) {
        return new SqmLiteral<Integer>(value, queryEngine.getCriteriaBuilder().getIntegerType(), queryEngine.getCriteriaBuilder());
    }

    public static SqmLiteral<Date> dateLiteralFrom(String literalText, SqmCreationState creationState) {
        LocalDate localDate = LocalDate.from(JdbcDateJavaTypeDescriptor.LITERAL_FORMATTER.parse(literalText));
        Date literal = new Date(localDate.toEpochDay());
        return new SqmLiteral<Date>(literal, creationState.getCreationContext().getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(Date.class), creationState.getCreationContext().getQueryEngine().getCriteriaBuilder());
    }

    public static SqmLiteral<Time> timeLiteralFrom(String literalText, SqmCreationState creationState) {
        LocalTime localTime = LocalTime.from(JdbcTimeJavaTypeDescriptor.LITERAL_FORMATTER.parse(literalText));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, creationState.getCreationContext().getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(Time.class), creationState.getCreationContext().getQueryEngine().getCriteriaBuilder());
    }
}

