/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmExistsPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> expression;

    public SqmExistsPredicate(SqmExpression<?> expression, NodeBuilder nodeBuilder) {
        this(expression, false, nodeBuilder);
    }

    public SqmExistsPredicate(SqmExpression<?> expression, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.expression = expression;
        expression.applyInferableType(expression.getNodeType());
    }

    public SqmExpression<?> getExpression() {
        return this.expression;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitExistsPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        if (this.isNegated()) {
            sb.append("not exists ");
        } else {
            sb.append("exists ");
        }
        this.expression.appendHqlString(sb);
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmExistsPredicate(this.expression, !this.isNegated(), this.nodeBuilder());
    }
}

