/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

public class Collate
implements Expression,
SqlExpressable,
SqlAstNode,
DomainResultProducer {
    private final Expression expression;
    private final String collation;

    public Collate(Expression expression, String collation) {
        this.expression = expression;
        this.collation = collation;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getCollation() {
        return this.collation;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        if (this.expression instanceof SqlExpressable) {
            return ((SqlExpressable)((Object)this.expression)).getJdbcMapping();
        }
        if (this.getExpressionType() instanceof SqlExpressable) {
            return ((SqlExpressable)this.getExpressionType()).getJdbcMapping();
        }
        if (this.getExpressionType() != null) {
            JdbcMappingContainer mappingContainer = this.getExpressionType();
            assert (mappingContainer.getJdbcTypeCount() == 1);
            return mappingContainer.getJdbcMappings().get(0);
        }
        return null;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.expression.getExpressionType();
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitCollate(this);
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        JavaType javaTypeDescriptor = this.expression.getExpressionType().getJdbcMappings().get(0).getJavaTypeDescriptor();
        return new BasicResult(creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, javaTypeDescriptor, creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()).getValuesArrayPosition(), resultVariable, javaTypeDescriptor);
    }
}

