/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.DelegatingTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class LazyTableGroup
extends DelegatingTableGroup {
    private final boolean canUseInnerJoins;
    private final NavigablePath navigablePath;
    private final boolean fetched;
    private final TableGroupProducer producer;
    private final String sourceAlias;
    private final SqlAliasBase sqlAliasBase;
    private final Supplier<TableGroup> tableGroupSupplier;
    private final TableGroup parentTableGroup;
    private final BiPredicate<NavigablePath, String> navigablePathChecker;
    private Consumer<TableGroup> tableGroupConsumer;
    private TableGroup tableGroup;

    public LazyTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, Supplier<TableGroup> tableGroupSupplier, BiPredicate<NavigablePath, String> navigablePathChecker, TableGroupProducer tableGroupProducer, String sourceAlias, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory, TableGroup parentTableGroup) {
        this.canUseInnerJoins = canUseInnerJoins;
        this.navigablePath = navigablePath;
        this.fetched = fetched;
        this.producer = tableGroupProducer;
        this.sourceAlias = sourceAlias;
        this.sqlAliasBase = sqlAliasBase;
        this.tableGroupSupplier = tableGroupSupplier;
        this.navigablePathChecker = navigablePathChecker;
        this.parentTableGroup = parentTableGroup;
    }

    public TableGroup getUnderlyingTableGroup() {
        return this.tableGroup;
    }

    @Override
    public TableGroup getTableGroup() {
        if (this.tableGroup != null) {
            return this.tableGroup;
        }
        this.tableGroup = this.tableGroupSupplier.get();
        if (this.tableGroupConsumer != null) {
            this.tableGroupConsumer.accept(this.tableGroup);
            this.tableGroupConsumer = null;
        }
        return this.tableGroup;
    }

    public void setTableGroupInitializerCallback(Consumer<TableGroup> tableGroupConsumer) {
        if (this.tableGroup != null) {
            tableGroupConsumer.accept(this.tableGroup);
        } else {
            this.tableGroupConsumer = tableGroupConsumer;
        }
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        if (this.tableGroup != null) {
            this.tableGroup.applyAffectedTableNames(nameCollector);
        }
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.tableGroup == null ? Collections.emptyList() : this.tableGroup.getTableReferenceJoins();
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroup == null ? Collections.emptyList() : this.tableGroup.getTableGroupJoins();
    }

    @Override
    public List<TableGroupJoin> getNestedTableGroupJoins() {
        return this.tableGroup == null ? Collections.emptyList() : this.tableGroup.getNestedTableGroupJoins();
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroup != null) {
            this.tableGroup.visitTableGroupJoins(consumer);
        }
    }

    @Override
    public void visitNestedTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroup != null) {
            this.tableGroup.visitNestedTableGroupJoins(consumer);
        }
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.canUseInnerJoins;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public String getGroupAlias() {
        return this.sqlAliasBase.getAliasStem();
    }

    @Override
    public TableGroupProducer getModelPart() {
        return this.producer;
    }

    @Override
    public ModelPart getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getSourceAlias() {
        return this.sourceAlias;
    }

    @Override
    public boolean isRealTableGroup() {
        return this.tableGroup != null && this.tableGroup.isRealTableGroup();
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public boolean isLateral() {
        return false;
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        assert (tableExpression != null);
        TableReference tableReference = this.getTableReferenceInternal(navigablePath, tableExpression, allowFkOptimization, true);
        if (tableReference == null) {
            throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        return this.getTableReferenceInternal(navigablePath, tableExpression, allowFkOptimization, resolve);
    }

    protected TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference reference;
        if (allowFkOptimization && (navigablePath == null || this.navigablePathChecker.test(navigablePath, tableExpression)) && (reference = this.parentTableGroup.getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve)) != null) {
            return reference;
        }
        return this.getTableGroup().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
    }
}

