/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.from.AbstractTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;

public class NamedTableReference
extends AbstractTableReference {
    private final String tableExpression;
    private String prunedTableExpression;

    public NamedTableReference(String tableExpression, String identificationVariable, boolean isOptional, SessionFactoryImplementor sessionFactory) {
        super(identificationVariable, isOptional);
        assert (tableExpression != null);
        this.tableExpression = tableExpression;
    }

    public String getTableExpression() {
        return this.prunedTableExpression == null ? this.tableExpression : this.prunedTableExpression;
    }

    @Override
    public String getTableId() {
        return this.getTableExpression();
    }

    public void setPrunedTableExpression(String prunedTableExpression) {
        this.prunedTableExpression = prunedTableExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitNamedTableReference(this);
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        nameCollector.accept(this.getTableExpression());
    }

    @Override
    public List<String> getAffectedTableNames() {
        return Collections.singletonList(this.getTableExpression());
    }

    @Override
    public boolean containsAffectedTableName(String requestedName) {
        return this.getTableExpression().equals(requestedName);
    }

    @Override
    public Boolean visitAffectedTableNames(Function<String, Boolean> nameCollector) {
        return nameCollector.apply(this.getTableExpression());
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        if (tableExpression.equals(this.getTableExpression())) {
            return this;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        if (this.tableExpression.equals(tableExpression)) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.getTableExpression() + "(" + this.getIdentificationVariable() + ")";
    }
}

