/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.select.QueryPart;

public class QueryPartTableGroup
extends AbstractTableGroup {
    private final QueryPartTableReference queryPartTableReference;

    public QueryPartTableGroup(NavigablePath navigablePath, TableGroupProducer tableGroupProducer, QueryPart queryPart, String sourceAlias, List<String> columnNames, boolean lateral, boolean canUseInnerJoins, SessionFactoryImplementor sessionFactory) {
        super(canUseInnerJoins, navigablePath, tableGroupProducer, sourceAlias, null, sessionFactory);
        this.queryPartTableReference = new QueryPartTableReference(queryPart, sourceAlias, columnNames, lateral, sessionFactory);
    }

    @Override
    public boolean isLateral() {
        return this.getPrimaryTableReference().isLateral();
    }

    @Override
    protected TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference groupTableReference;
        if (tableExpression == null) {
            return this.getPrimaryTableReference();
        }
        for (TableGroupJoin tableGroupJoin : this.getNestedTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        return null;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.queryPartTableReference.applyAffectedTableNames(nameCollector);
    }

    @Override
    public QueryPartTableReference getPrimaryTableReference() {
        return this.queryPartTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }
}

