/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.ColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public interface TableGroup
extends SqlAstNode,
ColumnReferenceQualifier,
SqmPathInterpretation,
DomainResultProducer {
    @Override
    public NavigablePath getNavigablePath();

    public String getGroupAlias();

    public ModelPartContainer getModelPart();

    public String getSourceAlias();

    public List<TableGroupJoin> getTableGroupJoins();

    public List<TableGroupJoin> getNestedTableGroupJoins();

    public boolean canUseInnerJoins();

    default public boolean isLateral() {
        return false;
    }

    public void addTableGroupJoin(TableGroupJoin var1);

    public void prependTableGroupJoin(NavigablePath var1, TableGroupJoin var2);

    public void addNestedTableGroupJoin(TableGroupJoin var1);

    public void visitTableGroupJoins(Consumer<TableGroupJoin> var1);

    public void visitNestedTableGroupJoins(Consumer<TableGroupJoin> var1);

    public void applyAffectedTableNames(Consumer<String> var1);

    public TableReference getPrimaryTableReference();

    public List<TableReferenceJoin> getTableReferenceJoins();

    default public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.getModelPart().createDomainResult(this.getNavigablePath(), this, resultVariable, creationState);
    }

    @Override
    default public void applySqlSelections(DomainResultCreationState creationState) {
        ModelPartContainer modelPart = this.getModelPart();
        ModelPartContainer modelPartToApply = modelPart instanceof EntityValuedModelPart ? ((EntityValuedModelPart)modelPart).getEntityMappingType() : modelPart;
        modelPartToApply.applySqlSelections(this.getNavigablePath(), creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(this.getNavigablePath()), creationState);
    }

    @Override
    default public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableGroup(this);
    }

    default public boolean isRealTableGroup() {
        return false;
    }

    default public boolean isFetched() {
        return false;
    }
}

