/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.ColumnReferenceQualifier;

public interface TableReference
extends SqlAstNode,
ColumnReferenceQualifier {
    public String getIdentificationVariable();

    public String getTableId();

    public boolean isOptional();

    @Override
    public void accept(SqlAstWalker var1);

    default public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.visitAffectedTableNames(name -> {
            nameCollector.accept((String)name);
            return null;
        });
    }

    default public List<String> getAffectedTableNames() {
        ArrayList<String> affectedTableNames = new ArrayList<String>();
        this.visitAffectedTableNames(name -> {
            affectedTableNames.add((String)name);
            return null;
        });
        return affectedTableNames;
    }

    default public boolean containsAffectedTableName(String requestedName) {
        return this.visitAffectedTableNames(requestedName::equals);
    }

    public Boolean visitAffectedTableNames(Function<String, Boolean> var1);

    @Override
    public TableReference resolveTableReference(NavigablePath var1, String var2, boolean var3);

    @Override
    public TableReference getTableReference(NavigablePath var1, String var2, boolean var3, boolean var4);
}

