/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.NoopLimitHandler;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.query.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcLockStrategy;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.jdbc.internal.AbstractResultSetAccess;

public class DeferredResultSetAccess
extends AbstractResultSetAccess {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DeferredResultSetAccess.class);
    private final JdbcSelect jdbcSelect;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final ExecutionContext executionContext;
    private final Function<String, PreparedStatement> statementCreator;
    private final SqlStatementLogger sqlStatementLogger;
    private final String finalSql;
    private final Limit limit;
    private final LimitHandler limitHandler;
    private final boolean usesFollowOnLocking;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public DeferredResultSetAccess(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, Function<String, PreparedStatement> statementCreator) {
        super(executionContext.getSession());
        this.jdbcParameterBindings = jdbcParameterBindings;
        this.executionContext = executionContext;
        this.jdbcSelect = jdbcSelect;
        this.statementCreator = statementCreator;
        this.sqlStatementLogger = executionContext.getSession().getJdbcServices().getSqlStatementLogger();
        QueryOptions queryOptions = executionContext.getQueryOptions();
        if (queryOptions == null) {
            this.finalSql = jdbcSelect.getSql();
            this.limit = null;
            this.limitHandler = NoopLimitHandler.NO_LIMIT;
            this.usesFollowOnLocking = false;
        } else {
            String sql;
            Dialect dialect = executionContext.getSession().getJdbcServices().getDialect();
            this.limit = queryOptions.getLimit();
            if (this.limit == null || this.limit.isEmpty() || jdbcSelect.usesLimitParameters()) {
                sql = jdbcSelect.getSql();
                this.limitHandler = NoopLimitHandler.NO_LIMIT;
            } else {
                this.limitHandler = dialect.getLimitHandler();
                sql = this.limitHandler.processSql(jdbcSelect.getSql(), this.limit, queryOptions);
            }
            LockOptions lockOptions = queryOptions.getLockOptions();
            boolean followOnLocking = false;
            if (lockOptions != null && !lockOptions.isEmpty() && jdbcSelect.getLockStrategy() != JdbcLockStrategy.NONE) {
                switch (jdbcSelect.getLockStrategy()) {
                    case FOLLOW_ON: {
                        followOnLocking = true;
                        break;
                    }
                    case AUTO: {
                        if ((lockOptions.getFollowOnLocking() != null || !dialect.useFollowOnLocking(sql, queryOptions)) && !Boolean.TRUE.equals(lockOptions.getFollowOnLocking())) break;
                        followOnLocking = true;
                    }
                }
                if (followOnLocking) {
                    LockMode lockMode = this.determineFollowOnLockMode(lockOptions);
                    if (lockMode != LockMode.UPGRADE_SKIPLOCKED) {
                        if (lockOptions.getLockMode() != LockMode.NONE) {
                            LOG.usingFollowOnLocking();
                        }
                        LockOptions lockOptionsToUse = new LockOptions(lockMode);
                        lockOptionsToUse.setTimeOut(lockOptions.getTimeOut());
                        lockOptionsToUse.setScope(lockOptions.getScope());
                        executionContext.getCallback().registerAfterLoadAction((session, entity, persister) -> ((Session)((Object)session)).buildLockRequest(lockOptionsToUse).lock(persister.getEntityName(), entity));
                    }
                } else {
                    sql = dialect.applyLocksToSql(sql, lockOptions, Collections.emptyMap());
                }
            }
            this.usesFollowOnLocking = followOnLocking;
            this.finalSql = dialect.addSqlHintOrComment(sql, queryOptions, executionContext.getSession().getFactory().getSessionFactoryOptions().isCommentsEnabled());
        }
    }

    @Override
    public ResultSet getResultSet() {
        if (this.resultSet == null) {
            this.executeQuery();
        }
        return this.resultSet;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.executionContext.getSession().getFactory();
    }

    public String getFinalSql() {
        return this.finalSql;
    }

    public boolean usesFollowOnLocking() {
        return this.usesFollowOnLocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() {
        LogicalConnectionImplementor logicalConnection = this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection();
        QueryOptions queryOptions = this.executionContext.getQueryOptions();
        try {
            LOG.tracef("Executing query to retrieve ResultSet : %s", this.finalSql);
            this.preparedStatement = this.statementCreator.apply(this.finalSql);
            if (queryOptions != null) {
                if (queryOptions.getFetchSize() != null) {
                    this.preparedStatement.setFetchSize(queryOptions.getFetchSize());
                }
                if (queryOptions.getTimeout() != null) {
                    this.preparedStatement.setQueryTimeout(queryOptions.getTimeout());
                }
            }
            int paramBindingPosition = 1;
            paramBindingPosition += this.limitHandler.bindLimitParametersAtStartOfQuery(this.limit, this.preparedStatement, paramBindingPosition);
            for (JdbcParameterBinder parameterBinder : this.jdbcSelect.getParameterBinders()) {
                parameterBinder.bindParameterValue(this.preparedStatement, paramBindingPosition++, this.jdbcParameterBindings, this.executionContext);
            }
            paramBindingPosition += this.limitHandler.bindLimitParametersAtEndOfQuery(this.limit, this.preparedStatement, paramBindingPosition);
            if (!this.jdbcSelect.usesLimitParameters() && this.limit != null && this.limit.getMaxRows() != null) {
                this.limitHandler.setMaxRows(this.limit, this.preparedStatement);
            } else {
                int maxRows = this.jdbcSelect.getMaxRows();
                if (maxRows != Integer.MAX_VALUE) {
                    this.preparedStatement.setMaxRows(maxRows);
                }
            }
            SessionEventListenerManager eventListenerManager = this.executionContext.getSession().getEventListenerManager();
            long executeStartNanos = 0L;
            if (this.sqlStatementLogger.getLogSlowQuery() > 0L) {
                executeStartNanos = System.nanoTime();
            }
            try {
                eventListenerManager.jdbcExecuteStatementStart();
                this.resultSet = this.wrapResultSet(this.preparedStatement.executeQuery());
            }
            finally {
                eventListenerManager.jdbcExecuteStatementEnd();
                this.sqlStatementLogger.logSlowQuery(this.preparedStatement, executeStartNanos);
            }
            int rowsToSkip = !this.jdbcSelect.usesLimitParameters() && this.limit != null && this.limit.getFirstRow() != null && !this.limitHandler.supportsLimitOffset() ? this.limit.getFirstRow().intValue() : this.jdbcSelect.getRowsToSkip();
            if (rowsToSkip != 0) {
                try {
                    this.resultSet.absolute(rowsToSkip);
                }
                catch (SQLException ex) {
                    try {
                        this.resultSet.next();
                    }
                    catch (SQLException ex2) {
                        throw ex;
                    }
                    for (int i = 1; i < rowsToSkip && this.resultSet.next(); ++i) {
                    }
                }
            }
            logicalConnection.getResourceRegistry().register(this.resultSet, this.preparedStatement);
        }
        catch (SQLException e) {
            throw this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, "JDBC exception executing SQL [" + this.finalSql + "]");
        }
        finally {
            logicalConnection.afterStatement();
        }
    }

    protected ResultSet wrapResultSet(ResultSet resultSet) throws SQLException {
        return resultSet;
    }

    protected LockMode determineFollowOnLockMode(LockOptions lockOptions) {
        LockMode lockModeToUse = lockOptions.findGreatestLockMode();
        if (lockOptions.hasAliasSpecificLockModes()) {
            if (lockOptions.getLockMode() == LockMode.NONE && lockModeToUse == LockMode.NONE) {
                return lockModeToUse;
            }
            LOG.aliasSpecificLockingWithFollowOnLocking(lockModeToUse);
        }
        return lockModeToUse;
    }

    @Override
    public void release() {
        if (this.resultSet != null) {
            this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.resultSet, this.preparedStatement);
            this.resultSet = null;
        }
        if (this.preparedStatement != null) {
            this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.preparedStatement);
            this.preparedStatement = null;
        }
    }
}

