/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.util.Collections;
import org.hibernate.MappingException;
import org.hibernate.annotations.TenantId;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.tuple.AttributeBinder;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public class TenantIdBinder
implements AttributeBinder<TenantId> {
    public static final String FILTER_NAME = "_tenantId";
    public static final String PARAMETER_NAME = "tenantId";

    @Override
    public void bind(TenantId tenantId, MetadataBuildingContext buildingContext, PersistentClass persistentClass, Property property) {
        InFlightMetadataCollector collector = buildingContext.getMetadataCollector();
        BasicType tenantIdType = collector.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(property.getReturnedClassName());
        FilterDefinition filterDefinition = collector.getFilterDefinition(FILTER_NAME);
        if (filterDefinition == null) {
            collector.addFilterDefinition(new FilterDefinition(FILTER_NAME, "", Collections.singletonMap(PARAMETER_NAME, tenantIdType)));
        } else {
            Type parameterType = filterDefinition.getParameterTypes().get(PARAMETER_NAME);
            if (!parameterType.getName().equals(tenantIdType.getName())) {
                throw new MappingException("all @TenantId fields must have the same type: " + parameterType.getName() + " differs from " + tenantIdType.getName());
            }
        }
        persistentClass.addFilter(FILTER_NAME, this.columnNameOrFormula(property) + " = :tenantId", true, Collections.emptyMap(), Collections.emptyMap());
        property.resetUpdateable(false);
        property.resetOptional(false);
    }

    private String columnNameOrFormula(Property property) {
        if (property.getColumnSpan() != 1) {
            throw new MappingException("@TenantId attribute must be mapped to a single column or formula");
        }
        Selectable column = property.getColumnIterator().next();
        return column.isFormula() ? ((Formula)column).getFormula() : ((Column)column).getName();
    }
}

