/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.ComponentType;

public abstract class AbstractEntityTuplizer
implements EntityTuplizer {
    private final EntityMetamodel entityMetamodel;
    protected final Getter[] getters;
    protected final Setter[] setters;
    protected final int propertySpan;
    protected final boolean hasCustomAccessors;
    private EntityPersister entityDescriptor;
    private EntityIdentifierMapping identifierMapping;

    protected abstract Getter buildPropertyGetter(Property var1, PersistentClass var2);

    protected abstract Setter buildPropertySetter(Property var1, PersistentClass var2);

    protected abstract ProxyFactory buildProxyFactory(PersistentClass var1, Getter var2, Setter var3);

    public AbstractEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappingInfo) {
        this.entityMetamodel = entityMetamodel;
        this.propertySpan = entityMetamodel.getPropertySpan();
        this.getters = new Getter[this.propertySpan];
        this.setters = new Setter[this.propertySpan];
        Iterator<Property> itr = mappingInfo.getPropertyClosureIterator();
        boolean foundCustomAccessor = false;
        int i = 0;
        while (itr.hasNext()) {
            Property property = itr.next();
            this.getters[i] = this.buildPropertyGetter(property, mappingInfo);
            this.setters[i] = this.buildPropertySetter(property, mappingInfo);
            if (!property.isBasicPropertyAccessor()) {
                foundCustomAccessor = true;
            }
            ++i;
        }
        this.hasCustomAccessors = foundCustomAccessor;
    }

    protected String getEntityName() {
        return this.entityMetamodel.getName();
    }

    protected Set<String> getSubclassEntityNames() {
        return this.entityMetamodel.getSubclassEntityNames();
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        EntityIdentifierMapping identifierMapping = this.resolveIdentifierDescriptor();
        return identifierMapping.getIdentifier(entity, session);
    }

    protected EntityIdentifierMapping resolveIdentifierDescriptor() {
        if (this.identifierMapping == null) {
            this.identifierMapping = this.resolveEntityDescriptor().getIdentifierMapping();
        }
        return this.identifierMapping;
    }

    private EntityPersister resolveEntityDescriptor() {
        if (this.entityDescriptor == null) {
            this.entityDescriptor = this.getFactory().getRuntimeMetamodels().getMappingMetamodel().findEntityDescriptor(this.getEntityName());
        }
        return this.entityDescriptor;
    }

    protected boolean shouldGetAllProperties(Object entity) {
        BytecodeEnhancementMetadata bytecodeEnhancementMetadata = this.getEntityMetamodel().getBytecodeEnhancementMetadata();
        if (!bytecodeEnhancementMetadata.isEnhancedForLazyLoading()) {
            return true;
        }
        return !bytecodeEnhancementMetadata.hasUnFetchedAttributes(entity);
    }

    @Override
    public Object[] getPropertyValuesToInsert(Object entity, Map mergeMap, SharedSessionContractImplementor session) {
        EntityPersister entityDescriptor = this.resolveEntityDescriptor();
        return entityDescriptor.getPropertyValuesToInsert(entity, mergeMap, session);
    }

    @Override
    public Object getPropertyValue(Object entity, int i) throws HibernateException {
        EntityPersister entityDescriptor = this.resolveEntityDescriptor();
        return entityDescriptor.getPropertyValue(entity, i);
    }

    protected Object getComponentValue(ComponentType type, Object component, String propertyPath) {
        int loc = propertyPath.indexOf(46);
        String basePropertyName = loc > 0 ? propertyPath.substring(0, loc) : propertyPath;
        int index = this.findSubPropertyIndex(type, basePropertyName);
        Object baseValue = type.getPropertyValue(component, index);
        if (loc > 0) {
            if (baseValue == null) {
                return null;
            }
            return this.getComponentValue((ComponentType)type.getSubtypes()[index], baseValue, propertyPath.substring(loc + 1));
        }
        return baseValue;
    }

    private int findSubPropertyIndex(ComponentType type, String subPropertyName) {
        String[] propertyNames = type.getPropertyNames();
        for (int index = 0; index < propertyNames.length; ++index) {
            if (!subPropertyName.equals(propertyNames[index])) continue;
            return index;
        }
        throw new MappingException("component property not found: " + subPropertyName);
    }

    protected final EntityMetamodel getEntityMetamodel() {
        return this.entityMetamodel;
    }

    protected final SessionFactoryImplementor getFactory() {
        return this.entityMetamodel.getSessionFactory();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getEntityMetamodel().getName() + ")";
    }

    @Override
    public Getter getGetter(int i) {
        return this.getters[i];
    }
}

