/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.SerializableJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;

public class SerializableType<T extends Serializable>
extends AbstractSingleColumnStandardBasicType<T> {
    public static final SerializableType<Serializable> INSTANCE = new SerializableType<Serializable>(Serializable.class);
    private final Class<T> serializableClass;

    public SerializableType(Class<T> serializableClass) {
        super(VarbinaryJdbcType.INSTANCE, new SerializableJavaTypeDescriptor<T>(serializableClass));
        this.serializableClass = serializableClass;
    }

    public SerializableType(JavaType<T> jtd) {
        super(VarbinaryJdbcType.INSTANCE, jtd);
        this.serializableClass = jtd.getJavaTypeClass();
    }

    @Override
    public String getName() {
        return this.serializableClass == Serializable.class ? "serializable" : this.serializableClass.getName();
    }
}

