/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptorHelper;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public abstract class AbstractClassJavaTypeDescriptor<T>
implements BasicJavaType<T>,
Serializable {
    private final Class<T> type;
    private final MutabilityPlan<T> mutabilityPlan;
    private final Comparator<T> comparator;

    protected AbstractClassJavaTypeDescriptor(Class<? extends T> type) {
        this(type, ImmutableMutabilityPlan.INSTANCE);
    }

    protected AbstractClassJavaTypeDescriptor(Class<? extends T> type, MutabilityPlan<? extends T> mutabilityPlan) {
        this(type, mutabilityPlan, Comparable.class.isAssignableFrom(type) ? ComparableComparator.INSTANCE : null);
    }

    protected AbstractClassJavaTypeDescriptor(Class<? extends T> type, MutabilityPlan<? extends T> mutabilityPlan, Comparator<? extends T> comparator) {
        this.type = type;
        this.mutabilityPlan = mutabilityPlan;
        this.comparator = comparator;
    }

    @Override
    public MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public Class<T> getJavaType() {
        return this.type;
    }

    @Override
    public Class<T> getJavaTypeClass() {
        return this.getJavaType();
    }

    @Override
    public int extractHashCode(T value) {
        return value.hashCode();
    }

    @Override
    public boolean areEqual(T one, T another) {
        return Objects.equals(one, another);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public String extractLoggableRepresentation(T value) {
        return value == null ? "null" : value.toString();
    }

    protected HibernateException unknownUnwrap(Class<?> conversionType) {
        return JavaTypeDescriptorHelper.unknownUnwrap(this.type, conversionType, this);
    }

    protected HibernateException unknownWrap(Class<?> conversionType) {
        return JavaTypeDescriptorHelper.unknownWrap(conversionType, this.type, this);
    }
}

