/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcDateJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimeJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class DateJavaTypeDescriptor
extends AbstractTemporalJavaTypeDescriptor<java.util.Date>
implements VersionJavaType<java.util.Date> {
    public static final DateJavaTypeDescriptor INSTANCE = new DateJavaTypeDescriptor();
    public static final String DATE_FORMAT = "dd MMMM yyyy";

    public DateJavaTypeDescriptor() {
        super(java.util.Date.class, DateMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeDescriptorRegistry().getDescriptor(93);
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return JdbcDateJavaTypeDescriptor.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return JdbcTimestampJavaTypeDescriptor.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return JdbcTimeJavaTypeDescriptor.INSTANCE;
    }

    @Override
    public String toString(java.util.Date value) {
        return new SimpleDateFormat(DATE_FORMAT).format(value);
    }

    @Override
    public java.util.Date fromString(CharSequence string) {
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(string.toString());
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse date string" + string, pe);
        }
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        if (one == another) {
            return true;
        }
        return one != null && another != null && one.getTime() == another.getTime();
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        return CalendarJavaTypeDescriptor.INSTANCE.extractHashCode(calendar);
    }

    @Override
    public <X> X unwrap(java.util.Date value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(type)) {
            Date rtn = Date.class.isInstance(value) ? (Date)value : new Date(value.getTime());
            return (X)rtn;
        }
        if (Time.class.isAssignableFrom(type)) {
            Time rtn = Time.class.isInstance(value) ? (Time)value : new Time(value.getTime());
            return (X)rtn;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            Timestamp rtn = Timestamp.class.isInstance(value) ? (Timestamp)value : new Timestamp(value.getTime());
            return (X)rtn;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return (X)cal;
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.getTime());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> java.util.Date wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (java.util.Date.class.isInstance(value)) {
            return (java.util.Date)value;
        }
        if (Long.class.isInstance(value)) {
            return new java.util.Date((Long)value);
        }
        if (Calendar.class.isInstance(value)) {
            return new java.util.Date(((Calendar)value).getTimeInMillis());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public java.util.Date next(java.util.Date current, SharedSessionContractImplementor session) {
        return this.seed(session);
    }

    @Override
    public java.util.Date seed(SharedSessionContractImplementor session) {
        return new Timestamp(System.currentTimeMillis());
    }

    public static class DateMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final DateMutabilityPlan INSTANCE = new DateMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            return new java.util.Date(value.getTime());
        }
    }
}

