/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.ComponentArrayComparator;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;

public class ObjectArrayJavaTypeDescriptor
extends AbstractClassJavaTypeDescriptor<Object[]> {
    private final JavaType<Object>[] components;

    public ObjectArrayJavaTypeDescriptor(JavaType<?>[] components) {
        super(Object[].class, ImmutableMutabilityPlan.INSTANCE, new ComponentArrayComparator(components));
        this.components = components;
    }

    @Override
    public String toString(Object[] value) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.components[0].toString(value[0]));
        for (int i = 1; i < this.components.length; ++i) {
            sb.append(", ");
            sb.append(this.components[i].toString(value[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean areEqual(Object[] one, Object[] another) {
        if (one == another) {
            return true;
        }
        if (one != null && another != null && one.length == another.length) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i].areEqual(one[i], another[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int extractHashCode(Object[] objects) {
        int hashCode = 1;
        for (int i = 0; i < objects.length; ++i) {
            hashCode = 31 * hashCode + this.components[i].extractHashCode(objects[i]);
        }
        return hashCode;
    }

    @Override
    public <X> X unwrap(Object[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Object[].class.isAssignableFrom(type)) {
            return (X)value;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Object[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Object[].class.isInstance(value)) {
            return (Object[])value;
        }
        throw this.unknownWrap(value.getClass());
    }
}

