/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.spi;

import jakarta.persistence.TemporalType;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BasicTypeRegistration;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.uuid.LocalObjectUuidHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.internal.ArrayTupleType;
import org.hibernate.metamodel.model.domain.internal.MappingMetamodelImpl;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.IntervalType;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.internal.BasicTypeImpl;

@Incubating
public class TypeConfiguration
implements SessionFactoryObserver,
Serializable {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Scope.class);
    private final String uuid = LocalObjectUuidHelper.generateLocalObjectUuid();
    private final Scope scope;
    private final transient JavaTypeRegistry javaTypeRegistry;
    private final transient JdbcTypeRegistry jdbcTypeRegistry;
    private final transient BasicTypeRegistry basicTypeRegistry;
    private final transient Map<Integer, Set<String>> jdbcToHibernateTypeContributionMap = new HashMap<Integer, Set<String>>();
    private final ConcurrentMap<ArrayCacheKey, ArrayTupleType> arrayTuples = new ConcurrentHashMap<ArrayCacheKey, ArrayTupleType>();
    private final ConcurrentHashMap<Class<?>, BasicType<?>> basicTypeByJavaType = new ConcurrentHashMap();

    public TypeConfiguration() {
        this.scope = new Scope(this);
        this.javaTypeRegistry = new JavaTypeRegistry(this);
        this.jdbcTypeRegistry = new JdbcTypeRegistry(this);
        this.basicTypeRegistry = new BasicTypeRegistry(this);
        StandardBasicTypes.prime(this);
    }

    public String getUuid() {
        return this.uuid;
    }

    public BasicTypeRegistry getBasicTypeRegistry() {
        return this.basicTypeRegistry;
    }

    public JavaTypeRegistry getJavaTypeDescriptorRegistry() {
        return this.javaTypeRegistry;
    }

    public JdbcTypeRegistry getJdbcTypeDescriptorRegistry() {
        return this.jdbcTypeRegistry;
    }

    public JdbcTypeDescriptorIndicators getCurrentBaseSqlTypeIndicators() {
        return this.scope.getCurrentBaseSqlTypeIndicators();
    }

    public Map<Integer, Set<String>> getJdbcToHibernateTypeContributionMap() {
        return this.jdbcToHibernateTypeContributionMap;
    }

    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.scope.getMetadataBuildingContext();
    }

    public void scope(MetadataBuildingContext metadataBuildingContext) {
        log.debugf("Scoping TypeConfiguration [%s] to MetadataBuildingContext [%s]", this, metadataBuildingContext);
        this.scope.setMetadataBuildingContext(metadataBuildingContext);
    }

    public MappingMetamodelImpl scope(SessionFactoryImplementor sessionFactory) {
        log.debugf("Scoping TypeConfiguration [%s] to SessionFactoryImplementor [%s]", this, sessionFactory);
        if (this.scope.getMetadataBuildingContext() == null) {
            throw new IllegalStateException("MetadataBuildingContext not known");
        }
        this.scope.setSessionFactory(sessionFactory);
        sessionFactory.addObserver(this);
        return new MappingMetamodelImpl(sessionFactory, this);
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.scope.getSessionFactory();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.scope.getServiceRegistry();
    }

    @Override
    public void sessionFactoryCreated(SessionFactory factory) {
        log.tracef("Handling #sessionFactoryCreated from [%s] for TypeConfiguration", factory);
        this.scope.setMetadataBuildingContext(null);
    }

    @Override
    public void sessionFactoryClosed(SessionFactory factory) {
        log.tracef("Handling #sessionFactoryClosed from [%s] for TypeConfiguration", factory);
        this.scope.unsetSessionFactory(factory);
    }

    public void addBasicTypeRegistrationContributions(List<BasicTypeRegistration> contributions) {
        for (BasicTypeRegistration basicTypeRegistration : contributions) {
            BasicType<?> basicType = basicTypeRegistration.getBasicType();
            this.basicTypeRegistry.register(basicType, basicTypeRegistration.getRegistrationKeys());
            this.javaTypeRegistry.resolveDescriptor(basicType.getJavaType(), () -> basicType.getJavaTypeDescriptor());
            try {
                int[] jdbcTypes = basicType.getSqlTypeCodes(null);
                if (jdbcTypes.length != 1) continue;
                int jdbcType = jdbcTypes[0];
                Set hibernateTypes = this.jdbcToHibernateTypeContributionMap.computeIfAbsent(jdbcType, k -> new HashSet());
                hibernateTypes.add(basicType.getName());
            }
            catch (Exception e) {
                log.errorf(e, "Cannot register [%s] Hibernate Type contribution", basicType.getName());
            }
        }
    }

    public BasicValuedMapping resolveCastTargetType(String name) {
        switch (name.toLowerCase()) {
            case "string": {
                return this.getBasicTypeForJavaType(String.class);
            }
            case "character": {
                return this.getBasicTypeForJavaType(Character.class);
            }
            case "byte": {
                return this.getBasicTypeForJavaType(Byte.class);
            }
            case "integer": {
                return this.getBasicTypeForJavaType(Integer.class);
            }
            case "long": {
                return this.getBasicTypeForJavaType(Long.class);
            }
            case "float": {
                return this.getBasicTypeForJavaType(Float.class);
            }
            case "double": {
                return this.getBasicTypeForJavaType(Double.class);
            }
            case "time": {
                return this.getBasicTypeForJavaType(Time.class);
            }
            case "date": {
                return this.getBasicTypeForJavaType(Date.class);
            }
            case "timestamp": {
                return this.getBasicTypeForJavaType(Timestamp.class);
            }
            case "localtime": {
                return this.getBasicTypeForJavaType(LocalTime.class);
            }
            case "localdate": {
                return this.getBasicTypeForJavaType(LocalDate.class);
            }
            case "localdatetime": {
                return this.getBasicTypeForJavaType(LocalDateTime.class);
            }
            case "offsetdatetime": {
                return this.getBasicTypeForJavaType(OffsetDateTime.class);
            }
            case "zoneddatetime": {
                return this.getBasicTypeForJavaType(ZonedDateTime.class);
            }
            case "biginteger": {
                return this.getBasicTypeForJavaType(BigInteger.class);
            }
            case "bigdecimal": {
                return this.getBasicTypeForJavaType(BigDecimal.class);
            }
            case "binary": {
                return this.getBasicTypeForJavaType(byte[].class);
            }
            case "boolean": {
                return this.getBasicTypeForJavaType(Boolean.class);
            }
            case "truefalse": {
                return this.basicTypeRegistry.getRegisteredType(StandardBasicTypes.TRUE_FALSE.getName());
            }
            case "yesno": {
                return this.basicTypeRegistry.getRegisteredType(StandardBasicTypes.YES_NO.getName());
            }
            case "numericboolean": {
                return this.basicTypeRegistry.getRegisteredType(StandardBasicTypes.NUMERIC_BOOLEAN.getName());
            }
        }
        BasicType registeredBasicType = this.basicTypeRegistry.getRegisteredType(name);
        if (registeredBasicType != null) {
            return registeredBasicType;
        }
        try {
            ClassLoaderService cls = this.getServiceRegistry().getService(ClassLoaderService.class);
            Class javaTypeClass = cls.classForName(name);
            JavaType jtd = this.javaTypeRegistry.resolveDescriptor(javaTypeClass);
            JdbcType jdbcType = jtd.getRecommendedJdbcType(this.getCurrentBaseSqlTypeIndicators());
            return this.basicTypeRegistry.resolve(jtd, jdbcType);
        }
        catch (Exception exception) {
            throw new HibernateException("unrecognized cast target type: " + name);
        }
    }

    public SqmExpressable<?> resolveTupleType(List<? extends SqmTypedNode<?>> typedNodes) {
        SqmExpressable[] components = new SqmExpressable[typedNodes.size()];
        for (int i = 0; i < typedNodes.size(); ++i) {
            SqmExpressable<?> sqmExpressable = typedNodes.get(i).getNodeType();
            components[i] = sqmExpressable != null ? sqmExpressable : this.getBasicTypeForJavaType(Object.class);
        }
        return this.arrayTuples.computeIfAbsent(new ArrayCacheKey(components), key -> new ArrayTupleType(key.components));
    }

    public SqmExpressable<?> resolveArithmeticType(SqmExpressable<?> firstType, SqmExpressable<?> secondType, BinaryArithmeticOperator operator) {
        return this.resolveArithmeticType(firstType, secondType, operator == BinaryArithmeticOperator.DIVIDE);
    }

    public SqmExpressable<?> resolveArithmeticType(SqmExpressable<?> firstType, SqmExpressable<?> secondType, boolean isDivision) {
        if (this.getSqlTemporalType(firstType) != null) {
            if (secondType == null || this.getSqlTemporalType(secondType) != null) {
                return this.getBasicTypeRegistry().getRegisteredType(Duration.class);
            }
            return firstType;
        }
        if (TypeConfiguration.isDuration(secondType)) {
            return secondType;
        }
        if (firstType == null && this.getSqlTemporalType(secondType) != null) {
            return this.getBasicTypeRegistry().getRegisteredType(Duration.class);
        }
        if (isDivision) {
            return this.getBasicTypeRegistry().getRegisteredType(Number.class.getName());
        }
        if (TypeConfiguration.matchesJavaType(firstType, Double.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Double.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Float.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Float.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, BigDecimal.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, BigDecimal.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, BigInteger.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, BigInteger.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Long.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Long.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Integer.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Integer.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Short.class)) {
            return this.getBasicTypeRegistry().getRegisteredType(Integer.class.getName());
        }
        if (TypeConfiguration.matchesJavaType(secondType, Short.class)) {
            return this.getBasicTypeRegistry().getRegisteredType(Integer.class.getName());
        }
        return this.getBasicTypeRegistry().getRegisteredType(Number.class.getName());
    }

    private static boolean matchesJavaType(SqmExpressable<?> type, Class<?> javaType) {
        assert (javaType != null);
        return type != null && javaType.isAssignableFrom(type.getExpressableJavaTypeDescriptor().getJavaTypeClass());
    }

    public <J> BasicType<J> getBasicTypeForJavaType(Class<J> javaType) {
        BasicType<?> existing = this.basicTypeByJavaType.get(javaType);
        if (existing != null) {
            return existing;
        }
        BasicType<J> registeredType = this.getBasicTypeRegistry().getRegisteredType(javaType);
        if (registeredType != null) {
            this.basicTypeByJavaType.put(javaType, registeredType);
            return registeredType;
        }
        return null;
    }

    public <J> BasicType<J> standardBasicTypeForJavaType(Class<J> javaType) {
        if (javaType == null) {
            return null;
        }
        return this.standardBasicTypeForJavaType(javaType, javaTypeDescriptor -> new BasicTypeImpl(javaTypeDescriptor, javaTypeDescriptor.getRecommendedJdbcType(this.getCurrentBaseSqlTypeIndicators())));
    }

    public <J> BasicType<J> standardBasicTypeForJavaType(Class<J> javaType, Function<JavaType<J>, BasicType<J>> creator) {
        if (javaType == null) {
            return null;
        }
        return this.basicTypeByJavaType.computeIfAbsent(javaType, jt -> {
            BasicType registeredType = this.basicTypeRegistry.getRegisteredType(javaType);
            if (registeredType != null) {
                return registeredType;
            }
            JavaType javaTypeDescriptor = this.javaTypeRegistry.resolveDescriptor(javaType);
            return (BasicType)creator.apply(javaTypeDescriptor);
        });
    }

    public TemporalType getSqlTemporalType(SqmExpressable<?> type) {
        if (type == null) {
            return null;
        }
        return TypeConfiguration.getSqlTemporalType(type.getExpressableJavaTypeDescriptor().getRecommendedJdbcType(this.getCurrentBaseSqlTypeIndicators()));
    }

    public static TemporalType getSqlTemporalType(JdbcMapping jdbcMapping) {
        return TypeConfiguration.getSqlTemporalType(jdbcMapping.getJdbcTypeDescriptor());
    }

    public static TemporalType getSqlTemporalType(JdbcMappingContainer jdbcMappings) {
        assert (jdbcMappings.getJdbcTypeCount() == 1);
        return TypeConfiguration.getSqlTemporalType(jdbcMappings.getJdbcMappings().get(0).getJdbcTypeDescriptor());
    }

    public static TemporalType getSqlTemporalType(MappingModelExpressable<?> type) {
        if (type instanceof BasicValuedMapping) {
            return TypeConfiguration.getSqlTemporalType(((BasicValuedMapping)type).getJdbcMapping().getJdbcTypeDescriptor());
        }
        return null;
    }

    public static TemporalType getSqlTemporalType(JdbcType descriptor) {
        return TypeConfiguration.getSqlTemporalType(descriptor.getDefaultSqlTypeCode());
    }

    protected static TemporalType getSqlTemporalType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case 93: 
            case 2014: {
                return TemporalType.TIMESTAMP;
            }
            case 92: 
            case 2013: {
                return TemporalType.TIME;
            }
            case 91: {
                return TemporalType.DATE;
            }
        }
        return null;
    }

    public static IntervalType getSqlIntervalType(JdbcMappingContainer jdbcMappings) {
        assert (jdbcMappings.getJdbcTypeCount() == 1);
        return TypeConfiguration.getSqlIntervalType(jdbcMappings.getJdbcMappings().get(0).getJdbcTypeDescriptor());
    }

    public static IntervalType getSqlIntervalType(JdbcType descriptor) {
        return TypeConfiguration.getSqlIntervalType(descriptor.getDefaultSqlTypeCode());
    }

    protected static IntervalType getSqlIntervalType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case 3100: {
                return IntervalType.SECOND;
            }
        }
        return null;
    }

    public static boolean isJdbcTemporalType(SqmExpressable<?> type) {
        return TypeConfiguration.matchesJavaType(type, java.util.Date.class);
    }

    public static boolean isDuration(SqmExpressable<?> type) {
        return TypeConfiguration.matchesJavaType(type, Duration.class);
    }

    private static class ArrayCacheKey {
        final SqmExpressable<?>[] components;

        public ArrayCacheKey(SqmExpressable<?>[] components) {
            this.components = components;
        }

        public boolean equals(Object o) {
            return Arrays.equals(this.components, ((ArrayCacheKey)o).components);
        }

        public int hashCode() {
            return Arrays.hashCode(this.components);
        }
    }

    private static class Scope
    implements Serializable {
        private final TypeConfiguration typeConfiguration;
        private transient MetadataBuildingContext metadataBuildingContext;
        private transient SessionFactoryImplementor sessionFactory;
        private String sessionFactoryName;
        private String sessionFactoryUuid;
        private final transient JdbcTypeDescriptorIndicators currentSqlTypeIndicators = new JdbcTypeDescriptorIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public int getPreferredSqlTypeCodeForBoolean() {
                return 16;
            }
        };

        public Scope(TypeConfiguration typeConfiguration) {
            this.typeConfiguration = typeConfiguration;
        }

        public JdbcTypeDescriptorIndicators getCurrentBaseSqlTypeIndicators() {
            return this.currentSqlTypeIndicators;
        }

        public MetadataBuildingContext getMetadataBuildingContext() {
            if (this.metadataBuildingContext == null) {
                throw new HibernateException("TypeConfiguration is not currently scoped to MetadataBuildingContext");
            }
            return this.metadataBuildingContext;
        }

        public ServiceRegistry getServiceRegistry() {
            if (this.metadataBuildingContext != null) {
                return this.metadataBuildingContext.getBootstrapContext().getServiceRegistry();
            }
            if (this.sessionFactory != null) {
                return this.sessionFactory.getServiceRegistry();
            }
            return null;
        }

        public void setMetadataBuildingContext(MetadataBuildingContext metadataBuildingContext) {
            this.metadataBuildingContext = metadataBuildingContext;
        }

        public SessionFactoryImplementor getSessionFactory() {
            if (this.sessionFactory == null) {
                if (this.sessionFactoryName == null && this.sessionFactoryUuid == null) {
                    throw new HibernateException("TypeConfiguration was not yet scoped to SessionFactory");
                }
                this.sessionFactory = SessionFactoryRegistry.INSTANCE.findSessionFactory(this.sessionFactoryUuid, this.sessionFactoryName);
                if (this.sessionFactory == null) {
                    throw new HibernateException("Could not find a SessionFactory [uuid=" + this.sessionFactoryUuid + ",name=" + this.sessionFactoryName + "]");
                }
            }
            return this.sessionFactory;
        }

        void setSessionFactory(SessionFactoryImplementor factory) {
            if (this.sessionFactory != null) {
                log.scopingTypesToSessionFactoryAfterAlreadyScoped(this.sessionFactory, factory);
            } else {
                CfgXmlAccessService cfgXmlAccessService;
                this.sessionFactoryUuid = factory.getUuid();
                String sfName = factory.getSessionFactoryOptions().getSessionFactoryName();
                if (sfName == null && (cfgXmlAccessService = factory.getServiceRegistry().getService(CfgXmlAccessService.class)).getAggregatedConfig() != null) {
                    sfName = cfgXmlAccessService.getAggregatedConfig().getSessionFactoryName();
                }
                this.sessionFactoryName = sfName;
            }
            this.sessionFactory = factory;
        }

        public void unsetSessionFactory(SessionFactory factory) {
            log.debugf("Un-scoping TypeConfiguration [%s] from SessionFactory [%s]", this, factory);
            this.sessionFactory = null;
        }

        private Object readResolve() throws InvalidObjectException {
            if (this.sessionFactory == null && (this.sessionFactoryName != null || this.sessionFactoryUuid != null)) {
                this.sessionFactory = SessionFactoryRegistry.INSTANCE.findSessionFactory(this.sessionFactoryUuid, this.sessionFactoryName);
                if (this.sessionFactory == null) {
                    throw new HibernateException("Could not find a SessionFactory [uuid=" + this.sessionFactoryUuid + ",name=" + this.sessionFactoryName + "]");
                }
            }
            return this;
        }
    }
}

