/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.usertype;

import java.util.Properties;
import java.util.function.BiConsumer;
import org.hibernate.MappingException;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.BaseUserTypeSupport;
import org.hibernate.usertype.ParameterizedType;

public class UserTypeLegacyBridge
extends BaseUserTypeSupport<Object>
implements ParameterizedType,
TypeConfigurationAware {
    public static final String TYPE_NAME_PARAM_KEY = "hbm-type-name";
    private TypeConfiguration typeConfiguration;
    private String hbmStyleTypeName;

    public UserTypeLegacyBridge() {
    }

    public UserTypeLegacyBridge(String hbmStyleTypeName) {
        this.hbmStyleTypeName = hbmStyleTypeName;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void setTypeConfiguration(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        if (this.hbmStyleTypeName != null) {
            return;
        }
        this.hbmStyleTypeName = parameters.getProperty(TYPE_NAME_PARAM_KEY);
        if (this.hbmStyleTypeName == null) {
            throw new MappingException("Missing `@Parameter` for `hbm-type-name`");
        }
    }

    @Override
    protected void resolve(BiConsumer resolutionConsumer) {
        assert (this.typeConfiguration != null);
        BasicType registeredType = this.typeConfiguration.getBasicTypeRegistry().getRegisteredType(this.hbmStyleTypeName);
        resolutionConsumer.accept(registeredType.getJavaTypeDescriptor(), registeredType.getJdbcTypeDescriptor());
    }
}

