/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManagerFactory;
import java.io.Closeable;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.naming.Referenceable;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.Transaction;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;

public interface SessionFactory
extends EntityManagerFactory,
Referenceable,
Serializable,
Closeable {
    public SessionFactoryOptions getSessionFactoryOptions();

    public SessionBuilder withOptions();

    public Session openSession() throws HibernateException;

    public Session getCurrentSession() throws HibernateException;

    public StatelessSessionBuilder withStatelessOptions();

    public StatelessSession openStatelessSession();

    public StatelessSession openStatelessSession(Connection var1);

    default public void inSession(Consumer<Session> action) {
        try (Session session = this.openSession();){
            action.accept(session);
        }
    }

    default public void inTransaction(Consumer<Session> action) {
        this.inSession(session -> {
            Transaction txn = session.beginTransaction();
            try {
                action.accept((Session)session);
                if (!txn.isActive()) {
                    throw new TransactionManagementException("Execution of action caused managed transaction to be completed");
                }
            }
            catch (RuntimeException e) {
                if (txn.isActive()) {
                    try {
                        txn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw e;
            }
            txn.commit();
        });
    }

    default public <R> R fromSession(Function<Session, R> action) {
        try (Session session = this.openSession();){
            R r = action.apply(session);
            return r;
        }
    }

    default public <R> R fromTransaction(Function<Session, R> action) {
        return (R)this.fromSession(session -> {
            Transaction txn = session.beginTransaction();
            try {
                Object result = action.apply((Session)session);
                if (!txn.isActive()) {
                    throw new TransactionManagementException("Execution of action caused managed transaction to be completed");
                }
                txn.commit();
                return result;
            }
            catch (RuntimeException e) {
                if (txn.isActive()) {
                    try {
                        txn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw e;
            }
        });
    }

    public Statistics getStatistics();

    @Override
    public void close() throws HibernateException;

    public boolean isClosed();

    public Cache getCache();

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> var1);

    public Set<String> getDefinedFilterNames();

    public FilterDefinition getFilterDefinition(String var1) throws HibernateException;

    public boolean containsFetchProfileDefinition(String var1);

    @Deprecated
    public ClassMetadata getClassMetadata(Class var1);

    @Deprecated
    public ClassMetadata getClassMetadata(String var1);

    @Deprecated
    public CollectionMetadata getCollectionMetadata(String var1);

    public static class TransactionManagementException
    extends RuntimeException {
        TransactionManagementException(String message) {
            super(message);
        }
    }
}

