/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.internal.util.StringHelper;

class ColumnsBuilder {
    private PropertyHolder propertyHolder;
    private Nullability nullability;
    private XProperty property;
    private PropertyData inferredData;
    private EntityBinder entityBinder;
    private MetadataBuildingContext buildingContext;
    private AnnotatedColumn[] columns;
    private AnnotatedJoinColumn[] joinColumns;

    public ColumnsBuilder(PropertyHolder propertyHolder, Nullability nullability, XProperty property, PropertyData inferredData, EntityBinder entityBinder, MetadataBuildingContext buildingContext) {
        this.propertyHolder = propertyHolder;
        this.nullability = nullability;
        this.property = property;
        this.inferredData = inferredData;
        this.entityBinder = entityBinder;
        this.buildingContext = buildingContext;
    }

    public AnnotatedColumn[] getColumns() {
        return this.columns;
    }

    public AnnotatedJoinColumn[] getJoinColumns() {
        return this.joinColumns;
    }

    public ColumnsBuilder extractMetadata() {
        this.columns = null;
        this.joinColumns = this.buildExplicitJoinColumns(this.property, this.inferredData);
        Comment comment = (Comment)this.property.getAnnotation(Comment.class);
        if (this.property.isAnnotationPresent(Column.class) || this.property.isAnnotationPresent(Formula.class)) {
            Column ann = (Column)this.property.getAnnotation(Column.class);
            Formula formulaAnn = AnnotationBinder.getOverridableAnnotation((XAnnotatedElement)this.property, Formula.class, this.buildingContext);
            this.columns = AnnotatedColumn.buildColumnFromAnnotation(new Column[]{ann}, formulaAnn, comment, this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        } else if (this.property.isAnnotationPresent(Columns.class)) {
            Columns anns = (Columns)this.property.getAnnotation(Columns.class);
            this.columns = AnnotatedColumn.buildColumnFromAnnotation(anns.columns(), null, comment, this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        }
        if (this.joinColumns == null && (this.property.isAnnotationPresent(ManyToOne.class) || this.property.isAnnotationPresent(OneToOne.class))) {
            this.joinColumns = this.buildDefaultJoinColumnsForXToOne(this.property, this.inferredData);
        } else if (this.joinColumns == null && (this.property.isAnnotationPresent(OneToMany.class) || this.property.isAnnotationPresent(ElementCollection.class))) {
            OneToMany oneToMany = (OneToMany)this.property.getAnnotation(OneToMany.class);
            String mappedBy = oneToMany != null ? oneToMany.mappedBy() : "";
            this.joinColumns = AnnotatedJoinColumn.buildJoinColumns(null, comment, mappedBy, this.entityBinder.getSecondaryTables(), this.propertyHolder, this.inferredData.getPropertyName(), this.buildingContext);
        } else if (this.joinColumns == null && this.property.isAnnotationPresent(Any.class)) {
            throw new AnnotationException("@Any requires an explicit @JoinColumn(s): " + BinderHelper.getPath(this.propertyHolder, this.inferredData));
        }
        if (this.columns == null && !this.property.isAnnotationPresent(ManyToMany.class)) {
            this.columns = AnnotatedColumn.buildColumnFromAnnotation(null, null, comment, this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        }
        if (this.nullability == Nullability.FORCED_NOT_NULL) {
            for (AnnotatedColumn col : this.columns) {
                col.forceNotNull();
            }
        }
        return this;
    }

    AnnotatedJoinColumn[] buildDefaultJoinColumnsForXToOne(XProperty property, PropertyData inferredData) {
        AnnotatedJoinColumn[] joinColumns;
        JoinTable joinTableAnn = this.propertyHolder.getJoinTable(property);
        Comment comment = (Comment)property.getAnnotation(Comment.class);
        if (joinTableAnn != null) {
            joinColumns = AnnotatedJoinColumn.buildJoinColumns(joinTableAnn.inverseJoinColumns(), comment, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData.getPropertyName(), this.buildingContext);
            if (StringHelper.isEmpty(joinTableAnn.name())) {
                throw new AnnotationException("JoinTable.name() on a @ToOne association has to be explicit: " + BinderHelper.getPath(this.propertyHolder, inferredData));
            }
        } else {
            OneToOne oneToOneAnn = (OneToOne)property.getAnnotation(OneToOne.class);
            String mappedBy = oneToOneAnn != null ? oneToOneAnn.mappedBy() : null;
            joinColumns = AnnotatedJoinColumn.buildJoinColumns(null, comment, mappedBy, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData.getPropertyName(), this.buildingContext);
        }
        return joinColumns;
    }

    AnnotatedJoinColumn[] buildExplicitJoinColumns(XProperty property, PropertyData inferredData) {
        JoinColumnsOrFormulas joinColumnsOrFormulasAnnotations;
        int length;
        JoinColumns joinColumnAnnotation;
        int length2;
        JoinColumn[] joinColumnAnnotations = null;
        if (property.isAnnotationPresent(JoinColumn.class)) {
            joinColumnAnnotations = new JoinColumn[]{(JoinColumn)property.getAnnotation(JoinColumn.class)};
        } else if (property.isAnnotationPresent(JoinColumns.class) && (length2 = (joinColumnAnnotations = (joinColumnAnnotation = (JoinColumns)property.getAnnotation(JoinColumns.class)).value()).length) == 0) {
            throw new AnnotationException("Cannot bind an empty @JoinColumns");
        }
        if (joinColumnAnnotations != null) {
            return AnnotatedJoinColumn.buildJoinColumns(joinColumnAnnotations, (Comment)property.getAnnotation(Comment.class), null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData.getPropertyName(), this.buildingContext);
        }
        JoinColumnOrFormula[] joinColumnOrFormulaAnnotations = null;
        if (property.isAnnotationPresent(JoinColumnOrFormula.class)) {
            joinColumnOrFormulaAnnotations = new JoinColumnOrFormula[]{(JoinColumnOrFormula)property.getAnnotation(JoinColumnOrFormula.class)};
        } else if (property.isAnnotationPresent(JoinColumnsOrFormulas.class) && (length = (joinColumnOrFormulaAnnotations = (joinColumnsOrFormulasAnnotations = (JoinColumnsOrFormulas)property.getAnnotation(JoinColumnsOrFormulas.class)).value()).length) == 0) {
            throw new AnnotationException("Cannot bind an empty @JoinColumnsOrFormulas");
        }
        if (joinColumnOrFormulaAnnotations != null) {
            return AnnotatedJoinColumn.buildJoinColumnsOrFormulas(joinColumnOrFormulaAnnotations, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData.getPropertyName(), this.buildingContext);
        }
        if (property.isAnnotationPresent(JoinFormula.class)) {
            JoinFormula ann = AnnotationBinder.getOverridableAnnotation((XAnnotatedElement)property, JoinFormula.class, this.buildingContext);
            AnnotatedJoinColumn[] annotatedJoinColumns = new AnnotatedJoinColumn[]{AnnotatedJoinColumn.buildJoinFormula(ann, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData.getPropertyName(), this.buildingContext)};
            return annotatedJoinColumns;
        }
        return null;
    }

    AnnotatedColumn[] overrideColumnFromMapperOrMapsIdProperty(boolean isId) {
        AnnotatedColumn[] result = this.columns;
        PropertyData overridingProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, this.propertyHolder, this.property.getName(), this.buildingContext);
        if (overridingProperty != null) {
            result = this.buildExcplicitOrDefaultJoinColumn(overridingProperty);
        }
        return result;
    }

    AnnotatedColumn[] buildExcplicitOrDefaultJoinColumn(PropertyData overridingProperty) {
        AnnotatedColumn[] result = this.buildExplicitJoinColumns(overridingProperty.getProperty(), overridingProperty);
        if (result == null) {
            result = this.buildDefaultJoinColumnsForXToOne(overridingProperty.getProperty(), overridingProperty);
        }
        return result;
    }
}

