/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventEngine;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.BindableType;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.spi.TypeConfiguration;

public class SessionFactoryDelegatingImpl
implements SessionFactoryImplementor,
SessionFactory {
    private final SessionFactoryImplementor delegate;

    public SessionFactoryDelegatingImpl(SessionFactoryImplementor delegate) {
        this.delegate = delegate;
    }

    protected SessionFactoryImplementor delegate() {
        return this.delegate;
    }

    @Override
    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.delegate.getSessionFactoryOptions();
    }

    @Override
    public SessionBuilderImplementor withOptions() {
        return this.delegate.withOptions();
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.delegate.openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        return this.delegate.getCurrentSession();
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return this.delegate.withStatelessOptions();
    }

    @Override
    public StatelessSession openStatelessSession() {
        return this.delegate.openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.delegate.openStatelessSession(connection);
    }

    @Override
    @Deprecated
    public ClassMetadata getClassMetadata(Class entityClass) {
        return this.delegate.getClassMetadata(entityClass);
    }

    @Override
    @Deprecated
    public ClassMetadata getClassMetadata(String entityName) {
        return this.delegate.getClassMetadata(entityName);
    }

    @Override
    @Deprecated
    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.delegate.getCollectionMetadata(roleName);
    }

    @Override
    public StatisticsImplementor getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public RuntimeMetamodelsImplementor getRuntimeMetamodels() {
        return this.delegate.getRuntimeMetamodels();
    }

    @Override
    public EventEngine getEventEngine() {
        return this.delegate.getEventEngine();
    }

    @Override
    public void close() throws HibernateException {
        this.delegate.close();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public CacheImplementor getCache() {
        return this.delegate.getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.delegate.getPersistenceUnitUtil();
    }

    public void addNamedQuery(String name, Query query) {
        this.delegate.addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.delegate.unwrap(cls);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.delegate.addNamedEntityGraph(graphName, entityGraph);
    }

    @Override
    public Set<String> getDefinedFilterNames() {
        return this.delegate.getDefinedFilterNames();
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.delegate.getFilterDefinition(filterName);
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.delegate.containsFetchProfileDefinition(name);
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.delegate.getIdentifierGenerator(rootEntityName);
    }

    public Map<String, Object> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.delegate.getJdbcServices();
    }

    @Override
    public SqlStringGenerationContext getSqlStringGenerationContext() {
        return this.delegate.getSqlStringGenerationContext();
    }

    @Override
    public RootGraphImplementor<?> findEntityGraphByName(String name) {
        return this.delegate.findEntityGraphByName(name);
    }

    @Override
    public String bestGuessEntityName(Object object) {
        return this.delegate.bestGuessEntityName(object);
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        return this.delegate.openTemporarySession();
    }

    @Deprecated
    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.delegate.getRuntimeMetamodels().getMappingMetamodel().getCollectionRolesByEntityParticipant(entityName);
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.delegate.getEntityNotFoundDelegate();
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.delegate.getFetchProfile(name);
    }

    @Override
    public JpaMetamodelImplementor getJpaMetamodel() {
        return this.delegate.getJpaMetamodel();
    }

    @Override
    public ServiceRegistryImplementor getServiceRegistry() {
        return this.delegate.getServiceRegistry();
    }

    @Override
    public Integer getMaximumFetchDepth() {
        return this.delegate.getMaximumFetchDepth();
    }

    @Override
    public void addObserver(SessionFactoryObserver observer) {
        this.delegate.addObserver(observer);
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.delegate.getCustomEntityDirtinessStrategy();
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.delegate.getCurrentTenantIdentifierResolver();
    }

    @Override
    public FastSessionServices getFastSessionServices() {
        return this.delegate.getFastSessionServices();
    }

    @Override
    public SessionFactoryImplementor.DeserializationResolver getDeserializationResolver() {
        return this.delegate.getDeserializationResolver();
    }

    @Override
    public Type getIdentifierType(String className) throws MappingException {
        return this.delegate.getIdentifierType(className);
    }

    @Override
    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.delegate.getIdentifierPropertyName(className);
    }

    @Override
    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.delegate.getReferencedPropertyType(className, propertyName);
    }

    @Override
    public String getUuid() {
        return this.delegate.getUuid();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.delegate.getTypeConfiguration();
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.delegate.getQueryEngine();
    }

    @Override
    public Reference getReference() throws NamingException {
        return this.delegate.getReference();
    }

    public EntityManager createEntityManager() {
        return this.delegate.createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.delegate.createEntityManager(map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.delegate.createEntityManager(synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.delegate.createEntityManager(synchronizationType, map);
    }

    @Override
    public HibernateCriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }

    @Override
    @Deprecated
    public MetamodelImplementor getMetamodel() {
        return this.delegate.getMetamodel();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public <T> BindableType<? extends T> resolveParameterBindType(T bindValue) {
        return this.delegate.resolveParameterBindType(bindValue);
    }

    @Override
    public <T> BindableType<T> resolveParameterBindType(Class<T> clazz) {
        return this.delegate.resolveParameterBindType(clazz);
    }

    @Override
    public WrapperOptions getWrapperOptions() {
        return this.delegate.getWrapperOptions();
    }

    @Override
    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.delegate.findEntityGraphsByType(entityClass);
    }
}

