/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.Cache;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityNameResolver;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.cfg.internal.DomainDataRegionConfigImpl;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.context.internal.JTASessionContext;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.event.spi.EventEngine;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoordinatingEntityNameResolver;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryObserverChain;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.SessionOwnerBehavior;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.internal.ExceptionMapperLegacyJpaImpl;
import org.hibernate.jpa.internal.PersistenceUnitUtilImpl;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.internal.RuntimeMetamodelsImpl;
import org.hibernate.metamodel.model.domain.internal.MappingMetamodelImpl;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.SessionFactoryBasedWrapperOptions;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.BindableType;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ExceptionMapper;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tool.schema.spi.DelayedDropAction;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SessionFactoryImpl
implements SessionFactoryImplementor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SessionFactoryImpl.class);
    private final String name;
    private final String uuid;
    private volatile transient Status status = Status.OPEN;
    private final transient SessionFactoryObserverChain observer = new SessionFactoryObserverChain();
    private final transient SessionFactoryOptions sessionFactoryOptions;
    private final transient Map<String, Object> properties;
    private final transient SessionFactoryServiceRegistry serviceRegistry;
    private final transient EventEngine eventEngine;
    private final transient JdbcServices jdbcServices;
    private final transient SqlStringGenerationContext sqlStringGenerationContext;
    private final transient RuntimeMetamodelsImplementor runtimeMetamodels;
    private final PersistenceUnitUtil jpaPersistenceUnitUtil;
    private final transient CacheImplementor cacheAccess;
    private final transient QueryEngine queryEngine;
    private final transient CurrentSessionContext currentSessionContext;
    private volatile DelayedDropAction delayedDropAction;
    private final transient Map<String, IdentifierGenerator> identifierGenerators;
    private final transient Map<String, FilterDefinition> filters;
    private final transient Map<String, FetchProfile> fetchProfiles;
    private final transient FastSessionServices fastSessionServices;
    private final transient WrapperOptions wrapperOptions;
    private final transient SessionBuilder defaultSessionOpenOptions;
    private final transient SessionBuilder temporarySessionOpenOptions;
    private final transient StatelessSessionBuilder defaultStatelessOptions;
    private final transient EntityNameResolver entityNameResolver;
    private transient StatisticsImplementor statistics;

    public SessionFactoryImpl(MetadataImplementor bootMetamodel, SessionFactoryOptions options) {
        LOG.debug("Building session factory");
        TypeConfiguration typeConfiguration = bootMetamodel.getTypeConfiguration();
        MetadataBuildingContext bootModelBuildingContext = typeConfiguration.getMetadataBuildingContext();
        BootstrapContext bootstrapContext = bootModelBuildingContext.getBootstrapContext();
        this.sessionFactoryOptions = options;
        this.serviceRegistry = options.getServiceRegistry().getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry(this, options);
        this.eventEngine = new EventEngine(bootMetamodel, this);
        bootMetamodel.initSessionFactory(this);
        CfgXmlAccessService cfgXmlAccessService = this.serviceRegistry.getService(CfgXmlAccessService.class);
        String sfName = this.sessionFactoryOptions.getSessionFactoryName();
        if (cfgXmlAccessService.getAggregatedConfig() != null && sfName == null) {
            sfName = cfgXmlAccessService.getAggregatedConfig().getSessionFactoryName();
        }
        this.name = sfName;
        this.uuid = options.getUuid();
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        ConfigurationService configurationService = this.serviceRegistry.getService(ConfigurationService.class);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(configurationService.getSettings());
        if (!this.properties.containsKey("javax.persistence.validation.factory") && !this.properties.containsKey("jakarta.persistence.validation.factory") && this.getSessionFactoryOptions().getValidatorFactoryReference() != null) {
            this.properties.put("javax.persistence.validation.factory", this.getSessionFactoryOptions().getValidatorFactoryReference());
            this.properties.put("jakarta.persistence.validation.factory", this.getSessionFactoryOptions().getValidatorFactoryReference());
        }
        this.maskOutSensitiveInformation(this.properties);
        this.logIfEmptyCompositesEnabled(this.properties);
        this.sqlStringGenerationContext = SqlStringGenerationContextImpl.fromExplicit(this.jdbcServices.getJdbcEnvironment(), bootMetamodel.getDatabase(), options.getDefaultCatalog(), options.getDefaultSchema());
        this.cacheAccess = this.serviceRegistry.getService(CacheImplementor.class);
        this.jpaPersistenceUnitUtil = new PersistenceUnitUtilImpl(this);
        for (SessionFactoryObserver sessionFactoryObserver : options.getSessionFactoryObservers()) {
            this.observer.addObserver(sessionFactoryObserver);
        }
        this.filters = new HashMap<String, FilterDefinition>();
        this.filters.putAll(bootMetamodel.getFilterDefinitions());
        LOG.debugf("Session factory constructed with filter configurations : %s", this.filters);
        LOG.debugf("Instantiating session factory with properties: %s", this.properties);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private final ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
                this.integrators.clear();
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        try {
            Map<String, HibernateException> errors;
            for (Integrator integrator : this.serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
                integrator.integrate((Metadata)bootMetamodel, bootstrapContext, this);
                integratorObserver.integrators.add(integrator);
            }
            this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
            bootMetamodel.getEntityBindings().stream().filter(model -> !model.isInherited()).forEach(model -> {
                IdentifierGenerator generator = model.getIdentifier().createIdentifierGenerator(bootstrapContext.getIdentifierGeneratorFactory(), this.jdbcServices.getJdbcEnvironment().getDialect(), (RootClass)model);
                generator.initialize(this.sqlStringGenerationContext);
                this.identifierGenerators.put(model.getEntityName(), generator);
            });
            bootMetamodel.validate();
            LOG.debug("Instantiated session factory");
            this.primeSecondLevelCacheRegions(bootMetamodel);
            this.queryEngine = QueryEngine.from(this, bootMetamodel);
            RuntimeMetamodelsImpl runtimeMetamodels = new RuntimeMetamodelsImpl();
            this.runtimeMetamodels = runtimeMetamodels;
            runtimeMetamodels.finishInitialization(bootMetamodel, bootstrapContext, this);
            this.queryEngine.prepare(this, bootMetamodel, bootstrapContext);
            if (options.isNamedQueryStartupCheckingEnabled() && !(errors = this.queryEngine.getNamedObjectRepository().checkNamedQueries(this.queryEngine)).isEmpty()) {
                StringBuilder failingQueries = new StringBuilder("Errors in named queries: ");
                String sep = "";
                for (Map.Entry<String, HibernateException> entry : errors.entrySet()) {
                    QueryLogging.QUERY_MESSAGE_LOGGER.namedQueryError(entry.getKey(), entry.getValue());
                    failingQueries.append(sep).append(entry.getKey());
                    sep = ", ";
                }
                HibernateException exception = new HibernateException(failingQueries.toString());
                errors.values().forEach(arg_0 -> exception.addSuppressed(arg_0));
                throw exception;
            }
            SchemaManagementToolCoordinator.process(bootMetamodel, this.serviceRegistry, this.properties, action -> {
                this.delayedDropAction = action;
            });
            this.currentSessionContext = this.buildCurrentSessionContext();
            this.fetchProfiles = new HashMap<String, FetchProfile>();
            for (org.hibernate.mapping.FetchProfile mappingProfile : bootMetamodel.getFetchProfiles()) {
                FetchProfile fetchProfile = new FetchProfile(mappingProfile.getName());
                for (FetchProfile.Fetch mappingFetch : mappingProfile.getFetches()) {
                    EntityPersister owner;
                    String entityName = this.runtimeMetamodels.getImportedName(mappingFetch.getEntity());
                    EntityPersister entityPersister = owner = entityName == null ? null : this.runtimeMetamodels.getMappingMetamodel().getEntityDescriptor(entityName);
                    if (owner == null) {
                        throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
                    }
                    Type associationType = owner.getPropertyType(mappingFetch.getAssociation());
                    if (associationType == null || !associationType.isAssociationType()) {
                        throw new HibernateException("Fetch profile [" + fetchProfile.getName() + "] specified an invalid association");
                    }
                    Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
                    fetchProfile.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
                    ((Loadable)owner).registerAffectingFetchProfile(fetchProfile.getName());
                }
                this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
            }
            this.defaultSessionOpenOptions = this.createDefaultSessionOpenOptionsIfPossible();
            this.temporarySessionOpenOptions = this.defaultSessionOpenOptions == null ? null : this.buildTemporarySessionOpenOptions();
            this.defaultStatelessOptions = this.defaultSessionOpenOptions == null ? null : this.withStatelessOptions();
            this.fastSessionServices = new FastSessionServices(this);
            this.wrapperOptions = new SessionFactoryBasedWrapperOptions(this);
            this.observer.sessionFactoryCreated(this);
            SessionFactoryRegistry.INSTANCE.addSessionFactory(this.getUuid(), this.name, this.sessionFactoryOptions.isSessionFactoryNameAlsoJndiName(), this, this.serviceRegistry.getService(JndiService.class));
            bootMetamodel.getMetadataBuildingOptions().getReflectionManager().reset();
            this.entityNameResolver = new CoordinatingEntityNameResolver(this, this.getInterceptor());
        }
        catch (Exception e) {
            for (Integrator integrator : this.serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
                integrator.disintegrate(this, this.serviceRegistry);
                integratorObserver.integrators.remove(integrator);
                this.serviceRegistry.close();
            }
            try {
                this.close();
            }
            catch (Exception closeException) {
                LOG.debugf("Eating error closing SF on failed attempt to start it", new Object[0]);
            }
            throw e;
        }
    }

    private SessionBuilder createDefaultSessionOpenOptionsIfPossible() {
        CurrentTenantIdentifierResolver currentTenantIdentifierResolver = this.getCurrentTenantIdentifierResolver();
        if (currentTenantIdentifierResolver == null) {
            return this.withOptions();
        }
        return null;
    }

    private SessionBuilder buildTemporarySessionOpenOptions() {
        return this.withOptions().autoClose(false).flushMode(FlushMode.MANUAL).connectionHandlingMode(PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_STATEMENT);
    }

    private void primeSecondLevelCacheRegions(MetadataImplementor mappingMetadata) {
        Set<DomainDataRegionConfig> regionConfigs;
        AccessType accessType;
        ConcurrentHashMap<String, DomainDataRegionConfigImpl.Builder> regionConfigBuilders = new ConcurrentHashMap<String, DomainDataRegionConfigImpl.Builder>();
        for (PersistentClass bootEntityDescriptor : mappingMetadata.getEntityBindings()) {
            accessType = AccessType.fromExternalName(bootEntityDescriptor.getCacheConcurrencyStrategy());
            if (accessType == null) continue;
            if (bootEntityDescriptor.isCached()) {
                regionConfigBuilders.computeIfAbsent(bootEntityDescriptor.getRootClass().getCacheRegionName(), DomainDataRegionConfigImpl.Builder::new).addEntityConfig(bootEntityDescriptor, accessType);
            }
            if (!(bootEntityDescriptor instanceof RootClass) || !bootEntityDescriptor.hasNaturalId() || bootEntityDescriptor.getNaturalIdCacheRegionName() == null) continue;
            regionConfigBuilders.computeIfAbsent(bootEntityDescriptor.getNaturalIdCacheRegionName(), DomainDataRegionConfigImpl.Builder::new).addNaturalIdConfig((RootClass)bootEntityDescriptor, accessType);
        }
        for (Collection collection : mappingMetadata.getCollectionBindings()) {
            accessType = AccessType.fromExternalName(collection.getCacheConcurrencyStrategy());
            if (accessType == null) continue;
            regionConfigBuilders.computeIfAbsent(collection.getCacheRegionName(), DomainDataRegionConfigImpl.Builder::new).addCollectionConfig(collection, accessType);
        }
        if (regionConfigBuilders.isEmpty()) {
            regionConfigs = Collections.emptySet();
        } else {
            regionConfigs = new HashSet();
            for (DomainDataRegionConfigImpl.Builder builder : regionConfigBuilders.values()) {
                regionConfigs.add(builder.build());
            }
        }
        this.getCache().prime(regionConfigs);
    }

    @Override
    public Session openSession() throws HibernateException {
        if (this.defaultSessionOpenOptions != null) {
            return this.defaultSessionOpenOptions.openSession();
        }
        return this.withOptions().openSession();
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        if (this.temporarySessionOpenOptions != null) {
            return this.temporarySessionOpenOptions.openSession();
        }
        return this.buildTemporarySessionOpenOptions().openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public SessionBuilderImplementor withOptions() {
        return new SessionBuilderImpl(this);
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return new StatelessSessionBuilderImpl(this);
    }

    @Override
    public StatelessSession openStatelessSession() {
        if (this.defaultStatelessOptions != null) {
            return this.defaultStatelessOptions.openStatelessSession();
        }
        return this.withStatelessOptions().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.withStatelessOptions().connection(connection).openStatelessSession();
    }

    @Override
    public void addObserver(SessionFactoryObserver observer) {
        this.observer.addObserver(observer);
    }

    public Map<String, Object> getProperties() {
        this.validateNotClosed();
        return this.properties;
    }

    protected void validateNotClosed() {
        if (this.status == Status.CLOSED) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.runtimeMetamodels.getMappingMetamodel().getTypeConfiguration();
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public EventEngine getEventEngine() {
        return this.eventEngine;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public SqlStringGenerationContext getSqlStringGenerationContext() {
        return this.sqlStringGenerationContext;
    }

    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    @Override
    public SessionFactoryImplementor.DeserializationResolver getDeserializationResolver() {
        return () -> SessionFactoryRegistry.INSTANCE.findSessionFactory(this.uuid, this.name);
    }

    @Override
    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.getJpaMetamodel().findEntityGraphsByJavaType(entityClass);
    }

    public Session createEntityManager() {
        this.validateNotClosed();
        return this.buildEntityManager(SynchronizationType.SYNCHRONIZED, null);
    }

    private <K, V> Session buildEntityManager(SynchronizationType synchronizationType, Map<K, V> map) {
        assert (this.status != Status.CLOSED);
        SessionBuilderImplementor builder = this.withOptions();
        builder.autoJoinTransactions(synchronizationType == SynchronizationType.SYNCHRONIZED);
        Session session = builder.openSession();
        if (map != null) {
            for (Map.Entry<K, V> o : map.entrySet()) {
                K key = o.getKey();
                if (!(key instanceof String)) continue;
                String sKey = (String)key;
                session.setProperty(sKey, o.getValue());
            }
        }
        return session;
    }

    public Session createEntityManager(Map map) {
        this.validateNotClosed();
        return this.buildEntityManager(SynchronizationType.SYNCHRONIZED, map);
    }

    public Session createEntityManager(SynchronizationType synchronizationType) {
        this.validateNotClosed();
        this.errorIfResourceLocalDueToExplicitSynchronizationType();
        return this.buildEntityManager(synchronizationType, null);
    }

    private void errorIfResourceLocalDueToExplicitSynchronizationType() {
        if (!this.getServiceRegistry().getService(TransactionCoordinatorBuilder.class).isJta()) {
            throw new IllegalStateException("Illegal attempt to specify a SynchronizationType when building an EntityManager from an EntityManagerFactory defined as RESOURCE_LOCAL (as opposed to JTA)");
        }
    }

    public Session createEntityManager(SynchronizationType synchronizationType, Map map) {
        this.validateNotClosed();
        this.errorIfResourceLocalDueToExplicitSynchronizationType();
        return this.buildEntityManager(synchronizationType, map);
    }

    @Override
    public NodeBuilder getCriteriaBuilder() {
        this.validateNotClosed();
        return this.queryEngine.getCriteriaBuilder();
    }

    @Override
    public MetamodelImplementor getMetamodel() {
        this.validateNotClosed();
        return (MetamodelImplementor)((Object)this.runtimeMetamodels.getMappingMetamodel());
    }

    public boolean isOpen() {
        return this.status != Status.CLOSED;
    }

    @Override
    public RootGraphImplementor<?> findEntityGraphByName(String name) {
        return this.getJpaMetamodel().findEntityGraphByName(name);
    }

    @Override
    public String bestGuessEntityName(Object object) {
        if (object instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (initializer.isUninitialized()) {
                return initializer.getEntityName();
            }
            object = initializer.getImplementation();
        }
        return this.entityNameResolver.resolveEntityName(object);
    }

    @Override
    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.sessionFactoryOptions;
    }

    public Interceptor getInterceptor() {
        return this.sessionFactoryOptions.getInterceptor();
    }

    @Override
    public Reference getReference() {
        LOG.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.getUuid()), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    @Override
    public Type getIdentifierType(String className) throws MappingException {
        return this.runtimeMetamodels.getMappingMetamodel().getEntityDescriptor(className).getIdentifierType();
    }

    @Override
    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.runtimeMetamodels.getMappingMetamodel().getEntityDescriptor(className).getIdentifierPropertyName();
    }

    @Override
    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getClassMetadata(persistentClass.getName());
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return (CollectionMetadata)((Object)this.runtimeMetamodels.getMappingMetamodel().getCollectionDescriptor(roleName));
    }

    @Override
    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return (ClassMetadata)((Object)this.runtimeMetamodels.getMappingMetamodel().getEntityDescriptor(entityName));
    }

    @Override
    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.runtimeMetamodels.getMappingMetamodel().getEntityDescriptor(className).getPropertyType(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HibernateException {
        SessionFactoryImpl sessionFactoryImpl = this;
        synchronized (sessionFactoryImpl) {
            if (this.status != Status.OPEN) {
                if (this.getSessionFactoryOptions().getJpaCompliance().isJpaClosedComplianceEnabled()) {
                    throw new IllegalStateException("EntityManagerFactory is already closed");
                }
                LOG.trace("Already closed");
                return;
            }
            this.status = Status.CLOSING;
        }
        try {
            LOG.closing();
            this.observer.sessionFactoryClosing(this);
            if (this.cacheAccess != null) {
                this.cacheAccess.close();
            }
            if (this.runtimeMetamodels != null && this.runtimeMetamodels.getMappingMetamodel() != null) {
                JdbcConnectionAccess jdbcConnectionAccess = this.jdbcServices.getBootstrapJdbcConnectionAccess();
                this.runtimeMetamodels.getMappingMetamodel().forEachEntityDescriptor(entityPersister -> {
                    if (entityPersister.getSqmMultiTableMutationStrategy() != null) {
                        entityPersister.getSqmMultiTableMutationStrategy().release(this, jdbcConnectionAccess);
                    }
                    if (entityPersister.getSqmMultiTableInsertStrategy() != null) {
                        entityPersister.getSqmMultiTableInsertStrategy().release(this, jdbcConnectionAccess);
                    }
                });
                ((MappingMetamodelImpl)this.runtimeMetamodels.getMappingMetamodel()).close();
            }
            if (this.queryEngine != null) {
                this.queryEngine.close();
            }
            if (this.delayedDropAction != null) {
                this.delayedDropAction.perform(this.serviceRegistry);
            }
            SessionFactoryRegistry.INSTANCE.removeSessionFactory(this.getUuid(), this.name, this.sessionFactoryOptions.isSessionFactoryNameAlsoJndiName(), this.serviceRegistry.getService(JndiService.class));
        }
        finally {
            this.status = Status.CLOSED;
        }
        this.observer.sessionFactoryClosed(this);
        this.serviceRegistry.destroy();
    }

    @Override
    public CacheImplementor getCache() {
        this.validateNotClosed();
        return this.cacheAccess;
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        this.validateNotClosed();
        return this.jpaPersistenceUnitUtil;
    }

    public void addNamedQuery(String name, Query query) {
        this.validateNotClosed();
        NamedObjectRepository namedObjectRepository = this.getQueryEngine().getNamedObjectRepository();
        try {
            ProcedureCallImplementor unwrapped = (ProcedureCallImplementor)query.unwrap(ProcedureCallImplementor.class);
            if (unwrapped != null) {
                namedObjectRepository.registerCallableQueryMemento(name, unwrapped.toMemento(name));
                return;
            }
        }
        catch (PersistenceException unwrapped) {
            // empty catch block
        }
        try {
            QueryImplementor hibernateQuery = (QueryImplementor)query.unwrap(QueryImplementor.class);
            if (hibernateQuery != null) {
                if (hibernateQuery instanceof NativeQueryImplementor) {
                    namedObjectRepository.registerNativeQueryMemento(name, ((NativeQueryImplementor)hibernateQuery).toMemento(name));
                } else {
                    namedObjectRepository.registerHqlQueryMemento(name, ((SqmQueryImplementor)hibernateQuery).toMemento(name));
                }
                return;
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        throw new PersistenceException(String.format("Unsure how to properly unwrap given Query [%s] as basis for named query", query));
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(SessionFactory.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(SessionFactoryImplementor.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(SessionFactoryImpl.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(EntityManagerFactory.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(SessionFactoryServiceRegistry.class)) {
            return type.cast(this.serviceRegistry);
        }
        if (type.isAssignableFrom(JdbcServices.class)) {
            return type.cast(this.jdbcServices);
        }
        if (type.isAssignableFrom(jakarta.persistence.Cache.class) || type.isAssignableFrom(Cache.class)) {
            return type.cast(this.cacheAccess);
        }
        if (type.isInstance(this.runtimeMetamodels)) {
            return type.cast(this.runtimeMetamodels);
        }
        if (type.isInstance(this.runtimeMetamodels.getJpaMetamodel())) {
            return type.cast(this.runtimeMetamodels.getJpaMetamodel());
        }
        if (type.isAssignableFrom(MetamodelImplementor.class) || type.isAssignableFrom(MetadataImplementor.class)) {
            return type.cast(this.runtimeMetamodels.getMappingMetamodel());
        }
        if (type.isAssignableFrom(QueryEngine.class)) {
            return type.cast(this.queryEngine);
        }
        throw new PersistenceException("Hibernate cannot unwrap EntityManagerFactory as '" + type.getName() + "'");
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.getMappingMetamodel().addNamedEntityGraph(graphName, (RootGraphImplementor)entityGraph);
    }

    @Override
    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    @Override
    public StatisticsImplementor getStatistics() {
        if (this.statistics == null) {
            this.statistics = this.serviceRegistry.getService(StatisticsImplementor.class);
        }
        return this.statistics;
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        FilterDefinition def = this.filters.get(filterName);
        if (def == null) {
            throw new HibernateException("No such filter configured [" + filterName + "]");
        }
        return def;
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.fetchProfiles.containsKey(name);
    }

    @Override
    public Set<String> getDefinedFilterNames() {
        return this.filters.keySet();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.identifierGenerators.get(rootEntityName);
    }

    private boolean canAccessTransactionManager() {
        try {
            return this.serviceRegistry.getService(JtaPlatform.class).retrieveTransactionManager() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String impl = (String)this.properties.get("hibernate.current_session_context_class");
        if (impl == null) {
            if (this.canAccessTransactionManager()) {
                impl = "jta";
            } else {
                return null;
            }
        }
        switch (impl) {
            case "jta": {
                return new JTASessionContext(this);
            }
            case "thread": {
                return new ThreadLocalSessionContext(this);
            }
            case "managed": {
                return new ManagedSessionContext(this);
            }
        }
        try {
            Class implClass = this.serviceRegistry.getService(ClassLoaderService.class).classForName(impl);
            return (CurrentSessionContext)implClass.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            LOG.unableToConstructCurrentSessionContext(impl, t);
            return null;
        }
    }

    @Override
    public RuntimeMetamodelsImplementor getRuntimeMetamodels() {
        return this.runtimeMetamodels;
    }

    @Override
    public JpaMetamodelImplementor getJpaMetamodel() {
        return this.runtimeMetamodels.getJpaMetamodel();
    }

    @Override
    public Integer getMaximumFetchDepth() {
        return this.getSessionFactoryOptions().getMaximumFetchDepth();
    }

    @Override
    public ServiceRegistryImplementor getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.sessionFactoryOptions.getEntityNotFoundDelegate();
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfiles.get(name);
    }

    @Override
    public <T> BindableType<? extends T> resolveParameterBindType(T bindValue) {
        Class<?> clazz;
        if (bindValue == null) {
            return null;
        }
        if (bindValue instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)bindValue;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            clazz = li.getPersistentClass();
        } else {
            clazz = bindValue.getClass();
        }
        Class<?> c = clazz;
        return this.resolveParameterBindType(c);
    }

    @Override
    public <T> BindableType<T> resolveParameterBindType(Class<T> javaType) {
        return this.getRuntimeMetamodels().getMappingMetamodel().resolveQueryParameterType(javaType);
    }

    @Deprecated
    public static Interceptor configuredInterceptor(Interceptor interceptor, SessionFactoryOptions options) {
        return SessionFactoryImpl.configuredInterceptor(interceptor, false, options);
    }

    public static Interceptor configuredInterceptor(Interceptor interceptor, boolean explicitNoInterceptor, SessionFactoryOptions options) {
        if (interceptor != null && interceptor != EmptyInterceptor.INSTANCE) {
            return interceptor;
        }
        Interceptor optionsInterceptor = options.getInterceptor();
        if (optionsInterceptor != null && optionsInterceptor != EmptyInterceptor.INSTANCE) {
            return optionsInterceptor;
        }
        if (explicitNoInterceptor) {
            return null;
        }
        Class<? extends Interceptor> statelessInterceptorImplementor = options.getStatelessInterceptorImplementor();
        Supplier<? extends Interceptor> statelessInterceptorImplementorSupplier = options.getStatelessInterceptorImplementorSupplier();
        if (statelessInterceptorImplementor != null && statelessInterceptorImplementorSupplier != null) {
            throw new HibernateException("A session scoped interceptor class or supplier are allowed, but not both!");
        }
        if (statelessInterceptorImplementor != null) {
            try {
                return statelessInterceptorImplementor.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new HibernateException("Could not supply session-scoped SessionFactory Interceptor", e);
            }
        }
        if (statelessInterceptorImplementorSupplier != null) {
            return statelessInterceptorImplementorSupplier.get();
        }
        return null;
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.getSessionFactoryOptions().getCustomEntityDirtinessStrategy();
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.getSessionFactoryOptions().getCurrentTenantIdentifierResolver();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Serializing: %s", this.getUuid());
        }
        out.defaultWriteObject();
        LOG.trace("Serialized");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing");
        in.defaultReadObject();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Deserialized: %s", this.getUuid());
        }
    }

    private Object readResolve() throws InvalidObjectException {
        LOG.trace("Resolving serialized SessionFactory");
        return SessionFactoryImpl.locateSessionFactoryOnDeserialization(this.getUuid(), this.name);
    }

    private static SessionFactory locateSessionFactoryOnDeserialization(String uuid, String name) throws InvalidObjectException {
        SessionFactoryImplementor namedResult;
        SessionFactoryImplementor uuidResult = SessionFactoryRegistry.INSTANCE.getSessionFactory(uuid);
        if (uuidResult != null) {
            LOG.debugf("Resolved SessionFactory by UUID [%s]", uuid);
            return uuidResult;
        }
        if (name != null && (namedResult = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(name)) != null) {
            LOG.debugf("Resolved SessionFactory by name [%s]", name);
            return namedResult;
        }
        throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + uuid + ",name=" + name + "]");
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.getUuid());
        oos.writeBoolean(this.name != null);
        if (this.name != null) {
            oos.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream ois) throws IOException {
        LOG.trace("Deserializing SessionFactory from Session");
        String uuid = ois.readUTF();
        boolean isNamed = ois.readBoolean();
        String name = isNamed ? ois.readUTF() : null;
        return (SessionFactoryImpl)SessionFactoryImpl.locateSessionFactoryOnDeserialization(uuid, name);
    }

    private void maskOutSensitiveInformation(Map<String, Object> props) {
        this.maskOutIfSet(props, "javax.persistence.jdbc.user");
        this.maskOutIfSet(props, "javax.persistence.jdbc.password");
        this.maskOutIfSet(props, "jakarta.persistence.jdbc.user");
        this.maskOutIfSet(props, "jakarta.persistence.jdbc.password");
        this.maskOutIfSet(props, "hibernate.connection.username");
        this.maskOutIfSet(props, "hibernate.connection.password");
    }

    private void maskOutIfSet(Map<String, Object> props, String setting) {
        if (props.containsKey(setting)) {
            props.put(setting, "****");
        }
    }

    private void logIfEmptyCompositesEnabled(Map<String, Object> props) {
        boolean isEmptyCompositesEnabled = ConfigurationHelper.getBoolean("hibernate.create_empty_composites.enabled", props, false);
        if (isEmptyCompositesEnabled) {
            LOG.emptyCompositesEnabled();
        }
    }

    @Override
    public FastSessionServices getFastSessionServices() {
        return this.fastSessionServices;
    }

    @Override
    public WrapperOptions getWrapperOptions() {
        return this.wrapperOptions;
    }

    private static enum Status {
        OPEN,
        CLOSING,
        CLOSED;

    }

    public static class StatelessSessionBuilderImpl
    implements StatelessSessionBuilder,
    SessionCreationOptions {
        private final SessionFactoryImpl sessionFactory;
        private Connection connection;
        private String tenantIdentifier;

        public StatelessSessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            CurrentTenantIdentifierResolver tenantIdentifierResolver = sessionFactory.getCurrentTenantIdentifierResolver();
            if (tenantIdentifierResolver != null) {
                this.tenantIdentifier = tenantIdentifierResolver.resolveCurrentTenantIdentifier();
            }
        }

        @Override
        public StatelessSession openStatelessSession() {
            return new StatelessSessionImpl(this.sessionFactory, this);
        }

        public StatelessSessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public StatelessSessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        @Override
        public boolean shouldAutoJoinTransactions() {
            return true;
        }

        @Override
        public FlushMode getInitialSessionFlushMode() {
            return FlushMode.ALWAYS;
        }

        @Override
        public boolean shouldAutoClose() {
            return false;
        }

        @Override
        public boolean shouldAutoClear() {
            return false;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public Interceptor getInterceptor() {
            return SessionFactoryImpl.configuredInterceptor(EmptyInterceptor.INSTANCE, false, this.sessionFactory.getSessionFactoryOptions());
        }

        @Override
        public StatementInspector getStatementInspector() {
            return null;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.sessionFactory.getSessionFactoryOptions().getPhysicalConnectionHandlingMode();
        }

        @Override
        public String getTenantIdentifier() {
            return this.tenantIdentifier;
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.sessionFactory.getSessionFactoryOptions().getJdbcTimeZone();
        }

        @Override
        public List<SessionEventListener> getCustomSessionEventListener() {
            return null;
        }

        @Override
        public ExceptionMapper getExceptionMapper() {
            return null;
        }
    }

    public static class SessionBuilderImpl<T extends SessionBuilder>
    implements SessionBuilderImplementor<T>,
    SessionCreationOptions {
        private static final Logger log = CoreLogging.logger(SessionBuilderImpl.class);
        private final SessionFactoryImpl sessionFactory;
        private Interceptor interceptor;
        private StatementInspector statementInspector;
        private Connection connection;
        private PhysicalConnectionHandlingMode connectionHandlingMode;
        private boolean autoJoinTransactions = true;
        private FlushMode flushMode;
        private boolean autoClose;
        private boolean autoClear;
        private String tenantIdentifier;
        private TimeZone jdbcTimeZone;
        private boolean explicitNoInterceptor;
        private List<SessionEventListener> listeners;
        private SessionOwnerBehavior sessionOwnerBehavior = SessionOwnerBehavior.LEGACY_NATIVE;

        public SessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
            this.statementInspector = sessionFactoryOptions.getStatementInspector();
            this.connectionHandlingMode = sessionFactoryOptions.getPhysicalConnectionHandlingMode();
            this.autoClose = sessionFactoryOptions.isAutoCloseSessionEnabled();
            CurrentTenantIdentifierResolver currentTenantIdentifierResolver = sessionFactory.getCurrentTenantIdentifierResolver();
            if (currentTenantIdentifierResolver != null) {
                this.tenantIdentifier = currentTenantIdentifierResolver.resolveCurrentTenantIdentifier();
            }
            this.jdbcTimeZone = sessionFactoryOptions.getJdbcTimeZone();
        }

        @Override
        public ExceptionMapper getExceptionMapper() {
            return this.sessionOwnerBehavior == SessionOwnerBehavior.LEGACY_JPA ? ExceptionMapperLegacyJpaImpl.INSTANCE : null;
        }

        @Override
        public boolean shouldAutoJoinTransactions() {
            return this.autoJoinTransactions;
        }

        @Override
        public FlushMode getInitialSessionFlushMode() {
            return this.flushMode;
        }

        @Override
        public boolean shouldAutoClose() {
            return this.autoClose;
        }

        @Override
        public boolean shouldAutoClear() {
            return this.autoClear;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public Interceptor getInterceptor() {
            return SessionFactoryImpl.configuredInterceptor(this.interceptor, this.explicitNoInterceptor, this.sessionFactory.getSessionFactoryOptions());
        }

        @Override
        public StatementInspector getStatementInspector() {
            return this.statementInspector;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.connectionHandlingMode;
        }

        @Override
        public String getTenantIdentifier() {
            return this.tenantIdentifier;
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.jdbcTimeZone;
        }

        @Override
        public List<SessionEventListener> getCustomSessionEventListener() {
            return this.listeners;
        }

        @Override
        public Session openSession() {
            log.tracef("Opening Hibernate Session.  tenant=%s", (Object)this.tenantIdentifier);
            return new SessionImpl(this.sessionFactory, this);
        }

        private T getThis() {
            return (T)this;
        }

        @Override
        public T interceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
            this.explicitNoInterceptor = false;
            return this.getThis();
        }

        @Override
        public T noInterceptor() {
            this.interceptor = EmptyInterceptor.INSTANCE;
            this.explicitNoInterceptor = true;
            return this.getThis();
        }

        @Override
        public T statementInspector(StatementInspector statementInspector) {
            this.statementInspector = statementInspector;
            return this.getThis();
        }

        @Override
        public T connection(Connection connection) {
            this.connection = connection;
            return this.getThis();
        }

        @Override
        public T connectionHandlingMode(PhysicalConnectionHandlingMode connectionHandlingMode) {
            this.connectionHandlingMode = connectionHandlingMode;
            return this.getThis();
        }

        @Override
        public T autoJoinTransactions(boolean autoJoinTransactions) {
            this.autoJoinTransactions = autoJoinTransactions;
            return this.getThis();
        }

        @Override
        public T autoClose(boolean autoClose) {
            this.autoClose = autoClose;
            return this.getThis();
        }

        @Override
        public T autoClear(boolean autoClear) {
            this.autoClear = autoClear;
            return this.getThis();
        }

        @Override
        public T flushMode(FlushMode flushMode) {
            this.flushMode = flushMode;
            return this.getThis();
        }

        @Override
        public T tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this.getThis();
        }

        @Override
        public T eventListeners(SessionEventListener ... listeners) {
            if (this.listeners == null) {
                this.listeners = this.sessionFactory.getSessionFactoryOptions().getBaselineSessionEventsListenerBuilder().buildBaselineList();
            }
            Collections.addAll(this.listeners, listeners);
            return this.getThis();
        }

        @Override
        public T clearEventListeners() {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SessionEventListener>(3);
            } else {
                this.listeners.clear();
            }
            return this.getThis();
        }

        @Override
        public T jdbcTimeZone(TimeZone timeZone) {
            this.jdbcTimeZone = timeZone;
            return this.getThis();
        }
    }
}

