/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.spi.SingleIdEntityLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryImplementor;

public class SingleIdEntityLoaderProvidedQueryImpl<T>
implements SingleIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final NamedQueryMemento namedQueryMemento;

    public SingleIdEntityLoaderProvidedQueryImpl(EntityMappingType entityDescriptor, NamedQueryMemento namedQueryMemento) {
        this.entityDescriptor = entityDescriptor;
        this.namedQueryMemento = namedQueryMemento;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        QueryImplementor query = this.namedQueryMemento.toQuery(session, this.entityDescriptor.getMappedJavaType().getJavaTypeClass());
        query.setParameter(1, pkValue);
        return (T)query.uniqueResult();
    }

    @Override
    public T load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (entityInstance != null) {
            throw new UnsupportedOperationException();
        }
        return this.load(pkValue, lockOptions, readOnly, session);
    }

    @Override
    public Object[] loadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        return ArrayHelper.EMPTY_OBJECT_ARRAY;
    }
}

